<?php
# NeoModule. An extended moduleclass for CMS - CMS Made Simple
# Copyright (c) 2009 by Morten Poulsen <morten@poulsen.org>
#
#CMS - CMS Made Simple
#(c)2004-09 by Ted Kulp (wishy@users.sf.net)
#This project's homepage is: http://cmsmadesimple.sf.net
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#


if (!function_exists("stripos")) {
	function stripos($str,$needle) {
		return strpos(strtolower($str),strtolower($needle));
	}
}
if (!function_exists("array_diff_key")) {
    function array_diff_key()
    {
        $arrs = func_get_args();
        $result = array_shift($arrs);
        foreach ($arrs as $array) {
            foreach ($result as $key => $v) {
                if (array_key_exists($key, $array)) {
                    unset($result[$key]);
                }
            }
        }
        return $result;
   }
}

if (!function_exists("is_assoc")) {
  function is_assoc($array) {
    return (is_array($array) && 0 !== count(array_diff_key($array, array_keys(array_keys($array)))));
  }
}

class NeoModule extends CMSModule {
  /*
   *
   * A couple of variables and methods for internal module usage
   *
   */
  var $_datastorage=false;
  var $_id=false;
  var $_returnid=false;
  var $_errors="";
  var $_themeobject=false;
  function _getds() {
    if ($this->_datastorage!==false) return $this->_datastorage;
    $this->_datastorage=$this->GetModuleInstance("NeoDataStorage");
    return $this->_datastorage;
  }
  function _getthemeobj() {
    global $gCms;
    if ($this->_themeobject!==false) return $this->_themeobject;
    $this->_themeobject=$themeObject = $gCms->variables['admintheme'];
    return $this->_themeobject;
  }

  /*
   *
   * Standard module-API-methods behaving in a standard way
   *
   */

	function GetName() {
		return 'NeoModule';
	}

  function GetVersion() {
    return "0.2.2";
  }

  function GetFriendlyName() {
		return "Neo Module base-class";
	}

	function IsPluginModule() {
		return false;
	}

	function MinimumCMSVersion() {
		return '1.6';
	}

	function GetAdminDescription() {
		return "An extended module-class, mainly for the Neo-series modules, but also for others to use";
	}

	function HasAdmin() {
		return false;
	}

	function GetAuthor() {
		return 'Morten Poulsen';
	}

	function GetAuthorEmail()	{
		return 'morten@poulsen.org';
	}

  function GetHelp($lang='en_US') {
    return $this->ProcessTemplate('help.tpl');
 	}

  function GetChangeLog()	{
		return $this->ProcessTemplate("changelog.tpl");
	}

  /*
   *
   * Setup functions
   *
   */  
  function NeoSetId($id) {
    $this->_id=$id;
  }  
  function NeoSetReturnId($returnid) {
    $this->_returnid=$returnid;
  }
  function NeoSetup($id,$module,$returnid="0") {
    $this->NeoSetId($id);
    $this->NeoSetReturnId($returnid);
    $this->SmartyAssignCMS($module);
    $this->SmartyAssign("module_id",$id);
  }


  /*
   *
   * General shortcut functions
   *
   */
  function Pref($prefname,$default="") {
    return $this->GetPreference($prefname,$default);
  }

  function NeoCmsLink($params=array()) {
    //CreateLink($id, $action, $returnid='', $contents='', $params=array(), $warn_message='', $onlyhref=false, $inline=false, $addttext='', $targetcontentonly=false, $prettyurl='')
    return $this->CreateLink(
      $this->NeoParamValue("id",$params,$this->_id),
      $this->NeoParamValue("action",$params,""),
      $this->NeoParamValue("returnid",$params,$this->_returnid),
      $this->NeoParamValue("content",$params,""),
      $this->NeoParamValue("params",$params,array()),
      $this->NeoParamValue("warnmessage",$params,""),
      false,
      $this->NeoParamValue("inline",$params,false),
      $this->NeoParamValue("addtext",$params,""),
      $this->NeoParamValue("prettyurl",$params,"")
    );
  }

  function NeoCmsUrl($params=array()) {
    //CreateLink($id, $action, $returnid='', $contents='', $params=array(), $warn_message='', $onlyhref=false, $inline=false, $addttext='', $targetcontentonly=false, $prettyurl='')
    return $this->CreateLink(
      $this->NeoParamValue("id",$params,$this->_id),
      $this->NeoParamValue("action",$params,""),
      $this->NeoParamValue("returnid",$params,$this->_returnid),
      "",
      $this->NeoParamValue("params",$params,array()),
      "",
      true ,
      false,
      "",
      false,
      $this->NeoParamValue("prettyurl",$params,"")
    );
  }

  function NeoRedirect($params=array()) {
    //Redirect($id, $action, $returnid='', $params=array(), $inline=false)
    return $this->Redirect(
      $this->NPV("id",$params,$this->_id),
      $this->NPV("action",$params,""),
      $this->NeoParamValue("returnid",$params,$this->_returnid),
      $this->NeoParamValue("params",$params,array()),
      $this->NeoParamValue("inline",$params,false)
    );
  }


  /*
   *
   * Form-generation functions, including smarty assignments
   *
   */

  function NeoFormStart($params=array()) {
    //CreateFormStart($id, $action='default', $returnid='', $method='post', $enctype='', $inline=false, $idsuffix='', $params = array(), $extra='')    
    return $this->CreateFormStart(
      $this->NeoParamValue("id",$params,$this->_id),
      $this->NeoParamValue("action",$params,"default"),
      $this->NeoParamValue("returnid",$params,$this->_returnid),
      $this->NeoParamValue("method",$params,"post"),
      $this->NeoParamValue(array("enctype","encoding"),$params,""),
      $this->NeoParamValue("inline",$params,false),
      $this->NeoParamValue("idsuffix",$params,""),
      $this->NeoParamValue("params",$params,array()),
      $this->NeoParamValue("extra",$params,"")
    );
  }
  function SmartyFormStart($smartyname,$params=array()) {
    $this->SmartyAssign($smartyname,$this->NeoFormStart($params));
  }
  function SmartyUploadFormStart($smartyname,$params=array()) {
    $params["method"]="post";
    $params["enctype"]="multipart/form-data";
    $this->SmartyFormStart($smartyname,$params);
  }

  function NeoFormEnd() {
    return $this->CreateFormEnd();
  }
  function SmartyFormEnd($smartyname) {
    $this->SmartyAssign($smartyname,$this->NeoFormEnd());
  }
  function SmartyInputSubmit($smartyname,$name,$text,$confirmtext="") {
    $this->SmartyAssign($smartyname,$this->NeoInputSubmit(array("name"=>$name,"value"=>$text,"confirmtext"=>$confirmtext)));
  }
  function SmartyInputHidden($smartyname,$name,$value="") {
    $this->SmartyAssign($smartyname,$this->NeoInputHidden(array("name"=>$name,"value"=>$value)));
  }
  function SmartyInputHiddenMulti($smartyname,$fields=array()) {
    $output="\n";
    foreach($fields as $name=>$value) {
      $output.=$this->NeoInputHidden(array("name"=>$name,"value"=>$value))."\n";
    }
    $output.="\n";
    $this->SmartyAssign($smartyname,$output);
  }

  function SmartyLink($smartyname,$fields=array()) {
    $this->SmartyAssign($smartyname,$this->NeoCmsLink($fields));
  }

  function NeoInputFile($params) {
  //public function CreateInputFile($id, $name, $accept='', $size='10',$addttext='')
   return $this->CreateInputFile(
      $this->NeoParamValue("id",$params,$this->_id),
      $this->NeoParamValue("name",$params,""),
      $this->NeoParamValue("accept",$params,""),
      $this->NeoParamValue("size",$params,"10"),
      $this->NeoParamValue("addtext",$params,"")
    );
  }

  function NeoInputText($params=array()) {
    return $this->CreateInputText(
      $this->NeoParamValue("id",$params,$this->_id),
      $this->NeoParamValue("name",$params,""),
      $this->NeoParamValue("value",$params,""),
      $this->NeoParamValue("size",$params,"10"),
      $this->NeoParamValue("maxlength",$params,"255"),
      $this->NeoParamValue("addtext",$params,"")
    );
  }

  function NeoTextarea($params=array()) {    
    return $this->CreateTextArea(
      $this->NeoParamValue("enablewysiwyg",$params,false),
      $this->NeoParamValue("id",$params,$this->_id),      
      $this->NeoParamValue(array("value","text"),$params,""),
      $this->NeoParamValue("name",$params,""),
      $this->NeoParamValue("classname",$params,""),
      $this->NeoParamValue("htmlid",$params,""),
      $this->NeoParamValue("encoding",$params,""),
      $this->NeoParamValue("stylesheet",$params,""),
      $this->NeoParamValue("cols",$params,"80"),
      $this->NeoParamValue("rows",$params,"15"),
      $this->NeoParamValue("forcewysiwyg",$params,""),
      $this->NeoParamValue("wantedsyntax",$params,""),
      $this->NeoParamValue("addtext",$params,"")
    );
  }

  function NeoInputCheckbox($params=array()) {
    if (isset($params["checked"]) && $params["checked"]==true) {
      $params["selectedvalue"]=$params["value"];
    }
    return $this->CreateInputCheckbox(
      $this->NeoParamValue("id",$params,$this->_id),
      $this->NeoParamValue("name",$params,""),
      $this->NeoParamValue("value",$params,""),
      $this->NeoParamValue("selectedvalue",$params,""),
      $this->NeoParamValue("addtext",$params,"")
    );
  }  

  function NeoInputSubmit($params=array()) {
    return $this->CreateInputSubmit(
      $this->NeoParamValue("id",$params,$this->_id),
      $this->NeoParamValue("name",$params,""),
      $this->NeoParamValue("value",$params,""),
      $this->NeoParamValue("addtext",$params,""),
      $this->NeoParamValue("image",$params,""),
      $this->NeoParamValue("confirmtext",$params,"")
    );
  }

  function NeoInputReset($params=array()) {
    return $this->CreateInputText(
      $this->NeoParamValue("id",$params,$this->_id),
      $this->NeoParamValue("name",$params,""),
      $this->NeoParamValue("value",$params,""),
      $this->NeoParamValue("addtext",$params,"Reset")
    );
  }

  function NeoInputHidden($params=array()) {
    return $this->CreateInputHidden(
      $this->NeoParamValue("id",$params,$this->_id),
      $this->NeoParamValue("name",$params,""),
      $this->NeoParamValue("value",$params,"")
    );
  }
  
  function NeoInputDropdown($params=array()) {
    return $this->CreateInputDropdown(
      $this->NeoParamValue("id",$params,$this->_id),
      $this->NeoParamValue("name",$params,""),
      $this->NeoParamValue("items",$params,""),
      $this->NeoParamValue("selectedindex",$params,-1),
      $this->NeoParamValue("selectedvalue",$params,""),
      $this->NeoParamValue("addtext",$params,"")
    );
  }

  function NeoInputRadioGroup($params=array()) {
    return $this->CreateInputRadioGroup(
      $this->NeoParamValue("id",$params,$this->_id),
      $this->NeoParamValue("name",$params,""),
      $this->NeoParamValue("items",$params,""),
      $this->NeoParamValue("selectedvalue",$params,-1),
      $this->NeoParamValue("addtext",$params,""),
      $this->NeoParamValue("delimiter",$params,"")
    );
  }
  
  function NeoInputSelectList($params=array()) {
    return $this->CreateInputSelectList(
      $this->NeoParamValue("id",$params,$this->_id),
      $this->NeoParamValue("name",$params,""),
      $this->NeoParamValue("items",$params,""),
      $this->NeoParamValue("selecteditems",$params,array()),
      $this->NeoParamValue("size",$params,3),
      $this->NeoParamValue("addtext",$params,""),
      $this->NeoParamValue("multiple",$params,true)
    );
  }  

  /**
   *
   * List helper functions
   *
   */
   function NeoDeleteIcon($action,$text,$params=array(),$confirmation="") {
     $icon=$this->CreateLink($this->_id, $action, $this->_returnid,$this->NeoSystemIcon("delete.gif",$text),$params, $confirmation);
     return $icon;
   }

   function NeoCopyIcon($action,$text,$params=array(),$confirmation="") {     
     $icon=$this->CreateLink($this->_id, $action, $this->_returnid,	$this->NeoSystemIcon("copy.gif",$text), $params, $confirmation);
     return $icon;
   }

   function NeoEditIcon($action,$text,$params=array(),$confirmation="") {
     $icon=$this->CreateLink($this->_id, $action, $this->_returnid,	$this->NeoSystemIcon("edit.gif",$text),	$params, $confirmation);
     return $icon;
   }
   function NeoTrueIcon($action,$text,$params=array(),$confirmation="") {
     $icon=$this->CreateLink($this->_id, $action, $this->_returnid,	$this->NeoSystemIcon("true.gif",$text),	$params, $confirmation);
     return $icon;
   }
   function NeoFalseIcon($action,$text,$params=array(),$confirmation="") {
     $icon=$this->CreateLink($this->_id, $action, $this->_returnid,	$this->NeoSystemIcon("false.gif",$text),	$params, $confirmation);
     return $icon;
   }

   function NeoAddIcon($action,$text,$params=array(),$confirmation="") {     
     $icon=$this->CreateLink($this->_id, $action, $this->_returnid, $this->NeoSystemIcon("newobject.gif",$text), $params, $confirmation);
     //$icon.=$this->CreateLink($this->_id,  $action, $this->_returnid, $text, $params, $confirmation, false, false, 'class="pageoptions"');

     //=$this->CreateLink($id, 'edittemplate', 0, $themeObject->DisplayImage('icons/system/newobject.gif',$this->Lang("addtemplate"),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'edittemplate', $returnid, $this->Lang("addtemplate"), array("todo"=>"add"), '', false, false, 'class="pageoptions"');
    return $icon;
   }
   
   function NeoSystemIcon($icon,$text="") {
     $themeobj=$this->_getthemeobj();
     return $themeobj->DisplayImage('icons/system/'.$icon, $text,'','','systemicon');
   }

   function NeoHiddenContent($text, $content, $clicktype="text", $startshown=false) {
     return "<strong>$text</strong><br/>$content";
   }
   			

  /**
   *
   * NeoDataStorage shortcuts
   *
   */
  function AddEntity($table, $props=array()) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->AddEntity($this->GetName(),$table,$props);
    } else {
      return $this->Error("function AddEntity: Cannot access NeoDataStorage module");
    }
  }


  function DeleteEntity($id) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->DeleteEntity($id);
    } else {
      return $this->Error("function DeleteEntity: Cannot access NeoDataStorage module");
    }
  }

  function GetEntity($id, $overrideprops=array(), $fillfields=array()) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->GetEntity($id, $overrideprops, $fillfields);
    } else {
      return $this->Error("function GetEntity: Cannot access NeoDataStorage module");
    }    
  }

  function GetEntities($table="", $criteria=array(), $alwaysreturnarray=false) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->GetEntities($this->GetName(), $table, $criteria);
    } else {
      if ($alwaysreturnarray) {
        return array();
      } else {
        return $this->Error("function GetEntities: Cannot access NeoDataStorage module");
      }
    }
  }

  function GetOneEntity($table, $criteria=array(), $failifmultiple=false) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->GetOneEntity($this->GetName(), $table, $criteria, $failifmultiple);
    } else {
      return $this->Error("function GetOneEntity: Cannot access NeoDataStorage module");
    }
  }

  function GetEntitiesFull($table="", $criteria=array(), $alwaysreturnarray=false) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->GetEntitiesFull($this->GetName(), $table, $criteria);
    } else {
      if ($alwaysreturnarray) {
        return array();
      } else {
        return $this->Error("function GetEntitiesFull: Cannot access NeoDataStorage module");
      }
    }
  }

  function SetEntityProp($id,$propname,$propvalue,$proptype="undefined") {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->SetEntityProp($id,$propname,$propvalue,$proptype);
    } else {
      return $this->Error("function SetEntityProp: Cannot access NeoDataStorage module");
    }
  }

  function ClearEntityProp($id, $propname) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->ClearEntityProp($id, $propname);
    } else {
      return $this->Error("function ClearEntityProp: Cannot access NeoDataStorage module");
    }
  }

  function SetEntityProps($id, $props/*, $clear=true*/) {
    //echo "hi1";die();
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->SetEntityProps($id, $props/*, $clear*/);
    } else {
      return $this->Error("function SetEntityProps: Cannot access NeoDataStorage module");
    }
  }
  
  function SetEntityPropsFromArray($id, $props, $values, $clear=true) {
    //echo "hi1";die();
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->SetEntityPropsFromArray($id, $props, $values, $clear);
    } else {
      return $this->Error("function SetEntityPropsFromArray: Cannot access NeoDataStorage module");
    }
  }



  function SetEntityPropsOnCriteria($table, $props, $criteria, $create=true, $clear=false) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->SetEntityPropsOnCriteria($this->GetName(), $table, $props, $criteria, $create, $clear);
    } else {
      return $this->Error("function SetEntityPropsOnCriteria: Cannot access NeoDataStorage module");;;
    }
  }

  function ResetEntityProps($id, $newprops=array()) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->ResetEntityProps($id, $newprop);
    } else {
      return $this->Error("function ResetEntityProps: Cannot access NeoDataStorage module");;;
    }
  }

  function RemoveModuleEntities() {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->RemoveModuleEntities($this->GetName());
    } else {
      return $this->Error("function RemoveModuleEntities: Cannot access NeoDataStorage module");
    }
  }

  function ClearEntityProps($id) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->ClearEntityProps($id);
    } else {
      return $this->Error("function ClearEntityProps: Cannot access NeoDataStorage module");
    }    
  }

  function CompareEntities($entity1, $entity2, $sortfield) {
    $ds=$this->_getds();
    if ($ds!==false) {
      $ds->CompareEntities($entity1, $entity2, $sortfield);
    } else {
      return $this->Error("function CompareEntities: Cannot access NeoDataStorage module");
    }
  }

  function CompareEntitiesComplex($entity1, $entity2, $sortfields) {
    $ds=$this->_getds();
    if ($ds!==false) {
      $ds->CompareEntitiesComplex($entity1, $entity2, $sortfield);
    } else {
      return $this->Error("function CompareEntitiesComplex: Cannot access NeoDataStorage module");
    }
  }

  function SortEntities($list, $sortfields) {
    $ds=$this->_getds();
    if ($ds!==false) {
      $ds->SortEntities($list, $sortfields);
    } else {
      return $this->Error("function SortEntities: Cannot access NeoDataStorage module");
    }
  }

  function EntitiesCount($table="", $criteria=array()) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->EntitiesCount($this->GetName(), $table, $criteria);
    } else {
      return $this->Error("function EntitiesCount: Cannot access NeoDataStorage module");
    }
  }

  function ClearModuleEntities() {    
    $ds=$this->_getds();
    if ($ds!==false) {      
      return $ds->ClearModuleEntities($this->GetName());
    } else {
      return $this->Error("function ClearModuleEntities: Cannot access NeoDataStorage module");
    }
  }

  /*
   *
   * Connection functions
   *
   */

  function SetEntityConnection($id1, $id2, $type="") {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->SetEntityConnection($id1, $id2, $type);
    } else {
      return $this->Error("function SetEntityConnection: Cannot access NeoDataStorage module");
    }
  }

  function ClearEntityConnections($id1, $id2=-1, $type="") {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->ClearEntityConnections($id1, $id2, $type);
    } else {
      return $this->Error("function ClearEntityConnections: Cannot access NeoDataStorage module");
    }    
  }



  function ClearEntityConnection($id1, $id2, $type="") {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->ClearEntityConnection($id1, $id2, $type);
    } else {
      return $this->Error("function ClearEntityConnection: Cannot access NeoDataStorage module");
    }
  }

  function CheckEntityConnection($id1, $id2, $type="", $returnvalue=true) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->CheckEntityConnection($id1, $id2, $type, $returnvalue);
    } else {
      return $this->Error("function CheckEntityConnection: Cannot access NeoDataStorage module");
    }
  }

  function GetEntityConnections($id1, $id2=-1, $type="") {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->GetEntityConnections($id1, $id2, $type);
    } else {
      return $this->Error("function GetEntityConnections: Cannot access NeoDataStorage module");
    }
  }

  function AddFieldSet($name,$fields) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->AddFieldSet($this->GetName(),$name,$fields);
    } else {
      return $this->Error("function AddFieldSet: Cannot access NeoDataStorage module");
    }
  }

  function GetFieldSet($name) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->GetFieldSet($this->GetName(),$name);
    } else {
      return $this->Error("function GetFieldSet: Cannot access NeoDataStorage module");
    }
  }

  function EntitySetUnsetProps($entity,$fieldset,$fillvalue="") {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->EntitySetUnsetProps($this->GetFieldSet($this->GetName()),$entity,$fieldset,$fillvalue="");
    } else {
      return $this->Error("function GetFieldSet: Cannot access NeoDataStorage module");
    }
  }


  function GetDSErrors($nl2br=true,$clear=true) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->GetErrors($nl2br,$clear);
    } else {
      return $this->Error("function GetFieldSet: Cannot access NeoDataStorage module");
    }
  }

  function ShowDSErrors($clear=true) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->GetErrors($clear);
    } else {
      return $this->Error("function ShowDSErrors: Cannot access NeoDataStorage module");
    }
  }

  function DSInError() {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->InError();
    } else {
      return $this->Error("function DSInError: Cannot access NeoDataStorage module");
    }
  }

  /*
   *
   * Utility functions
   *
   */

  function NeoSlashes($url) {
		$result=str_replace("\\","/",$url);
    //Yes, php under windows runs perfectly with those slashes, as long as you
    //don't mix them with backslashes!!
		//$result=str_replace("/",DIRECTORY_SEPARATOR,$url);
		//return str_replace("\\",DIRECTORY_SEPARATOR,$result);
		return $result;
	}

  function Slashes($url) {
    return $this->NeoSlashes($url);
  }

	function Slash($str,$str2="",$str3="") {
		if ($str=="") return $str2;
		if ($str2=="" && $str3=="") return $str;
    $result="";
		if ($str[strlen($str)-1]!="/") {
			if ($str2[0]!="/") {
				$result=$str."/".$str2;
			} else {
				$result=$str.$str2;
			}
		} else {
			if ($str2[0]!="/") {
				$result=$str.$str2;
			} else {
				$result=$str.substr($str2,1); //trim away one of the slashes
			}
		}
    if ($str3=="") return $result;
    if ($result[strlen($result)-1]!="/") {
			if ($str3[0]!="/") {
				$result=$result."/".$str3;
			} else {
				$result=$result.$str3;
			}
		} else {
			if ($str3[0]!="/") {
				$result=$result.$str3;
			} else {
				$result=$result.substr($str3,1); //trim away one of the slashes
			}
		}
    return $result;		
	}  

  function NeoDirList($root,$return="files",$introduction=array(),$excludes=array(),$maxrecursion=-1) {
    $dirlist=array();
    $config=$this->GetConfig();
    $mode="";
    switch($return) {
      case "files": $mode="FILES";break;
      case "dirs": $mode="DIRS";break;
      case "both": $mode="FULL";break;
    }
    $fullroot=$this->Slash($config["root_path"],$root);
    $filerec= get_recursive_file_list ($fullroot, $excludes ,$maxrecursion ,$mode); //No maxdepth in recursion
    if (!empty($introduction)) {
      $dirlist=$introduction;
    }    
    foreach($filerec as $key=>$value) {
      $value1=$this->Slashes(str_replace($config['root_path'],'',$value));
      //prevent current dir from showing up
      //if ($value1==($profile["path"]."/")) continue;
      //Check for hidden files
      $dirs=explode("/",$value1);
      $hidden=false;
      foreach($dirs as $dir) {
        if (substr($dir,0,1)==".") {$hidden=true; break;}
      }
      if ($hidden) continue;

      //not hidden, add to list
      $dirlist[$value1]=$value1;
    }
    return $dirlist;
  }

  /*Checks for the existence of an index in an array and return the value if it's there
   *and the default value if it's not
  */
  function NeoParamValue($name,$params,$default="") {
    if (!is_array($name)) {
      if (isset($params[$name])) return $params[$name];      
      return $default;
    } else {
      foreach ($name as $singlename) {
        if (isset($params[$singlename])) return $params[$singlename];
      }
      return $default;
    }
  }

  //Shortcut for the above
  function NPV($name, $params, $default="") {
    return $this->NeoParamValue($name, $params, $default);
  }

  Function NeoApplyParamValues($thisarray, $params, $indexes, $alwaysfill=false) {
    if (empty($params) || empty($indexes)) return $thisarray;
    if (is_assoc($indexes)) {
      foreach($indexes as $index=>$defaultvalue) {
        if (isset($params[$index])) {
          $thisarray[$index]=$params[$index];
        } else {
          $thisarray[$index]=$defaultvalue;
        }
      }
    } else {
      foreach($indexes as $index) {        
        if (isset($params[$index])) {
          $thisarray[$index]=$params[$index];
        } else {
          if ($alwaysfill) {
            if (!isset($thisarray[$index])) $thisarray[$index]="";
          }
        }
      }
    }
    //print_r($thisarray);
    return $thisarray;
  }

  function MakeSimpleArray($table,$field,$associd=true) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->MakeSimpleArray($this->GetName(), $table, $field, $associd);
    } else {
      return $this->Error("function MakeSimpleArray: Cannot access NeoDataStorage module");;
    }
  }

  function MakeAssocArray($table,$fields) {
    $ds=$this->_getds();
    if ($ds!==false) {
      return $ds->MakeAssocArray($this->GetName(), $table, $fields);
    } else {
      return $this->Error("function MakeAssocArray: Cannot access NeoDataStorage module");
    }
  }

  function CheckFileExtension($filename, $allowedextensions=array()) {
		$explodedfile=explode(".",$filename);
		$ext=strtolower(array_pop($explodedfile));
		if (in_array($ext,$allowedextensions)) return true;
    return false;
  }

  function NeoToolTip($params=array()) {
    $text=$this->NPV("text",$params,"?");
    $url=$this->NPV("url",$params,"");
    $title=$this->NPV("title",$params,"");
    $content=$this->NPV("content",$params,"");
    $spanclass=$this->NPV("spanclass",$params,"neotooltip");
    if ($url!="") {
      $result='<a class="'.$spanclass.'" href="'.$url.'">';
    } else {
      $result='<a class="'.$spanclass.'" style="cursor: default;" href="#" onclick="return false;">';
    }
    $result.=$text;
    $result.='<span>';
    if ($title!="") {
      $result.="<strong>".$title."</strong><br/>";
    }
    $result.=$content;
    $result.="</span>";
    $result.="</a>";         
    return $result;
  }

  function NeoPrintR($data=array(),$sendout=true) {
    $output='<br/><div style="border:1px solid black">';
    $output.="<pre>";
    $output.=print_r($data,true);
    $output.="</pre>";
    $output.="</div><br/>";
    if ($sendout) {
      echo $output;
    }
    return $output;
  }

  /*
   *
   * Smarty shortcuts
   *
   */
  function SmartyAssign($smartyinfo, $smartycontent="") {
    if (!is_array($smartyinfo)) {
      if ($smartyinfo!="" && $smartycontent!="") {
        $this->smarty->assign($smartyinfo, $smartycontent);
      } else {
        if ($smartyinfo=="") {
          return $this->Error("function SmartyAssign: smarty-varname not set",false,array("smartyinfo"=>$smartyinfo,"smartycontent"=>$smartycontent));
        }
      }
      return true;
    }
    //Ok it's an array
    if (is_assoc($smartyinfo)) {
      //It's an assoc_array, so we assign every single pair of info
      foreach($smartyinfo as $smartyname=>$smartycontent) {
        if (is_array($smartycontent)) {
          //it's a nested array
          $this->smarty->assign_by_ref($smartyname, $smartycontent);
        } else {
          $this->smarty->assign($smartyname, $smartycontent);
        }
      }
    } else {
      //It's not an assoc_array, so we simply ref-assign it.
      $this->smarty->assign_by_ref($smartyinfo, $smartycontent);
    }
    return true;
  }

  function NeoSmartyAssign($smartyinfo, $smartycontent="") {
    $this->SmartyAssign($smartyinfo, $smartycontent);
  }

  function SmartyAssignPref($smartyname, $preferencename="") {
    if ($preferencename!="") {
      $this->SmartyAssign($smartyname, $this->Pref($preferencename));
    } else {
      $this->SmartyAssign($smartyname, $this->Pref($smartyname));
    }
  }

  function SmartyAssignCMS($module,$smartyname="module") {
    if (is_object($module)) {
      $this->smarty->assign_by_ref($smartyname, $module);
    } else {
      $this->smarty->assign_by_ref($smartyname, $this->GetModuleInstance($module));
    }
  }

  /*
   *
   * Debugging functions
   *
   */

  function FireDebug($command,$message="",$variables=array()) {
    $firephpmodule=$this->GetModuleInstance('FirePHPDebug');
    if ($firephpmodule) {
      //Module found
      $firephpmodule->SetModuleName($this->GetName());
      $firephpmodule->Command($command, $message, $variables);
    } //else Module not found}
  }


  /*
   *
   * Error handling
   *
   */
  function Error($errortext,$returnvalue=false,$params=array()) {
    $this->_errors.=$text;
    if (!empty($params) && is_array($params)) {
      $this->_errors.=" (";
      $first=true; //Handling the comma
      foreach ($params as $param=>$value) {
        if ($first) $first=false; else $this->_errors.=",";
        $this->_errors.=$param."=>".$value;
      }
      $this->_errors.=")";
    }
    $this->_errors.="\n";
    return $returnvalue;
  }

  function GetErrors($nl2br=true,$clear=true,$includeds=true) {
    $errors=$this->_errors;
    if ($nl2br) {
      $errors=nl2br($errors);
    }
    if ($includeds) {
      if ($this->DSInError()) {
        $errors.=$this->GetDSErrors($nl2br,$clear);
      }
    }
    if ($clear) {
      $this->_errors="";
    }
    return $errors;
  }

  function OutputErrors($clear=true,$includeds=true) {
    if ($this->InError()) {
      echo "\n\n<div style='border:3px solid red>\n";
      echo $this->GetErrors(true,$clear,$includeds);
      echo "\n</div>\n\n";
    }
  }

  function InError() {
    return ($this->_errors!="");
  }

}
?>
