<?php
#-------------------------------------------------------------------------
# Module: ScriptDeploy - Minify and deployment of JS CSS and HTML
# Mod designed by jeremyBass (jeremyBass@cableone.net)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/Minify/
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

require 'jsmin.php';
class ScriptDeploy extends CMSModule
{
	function GetName(){
		return get_class($this);
	}
	function GetFriendlyName(){
		return $this->Lang('friendlyname');
	}
	function GetVersion(){
		return '0.3';
	}
	function GetHelp(){
		return $this->Lang('help');
	}
	function GetAuthor(){
		return 'jeremyBass';
	}
	function GetAuthorEmail(){
		return 'jeremybass@cableone.net';
	}
	function GetChangeLog(){
		return $this->Lang('changelog');
	}
	function IsPluginModule(){
		return true;
	}
	function HasAdmin(){
		return true;
	}
	function GetAdminSection(){
		return 'extensions';
	}
	function GetAdminDescription(){
		return $this->Lang('moddescription');
	}
	function VisibleToAdminUser(){
		return $this->CheckPermission('Modify Calendar');
	}
	function GetDependencies(){
		return array();
	}
	function MinimumCMSVersion(){
		return "1.6.6";
	}
	function InstallPostMessage(){
		return $this->Lang('postinstall');
	}
	function UninstallPostMessage(){
		return $this->Lang('postuninstall');
	}
	function UninstallPreMessage(){
		return false;//$this->Lang('really_uninstall');
	}
	function FireDebug($command,$message,$variables=array()){
	 if($this->GetPreference('debugIT')==1){ $firephpmodule=$this->GetModuleInstance('FirePHPDebug');
	  if ($firephpmodule){
		//Module found
		$firephpmodule->SetModuleName($this->GetName());
		$firephpmodule->Command($command, $message, $variables);
	  } //else Module not found
	 }
	}//$this->FireDebug('message',$k);//<<<<------Fire PHP message
	function recursive_rmdir($dir)
	 {
		// all subdirectories and contents:
		if(is_dir($dir)){
			$dir_handle=opendir($dir);
		}else{
			return false;
		}
		while($file=readdir($dir_handle))
		{
		if($file!="." && $file!="..")
		{
		if(!is_dir($dir."/".$file))unlink ($dir."/".$file);
		else $this->recursive_rmdir($dir."/".$file);
		}
		}
		closedir($dir_handle);
		rmdir($dir);
		return true;
	}

/*----Do-final-output-steps---------------------------*/

	function filestime($ID,$type){
		global $gCms;
		$config =& $gCms->GetConfig(); 
		$codeToFile='';
		$smartyOn=$this->GetPreference('smartyOn','0');
		if($type=="scriptID"){
			extract($this->TieAScript('select',$ID));
			if($ScriptIs!=''){
				$codeToFile=$ScriptIs;
			}
			if($pathOption!=''){
				$pathOption=$config['root_path'].$pathOption;
				$codeToFile=file_get_contents($pathOption);
			}
		}elseif($type=="groupID"){
			$GroupArray=$this->TieAScript('selectGroupItems',$ID);
			foreach($GroupArray as $key => $ID){
				extract($this->TieAScript('select',$ID));
				if($ScriptIs!=''){
					$codeToFile.='
					'.$ScriptIs;
				}
				if($pathOption!=''){
					$pathOption=$config['root_path'].$pathOption;
					$codeToFile.='
					'.file_get_contents($pathOption);
				}
			}
		}
		if($scriptType!=''){
			$type=$scriptType;
		}
		if($smartyOn==1){
			$this->smarty->left_delimiter = '{{';
			$this->smarty->right_delimiter = '}}';
			$codeToFile=$this->ProcessTemplateFromData($codeToFile); 
			$this->smarty->left_delimiter = '{';
			$this->smarty->right_delimiter = '}';
		}
		$ouput = array($codeToFile,$type);
		return $ouput;
	}
/**
* Display a simple message
*/
	function DisplayMessage($id, &$params, $returnid, $title, $message){
		$this->smarty->assign('title', $title);
		$this->smarty->assign('message', $message);
		echo $this->ProcessTemplate('message.tpl');
	}
  
/**
* Check if current user is allowed to post
*/
	function RealURL(){
		global $gCms;
		$urlBASE = "http://".$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'];
		if (!empty($_SERVER["QUERY_STRING"]))
		$urlBASE .= "?".$_SERVER['QUERY_STRING'];
		if (isset($gCms->config['assume_mod_rewrite']) && ($gCms->config['assume_mod_rewrite']==true) || (isset($gCms->config['url_rewriting'])&& $gCms->config['url_rewriting']=='mod_rewrite')){
			$urls = str_replace("index.php?page=", "", $urlBASE);
			$urls = str_replace("index.php", "", $urls);
		}else{
			$urls = $urlBASE;
		}
		return $urls;
	}

	function RedirectURL($secureRedirect){
		global $gCms;
		$RedirectURL=$this->GetPreference('RedirectURL','');
		if($RedirectURL!=''){
			if (isset($gCms->config['assume_mod_rewrite']) && ($gCms->config['assume_mod_rewrite']==true) || (isset($gCms->config['url_rewriting'])&& $gCms->config['url_rewriting']=='mod_rewrite')){
				$urls = $RedirectURL;
				$urls .="?".$secureRedirect;
			}else{
				$urls = $RedirectURL;
				$urls .="&".$secureRedirect;
			}
		}else{
			$urlBASE = "http://".$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'];
			if (!empty($_SERVER["QUERY_STRING"]))
			$urlBASE .= "?".$_SERVER['QUERY_STRING'];
			if (isset($gCms->config['assume_mod_rewrite']) && ($gCms->config['assume_mod_rewrite']==true) || (isset($gCms->config['url_rewriting'])&& $gCms->config['url_rewriting']=='mod_rewrite')){
				$urls = str_replace("index.php?page=", "", $urlBASE);
				$urls = str_replace("index.php", "", $urls);
				$urls .="?".$secureRedirect;
			}else{
				$urls = $urlBASE;
				$urls .="&".$secureRedirect;
			}
		}
		return $urls;
	}

	function myRedirectToTab( $id, $tab, $params = '' ){
		$parms = array();
		if(is_array($params)){
			$parms = $params;
		}
		$parms = array('active_tab' => $tab );
		$this->myRedirect( $id, 'defaultadmin', $parms );
	}

	function myRedirect( $id, $action, $params = '' ){
		unset( $params['action'] );
		$this->Redirect( $id, $action, '', $params );
	}


/*----Makeing-all-the-Selections--DB-calls------------*/
	function TieAScript($action='select',$scriptID='',$GrouptSetID=''){
		$db =& $this->GetDb();
		$retresult = array();
		$results = array();
		$this->FireDebug('message',$action);//<<<<------Fire PHP message
		$this->FireDebug('message',$scriptID);//<<<<------Fire PHP message
		$this->FireDebug('message',$GrouptSetID);//<<<<------Fire PHP message
		$r='';
		
		
		/*------Pull-A-Script-------*/
		
		if($action=='select'){
			
			$db =& $this->GetDb();
			$retresult = array();
			$results = array();	
			
			$query = 'SELECT * FROM '.cms_db_prefix().'module_scriptdeploy_scriptnames AS sn '
				.'LEFT JOIN '.cms_db_prefix().'module_scriptdeploy_scriptoptions AS so ON sn.ID = so.ID '
				.'LEFT JOIN '.cms_db_prefix().'module_scriptdeploy_scriptparts AS sp ON sn.ID = sp.ID '
				.'WHERE sn.ID = '.$scriptID.'';
				
			$result = &$db->Execute($query);
		
			while ($result && !$result->EOF){
				$daKey=$result->fields['ID'];
				$results['ScriptID']= $result->fields['ID'];
				$results['ScriptSet']= $result->fields['ScriptSet'];
				$results['Minify']= $result->fields['Minify'];
				$results['maxAge']= $result->fields['maxAge'];
				$results['pathOption']= $result->fields['pathOption'];
				$results['ScriptIs']= $result->fields['ScriptIs'];
				$results['scriptType']= $result->fields['scriptType'];
				$results['scriptSize']= $result->fields['scriptSize'];
				$results['notes']= $result->fields['notes'];
				$results['MediaType']= $result->fields['MediaType'];
				$retresult[$daKey] = $results;
				$result->MoveNext();
			}
			$this->FireDebug('message','Results '.$retresult[$scriptID]);//<<<<------Fire PHP message
			return $retresult[$scriptID];		
		
		/*--Pull-A-List-Of-Scripts--*/
		
		}elseif($action=='selectList'){
			$this->FireDebug('message','Got here');//<<<<------Fire PHP message
			$db =& $this->GetDb();
		
			$retresult = array();
			$results = array();	
		
			$query = 'SELECT * FROM '.cms_db_prefix().'module_scriptdeploy_scriptnames AS sn '
			.'LEFT JOIN '.cms_db_prefix().'module_scriptdeploy_scriptoptions AS so ON sn.ID = so.ID';
			$result = &$db->Execute($query);
		
			while ($result && !$result->EOF){
				$daKey=$result->fields['ID'];
				$results['ScriptSet']= $result->fields['ScriptSet'];
				$results['Minify']= $result->fields['Minify'];
				$results['maxAge']= $result->fields['maxAge'];
				$results['pathOption']= $result->fields['pathOption'];
				$results['scriptType']= $result->fields['scriptType'];
				$results['scriptSize']= $result->fields['scriptSize'];
				$results['notes']= $result->fields['notes'];
				$results['MediaType']= $result->fields['MediaType'];
				$retresult[$daKey] = $results;
				$result->MoveNext();
			}
			return $retresult;
		
		/*--Pull-A-List-Of-Groups---*/
		
		}elseif($action=='selectGroupList'){
			
			$db =& $this->GetDb();
		
			$retresult = array();
			$results = array();	

			$query = 'SELECT * FROM '.cms_db_prefix().'module_scriptdeploy_group AS sdG '
				.'LEFT JOIN '.cms_db_prefix().'module_scriptdeploy_groupassignment AS sdGm ON sdG.ID = sdGm.GrouptSetID';
			$result = &$db->Execute($query);

			while ($result && !$result->EOF){
				$daKey=$result->fields['ID'];
				$results['GrouptSet']= $result->fields['GrouptSet'];
				$results['GrouptType']= $result->fields['GrouptType'];
				
				if(isset($result->fields['ScriptID'])){
					$results['ScriptID']= '';
				}else{
					$results['ScriptID']= '';
				}
				$this->FireDebug('message',count($result->fields['ScriptID']));//<<<<------Fire PHP message
				$retresult[$daKey] = $results;
				$result->MoveNext();
			}
			return $retresult;
		
		/*----Pull-A-Groups-List----*/
		
		}elseif($action=='selectGroupsListings'){
			$this->FireDebug('message','Got here');//<<<<------Fire PHP message
			$db = $this->GetDb();
		
			$retresult = array();
			$results = array();	

			$query = 'SELECT sn.ScriptSet,so.scriptSize,sdGm.ScriptID,sdGm.ScriptORDER FROM '.cms_db_prefix().'module_scriptdeploy_group AS sdG '
				.'LEFT JOIN '.cms_db_prefix().'module_scriptdeploy_groupassignment AS sdGm ON sdG.ID = sdGm.GrouptSetID '
				.'LEFT JOIN '.cms_db_prefix().'module_scriptdeploy_scriptoptions AS so ON so.ID = sdGm.ScriptID '
				.'LEFT JOIN '.cms_db_prefix().'module_scriptdeploy_scriptnames AS sn ON so.ID = sn.ID '
				.'WHERE sdG.ID = '.$scriptID.'';
			$result = $db->Execute($query);
			
			while ($result && !$result->EOF){
				$daKey=$result->fields['ScriptID'];
				$results['ScriptSet']= $result->fields['ScriptSet'];
				$results['scriptSize']= $result->fields['scriptSize'];
				$results['ScriptORDER']= $result->fields['ScriptORDER'];
				$retresult[$daKey] = $results;
				$result->MoveNext();
			}
			
			return $retresult;
			
		
		/*----Pull-A-Groups-List----*/
		
		}elseif($action=='selectGroup'){
			$this->FireDebug('message','Got here');//<<<<------Fire PHP message
			$db =& $this->GetDb();
		
			$retresult = array();
			$results = array();	

			$query = 'SELECT * FROM '.cms_db_prefix().'module_scriptdeploy_group AS sdG '
				.'WHERE sdG.ID = '.$scriptID.'';
			$result = &$db->Execute($query);
		
			while ($result && !$result->EOF){
				$daKey=$result->fields['ID'];
				$results['GrouptSet']= $result->fields['GrouptSet'];
				$results['GrouptType']= $result->fields['GrouptType'];
				
				
				$retresult[$daKey] = $results;
				$result->MoveNext();
			}
			return $retresult[$scriptID];	
			
		
		/*----Pull-A-Groups-List-#--*/
		
		}elseif($action=='selectGroupItems'){
			$this->FireDebug('message','Got here');//<<<<------Fire PHP message
			$db =& $this->GetDb();
		
			$retresult = array();
			$results = array();	

			$query = 'SELECT ScriptID FROM '.cms_db_prefix().'module_scriptdeploy_groupassignment AS sdGm '
				.'WHERE sdGm.GrouptSetID = '.$scriptID.' ORDER BY ScriptORDER ASC';
			$result = &$db->Execute($query);
			while ($result && !$result->EOF){
				array_push($results, $result->fields['ScriptID']);
				$result->MoveNext();
			}
			return $results;	

		
		/*----Check-For-A-Script----*/
		
		}elseif($action=='selectGroupSNUM'){
			$this->FireDebug('message','Got here');//<<<<------Fire PHP message
			$db =& $this->GetDb();
		
			$retresult = array();
			$results = array();	

			$query = 'SELECT ScriptID FROM '.cms_db_prefix().'module_scriptdeploy_groupassignment AS sdGm '
				.'WHERE sdGm.GrouptSetID = '.$scriptID.'';
			$result = &$db->Execute($query);
			$sciptnumber=0;
			while ($result && !$result->EOF){
				$sciptnumber=$sciptnumber+1;
				$result->MoveNext();
			}
			return $sciptnumber;	
			

		
		/*----Check-For-A-Script----*/
		
		}elseif($action=='CheckScript'){
			$query = 'SELECT * FROM '.cms_db_prefix().'module_scriptdeploy_groupassignment '
				.'WHERE ScriptID='.$scriptID.' AND GrouptSetID='.$GrouptSetID.'';
			$result = &$db->Execute($query);
				if($result && !$result->EOF){$r=$scriptID;}else{$r='';}
				$this->FireDebug('message','for ScriptID '.$scriptID.' has: '.$r);//<<<<------Fire PHP message
			return $r;
		}			
	}
	

/*----Get-the-set-of-the-file-------------------------*/
	
	function SizeItUp($size){
	 if($size < 1024){
		  $size2="$size bytes";
      }
      if($size > 1024 && $size < 1048576){
		  $size1= number_format($size/1024,2);
		  $size2="$size1 Kb";
      }
      if($size > 1048576){
		  $size1= number_format($size/1048576,2);
		  $size2="$size1 Mb";
      }	
	  return $size2;
	}



/*----Script-List-Set-up------------------------------*/


	
	function _AdminCreateTemplateList( $id, $returnid, $prefix, $defaulttemplatepref, 
						 $active_tab, $defaultprefname,
						 $title){
		// we're gonna allow multiple templates here
		// but we're gonna prefix them all with something
		global $gCms;
		
		$falseimage1 = $gCms->variables['admintheme']->DisplayImage('icons/system/false.gif','make default','','','systemicon');
		$trueimage1 = $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif','default','','','systemicon');
		$alldbProfiles = $this->TieAScript('selectList');
		$rowarray = array();
		$rowclass = 'row1';
		

		
		foreach($alldbProfiles as $key => $onedbProfile ){
			$ScriptSet= $onedbProfile['ScriptSet'];
			$Minify= $onedbProfile['Minify'];
			$maxAge= $onedbProfile['maxAge'];
			$pathOption= $onedbProfile['pathOption'];
			$scriptType= $onedbProfile['scriptType'];
			$scriptSize= $onedbProfile['scriptSize'];
			$row = new StdClass();
			$row->name = $this->CreateLink( $id, 'edittemplate', $returnid,
							$key, array('ScriptSet' => $key,
									'active_tab' => $active_tab,
									'mode'=>'edit'));
			$row->default = $this->CreateLink( $id, 'edittemplate', $returnid,
							$ScriptSet, array('ScriptSet' => $key,
									'active_tab' => $active_tab,
									'mode'=>'edit'));
			//$row->typeIcon ='<img src="../modules/ScriptDeploy/images/'.$scriptType.'.png" width="35" height="35" />';
			if($Minify==1){
				$minimg='<img src="../modules/ScriptDeploy/images/Min.png" width="35" height="35" style="position:absolute; z-index:99;top:0px;"/>';
			}else{
				$minimg='';
			}
			$row->typeIcon ='<div style=" position:relative; height:35px;">'.$minimg.'<img src="../modules/ScriptDeploy/images/'.$scriptType.'.png" width="35" height="35" style="position:absolute; z-index:9; top:0px;"/></div>';
			$row->Btn = $key;
			$row->rowclass = $rowclass;
			$row->editlink = $this->CreateLink( $id, 'edittemplate', $returnid,
								$gCms->variables['admintheme']->
								DisplayImage ('icons/system/edit.gif',
									  $this->Lang ('edit'), '', '', 'systemicon'),
								array ('ScriptSet' => $key,
								   'active_tab' => $active_tab,
								   'mode'=>'edit'));
			$row->type = $scriptType;
			$row->scriptSize = $this->SizeItUp($scriptSize);
			$row->deletelink = $this->CreateLink( $id, 'deletetemplate', $returnid,
							  $gCms->variables['admintheme']->
							  DisplayImage ('icons/system/delete.gif',
									$this->Lang ('delete'), '', '', 'systemicon'),
							  array ('ScriptID' => $key),
							  $this->Lang ('areyousure'));
			
			
			array_push ($rowarray, $row);
			($rowclass == "row1" ? $rowclass = "row2" : $rowclass = "row1");
		}
		
		$this->smarty->assign('items', $rowarray );
		
		$this->smarty->assign('type_label', $this->Lang('type_label'));
		$this->smarty->assign('Name_label', $this->Lang('ScriptSet_label'));
		$this->smarty->assign('nameprompt_label', $this->Lang('prompt_name'));
		$this->smarty->assign('ScriptName_label', $this->Lang('ScriptName_label'));
		$this->smarty->assign('SingleCode_label', $this->Lang('SingleCode_label'));//$this->Lang('prompt_default')
		
		 
		
		$this->smarty->assign('newtemplatelink',
				  $this->CreateLink( $id, 'edittemplate', $returnid,
							 $this->Lang('prompt_newScript'),
							 array('prefix' => $prefix,
							   'active_tab' => $active_tab,
							   'title'=>$title,
							   'mode' => 'add',
							   'defaulttemplatepref' => $defaulttemplatepref
							   )));
		$this->smarty->assign($this->CreateFormEnd());
		echo $this->ProcessTemplate('edittemplates.tpl');
	}


/*----Group-List-Set-up-------------------------------*/


	function _AdminCreateAssignmentList( $id, $returnid, $prefix, $defaulttemplatepref, 
						 $active_tab, $defaultprefname,
						 $title){
		// we're gonna allow multiple templates here
		// but we're gonna prefix them all with something
		global $gCms;
		
		$falseimage1 = $gCms->variables['admintheme']->DisplayImage('icons/system/false.gif','make default','','','systemicon');
		$trueimage1 = $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif','default','','','systemicon');
		$alldbProfiles = $this->TieAScript('selectGroupList');
		$rowarray = array();
		$rowclass = 'row1';
		


		foreach($alldbProfiles as $key => $onedbProfile ){
			$GrouptSet= $onedbProfile['GrouptSet'];
			$ScriptNum= $this->TieAScript('selectGroupSNUM',$key);
			$GrouptType= $onedbProfile['GrouptType'];
			

				$this->FireDebug('error',$key);//<<<<------Fire PHP message
			$row = new StdClass();
			$row->name = $this->CreateLink( $id, 'editassignment', $returnid,
							$key, array('GrouptSet' => $key,
									'active_tab' => $active_tab,
									'mode'=>'edit'));
			
			if(isset($ScriptNum)&&$ScriptNum!=0){
				$row->Sample='<h3>{cms_module module=ScriptDeploy groupID="'.$key.'" Stype="'.$GrouptType.'"}</h3>';
			}else{
				$row->Sample='<h5>'.$this->Lang ('emtpyGroup').'</h5>';
			}
			
			$row->default = $this->CreateLink( $id, 'editassignment', $returnid,
							$GrouptSet, array('GrouptSet' => $key,
									'active_tab' => $active_tab,
									'mode'=>'edit'));
			$row->Btn = $key;
			$row->NumberOf = $ScriptNum;
			$row->rowclass = $rowclass;
			$row->typeIcon ='<div style=" position:relative; height:35px;"><img src="../modules/ScriptDeploy/images/'.$GrouptType.'.png" width="35" height="35" style="position:absolute; z-index:9; top:0px;"/></div>';
			$row->editlink = $this->CreateLink( $id, 'editassignment', $returnid,
								$gCms->variables['admintheme']->
								DisplayImage ('icons/system/edit.gif',
									  $this->Lang ('edit'), '', '', 'systemicon'),
								array ('GrouptSet' => $key,
								   'active_tab' => $active_tab,
								   'mode'=>'edit'));
			
			
			$row->deletelink = $this->CreateLink( $id, 'deleteassignment', $returnid,
							  $gCms->variables['admintheme']->
							  DisplayImage ('icons/system/delete.gif',
									$this->Lang ('delete'), '', '', 'systemicon'),
							  array ('GrouptSet' => $key),
							  $this->Lang ('areyousure'));
			
			
			array_push ($rowarray, $row);
			($rowclass == "row1" ? $rowclass = "row2" : $rowclass = "row1");
		}
		
		$this->smarty->assign('Ass_items', $rowarray );
		$this->smarty->assign('Ass_header', $this->Lang('Ass_header'));
		$this->smarty->assign('SampleCode', $this->Lang('SampleTag'));//$this->Lang('prompt_default')
		$this->smarty->assign('newScriptAsslink',
				  $this->CreateLink( $id, 'editassignment', $returnid,
							 $this->Lang('prompt_newScriptAss'),
							 array('prefix' => $prefix,
							   'active_tab' => $active_tab,
							   'title'=>$title,
							   'mode' => 'add',
							   'defaulttemplatepref' => $defaulttemplatepref
							   )));
		$this->smarty->assign($this->CreateFormEnd());
		echo $this->ProcessTemplate('editAssignments.tpl');
	}
}
?>
