<?php


if (!isset($gCms)) exit;

if (!$this->CheckPermission('Modify Site Preferences')) {
  echo $this->ShowErrors($this->Lang('needpermission', array('Modify Site Preferences')));
  return;
}

echo $this->StartTabHeaders();
echo $this->SetTabHeader("settings",$this->Lang("settingstab"));

echo $this->SetTabHeader("htmltest",$this->Lang("htmltest"));
echo $this->SetTabHeader("csstest",$this->Lang("csstest"));
echo $this->SetTabHeader("phptest",$this->Lang("phptest"));

echo $this->EndTabHeaders();
echo $this->StartTabContent();


echo $this->StartTab("settings");
$this->smarty->assign('startform', $this->CreateFormStart($id, 'savesettings', $returnid));
$this->smarty->assign('endform', $this->CreateFormEnd());

$this->smarty->assign('showlinenumberstext', $this->Lang("showlinenumbers"));
$this->smarty->assign('showlinenumbersinput', $this->CreateInputCheckbox($id,"showlinenumbers",1,$this->GetPreference("showlinenumbers",1)));

$this->smarty->assign('textwrappingtext', $this->Lang("textwrapping"));
$this->smarty->assign('textwrappinginput', $this->CreateInputCheckbox($id,"textwrapping",1,$this->GetPreference("textwrapping",1)));

$this->smarty->assign('useautocompletetext', $this->Lang("useautocomplete"));
$this->smarty->assign('useautocompleteinput', $this->CreateInputCheckbox($id,"useautocomplete",1,$this->GetPreference("useautocomplete",1)));

$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('savesettings')));

echo $this->ProcessTemplate('settings.tpl');

echo $this->EndTab();

echo $this->StartTab("htmltest");
$content="
<html>
  <head>
    <title>Testing html-syntax</title>
  </head>
  <body>
    And doing absolutely nothing else
  </body>
</html> 
";
echo $this->CreateFormStart($id,"defaultadmin");
echo $this->CreateTextArea(false,$id,$content,"testarea1",'','','','','60','10','CodeMirror','html');

echo $this->CreateFormEnd();
echo $this->EndTab();

echo $this->StartTab("csstest");
$content="
.testcss {
  font-weight:bold;
  height: 10px;
} 
";
echo $this->CreateFormStart($id,"defaultadmin");
echo $this->CreateTextArea(false,$id,$content,"testarea2",'','','','','60','10','CodeMirror','css');

echo $this->CreateFormEnd();

echo $this->EndTab();

echo $this->StartTab("phptest");
$content="
<?php
  function testPHP(\$someparam) {
    echo 'Do you think this looks nice?';
  }
?>
";
echo $this->CreateFormStart($id,"defaultadmin");
echo $this->CreateTextArea(false,$id,$content,"testarea3",'','','','','60','10','CodeMirror','php');
echo $this->CreateFormEnd();

echo $this->EndTabContent();


/*

echo "<h3>".$this->Lang("testarea").":</h3>";

$content="
<html>
  <head>
    <title>Testing html-syntax</title>
  </head>
  <body>
    And doing absolutely nothing else
  </body>
</html> 
";
echo $this->CreateFormStart($id,"defaultadmin");
echo $this->CreateTextArea(false,$id,$content,"testarea",'','','','','','','CodeMirror','html');
echo $this->CreateFormEnd();
 
echo $this->EndTab();
 */

?>