<?php
#CMS - CMS Made Simple
#(c)2005-06 by Morten Poulsen (morten@poulsen.org)
#This project's homepage is: http://www.cmsmadesimple.org
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


class CodeMirror extends CMSModule {
	var $noeditors=0;
	var $headerinfosent=false;

	function GetName() {
		return 'CodeMirror';
	}

	function IsPluginModule() {
		return false;
	}

	function HasAdmin() {
		return true;
	}

	function GetHelp() {
		return $this->Lang("help");
	}

	function GetAuthor() {
		return 'Morten Poulsen';
	}

	function GetAuthorEmail() {
		return '&lt;morten@poulsen.org&gt;';
	}

	function GetChangeLog() {
		return $this->ProcessTemplate('changelog.tpl');
	}

	function GetVersion() {
		return '0.1.3';
	}
	
	function MinimumCMSVersion() {
		return "1.5.3";
	}

  function HasCapability($capability, $params=array()) {
    if ($capability=="wysiwyg") return true;
    if ($capability=="syntaxhighlighting") return true;
    return false;
  }

	function IsWYSIWYG() {
		return true;
	}

	function IsSyntaxHighlighter() {
		return true;
	}

	function VisibleToAdminUser() {
		return $this->CheckPermission('Modify Site Preferences');
	}

	function SyntaxPageFormSubmit() {
		return "for (var cntEditor = 0; cntEditor < numCodePressAreas; cntEditor++) {\n"
		. "\t\tvar id = eval('codepress' + cntEditor);\n"
		. "\t\tid.textarea.value = id.getCode();\n"
		. "\t}\n";
	}
	
	function WYSIWYGPageFormSubmit() {
		return $this->SyntaxPageFormSubmit();
	}

	function WYSIWYGTextArea($name='textarea',$columns='80',$rows='15',$encoding='',$content='',$stylesheet='') {
		$this->wysiwygactive=true;
		return $this->SyntaxTextarea($name,"html",$columns,$rows,$encoding,$content);
	}

	function SyntaxTextarea($name='textarea',$syntax="html",$columns='80',$rows='15',$encoding='',$content='') {	  
		$textarea="";
		$this->syntaxactive=true;	
		/*if ($this->GetPreference("useautocomplete","1")=="0") $class.=" autocomplete-off";
		if ($this->GetPreference("showlinenumbers","1")=="0") $class.=" linenumbers-off";
		*/
      /*if ($this->GetPreference("showtogglesyntax","1")=="1") {
     
			$textarea.="<br/><input type='checkbox' checked='1' onclick='codepress".$this->noeditors.".toggleEditor();' checked='checked' id='codepresscheck".$this->noeditors."'><label for='codepresscheck".$this->noeditors."'>".$this->Lang("togglesyntax")."</label>";
		}*/
    if ($this->GetPreference("showlinenumbers","1")=="1"){
      $this->smarty->assign('linenumbers', "true");
    } else {
      $this->smarty->assign('linenumbers', "false");
    }
    if ($this->GetPreference("textwrapping","1")=="1"){
      $this->smarty->assign('textwrapping', "true");
    } else {
      $this->smarty->assign('textwrapping', "false");
    }
    //lineNumbers: true,
    $config=$this->GetConfig();

    $this->smarty->assign('textareaid', "codemirrorarea".$this->noeditors);
    $this->smarty->assign('textareaname', $name);
    $this->smarty->assign('content', $content);
    $this->smarty->assign('id', $this->noeditors);
    $parserfile=""; $cssfile="";
    $cmdir=$config["root_url"].'/modules/CodeMirror/codemirror';
    switch($syntax) {
      
      case "html" : 
        $parserfile='"parsexml.js"'; 
        $cssfile='"'.$cmdir.'/css/xmlcolors.css"';
        break;
      case "css" :
        $parserfile='"parsecss.js"';
        $cssfile='"'.$cmdir.'/css/csscolors.css"';
        break;
      case "php" :
        $parserfile='["parsexml.js", "parsecss.js", "tokenizejavascript.js", "parsejavascript.js", "parsehtmlmixed.js","../contrib/php/js/tokenizephp.js", "../contrib/php/js/parsephp.js",                     "../contrib/php/js/parsephphtmlmixed.js"]';
        $cssfile='["'.$cmdir.'/css/xmlcolors.css","'.$cmdir.'/css/jscolors.css","'.$cmdir.'/css/csscolors.css","'.$cmdir.'/contrib/php/css/phpcolors.css"]';
        break;
    }
    $this->smarty->assign('parserfile', $parserfile);
    $this->smarty->assign('cssfile', $cssfile);
    $this->smarty->assign('root_url', $config["root_url"]);

    $textarea=$this->ProcessTemplate('codemirrorarea.tpl');

		$this->noeditors++;

		return $textarea;
	}

	function WYSIWYGGenerateHeader($htmlresult='') {
		return $this->SyntaxGenerateHeader();
	}

	function SyntaxGenerateHeader($htmlresult='') {
		if ($this->headerinfosent) return "";
		if ($this->noeditors==0) return '';
		//$GLOBALS["config"]["root_path"].

		$scriptpath=$GLOBALS["config"]["root_url"]."/modules/CodeMirror/codemirror/js/codemirror.js";
		$header="";
		$header.='<script language="Javascript" type="text/javascript" src="'.$scriptpath.'"></script>\n';
    $header.='<link rel="stylesheet" type="text/css" href="'.$GLOBALS["config"]["root_url"].'/modules/CodeMirror/codemirror.css"/>';
		$this->headerinfosent=true;
		return $header;
	}
}

?>