<?php
	
	/*

	function.rotate.php
	--------------------

	@file 		function.rotate.php
	@version 	0.2.1
	@date 		2009-12-01 22:47:58 -0600 (Sun, 29 Nov 2009)
	@author 	Kenton Glass <kenton@notnek.com>

	Copyright (c) 2009 Kenton Glass <http://www.notnek.com>

	*/
	
	
	# Rotate Function
	function smarty_cms_function_rotate($params, &$smarty){
	
		# Default Values
		$default['path']   = 'uploads/images/';
		$default['effect'] = 'fade';
		$default['speed']  = '2000';
		$default['delay']  = '5000';
		$default['width']  = '';
		$default['height'] = '';
		$default['max']    = 10;
	
		# Width
		if(!empty($params['width'])){
			$width = 'width="'.$params['width'].'px"';
		}
		else{
			$width = 'width="'.$default['width'].'px"';
		}
	
		# Height
		if(!empty($params['height'])){
			$height = 'height="'.$params['height'].'px"';
		}
		else{
			$height = 'height="'.$default['height'].'px"';
		}
		
		# Div Height
		if(!empty($params['height'])){
			$div_height = 'height:'.$params['height'].'px;';
		}
		else{
			$div_height = 'height:'.$default['height'].'px;';
		}
		
		# Max Images
		if(!empty($params['max'])){
			$max = $params['max'];
		}
		else{
			$max = $default['max'];
		}
 
		# Path
		if(!empty($params['path'])){
			$path = $params['path'];
		}
		else{
			$path = $default['path'];
		}
		
		# Allowed File Types
		$file_types = array('.jpg', '.gif', '.png');
	
		# Start Array
 		$image_list = array();
 
		# Check Path
		if(is_dir($path)){
 		
 			# Try to Open Directory
	 		$handle = opendir($path);
		
			# Read All Files in Directory
 			while(false !== ($file = readdir($handle))){
  			
  				# Not Hidden Files
  				if($file != "." && $file != ".."){
  				
  					# Get Exentension
   					$extension = strtolower(substr($file,-4));
   				
   					# Check Image
   					if(in_array($extension, $file_types)){
    				
   		 				# Add To Array
    					$image_list[] = $file;
  				
  					# End Check
  					}
 		
 				# End Not Hidden
 				}
 		
 			# End Loop
 			}
 		
 			# Close Directory
 			closedir($handle);
	
		# End Check Path
		}
 
		# Count Under Max
		if(count($image_list) < $max){
		
			# Set To Actual Count
			$max = count($image_list);
	 	
		# End Count Under Max
		}
		
		# Effect
		if(!empty($params['effect'])){
			$effect = $params['effect'];
		}
		else{
			$effect = $default['effect'];
		}
		
		# Delay
		if(!empty($params['delay'])){
			$delay = $params['delay'];
		}
		else{
			$delay = $default['delay'];
		}
		
		# Speed
		if(!empty($params['speed'])){
			$speed = $params['speed'];
		}
		else{
			$speed = $default['speed'];
		}
		
		# Start Div
		print '<div class="rotate" style="display:none;'.$div_height.'">'."\n";
		
		# Random Max Images
		$random = array_rand($image_list, $max);
 
		# Loop Images
		foreach($random as $image){
 		
 			# Print Image"
 			print '		<img src="'.$path.$image_list[$image].'" '.$width.' '.$height.' alt="'.$image_list[$image].'" />'."\n";
 	
 		# End Loop
 		}
 		
 		# End Div
 		print '</div>'."\n";
 		
 		# jQuery
		print '<script type="text/javascript">$(document).ready(function(){$(\'.rotate\').fadeIn(\'slow\');$(\'.rotate\').cycle({fx:\''.$effect.'\',timeout:'.$delay.',speed:'.$speed.'});});</script>';
	
	# End Rotate Function
	}
	
	# Help Function
	function smarty_cms_help_function_rotate(){

?>
<h3>What is Rotate?</h3>
	<p>Rotate is a plugin that creates a slideshow from a directory of images using the <a href="http://jquery.malsup.com/cycle/" rel="external">jQuery Cycle Plugin</a>.</p>
<h3>How do I use it?</h3>
	<p>Make sure to include the jQuery script, as well as the Cycle Script. Then just place the following tag in your template or content: <code>{rotate}</code></p>
<h3>What parameters can I use with Rotate?</h3>
	<p>
		<ul>
			<li><em>(optional)</em> <tt>path</tt> - Relative URL to pick images from (default is "uploads/images/").</li>
			<li><em>(optional)</em> <tt>effect</tt> - Transition Effect (default is fade; see <a href="http://malsup.com/jquery/cycle/browser.html" rel="external">Effects Browser</a> for available effects).</li>
			<li><em>(optional)</em> <tt>delay</tt> - Interval between images (default is 5 seconds).</li>
			<li><em>(optional)</em> <tt>speed</tt> - Transition speed (default is 2 seconds).</li>
			<li><em>(optional)</em> <tt>height</tt> - Image height (default is unspecified, eg. the actual image height).</li>
			<li><em>(optional)</em> <tt>width</tt> - Image width (default is unspecified, eg. actual image width).</li>
			<li><em>(optional)</em> <tt>max</tt> - Max number of images to display (default is 10).</li>
		</ul>
	</p>
	<p>You can change every parameter default by editing line 21-26 of <em>function.rotate.php</em>.</p>
<h3>Javascript</h3>
	<p>Make sure to include the following scripts before using {rotate}. You need to upload cycle.js to your server and change /PATH/TO/ to it's correct path.</p>
	<ul>
		<li><code>&lt;script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js"&gt;&lt;/script&gt;</code></li>
		<li><code>&lt;script type="text/javascript" src="/PATH/TO/cycle.js"&gt;&lt;/script&gt;</code></li>
	</ul>
<?php 

	# End Help Function
	}
	
	# About Function
	function smarty_cms_about_function_rotate(){

?>
<p>Author: <a href="http://www.notnek.com/" rel="external">Kenton Glass</a></p>
<p>Cycle Plugin from <a href="http://jquery.malsup.com/cycle/" rel="external">malsup</a> and licensed under the <a href="http://www.opensource.org/licenses/mit-license.php" rel="external">MIT License</a>.</p>
<p>Version: 0.2.1</p>
<br />
<p>Changes:</p>
<p>0.2.1 - Created Full &amp; Lite Versions. Changed jQuery load from css.block to fadein.</p>
<p>0.2 - Added full cycle effects. Upload included cycle.js to use different effects. You can use the 'effect' parameter to specify the effect.</p>
<p>0.1 - Fixed some code formatting.</p>
<p>0.1 - Version released.</p>
<?php

	# End About Function
	}
	
?>