<?php
  /*****************************************************************************************************************************
    XT TOOLS FUNCTIONS

    Jean-Christophe Cuvelier - Morris & Chapman Belgium - Copyrights 2009
    
    This class just contain some statics functions that can be used anywhere
  ********************************************************************************************************************************/
  
  class XT_XtendedModule extends CmsObject {


  	/**
  	 * This function validate an  email address (raw input) regarding several recent RFC
  	 *
  	 * @param string $email Email to be validated
  	 * @param boolean $dnstest Should we validate the DNS ? Default: false
  	 * @return boolean
  	 */
  	
  	 /*
  	  * This function was taken from  http://www.linuxjournal.com/article/9585 (2007/06/01) on 2009/05/25
  	  */
  	
  public static function isXtendedModule ($modulename)
  {
    $xtendedModule = MX_XtendedModule::doSelectOne(array('where' => array('modulename' => $modulename, 'isactive' => 1)));     
    
    if ($xtendedModule)
    {
      return true;
    }
    else
    {
      return false;
    }
  }
    
  
  public static function getXtendableModules()
  {
  	$instance = new self;
  	
    $db =& $instance->GetDb();

    $xtendedmodules = MX_XtendedModule::doSelectByModuleName();

    global $gCms;
    
    // Delete nonexistent modules
    
    foreach ($xtendedmodules as $key => $module)
    {
    	if (!isset($gCms->modules[$key]))
    	{
    		$module->delete();
    		unset($xtendedmodules[$module->getModuleName()]);
    	}
    }
       
    foreach( $gCms->modules as $key => $value )
    {
      $modinstance = $value['object'];
        
      if (method_exists($modinstance, 'XtendedModule'))
      {
      	if (isset($xtendedmodules[$modinstance->GetName()]))
        {
        	if ($modinstance->GetFriendlyName() != $xtendedmodules[$modinstance->GetName()]->getModuleFriendlyName())
        	{
        		 $xtendedmodules[$modinstance->GetName()]->modulefriendlyname = $modinstance->GetFriendlyName();
        		 $xtendedmodules[$modinstance->GetName()]->save();
        	}
        }
        else
        {
        	$xtendedmodule = new MX_XtendedModule();
        	$xtendedmodule->setModuleName($modinstance->GetName());
        	$xtendedmodule->setModuleFriendlyName($modinstance->GetFriendlyName());
        	$xtendedmodule->setInstalled(1);
        	$xtendedmodule->save();        

        	$xtendedmodules[$xtendedmodule->GetModuleName()] = $xtendedmodule;
        }
      }
    }
    
   return $xtendedmodules; 
  }  
 }
  ?>