<?php
  
  /*
   * Relation class
   * 
   * This class allow management of a relation object
   * 
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2009
   * 
   */

class MX_Category extends CmsObject 
{
  // Vars

	var $id;
  var $title;
  var $position;
  var $loaded = false;
	
	const DB_NAME  = 'module_modulextender_categories';

	public function __construct($id = null)
	{
		if ($id)
		{
			$this->id = $id;
			$this->load();
		}
	}
	
	public function getId()
	{
		return $this->id;
	}

	public function setId($value)
  {
    $this->id = $value;
  }
  
	
	public function __toString()
	{
		return $this->getTitle();
	}	
	
	public function getTitle($with_position = false)
	{
		// Numbering to implement
		return $this->title;
	}
	
	 public function setTitle($value)
  {
    $this->title = $value;
  }
  
	
	public function getPosition()
	{
		return $this->position;
	}
	
	public function getOptions($params = array()) 
	{
		$request = array('where' => array('category_id' => $this->getId()));
		
		if (isset($params['order_by']))
		{
			$request['order_by'] = $params['order_by'];
		}
		
	  if (isset($params['where_in']))
    {
      $request['where_in']= $params['where_in'];
    }
		
		return MX_Option::doSelect($request);
	}

	public function getOptionsById()
	{
		$options = array();
		
		foreach($this->getOptions() as $option)
		{
			$options[$option->getId()] = $option;
		}
		
		return $options;
	}
	
	public function load()
	{
		
    $db =& $this->GetDb();
    
		$query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME . ' WHERE id = ? LIMIT 1';
		
		$dbresult = $db->Execute($query, array($this->id));
		
	   if ($dbresult && $dbresult->RecordCount() > 0)
      {
      	$this->loaded = true;
        while ($dbresult && $row = $dbresult->FetchRow())
        {
          $this->PopulateFromDb($row);
        }
      }
	}
	
	public function PopulateFromDb($row)
	{
		  $this->id = $row['id'];
		  $this->title = $row['title'];
		  $this->position = $row['position'];
	}
	
  public function save()
  {
    // Upgrade or Insert ?
    if ($this->id != null)
    {
      $this->update();
    }
    else 
    {     
        $this->insert();
    }   
    
  }
  
  protected function update()
  {
    
    $db =& $this->GetDb();
    

      $query = 'UPDATE  ' . cms_db_prefix() .  self::DB_NAME . ' 
      
      SET ';
            
      $query .= ' title = ?, position = ?';
      
      $query .= '
      
      WHERE
      
      id = ?  ';
      
      
      $result = $db->Execute($query,
          array(
             $this->title, $this->getPosition(),

             $this->getId()
          )
        );        
        
        /*FIXME: Test the $db status; */
        
        return true;
  }
  
  protected function insert()
  {
    $db =& $this->GetDb();
    
    $this->setId($db->GenID(cms_db_prefix() .  self::DB_NAME .'_seq' ));
      
    $query = 'INSERT INTO ' . cms_db_prefix() .  self::DB_NAME .  ' 
      
      SET  id = ?,  ';

      $query .= ' title = ?, position = ?';
      
      
       $db->Execute($query,
          array(
            $this->getId(), 
             $this->title,
             $this->getPosition(),
          )
        );
        
        return true;    
  }
  
  public function isLoaded()
  {
    return $this->loaded;
  }
  
  public static function retrieveByPk($id)
  {
    return self::doSelectOne(array('where' => array('id' => $id)));    
  }
  
  public static function doSelectOne($params = array())
  {
    $items = self::doSelect($params);
    if ($items)
    {
      return $items[0];
    }
    else 
    {
      return null;
    }   
  }
    
  public static function doSelect($params = array())
  {
    $instance = new self();
    
    $db =& $instance->GetDb();
    
    $query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME;;
    
    $values = array();
    
    if (isset($params['where']))
    {

      $fields = array();
      foreach ($params['where'] as $field => $value) 
      {
        $fields[] = $field . ' =  ?';
        $values[] = $value;
      }
      
      $query .= ' WHERE ' . implode(' AND ', $fields);
    } 
    
    if(isset($params['order_by']))
    {
     $query .= ' ORDER BY ' . implode(', ' , $params['order_by']);
    }
    else
    {
      $query .= ' ORDER BY position';
    }
    
    $dbresult = $db->Execute($query, $values);
  
    $items = array();
   if ($dbresult && $dbresult->RecordCount() > 0)
    {
      while ($dbresult && $row = $dbresult->FetchRow())
      {
        $item = new self();
        $item->PopulateFromDb($row);
        $items[] = $item;
      }
    }
    
    return  $items;   
  }
  
    public function delete()
    {   
    	// Delete options first
    	
    	$options = $this->getOptions();
    	foreach ($options as $option)
    	{
    		$option->delete();
    	}
    
    $db =& $this->GetDb();
    $query = 'DELETE FROM '. cms_db_prefix() . self::DB_NAME;
    $query .= ' WHERE id = ?';
    $db->Execute($query, array($this->id));   
  }
}

?>