<?php
$lang["friendlyname"] = "plFileHandler";
$lang["moddescription"] = "Provides a file selection and upload for other back-end modules.";
$lang["admindescription"] = "Manage plFileHandler settings and templates.";

// GENERAL
$lang["uploadfile"] = "Upload a new file";
$lang["selectfile"] = "Select an existing file on the server";
$lang["removefile"] = "Remove file";
$lang["addfileinput"] = "Add another file";
$lang["filename"] = "Filename";
$lang["fileext"] = "Ext.";
$lang["filesize"] = "Size";
$lang["imagesize"] = "Dims";
$lang["Actions"] = "Actions";
$lang["lastmod"] = "Modified";
$lang["fileowner"] = "Owner";
$lang["fileperms"] = "Permissions";
$lang["showingdir"] = "Showing directory: ";
$lang["uploadsubmit"] = "Upload file";
$lang["cancel"] = "Cancel";
$lang["submit"] = "Submit";
$lang["apply"] = "Apply";
$lang["helptab"] = "Help";
$lang["sample"] = "Sample";
$lang["select"] = "Select file";
$lang["upload"] = "Upload new file";
$lang["remove"] = "Remove";
$lang["fieldtopopulate"] = "This is the field to populate (should be a hidden field):";
$lang["whatusersees"] = "This is what the user sees:";
$lang["postmaxsize"] = "(Note: the POST maximum size is currently set to %s)";

// TEMPLATES
$lang["templates"] = "Templates";
$lang["template"] = "Template";
$lang["name"] = "Name";
$lang["tpl_selector"] = "The small interface that integrate with other modules";
$lang["tpl_select_image"] = "The popup to select an image in image mode";
$lang["tpl_select_file"] = "The popup to select any file (in file mode)";
$lang["tpl_upload"] = "The popup to upload a new file";
$lang["tpl_minimal"] = "The popup to display error messages and such";


// PROMPTS, MESSAGES AND ERRORS
$lang["searchthistable"] = "Search this table for ";
$lang["prompt_select"] = "Select the file";
$lang["prompt_upload"] = "Select the file to upload";
$lang["partial_proceed"] = "Proceed with the files successfully uploaded.";
$lang["message_deleted"] = "Element deleted";
$lang["message_modified"] = "Modification saved";
$lang["message_successful"] = "The file upload was successful!";
$lang["error_couldnotfindfile"] = "The file could not be found.";
$lang["error_couldnotupload"] = "Could not upload file. Could it be a permission problem?";
$lang["error_wrongfiletype"] = "This file format is not accepted here.";

// MODULE INTERACTION
$lang["postinstall"] = "Module version %s installed.";
$lang["postuninstall"] = "Module uninstalled.";
$lang['help_sample'] = "This is an example call of the module. The only parameter specified here was 'mode', which has been set to 'image'.";
$lang["help"] = '<h3>What Does This Do?</h3>
				<p>It provides a small (easy to use and easy to implement) file selection and upload interface for other back-end modules.<br>
				<br/>You can see a sample in Extensions-&gt;plFileHandler, in the "Sample" tab.</p>
			<br/><h3>How Do I Use It?</h3>
				<br/><h4>The short version</h4><br/>
				<p>Call the DisplayInputs($params) function of this module from yours.</p>
				<br/><h4>The slightly longer version</h4><br/>
				<p>Let\'s say your module has a text field in which the user enters the url of an image he has uploaded. You will have something like this:<br/>
				<code>echo $this->CreateInputText($id, "nameofthefield", $current_value);</code></p>
				<p>Now what we will do is replace this field with the image selector provided by this module. In order not to alter the form submission of your module, we will keep the original input, but change it to a hidden input:<br/>
				<code>echo $this->CreateInputHidden($id, "nameofthefield", $current_value, \' id="\'.$id.\'nameofthefield"\');</code><br/>
				We specified the id of the input because we will need it later. You could also create it without the cmsms wrapper (like <code>echo \'&lt;input type="hidden" name="\'.$id.\'nameofthefield" id="\'.$id.\'nameofthefield" value="\'.$current_value.\'"/&gt;\';</code>), but in that case make sure to include the module instance $id in the name, otherwise your module won\'t retrieve the field.</p>
				<p>Now to add the image selector, we need to retrieve the plFileHandler module, which we can do in the following way:<br/>
				<code>$fhmod = $this->$this->GetModuleInstance("plFileHandler");</code><br/>
				(just to be safe, the whole procedure should be in a if($fhmod)-clause - see below)</p
				<p>Now we can call the selector using the following function:<br/>
				<code>echo $fhmod->DisplayInputs($params);</code><br/>
				Parameters are explained below. The returnInput is mandatory, so we\'ll need to define it - it is simply the id of the input we are wishing to replace. In addition, we\'ll set the "mode" to "image" (as we want only images anyway) and give the function the current value of the input. So this would give us the following parameters:<br/>
				<code>$params = array("returnInput"=>$id."nameofthefield", "mode"=>"image", "current"=>$current_value);</code><br/>
				or the following function :<br/>
				<code>$fhmod->DisplayInputs(array("returnInput"=>$id."nameofthefield", "mode"=>"image", "current"=>$current_value));</code><br/>
				(we could have set all other parameters, like start directory, but you can figure that out...)</p>
				<p>That\'s it.</p>
				<p>The following provides the complete example, with a fallback method:</p>
<textarea style="width: 800px; height: 200px;">
$fhmod = $this->GetModuleInstance("plFileHandler");
if($fhmod){
	echo \'<input type="hidden" name="\'.$id.\'nameofthefield" id="\'.$id.\'nameofthefield" value="\'.$current_value.\'"/>\';
	$params = array("returnInput"=>$id."nameofthefield", "mode"=>"image", "current"=>$current_value);
	echo $fhmod->DisplayInputs($params);
}else{
	echo $this->CreateInputText($id, "nameofthefield", $current_value);
}			
</textarea><br/><br/>
				<br/><h4>Note</h4>
				<p>As this module strongly relies on javascript, it <b>needs javascript to be enabled</b> in order to work.</p><br/>
			<br/><h3>Copyright and License</h3>
				<p>This module has been created by Pierre-Luc Germain (plger) and is released under the GNU Public License.</p><br/><br/>';

//PREFERENCES
$lang["settings"] = "Settings";
$lang["pref_default_allowed"] = "Default allowed extensions,separated by commas. Leave empty to allow all.";
$lang["pref_default_multiple"] = "Allow multiple files by default.";
$lang["pref_default_imagemode"] = "Use image mode by default.";
$lang["pref_default_crop"] = "Crop to proportion by default when resizing.";
$lang["pref_clean_names"] = "Clean names of uploaded files.";
$lang["pref_resize_existing"] = "Resize files that are already on the server.";
$lang["pref_resize_existing_replace"] = "When resizing a file already on the server, replace the file.";
$lang["pref_hide_thumbs"] = "Hide ImageManager and FileHandler thumnails (files that start with 'thumb_') from view (recommended).";
$lang["pref_filename_limit"] = "Limit (in characters) of the displayed filenames.";
$lang["pref_allow_filedelete"] = "Allow users to delete files via the plFileHandler interface.";
$lang["pref_create_thumbnails"] = "Create thumbnails when none available (recommended).";
$lang["pref_default_popup_width"] = "Default popup width";
$lang["pref_default_popup_height"] = "Default popup height";


//PARAMETERS
$lang["phelp_returnInput"] = "The full id of the input in which the file url should be returned. This parameter is <b>mandatory</b>.";
$lang["phelp_height"] = "The height of the popup window.";
$lang["phelp_width"] = "The width of the popup window.";
$lang["phelp_method"] = "The allowed method of choosing a file. Either 'upload', 'select' or 'both' (default both).";
$lang["phelp_noinit"] = "Does not initialize the javascript object - enable this if you use multiple instances on the same page.";
$lang["phelp_allowedext"] = "List of allowed file extensions, separated by commas.";
$lang["phelp_mode"] = "Specify the select mode: 'image' shows thumbnails (and allow to select only images) while 'file' shows a list.";
$lang["phelp_resize"] = "If you need the file to be resized, specify the target size ('widthxheight') with this parameter (check settings for resizing server images). This will prevent the selection of non-image files.";
$lang["phelp_crop"] = "When resizing, specifies whether or not to crop to proportions.";
$lang["phelp_noinit"] = "Does not initialize the javascript object - enable this if you use multiple instances on the same page.";
$lang["phelp_startdir"] = "Specifies the path (within the uploads path) at below which the user won't be able to go back.";
$lang["phelp_curdir"] = "Specifies a path (within the startdir) at which the selection will begin.";
$lang["phelp_multiple"] = "Specifies whether or not users can upload multiple files for this field.";
$lang["phelp_current"] = "Specifies the current value of the field.";


// TEMPLATE HELP
$lang["tpl_selector"] = "The small interface that integrate with other modules";
$lang["tpl_select_image"] = "The popup to select an image in image mode";
$lang["tpl_select_file"] = "The popup to select any file (in file mode)";
$lang["tpl_upload"] = "The popup to upload a new file";
$lang["tpl_minimal"] = "The popup to display error messages and such";

$lang["templatehelp_selector"] = '<ul>
<li>$method</li>
<li>$current_pic</li>
<li>$current_name</li>
<li>$currentdiv_id (id of the div in which the selected file will appear)</li>
<li>$current_url</li>
<li>$select_js</li>
<li>$select_link</li>
<li>$upload_js</li>
<li>$upload_link</li>
<li>$remove_js</li>
<li>$remove_link</li>
</ul>';
$lang["templatehelp_fileobj"] = '<br/>File Object:<ul>
<li>$file-&gt;filename</li>
<li>$file-&gt;path</li>
<li>$file-&gt;url</li>
<li>$file-&gt;is_folder</li>
<li>$file-&gt;owner</li>
<li>$file-&gt;permission</li>
<li>$file-&gt;filemtime</li>
<li>$file-&gt;modified</li>
<li>$file-&gt;imagesize</li>
<li>$file-&gt;width</li>
<li>$file-&gt;height</li>
<li>$file-&gt;ext</li>
<li>$file-&gt;size</li>
<li>$file-&gt;size_wformat</li>
<li>$file-&gt;sizecol</li>
<li>$file-&gt;imagesizecol</li>
<li>$file-&gt;deletelink</li>
<li>$file-&gt;thelink</li>
<li>$file-&gt;GetPic()</li>
<li>$file-&gt;GetIcon()</li>
<li>$file-&gt;limitName()</li>
<li>$file-&gt;GetViewLink()</li>
</ul>';
$lang["templatehelp_select_image"] = '<ul>
<li>$itemlist (array of file objects)</li>
<li>$title</li>
<li>$curdir</li>
<li>$showingdir</li>
<li>$javascript (needed)</li>
<li>$message</li>
</ul>'.$lang["templatehelp_fileobj"];
$lang["templatehelp_select_file"] = '<ul>
<li>$itemlist (array of file objects)</li>
<li>$title</li>
<li>$curdir</li>
<li>$showingdir</li>
<li>$instantsearch</li>
<li>$tablename</li>
<li>$sortlinks</li>
<li>$numeric_sortlinks</li>
<li>$headers (similar to file objects)</li>
<li>$javascript (needed)</li>
<li>$message</li>
</ul>'.$lang["templatehelp_fileobj"];
$lang["templatehelp_upload"] = '<ul>
<li>$title</li>
<li>$allowmultiple (bool)</li>
<li>$formstart</li>
<li>$fileinput</li>
<li>$addinput</li>
<li>$submit</li>
<li>$formend</li>
<li>$javascript (needed)</li>
<li>$message</li>
</ul>
';
$lang["templatehelp_minimal"] = '<ul>
<li>$message</li>
<li>$content</li>
</ul>
';
?>
