<?php
#-------------------------------------------------------------------------
# Module: plFileHandler
# by Pierre-Luc Germain
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project"s homepage is: http://www.cmsmadesimple.org
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class plFileHandler extends CMSModule {

	function GetName(){					return "plFileHandler";					}
	function GetFriendlyName(){			return $this->Lang("friendlyname");		}
	function GetVersion(){				return "0.1";							}
	function GetHelp(){					return $this->Lang("help");				}
	function GetAuthor(){				return "Pierre-Luc Germain (plger)";	}

	function IsPluginModule(){			return false;	}

	function HasAdmin(){				return true;	}
	function GetAdminSection(){			return "extensions";					}
	function GetAdminDescription(){		return $this->Lang("admindescription");	}

	function InstallPostMessage(){		return $this->Lang("postinstall",$this->GetVersion());	}
	function UninstallPostMessage(){	return $this->Lang("postuninstall");	}

	function VisibleToAdminUser(){
		return ($this->CheckPermission("plFileHandler_admin"));
	}
	
	function Install(){
		global $gCms;
		require "method.install.php";
	}

	function Uninstall(){
		global $gCms;
		require "method.uninstall.php";
	}
	
	function SetParameters(){
		$this->CreateParameter("returnInput", "", $this->lang("phelp_returnInput"));
		$this->SetParameterType("returnInput",CLEAN_STRING);		
		$this->CreateParameter("current", "", $this->lang("phelp_current"));
		$this->SetParameterType("current",CLEAN_STRING);					
		$this->CreateParameter("method", "", $this->lang("phelp_method"));
		$this->SetParameterType("method",CLEAN_STRING);		
		$this->CreateParameter("allowedext", "", $this->lang("phelp_allowedext"));
		$this->SetParameterType("allowedext",CLEAN_STRING);		
		$this->CreateParameter("mode", "", $this->lang("phelp_mode"));
		$this->SetParameterType("mode",CLEAN_STRING);
		$this->CreateParameter("noinit", 0, $this->lang("phelp_noinit"));
		$this->SetParameterType("noinit",CLEAN_INT);				
		$this->CreateParameter("resize", "", $this->lang("phelp_resize"));
		$this->SetParameterType("resize",CLEAN_STRING);		
		$this->CreateParameter("crop", 0, $this->lang("phelp_crop"));
		$this->SetParameterType("crop",CLEAN_INT);				
		$this->CreateParameter("curdir", "", $this->lang("phelp_curdir"));
		$this->SetParameterType("curdir",CLEAN_STRING);		
		$this->CreateParameter("startdir", "", $this->lang("phelp_startdir"));
		$this->SetParameterType("startdir",CLEAN_STRING);		
		$this->CreateParameter("multiple", "", $this->lang("phelp_multiple"));
		$this->SetParameterType("multiple",CLEAN_INT);						
		$this->CreateParameter("width", "", $this->lang("phelp_width"));
		$this->SetParameterType("width",CLEAN_INT);		
		$this->CreateParameter("height", "", $this->lang("phelp_height"));
		$this->SetParameterType("height",CLEAN_INT);		
		
	}
	
	function getFileContent($filename){
		$filepath = dirname(__FILE__).DIRECTORY_SEPARATOR.$filename;
		if(file_exists($filepath)){
			$fhandle = fopen($filepath, 'r');
			$content = fread($fhandle, filesize($filepath));
			fclose($fhandle);
			return $content;
		}else{
			return false;
		}
	}

	function getSettings(){
		// returns preferences
		// array of array(pref_name, pref_type, default_value)
		$settings = array(
			array( "default_allowed", "text", "" ),
			array( "default_multiple", "checkbox", false ),
			array( "default_imagemode", "checkbox", false ),
			array( "default_popup_width", "number", 480 ),
			array( "default_popup_height", "number", 400 ),
			array( "clean_names", "checkbox", true ),
			array( "resize_existing", "checkbox", false ),
			array( "resize_existing_replace", "checkbox", false ),
			array( "default_crop", "checkbox", false ),
			array( "hide_thumbs", "checkbox", true ),
			array( "filename_limit", "number", 20 ),
			array( "allow_filedelete", "checkbox", true ),
			array( "create_thumbnails", "checkbox", true )
		);
		return $settings;
	}

	function DoAction($action, $id, $params, $returnid=-1){
		global $gCms;
		
		switch($action){
			case "edittemplate":
				require "action.edittemplate.php";
				break;
			case "defaultadmin":
				require "action.defaultadmin.php";
				break;
			case "default":
			default:
				return $this->DisplayInputs;
				break;
		}
	}
	
	function DisplayInputs($params){
		global $gCms;
		$output = false;
		require "action.default.php";
		return $output;
	}

	function GetReturnScript($close=true){
		return '
<script type="text/javascript">
function plFileHandler_return(returnValue, pictoshow){
	if(parent && parent.plFileHandler){
		parent.plFileHandler.do_return(returnValue, pictoshow);
	}else{
		if(plFileHandler)	plFileHandler.do_return(returnValue, pictoshow);
	}
}
'.($close?'</script>
':'');
	}

	function GetFileInfo($filepath){
		require "function.GetFileInfo.php";
		return $info;
	}

	function plResize($fullpath, $newpath, $newwidth, $newheight=false, $transparency=false, $crop=false){
		require "function.plresize.php";
		return $return;
	}
	
	function clean_file_name($filename){
		$extension = strtolower(strrchr($filename, "."));
		$filename = str_replace('-','_',munge_string_to_url(substr($filename,0,strlen($filename)-strlen($extension))));
		return $filename.$extension;
	}
	
	function iterate_to_unique($filepath){
		// if a file of that name exists, appends number to the filename
		$extension = strrchr($filepath, ".");
		$cleanfilename = str_replace($extension, "", $filepath);

		$i = 1;
		while(file_exists($filepath)){
			$filepath = $cleanfilename."_".$i.$extension;
			$i++;
		}
		return $filepath;
	}
	
	function GetFileIcon($filename, $small=false){
		global $gCms;
		$extension = strtolower(substr(strrchr($filename, "."), 1));
		if($extension == 'pdf'){
			$icon = 'pdf';
		}elseif(in_array($extension, array('txt','asc','ascii','nfo','msg'))){
			$icon = 'text';
		}elseif(in_array($extension, array('exe','bat','sh'))){
			$icon = 'application';
		}elseif(in_array($extension, array('flv','wma','wmv','mp3','wav','midi'))){
			$icon = 'media';
		}elseif(in_array($extension, array('swf','html','htm','shtml','js','xml','css','cfm'))){
			$icon = 'html';
		}elseif(in_array($extension, array('doc','docx','xls','xlsx','ppt','odt','ods','rtf','dot','email','latex','tex','wpd'))){
			$icon = 'document';
		}elseif(in_array($extension, array('jpg','jpeg','gif','png','bmp','tiff','psd','xcf'))){
			$icon = 'image';
		}elseif(in_array($extension, array('zip','tar','jar','7zip','rar','ace','arc','arj','z','sit','bz2','tgz','gz','lha','lzh','deb','rpm'))){
			$icon = 'archive';
		}elseif(in_array($extension, array('ttf','abf','afm','dfont','eot','fi','fnt','fon','font','fot','gdr','gsf','tfm'))){
			$icon = 'font';
		}elseif(in_array($extension, array('docm','php','asp','java'))){
			$icon = 'script';
		}else{
			$icon = 'file';
		}
		return $gCms->config['root_url'].'/modules/plFileHandler/images/'.$icon.($small?'_small':'').'.png';
	}
	
	

}

?>
