<?php
require "class.plFileHandler_file.php";
require "functions.select.php";

$params = array_merge($_GET, $_POST);

require '../../include.php';

if(!isset($gCms->modules['plFileHandler']) || !$gCms->modules['plFileHandler']['active'])	die('Could not find module');
$module = $gCms->modules['plFileHandler']['object'];

$crop = false;
$resize = false;
if(isset($params['resize'])){
	$resize = explode('x',$params['resize']);
	if(count($resize)==2 && $resize[0] > 0 && $resize[1] > 0){
		$crop = isset($params['crop'])?$params['crop']:$module->GetPreference('default_crop',false);
	}
}


$imgext = array('jpeg','jpg','png','gif');
$allowedext = isset($params['allowedext'])?$params['allowedext']:$module->GetPreference('default_allowed','');
if($allowedext && $allowedext != ''){
	$allowedext = array();
	foreach(explode(',',$params['allowedext']) as $ext){
		if($resize){
			if(in_array($ext, $imgext))	array_push($allowedext, strtolower(trim($ext)));
		}else{
			array_push($allowedext, strtolower(trim($ext)));
		}
	}
}elseif($resize){
	$allowedext = $imgext;
}else{
	$allowedext = false;
}

$clean_names = $module->GetPreference('clean_names',true);
$allowmultiple = isset($params['multiple'])?$params['multiple']:$module->GetPreference('default_multiple',false);


/* PROCESS FILES */
$errors = '';
$firstpath = false;
$uploaded = array();
if(isset($params['uploadsubmit'])){
	foreach($_FILES as $fieldname=>$file){
		if(isset($file['name']) && $file['name'] != ""){
			$extension = strtolower(substr(strrchr($file['name'], "."),1));
			if( !$allowedext || in_array($extension, $allowedext) ){
				$filename = $file['name'];
				if($clean_names)	$filename = $module->clean_file_name($filename);
				$startdir = (isset($params['startdir'])?rtrim($params['startdir'],'/').'/':'');
				$filepath = clean_join_path($gCms->config['uploads_path'].'/'.$startdir.$filename);
				$filepath = $module->iterate_to_unique($filepath);
				if(cms_move_uploaded_file($file["tmp_name"], $filepath)){
					if(!$firstpath)	$firstpath = $filepath;
					if($resize)	$module->plResize($filepath, $filepath, $resize[0], $resize[1], true, $crop);
					$fileUrl = clean_join_url($gCms->config['uploads_url'].'/'.$startdir.$filename);
					array_push($uploaded, $fileUrl);
				}else{
					$errors .= "<li>".$file['name'].': '.$module->Lang('error_couldnotupload')."</li>";
				}
			}else{
				$errors = '<li>'.$file['name'].': '.$module->Lang('error_wrongfiletype').'</li>';
			}
		}
	}
}

if($errors != ''){
	$message = '<ul>'.$errors.'</ul>';
}elseif(count($uploaded)>0){
	$message = $module->Lang('message_successful');
}
$module->smarty->assign("message",isset($message)?$message:false);

if(count($uploaded) == 0){

	/* DISPLAY FORM */

	$javascript = '';
	if($allowmultiple)	$javascript = '<script type="text/javascript">
	var fh_nbfileinput = 1;

	function fh_addfileinput(btn){
		if(!btn.parentNode)	return false;
		var container = btn.parentNode.parentNode.getElementsByTagName("div")[0];
		if(!container) return false;
		nbfileinput++;
		var tmpinput = document.createElement("input");
		tmpinput.type = "file";
		tmpinput.name = "uploadfile"+nbfileinput;
		var thep = document.createElement("p");
		thep.appendChild(tmpinput);
		container.appendChild(thep);
		if(nbfileinput == 12)	btn.style.display = false;
		return false;
	}
	</script>';
	$addinput = $allowmultiple?'<a style="cursor: pointer;" onclick="fh_addfileinput(this);">'.$module->Lang('addfileinput').'</a>':false;

	$module->smarty->assign("title",$module->Lang('prompt_upload'));
	$module->smarty->assign("allowmultiple",$allowmultiple);
	$module->smarty->assign("postmaxsize", $module->Lang('postmaxsize', ini_get('post_max_size')));
	$module->smarty->assign("javascript",$javascript);
	$module->smarty->assign("formstart",'<form action="bg_upload.php" method="POST" enctype="multipart/form-data">');
	$module->smarty->assign("fileinput",'<div><p><input type="file" name="uploadfile1"/></p></div>');
	$module->smarty->assign("addinput",$addinput);
	$module->smarty->assign("submit",'<input type="submit" name="uploadsubmit" value="'.$module->Lang('uploadsubmit').'"/>');
	
	$formend = '';
	foreach($params as $key=>$value)	$formend .= '<input type="hidden" name="'.$key.'" value="'.$value.'"/>';
	$module->smarty->assign("formend",$formend.'</form>');

	echo $module->ProcessTemplateFromDatabase('upload');

}elseif($errors == ''){
	// all files were uploaded
	$obj = new plFileHandler_file($firstpath, $uploaded[0], false);
	$content = $module->GetReturnScript(false).'
plFileHandler_return("'.implode(',',$uploaded).'","'.$obj->GetPic(false).'");
</script>';
	$module->smarty->assign("content", $content);
	echo $module->ProcessTemplateFromDatabase('minimal');
	
}else{

	// files were partially uploaded
	$obj = new plFileHandler_file($firstpath, $uploaded[0], false);
	$content = $module->GetReturnScript().'
<a style="cursor: pointer;" onclick="plFileHandler_return("'.implode(',',$uploaded).'","'.$obj->GetPic(false).'");">'.$module->Lang('partial_proceed').'<a>';	
	$module->smarty->assign("content", $content);
	echo $module->ProcessTemplateFromDatabase('minimal');
	
}
