<?php
if (!isset($gCms)) exit;

if (! $this->CheckAccess())
	{
	return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
	}

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for XMLMadeSimple "defaultadmin" admin action
   
   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/

$this->smarty->assign('tab_headers',$this->StartTabHeaders().
	$this->SetTabHeader('feeds',$this->Lang('title_feeds')).
	$this->SetTabHeader('templates',$this->Lang('title_templates')).
	$this->SetTabHeader('options',$this->Lang('title_options')).
	$this->EndTabHeaders().$this->StartTabContent());
$this->smarty->assign('end_tab',$this->EndTab());
$this->smarty->assign('tab_footers',$this->EndTabContent());
$this->smarty->assign('start_feeds_tab',$this->StartTab('feeds'));
$this->smarty->assign('start_templates_tab',$this->StartTab('templates'));
$this->smarty->assign('start_options_tab',$this->StartTab('options'));
$this->smarty->assign('title_section','defaultadmin');


// Feeds Tab
//**********

$feeds = MCFeed::doSelect();

$rowclass = 'row1'; 

foreach ($feeds as $feed)
{
  $feed->rowclass = $rowclass;
  $feed->edit = $this->CreateLink($id, 'manageFeed', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $feed->getTitle(),'','','systemicon'), array('feed_id'=>$feed->getId()), '');
  $feed->delete = $this->CreateLink($id, 'deleteFeed', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $feed->getTitle(),'','','systemicon'), array('feed_id'=>$feed->getId()), '');
  
  ($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}
  
$this->smarty->assign('feeds', $feeds);
$this->smarty->assign('feed_title', $this->Lang('feed_title'));
$this->smarty->assign('feed_url', $this->Lang('feed_url'));

$this->smarty->assign('addfeedlink',$this->CreateLink($id, 'manageFeed', '', $this->Lang('title_add_feed'),array()));    
$this->smarty->assign('addfeedicon',$this->CreateLink($id, 'manageFeed', '', $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('title_add_feed'),'', '','systemicon'), array()));



// Templates Tabs
//****************

    $template_list = $this->ListTemplates();
    
    $rowclass = 'row1';
    
    $templates = array();
    
    foreach ($template_list as $template)
    {
        $onerow = new stdClass();
    
        $onerow->name = $template;
        $onerow->deletelink = $this->CreateLink($id, 'deleteTemplate', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('deleteTemplate'),'','','systemicon'), array('template'=>$template), $this->Lang('areyousure'));
        $onerow->editlink = $this->CreateLink($id, 'manageTemplate', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('editTemplate'),'','','systemicon'), array('template'=>$template));
        $onerow->rowclass = $rowclass;
        $templates[] = $onerow;
    
        ($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
    }
    
    $this->smarty->assign('templates', $templates);
    $this->smarty->assign('title_template', $this->Lang('title_template'));    
    $this->smarty->assign('addtemplatelink',$this->CreateLink($id, 'manageTemplate', '', $this->Lang('title_add_template'),array()));    
    $this->smarty->assign('addtemplateicon',$this->CreateLink($id, 'manageTemplate', '', $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('title_add_template'),'', '','systemicon'), array()));
    
// Option Tab
//************

    
$this->smarty->assign('form_start', $this->CreateFormStart($id, 'defaultadmin', $returnid));
$this->smarty->assign('form_end',$this->CreateFormEnd());

$this->smarty->assign('options_title', $this->Lang('options_title'));
if (isset($params['submit_options']) && isset($params['cache']) && is_numeric($params['cache']) && $params['cache'] > 0 )
{
  $this->SetPreference('cache', $params['cache']);
}

$this->smarty->assign('cache_title', $this->Lang('cache'));
$this->smarty->assign('cache', $this->CreateInputText($id, 'cache', $this->GetPreference('cache')));


$this->smarty->assign('submit_options',$this->CreateInputSubmit($id, 'submit_options', $this->Lang('submit'))); 
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));

$this->smarty->assign('options_tab', $this->ProcessTemplate('admin.options.tab.tpl'));


echo $this->ProcessTemplate('adminpanel.tpl');


?>