﻿<?php
echo '<SCRIPT LANGUAGE=javascript>
<!--
	// Set the scale of the spectrum and gray scale images.
	var m_intScale = 6; // 1/6 size
	
	// Capture events for Mozilla and Netscape
	try {
		document.captureEvents(Event.MOUSEMOVE | Event.MOUSEUP | Event.MOUSEDOWN);
	} catch (ex) { }


	// The images src property must be set here to use the filePath
	function body_onLoad() {
		var filePath = ".";
		
		document.getElementById("__advCP_spectrum").src = filePath + "/images/spectrum_small.jpg";
		document.getElementById("__advCP_grayScale").src = filePath + "/images/grayScale.jpg";
		document.getElementById("__advCP_circle").src = filePath + "/images/10Pix-circle.gif";
		
		document.getElementById("__advCP_grayScale").onmousemove = grayScale_onMove;
		document.getElementById("__advCP_grayScale").onmouseup = grayScale_onClick;
		
		document.getElementById("__advCP_spectrum").onmousemove = spectrum_onMove;
		document.getElementById("__advCP_spectrum").onmouseup = spectrum_onClick;
		
		document.getElementById("__advCP_circle").onmousemove = circle_onMove;
		document.getElementById("__advCP_circle").onmouseup = circle_onClick;
		
	}
	
	
	// Puts the circle gif at the position specified.
	function placeCircle(xPos, yPos) {
		var circle = document.getElementById("__advCP_circle");
		
		circle.style.left = (xPos) - (circle.width/2);
		circle.style.top = (yPos) - (circle.height/2);
	}

	
	function ok_onClick() {
		window.opener.colorPicker_callBack(document.getElementById("__advCP_colorTxt").value, "");
		
	}

	
	function cancel_onClick() {
		self.close();
	}


	// Circle events pass the event on the the correct function.
	function circle_onClick(e) {
		try {
			if (((window.event)? window.event.x : e.pageX) > 278) {
				grayScale_onClick(e);
			}
			else {
				spectrum_onClick(e);
			}
		} catch (e) {};
	}
	
	
	function circle_onMove(e) {
		try {
			if (((window.event)? window.event.x : e.pageX) > 278) {
				grayScale_onMove(e);
			}
			else {
				spectrum_onMove(e);
			}
		} catch (e) {};
	}



	function grayScale_onClick(e) {
		try {
			var yPos = (window.event)? window.event.y : e.pageY;
			var xPos = (window.event)? window.event.x : e.pageX;
			var strColor = getColorGS(yPos - 19);
		
			placeCircle(xPos, yPos);
			document.getElementById("__advCP_colorChoice").style.backgroundColor = strColor;
			document.getElementById("__advCP_colorTxt").value = strColor;
		} catch (e) {};
	}
	
	
	function grayScale_onMove(e) {
		try {
			document.getElementById("__advCP_colorView").style.backgroundColor = getColorGS((window.event)? window.event.y - 19 : e.pageY - 19);
		} catch (e) {};
	}
	
	
	// Gets the gray scale color for the position given.
	function getColorGS(yPos) {
		
		var value = 0;
		
		yPos = yPos * (m_intScale / 2);
		value = number2Hex(Math.max(Math.min(256 - yPos,255),0));
		
		return value + "" + value + "" + value;
	}
	
	
	function spectrum_onClick(e) {
		try {
			var yPos = (window.event)? window.event.y : e.pageY;
			var xPos = (window.event)? window.event.x : e.pageX;
			var strColor = getColor(xPos - 19, yPos - 19);
		
			placeCircle(xPos, yPos);
			document.getElementById("__advCP_colorChoice").style.backgroundColor = strColor;
			document.getElementById("__advCP_colorTxt").value = strColor;
		} catch (e) {};
	}
	
	
	function spectrum_onMove(e) {
		try {
			var yPos = (window.event)? window.event.y : e.pageY;
			var xPos = (window.event)? window.event.x : e.pageX;
			
			document.getElementById("__advCP_colorView").style.backgroundColor = getColor(xPos - 19, yPos - 19);
		} catch (e) {};
	}
	
	
	function getColor(xPos, yPos) {
		var red = 0;
		var blue = 0;
		var green = 0;
		
		xPos = xPos * m_intScale;
		yPos = yPos * m_intScale;
		
		
		// Get the hue based on the x position.
		
		// Get Red Value
		if ((xPos < 256) || (xPos > 1280)) {
			red = 255;
		}
		else if ((xPos > 255) && (xPos < 512)) {
			red = 255 + (256 - (xPos));
		}
		else if (xPos > 1023) {
			red = xPos - 1024;
		}
		
		
		//Get Green Value
		if (xPos < 256) {
			green = xPos;
		}
		else if ((xPos > 255) && (xPos < 768)) {
			green = 255;
		}
		else if ((xPos > 767) && (xPos < 1024)) {
			green = 255 + (768 - (xPos));
		}
		
		//Get Blue Value
		if ((xPos > 767) && (xPos < 1280)) {
			blue = 255;
		}
		else if ((xPos > 511) && (xPos < 768)) {
			blue = xPos - 512;
		}
		else if (xPos > 1279) {
			blue = 256 + (1280 - (xPos));
		}
		

		// Darken or lighten the correct percentage based on the y position.
		if (yPos > 255) {
			var darkenPct = ((yPos - 256) / 256);

			red = parseInt(red - (red * darkenPct));
			green = parseInt(green - (green * darkenPct));
			blue = parseInt(blue - (blue * darkenPct));
		}
		else {
			yPos = 256 - yPos;
			var lightenPct = (yPos / 256);
			
			red = parseInt(red + ((256 - red) * lightenPct));
			green = parseInt(green + ((256 - green) * lightenPct));
			blue = parseInt(blue + ((256 - blue) * lightenPct));
		}
		
		
		// Make sure the value is between 0-255
		red = Math.max(Math.min(red,255),0);
		green = Math.max(Math.min(green,255),0);
		blue = Math.max(Math.min(blue,255),0);
		
		//return the RGB Hex string
		return number2Hex(red) + "" + number2Hex(green) + "" + number2Hex(blue);
	}
	
	
	function number2Hex(intNum) {
		var intBase = intNum / 16;
		var intRem = intNum % 16;
		
		intBase = intBase - (intRem / 16);
		
		return digit2Hex(intBase) + "" + digit2Hex(intRem);
	}

	
	
	function digit2Hex(intDig) {
		if((intDig >= 0) && (intDig <= 9)) {
			return intDig;
		}
		else {
			switch(intDig) {
				case 10: return "A"; 
				case 11: return "B"; 
				case 12: return "C"; 
				case 13: return "D"; 
				case 14: return "E"; 
				case 15: return "F"; 
			}
		}
	}

//-->
</SCRIPT>
</HEAD>
<BODY BGCOLOR="#D4D0C8" ONLOAD="body_onLoad();">

<IMG SRC="" BORDER=0 
	ID="__advCP_spectrum"
	STYLE="position:absolute;top: 15; left:15; border-style:solid;border-width:1px;z-index:1000;">
	
<IMG SRC="images/grayScale.jpg" BORDER=0 
	ID="__advCP_grayScale"
	STYLE="position:absolute;top: 15; left:280; border-style:solid;border-width:1px;z-index:1000;">

<IMG SRC="images/10Pix-circle.gif" WIDTH=10 HEIGHT=10 BORDER=0 
	ID="__advCP_circle"
	STYLE="position:absolute;position:absolute;top: -500; left:-500;border-style:none;z-index:1001;">

<TABLE ID="__advCP_colorView" WIDTH="40" HEIGHT="39" STYLE="position:absolute;top:15;left:300;border-style:solid;border-color:black;border-width:1px;">
	<TR><TD>&nbsp;</TD></TR></TABLE>
<TABLE ID="__advCP_colorChoice" WIDTH="40" HEIGHT="39" STYLE="position:absolute;top:63;left:300;border-style:solid;border-color:black;border-width:1px;background-color:white;">
	<TR><TD>&nbsp;</TD></TR></TABLE>

<INPUT TYPE="text" ID="__advCP_colorTxt" VALUE="FFFFFF" DISABLED
	STYLE="FONT-SIZE: 9pt;width:50px;position:absolute;top:110;left:15;border-width:1px;font-weight:bold;">

<INPUT TYPE="button" ID="__advCP_cancelBttn" VALUE="Cancel"
	STYLE="FONT-SIZE: 9pt;width:60px;position:absolute;top:110;left:215"
	ONCLICK="cancel_onClick();">
	
<INPUT TYPE="button" ID="__advCP_okBttn" VALUE="OK"
	STYLE="FONT-SIZE: 9pt;width:60px;position:absolute;top:110;left:280"
	ONCLICK="ok_onClick();">
	';