<?php
#-------------------------------------------------------------------------
# Module: TruetypeText - This module can be used to write any text with a TrueType font.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2006 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
# This file originally created by ModuleMaker module, version 0.2
# Copyright (c) 2006 by Samuel Goldstein (sjg@cmsmadesimple.org) 
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
//error_reporting(2047);

error_reporting(E_ALL);

class TruetypeText extends CMSModule
{
	function GetName() { return 'TruetypeText'; }
	function GetFriendlyName() {return $this->lang('friendlyname');}
	function GetVersion() { return '2.1.1'; }
	function MinimumCMSVersion() { return '1.0';}
	function GetHelp() {return $this->lang('help');}
	function GetDescription($lang = 'en_US') {return $this->lang('description');}
	function GetAdminDescription($lang = 'en_US') {return $this->lang('admindescription');}
	function GetAuthor() {return 'Damien GAUTHIER';}
	function HasAdmin() {return true;}
	function GetAdminSection() {return 'layout';}
	function IsPluginModule() {return true;}
	
	function getHTMLimg (& $ttt, $text)
	{
		global $CMS_ADMIN_PAGE;
		
		$image = cms_join_path('modules', $this->GetName(),$ttt->getImage($text));
		if (isset($CMS_ADMIN_PAGE))
			$image = cms_join_path('..', $image);
		return '<img src="'.$image.'" alt="'.$text.'" />';
	}
	

	
	function getFonts()
	{
		$fontfiles = array();
		if ($handle = @opendir(cms_join_path(dirname(__FILE__),'fonts')))
		{
			while (false !== ($file = @readdir($handle)))
			{
				if (endswith(strtolower($file), '.ttf') || endswith(strtolower($file), '.otf'))
				{
					$fontfiles[] = $file;
				}
			}
			@closedir($handle);
		}
		return $fontfiles;
	}
	
	
	function ContentPostRender(&$content)
	{
		
		if ($this->getpreference('replacefunction')!='ContentPostRender') return;
		
		include_once cms_join_path(dirname(__FILE__),'class.replacements.php');
		$TTTrl = new TTTreplacementlist();
		if (count($TTTrl->replacements)==0) return;
		
		$this->autoreplace($content, $TTTrl->replacements);
	}
	
	function ContentPostCompile(&$content)
	{
		
		if ($this->getpreference('replacefunction')!='ContentPostCompile') return;
		
		include_once cms_join_path(dirname(__FILE__),'class.replacements.php');
		$TTTrl = new TTTreplacementlist();
		if (count($TTTrl->replacements)==0) return;
		
		$this->autoreplace($content, $TTTrl->replacements);
	}
	
	function AutoReplace(&$content, $replacementlist)
	{
		include_once cms_join_path(dirname(__FILE__),'class.style.php');
		$TTTsl = new TTTstylelist();
		$TTTstyles = array();
		foreach ($TTTsl->styles as $TTTstyle)
			$TTTstyles[$TTTstyle->id] = $TTTstyle;
		
		$patterns = array();
		$replacements = array();
		
		foreach ($replacementlist as $TTTr)
		{
			$patterns[] = '|(<'.$TTTr->tag.'(?:[^>]*)'.($TTTr->additional=='' ? '' : $TTTr->additional.'(?:[^>]*)').'>)(.*?)(</'.$TTTr->tag.'>)|seim';
			$replacements[] = '"\\1".\$TTTstyles['.$TTTr->style.']->getImageClean("\\2")."\\3"';
		}
		//$content .= '<!-- '.count($replacements).' - '.$replacements[0].' -->';
		$content = preg_replace($patterns, $replacements, $content);
		
	}
	
}

?>
