<?php
  /*****************************************************************************************************************************
    XT TOOLS FUNCTIONS

    Jean-Christophe Cuvelier - Morris & Chapman Belgium - Copyrights 2009
    
    This class just contain some statics functions that can be used anywhere
  ********************************************************************************************************************************/
  
  class XT_Tools extends CmsObject {


  	/**
  	 * This function validate an  email address (raw input) regarding several recent RFC
  	 *
  	 * @param string $email Email to be validated
  	 * @param boolean $dnstest Should we validate the DNS ? Default: false
  	 * @return boolean
  	 */
  	
  	 /*
  	  * This function was taken from  http://www.linuxjournal.com/article/9585 (2007/06/01) on 2009/05/25
  	  */
  	
		public static function validEmail($email, $dnstest = false)
		{
		   $isValid = true;
		   $atIndex = strrpos($email, "@");
		   if (is_bool($atIndex) && !$atIndex)
		   {
		      $isValid = false;
		   }
		   else
		   {
		      $domain = substr($email, $atIndex+1);
		      $local = substr($email, 0, $atIndex);
		      $localLen = strlen($local);
		      $domainLen = strlen($domain);
		      if ($localLen < 1 || $localLen > 64)
		      {
		         // local part length exceeded
		         $isValid = false;
		      }
		      else if ($domainLen < 1 || $domainLen > 255)
		      {
		         // domain part length exceeded
		         $isValid = false;
		      }
		      else if ($local[0] == '.' || $local[$localLen-1] == '.')
		      {
		         // local part starts or ends with '.'
		         $isValid = false;
		      }
		      else if (preg_match('/\\.\\./', $local))
		      {
		         // local part has two consecutive dots
		         $isValid = false;
		      }
		      else if (!preg_match('/^[A-Za-z0-9\\-\\.]+$/', $domain))
		      {
		         // character not valid in domain part
		         $isValid = false;
		      }
		      else if (preg_match('/\\.\\./', $domain))
		      {
		         // domain part has two consecutive dots
		         $isValid = false;
		      }
		      else if
		      (!preg_match('/^(\\\\.|[A-Za-z0-9!#%&`_=\\/$\'*+?^{}|~.-])+$/',
		                 str_replace("\\\\","",$local)))
		      {
		         // character not valid in local part unless 
		         // local part is quoted
		         if (!preg_match('/^"(\\\\"|[^"])+"$/',
		             str_replace("\\\\","",$local)))
		         {
		            $isValid = false;
		         }
		      }
		      
          
		      if ($dnstest && ($isValid && !(checkdnsrr($domain,"MX") || checkdnsrr($domain,"A"))))
		      {
		         // domain not found in DNS
		         $isValid = false;
		      }
		      
		   }
		   return $isValid;
		}
  
 }
  ?>