<?php
  
  /*
   * Relation class
   * 
   * This class allow management of a relation object
   * 
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2009
   * 
   */

class MX_RelatedCategory extends CmsObject 
{
  // Vars

	var $id;
	var $type;
  var $modulename;
  var $category_id;
  var $position;

	const DB_NAME  = 'module_modulextender_related_categories';

	public function __construct()
	{
	}
	
  public function __toString()
  {
    return $this->getTitle();
  } 
  
  public function getTitle()
  {
  	return $this->getCategory()->getTitle();
  }
	
	public function getId()
	{
		return $this->id;
	}
	
  public function setId($value)
  {
    $this->id = $value;
  }
	
	public function getType()
	{
		return $this->type;
	}
	
	 public function setType($value)
  {
    $this->type = $value;
  }
  
	public function getModuleName()
	{
		return $this->modulename;
	}
	
	public function setModuleName($value)
	{
		$this->modulename = $value;
	}
		 
  
	public function getCategoryId()
	{
		return $this->category_id;
	}
	
	public function setCategoryId($value)
	{
		$this->category_id = $value;
	}
		 
  public function getCategory()
  {
  	return MX_Category::retrieveByPk($this->category_id);
  }
   
	public static function relationExists($modulename, $type, $category_id)
	{
		if (count(self::doSelect(array('where' => array('modulename' => $modulename, 'type' => $type, 'category_id' => $category_id)))) > 0)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	/**
	 * checkRelation checks if the current item have an associated option  
	 * @param $module_id
	 * @return integer
	 */
	
	public function checkRelation($module_id)
	{
		if ($module_id != '' )
		{
			$related_option_link = MX_RelationLink::doSelectOne(array('where' => array(
			  'modulename' => 'MX_' . $this->getType(),
			  'module_id' => $module_id,
			  'rel_code' => 'related_category_' . $this->getId(),
			)));
			
			if ($related_option_link)
			{
				$option = MX_Option::retrieveByPk($related_option_link->getLeftModuleId());

				if ($option)
				{
				  return $option->getId();
				}
				else
				{
					return null;
				}
			}
			else
			{
				return null;
			}
		}
		else
		{
			return null;
		}
	}
	
 public function getOption($module_id)
  {
    if ($module_id != '' )
    {
      $related_option_link = MX_RelationLink::doSelectOne(array('where' => array(
        'modulename' => 'MX_' . $this->getType(),
        'module_id' => $module_id,
        'rel_code' => 'related_category_' . $this->getId(),
      )));
      
      if ($related_option_link)
      {
        $option = MX_Option::retrieveByPk($related_option_link->getLeftModuleId());

        if ($option)
        {
          return $option;
        }
        else
        {
          return null;
        }
      }
      else
      {
        return null;
      }
    }
    else
    {
      return null;
    }
  }
  
  public static function getRelatedOptions($module_id, $type)
  {
  	    $related_options = MX_RelationLink::doSelect(array('where' => array(
        'modulename' => 'MX_' . $type,
        'module_id' => $module_id
      )));
      
      $options = array();
      
      foreach ($related_options as $option)
      {
      	$options[] = MX_Option::retrieveByPk($option->getLeftModuleId());
      }
      
      return $options;
  }
	
  public function getPosition()
  {
    if ($this->position != '')
    {
      return $this->position;
    }
    else
    {
      return self::retrieveNextPosition($this->modulename, $this->type);
    }
  }

  public static function retrieveNextPosition($modulename, $type)
  {
    $last_document = self::doSelectOne(array('where' => array('modulename' => $modulename, 'type' => $type), 'order_by' => array('position desc')));
    
    if ($last_document)
    {
      return $last_document->getPosition()+1;
    }
    else
    {
      return 1;
    }
  }
  
  public function getNextItem()
  {
    $document =  self::doSelectOne(array('where' => array('modulename' => $this->modulename, 'type' => $this->type,  'position' => $this->position+1)));
    
    if ($document)
    {
      return $document;
    }
    else 
    {
      return false;
    }
   }
   
  public function getPreviousItem()
  {
    $document =  self::doSelectOne(array('where' => array('modulename' => $this->modulename, 'type' => $this->type,   'position' => $this->position-1)));
    
    if ($document)
    {
      return $document;
    }
    else 
    {
      return false;
    }
   }
  
   public function moveUp()
   {
    $this->switchPosition($this->getPreviousItem());
   }
   
   public function moveDown()
   {
    $this->switchPosition($this->getNextItem());
   }
   
   protected function switchPosition($item)
   {
      if($item)
      {
        $current_position = $this->getPosition();
        $this->setPosition($item->getPosition());
        $item->setPosition($current_position);
        $this->save();
        $item->save();
      }
   }
   
  public function setPosition($position)
  {
    $this->position = $position;
  }

  public static function resetPositions($modulename, $type)
  {
    $documents = self::doSelect(array('where' => array('modulename' => $modulename, 'type' => $type ), 'order_by' => array('position asc')));
    
    $position = 1;
    
    foreach ($documents as $document)
    {
      $document->setPosition($position);
      $position = $document->getPosition() + 1;
      $document->save();
    }
    
  }
	
	public function PopulateFromDb($row)
	{
		  $this->id = $row['id'];
		  $this->type = $row['type'];
		  $this->modulename = $row['modulename'];
		  $this->category_id = $row['category_id'];
		  $this->position = $row['position'];
	}
	
  public function save()
  {
    // Upgrade or Insert ?
    if ($this->id != null)
    {
      $this->update();
    }
    else 
    {     
        $this->insert();
    }   
    
  }
  
  protected function update()
  {
    
    $db =& $this->GetDb();
    

      $query = 'UPDATE  ' . cms_db_prefix() .  self::DB_NAME . ' 
      
      SET ';
            
      $query .= ' type = ?,  modulename = ?, category_id = ?, position = ?';
      
      $query .= '
      
      WHERE
      
      id = ?  ';
      
      
      $result = $db->Execute($query,
          array(
             $this->getType(),
             $this->getModuleName(),
             $this->getCategoryId(),
             $this->getPosition(),
             $this->getId()
          )
        );        
        
        /*FIXME: Test the $db status; */
        
        return true;
  }
  
  protected function insert()
  {
  	if ($this->relationExists($this->getModulename(), $this->getType(), $this->getCategoryId()))
  	{
  		return false;
  	}
  	
    $db =& $this->GetDb();
    
    $this->setId($db->GenID(cms_db_prefix() .  self::DB_NAME .'_seq' ));
      
    $query = 'INSERT INTO ' . cms_db_prefix() .  self::DB_NAME .  ' 
      
      SET  id = ?,  ';

     $query .= ' type = ?,  modulename = ?, category_id = ?, position = ?';   
      
       $db->Execute($query,
          array(
            $this->getId(), 
             $this->getType(),
             $this->getModuleName(),
             $this->getCategoryId(),
             $this->getPosition(),
          )
        );
        
        return true;    
  }
   
  public static function retrieveByPk($id)
  {
    return self::doSelectOne(array('where' => array('id' => $id)));    
  }
  
  public static function doSelectOne($params = array())
  {
    $items = self::doSelect($params);
    if ($items)
    {
      return $items[0];
    }
    else 
    {
      return null;
    }   
  }
  
  public static function doSelect($params = array())
  {
    $instance = new self();
    
    
    $db =& $instance->GetDb();
    
    $query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME;;
    
    $values = array();
    
    if (isset($params['where']))
    {

      $fields = array();
      foreach ($params['where'] as $field => $value) 
      {
        $fields[] = $field . ' =  ?';
        $values[] = $value;
      }
      
      $query .= ' WHERE ' . implode(' AND ', $fields);
    } 
    
    if(isset($params['order_by']))
    {
     $query .= ' ORDER BY ' . implode(', ' , $params['order_by']);
    }
    else
    {
    	$query .= ' ORDER BY position';
    }
    
    $dbresult = $db->Execute($query, $values);
  
    $items = array();
   if ($dbresult && $dbresult->RecordCount() > 0)
    {
      while ($dbresult && $row = $dbresult->FetchRow())
      {
        $item = new self();
        $item->PopulateFromDb($row);        
        $items[] = $item;
      }
    }
    
    return  $items;   
  }
  
  public static function resetAllPositions()
  {
    $documents = self::doSelect(array('order_by' => array('modulename asc', 'type asc', 'position asc')));
    
    $modulename ='';
    $type = '';
    
    foreach ($documents as $document)
    {
      if ($document->getModuleName() != $modulename && $document->getType() != $type)
      {
          $modulename =$document->getModuleName();
          $type = $document->getType();
          self::resetPositions($modulename, $type);
      }
    }
  }
  
  
    public function delete()
    {   
    
    $db =& $this->GetDb();
    $query = 'DELETE FROM '. cms_db_prefix() . self::DB_NAME;
    $query .= ' WHERE id = ?';
    $db->Execute($query, array($this->id));   

    self::resetPositions($this->getModuleName(), $this->getType());
  }
  
}

?>