<?php
  
  /*
   * Relation class
   * 
   * This class allow management of a related pages object
   * 
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2009
   * 
   */

class MX_Page extends CmsObject 
{
	var $id;
	var $parent_id;
	var $alias;
	var $title;
	var $active;
	var $show_menu;
	var $cms_page;
	var $hierarchy;
	var $subpages = array();
	
	const ITEMS_NAME = 'pages';
  const ITEM_NAME = 'page';
	
	public function __toString()
  {
    return $this->getTitle();
  } 
	
	public function getTitle($with_position = false)
	{
		if ($with_position)
		{
			return $this->hierarchy . ' - ' . $this->title;
		}
		else 
		{
      return $this->title;
    }
	}
	
	public function getItemsName()
	{
		return self::ITEMS_NAME;
	}
	
	public function getItemName()
	{
		return self::ITEM_NAME;
	}
	
	public static function retrieveByPk($id)
	{
		global $gCms;
		$contentops =& $gCms->GetContentOperations();
		
		if ($page_content = &$contentops->LoadContentFromId($id))
    {
    	//var_dump($page_content);
    	return MX_Page::createFromPage($page_content);
    }
    else 
    {
    	return null;
    }
    
	}
	
	public static function createFromPage($page_content)
	{
		  $page = new self();
      $page->id = $page_content->mId;   
      $page->parent_id = $page_content->ParentId();
      $page->alias = $page_content->Alias();
      $page->title = $page_content->MenuText();
      $page->active = $page_content->Active();
      $page->show_menu = $page_content->ShowInMenu();
      $page->hierarchy = $page_content->Hierarchy();
      $page->cms_page = $page_content;
      return $page;
	}
	
	public function getId()
	{
		return $this->id;
	}
		
	public function getPages($mode = 0)
	{
		switch ($mode)
		{
			case 0: // Mode 1 Page
				return self;
			case 1: // Mode Subpages
				return $this->getSubpages();
			case 2: // Mode page & subpages
				return $this->getSubpages(true);
		}
	}
	
	public function getSubpages($with_self = false)
	{
    if ($with_self)
    {
      return array_merge(array($this), self::getChildrens($this->getId())); 	
    }
    else 
    {
    	return self::getChildrens($this->getId());
    }
	}

	public static function getChildrens($content_id, $recursive = true, $active_only = false)
	{
		$pages = array();
		
		$query = "SELECT content_id FROM ".cms_db_prefix()."content WHERE parent_id = ? ORDER BY item_order";
	  if( $active_only )
    {
      $query .= ' AND show_in_menu = 1 AND active = 1';
    }    
    
    $instance = new self();
    
    $db = &$instance->GetDb();

   $dbresult = $db->Execute($query, array($content_id));   
    
    while ($dbresult && $row = $dbresult->FetchRow())
    {
    	$pages[] = self::retrieveByPk($row['content_id']);
    	
    	if ($recursive)
    	{
    		$pages = array_merge($pages, self::getChildrens($row['content_id'], $recursive, $active_only));
    	}
    }
    
		return $pages;
	}
}