<?php
  
  /*
   * Relation class
   * 
   * This class allow management of a relation object
   * 
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2009
   * 
   */

class MX_Document extends CmsObject 
{
  // Vars

	var $id;
	
	var $modulename;
	var $module_id;
	
  var $title;
  var $type;
  var $file;
  var $filename;
  var $position;  
  
  var $path; // TODO: Use this
 
  var $loaded;
	
	const DB_NAME  = 'module_modulextender_documents';

	public function __construct($id = null)
	{
		if ($id)
		{
			$this->id = $id;
			$this->load();
		}
	}
	
	
  public function __toString()
  {
    return $this->getTitle();
  } 
	
	// Special
	
	public function getPath($prefix = null)
	{
		 return XT_Documents::CheckDirectory('ModuleXtender' . DIRECTORY_SEPARATOR . $this->modulename . DIRECTORY_SEPARATOR . $this->module_id, true, $prefix);
	}
   
    public static function guessPath()
    {
    	return realpath(dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'uploads');
    }
	
    
	public function uploadDocument($destination_directory, $document)
	{
    return $this->uploadFile($destination_directory, $document['tmp_name'], $document['name']);
	}
	
	public function uploadFile($destination_directory, $source_document, $destination_file, $doCopy = false)
	{
	   if (is_file($source_document))
     {
      // Remove previous document
      
      if ($this->file != '')
      {
        $this->removeDocument($destination_directory);
      }

      // Check destination

      $this->file = self::checkDocumentName($destination_directory, $destination_file);
      
      // Upload
           
      if (
      //$this->rename($source_document, $destination_directory . DIRECTORY_SEPARATOR . $this->file, null, $doCopy)
      self::move(null, $source_document, $destination_directory, $this->file, $doCopy ) !== false
      )
      {
        $this->save();
        return true;
      }
      else 
      {
        return false;
      }
    }
    else
    {
      return false;
    }
	}
	
  public static function move($source_path, $source_file, $destination_path, $destination_file, $doCopy = false)
  {
  	$destination_file = self::checkDocumentName($destination_path, $destination_file);
   	
    if ($destination_file)
    {
    	$source = ($source_path != null)?$source_path . DIRECTORY_SEPARATOR . $source_file:$source_file;
    	$destination = ($destination_path != null)?$destination_path . DIRECTORY_SEPARATOR . $destination_file:$destination_file;
    	
    	
      if ($doCopy)
      {
        $transfer = copy($source, $destination);     
      }
      else 
      {
        $transfer = rename($source, $destination); 
      }
      
      if ($transfer)
      {      
       return $destination_file;
      }
      else
      {
      	return false;
      }
    }
    else
    {
      return false;
    }
  }
	
  public function rename($source_path, $destination_file, $source_file = null)
  {            
  	if (!$source_file)
  	{
  		$source_file = $this->file;
  	}
    $filename = self::checkDocumentName($source_path, $destination_file);
  
    if ($filename && self::move($source_path, $source_file, $source_path, $filename) !== false)
    {     
       $this->file = $filename;
       $this->save();
    }
  }
  
   public static function size_readable ($size, $retstring = null)
   {

        $sizes = array('B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');

        if ($retstring === null) { $retstring = '%01.2f %s'; }

        $lastsizestring = end($sizes);

        foreach ($sizes as $sizestring) {
            if ($size < 1024) { break; }
            if ($sizestring != $lastsizestring) { $size /= 1024; }
        }

        if ($sizestring == $sizes[0]) { $retstring = '%01d %s'; } // Bytes aren't normally fractional

        return sprintf($retstring, $size, $sizestring);
    }
    
    public function getSize($readable = false)
    {
      // We do not know the path so we should try a 'best guess'
      
      $upload_path = self::guessPath();//
      $file = $this->getPath($upload_path) . DIRECTORY_SEPARATOR . $this->file;
      if (is_file($file))
      {
       $size = filesize($file);
       if ($readable)
       {
        return self::size_readable($size);
       }
       else
       {
        return $size;
       }
      }
      else
      {
        return null;
      }
    }
	
	protected static function checkDocumentName($path, $document_name, $sufix = null)
	{
		// Prepare document name
		
		if (strpos($document_name, '.') === false)
		{
			$new_name = $document_name . $sufix;
		}
		else
		{
			$tmp = explode('.', $document_name);
			
			if (count($tmp) > 1)
			{
				$tmp[count($tmp)-2] .= $sufix;
				$new_name = implode('.', $tmp);
			}
			else
			{
				$new_name = $sufix . $document_name;
			}
		}		
			
		if (is_file($path . DIRECTORY_SEPARATOR . $new_name))
		{
			if ($sufix != null)
			{
				$sufix++;
			}
			else 
			{
				$sufix = 1;
			}
			
			// File exists, try a varient
			return self::checkDocumentName($path, $document_name, $sufix);
		}
		else
		{
			return $new_name;
		}
	}
	
	// Common
	public function getId()
	{
		return $this->id;
	}
	
	 public function setId($id)
  {
    $this->id = $id;
  }
  	
	public function getModuleName()
	{
		return $this->modulename;
	}

	public function setModuleName($modulename)
	{
		$this->modulename = $modulename;
	}
	
	public function getModuleId()
	{
		return $this->module_id;
	}

	public function setModuleId($module_id)
	{
		$this->module_id = $module_id;
	}
	
	public function getTitle()
	{
		return $this->title;
	}
	
	public function setTitle($title)
	{
		$this->title = $title; 
	}
	
 
  public function getType()
  {
  	if ($this->type == '')
  	{
  		return 'document';
  	}
  	else
  	{
  		return $this->type;
  	}
  }
 
  public function setType($type)
  {
    $this->type = $type;
  }
 
  public function getFile()
  {
    return $this->file;
  }
	
  public function getUrl($prefix = null, $sufix = null, $with_file = true)
  {
  	if ($sufix)
  	{
  		$url =  $prefix . '/ModuleXtender/' . $this->getModuleName() . '/' . $this->getModuleId() . '/' . $sufix . '/' ;
  	}
  	else 
  	{
  		$url =  $prefix . '/ModuleXtender/' . $this->getModuleName() . '/' . $this->getModuleId() . '/' ;
  	}
  	
  	if($with_file)
  	{
  		return $url . $this->getFile();
  	}
  	else
  	{
  		return $url;
  	}
  }
  
	public function setFile($file)
	{
		$this->file = $file; 
	}
	
	public function getPosition()
	{
		if ($this->position != '')
		{
			return $this->position;
		}
		else
		{
			return self::retrieveNextPosition($this->modulename, $this->module_id, $this->getType());
		}
	}

	public static function retrieveNextPosition($modulename, $module_id, $type)
	{
		$last_document = self::doSelectOne(array('where' => array('modulename' => $modulename, 'module_id' => $module_id, 'type' => $type), 'order_by' => array('position desc')));
		
		if ($last_document)
		{
			return $last_document->getPosition()+1;
		}
		else
		{
			return 1;
		}
	}
	
	public function getNextDocument()
	{
		$document =  self::doSelectOne(array('where' => array('modulename' => $this->modulename, 'module_id' => $this->module_id, 'type' => $this->getType(),  'position' => $this->position+1)));
		
		if ($document)
		{
			return $document;
		}
		else 
		{
			return false;
		}
	 }
	 
  public function getPreviousDocument()
  {
    $document =  self::doSelectOne(array('where' => array('modulename' => $this->modulename, 'module_id' => $this->module_id, 'type' => $this->getType(),  'position' => $this->position-1)));
    
    if ($document)
    {
      return $document;
    }
    else 
    {
      return false;
    }
   }
	
   public function moveUp()
   {
    $this->switchPosition($this->getPreviousDocument());
   }
   
   public function moveDown()
   {
   	$this->switchPosition($this->getNextDocument());
   }
   
   protected function switchPosition($document)
   {
	   	if($document)
	   	{
	   	  $current_position = $this->getPosition();
	      $this->setPosition($document->getPosition());
	      $document->setPosition($current_position);
	      $this->save();
	      $document->save();
	   	}
   }
   
	public function setPosition($position)
	{
		$this->position = $position;
	}

	public static function resetPositions($modulename, $module_id, $type)
	{
		$documents = self::doSelect(array('where' => array('modulename' => $modulename, 'module_id' => $module_id,  'type' => $type), 'order_by' => array('position asc')));
		
		$position = 1;
		
		foreach ($documents as $document)
		{
			$document->setPosition($position);
      $position = $document->getPosition() + 1;
			$document->save();
		}
		
	}
	
	public function load()
	{
		
    $db =& $this->GetDb();
    
		$query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME . ' WHERE id = ? LIMIT 1';
		
		$dbresult = $db->Execute($query, array($this->id));
		
	   if ($dbresult && $dbresult->RecordCount() > 0)
      {
      	$this->loaded = true;
        while ($dbresult && $row = $dbresult->FetchRow())
        {
          $this->PopulateFromDb($row);
        }
      }
	}
	
	public function Populate($row)
	{
			if (isset($row['document_id']))
			{
				$this->id = $row['document_id'];
			}
			elseif (isset($row['id'])	)
			{
				$this->id = $row['id'];
			}
				  
		  if (isset($row['module_name']))
		  {		  	
        $this->modulename = $row['module_name'];
		  }
		  elseif(isset($row['modulename']))
		  {
		  	$this->modulename = $row['modulename'];
		  }
		  
		  if (isset($row['module_id']))
      {    
		    $this->module_id = $row['module_id'];
      }

      if (isset($row['document_title']))
      {
      	$this->title = $row['document_title'];
      }
      elseif (isset($row['title']))
      {
      	$this->title = $row['title'];
      }
      
      if (isset($row['type']))
      {
      	$this->type = $row['type'];
      }
      
      if (isset($row['file']))
      {
      	$this->file = $row['file'];
      	$this->filename = $row['file'];
      }
      
      if (isset($row['position']))
      { 
      	$this->position = $row['position'];		  
      }
	}
	
 public function PopulateFromDb($row)
  {
    $this->Populate($row);
  }
	
  public function save()
  {
    // Upgrade or Insert ?
    if ($this->id != null)
    {
      $this->update();
    }
    else 
    {     
        $this->insert();
    }   
    
  }
  
  protected function update()
  {
    
    $db =& $this->GetDb();
    

      $query = 'UPDATE  ' . cms_db_prefix() .  self::DB_NAME . ' 
      
      SET ';
            
      $query .= 'modulename = ?, module_id = ?, title = ?, type = ?, file = ?, position = ?';
      
      $query .= '
      
      WHERE
      
      id = ?  ';
      
      
      $result = $db->Execute($query,
          array(      
				      $this->modulename,
				      $this->module_id,
				      $this->title,
				      $this->getType(),
				      $this->file,
				      $this->getPosition(),
             $this->getId()
          )
        );        
        
        //FIXME: Test the $db status; 
        
        return true;
  }
  
  protected function insert()
  {
    $db =& $this->GetDb();
    
    $this->setId($db->GenID(cms_db_prefix() .  self::DB_NAME .'_seq' ));
      
    $query = 'INSERT INTO ' . cms_db_prefix() .  self::DB_NAME .  ' 
      
      SET  id = ?,  ';

   $query .= 'modulename = ?, module_id = ?, title = ?, type = ?, file = ?, position = ?';
      
      
       $db->Execute($query,
          array(
            $this->getId(), 
              $this->modulename,
              $this->module_id,
              $this->title,
              $this->getType(),
              $this->file,
              $this->getPosition(),
          )
        );
        
        return true;    
  }  
  
  public function isLoaded()
  {
    return $this->loaded;
  }
  
  public static function retrieveByPk($id)
  {
  	return self::doSelectOne(array('where' => array('id' => $id)));    
  }
  
  public static function doSelectOne($params = array())
  {
  	$items = self::doSelect($params);
  	if ($items)
  	{
  		return $items[0];
  	}
  	else 
  	{
  		return null;
  	}  	
  }
  
  public static function doSelect($params = array())
  {
  	$instance = new self();
        
    $db =& $instance->GetDb();
    
    $query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME;
    
    $values = array();
    
  	if (isset($params['where']))
  	{

  		$fields = array();
  		foreach ($params['where'] as $field => $value) 
  		{
        $fields[] = $field . ' =  ?';
  			$values[] = $value;
  		}
  		
  		$query .= ' WHERE ' . implode(' AND ', $fields);
  	} 
    
    if(isset($params['order_by']))
    {
     $query .= ' ORDER BY ' . implode(', ' , $params['order_by']);
    }
    else
    {
      $query .= ' ORDER BY position asc';
    }
  	
    $dbresult = $db->Execute($query, $values);
  
    $items = array();
   if ($dbresult && $dbresult->RecordCount() > 0)
    {
      while ($dbresult && $row = $dbresult->FetchRow())
      {
      	if ($row['type'] == 'image')
      	{
      		// HACK FOR THE SELF
      	 $item = new MX_Image();
      	}
      	else 
      	{
      		$item = new self();
      	}
        $item->PopulateFromDb($row);
        $items[] = $item;
      }
    }
    
    return  $items;  	
  }

  protected function removeDocument($directory)
  {
  	unlink($directory . DIRECTORY_SEPARATOR . $this->file);
  }
  
  public function delete($path = null)
  {  	
  	// Remove associate file only if upload path is specified
  	if ($path)
  	{
  		$this->removeDocument($path);
  	}
  	
  	$db =& $this->GetDb();
  	$query = 'DELETE FROM '. cms_db_prefix() . self::DB_NAME;
  	$query .= ' WHERE id = ?';
    $db->Execute($query, array($this->id));  	

    self::resetPositions($this->getModuleName(), $this->getModuleId(), $this->getType());
  }
  
  public static function resetAllPositions()
  {
  	$documents = self::doSelect(array('order_by' => array('modulename asc', 'module_id asc', 'type asc', 'position asc')));
  	
  	$modulename ='';
  	$module_id = '';
  	$type = '';
  	
  	foreach ($documents as $document)
  	{
  		if ($document->getModuleName() != $modulename || $document->getModuleId() != $module_id || $document->getType() != $type)
  		{
  			  $modulename =$document->getModuleName();
			    $module_id = $document->getModuleId();
			    $type = $document->getType();
			    
			    self::resetPositions($modulename, $module_id, $type);
  		}
  	}
  }
  
}

?>