<?php
if (!isset($gCms)) exit;

if (! $this->CheckAccess("Use Category Manager"))
	{
	return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
	}

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for CategoryManager "addeditOptions" admin action
   
   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/

// Precheck
//*********

// If cancel, return home...

if (isset($params['cancel']))
{
	$params = array(
		//'tab_message'=> 'list_template_updated',
		'active_tab' => 'options'
		);		
	
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

// If not defined category_id, make an error

if (!isset($params['category_id']))
{
		echo $this->ShowErrors($this->Lang('nocatselect'));
}


// First, if $param['category_name'] is define, we save it in database

if (isset($params['title']))
{
	$title = $params['title'];
}
else 
{
	$title = '';
}



if (isset($params['input_submitted']))
{
	
	if ($title != '')
	{
		
		if (!isset($params['option_id']))
		{
			//echo 'INSERT';
			
			// We have to insert it
			
			// DB : module_modulextender_categories
			
			$option_id = $db->GenID(cms_db_prefix()."module_modulextender_options_seq");
			
			//$time = $db->DBTimeStamp(time());
			
			$query = 'INSERT INTO '.cms_db_prefix().'module_modulextender_options (id, title, category_id) VALUES (?,?,?)';
			
			$db->Execute($query, array($option_id, $title, $params['category_id']));
			
			//$this->UpdateHierarchyPositions();
			
			@$this->SendEvent('NewsCategoryAdded', array('category_id' => $category_id, 'name' => $category_name));
			
			$params = array('tab_message'=> 'optionadded', 'active_tab' => 'options', 'cat_selected' => $params['category_id']);
		}
		else 
		{
			//echo 'UPDATE '.$params['category_id'];
			
			// We have to update it
			
			// DB : module_modulextender_categories
			
			$option_id = $params['option_id'];
			
			//$time = $db->DBTimeStamp(time());
			
			$query = 'UPDATE '.cms_db_prefix().'module_modulextender_options SET title = ? WHERE id = ?';
			
			$db->Execute($query, array($title, $option_id));
			//$this->UpdateHierarchyPositions();
			
			@$this->SendEvent('NewsCategoryAdded', array('category_id' => $category_id, 'name' => $category_name));
			
			$params = array('tab_message'=> 'optionmodified', 'active_tab' => 'options', 'cat_selected' => $params['category_id']);
		}
		
		
				
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
	}
	elseif (!isset($params['option_id']))
	{
		echo $this->ShowErrors($this->Lang('nonamegiven'));
	}
}


// If nothing is done, show the form.

$this->smarty->assign('title_section',$this->Lang('title_add_edit_option'));

// Form
$this->smarty->assign('form_start',$this->CreateFormStart($id, 'addeditOptions', $returnid));

$this->smarty->assign('title_option_name',$this->Lang('title_option_name'));

$this->smarty->assign('input_option_name',$this->CreateInputText($id, 'title', $title, 50));
$this->smarty->assign('input_submitted',$this->CreateInputHidden($id, 'input_submitted', ''));

if (isset($params['title']))
{
	$this->smarty->assign('submit_button',$this->CreateInputSubmit($id, 'submit', $this->Lang('edit_option')));
}
else 
{
	$this->smarty->assign('submit_button',$this->CreateInputSubmit($id, 'submit', $this->Lang('add_option')));
}

if (isset($params['category_id']))
{
	$this->smarty->assign('category_id',$this->CreateInputHidden($id, 'category_id', $params['category_id']));
}

if (isset($params['option_id']))
{
	$this->smarty->assign('option_id',$this->CreateInputHidden($id, 'option_id', $params['option_id']));
}

$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));


			
$this->smarty->assign('form_end',$this->CreateFormEnd());


// MC ADDS  $this->Name


echo $this->ProcessTemplate('adminAddEditOption.tpl');

?>