<?php

/*

Javascripts class

This class is made to provide a way to manage javascripts requests

Copyrights: 2009 - Jean-Christophe Cuvelier - Morris & Chapman Belgium

VERSION: 0.0.1

*/

class XT_Javascripts extends CmsObject 
{
	var $scripts = array();
	var $config;
	var $call;
	var $called = false;
	
	const GLOBAL_SCRIPTS = '<script language="JavaScript" type="text/javascript" src="%ROOT_URL%/modules/ModuleXtender/js/modulextender.js" ></script>';
	
	public function __construct()
	{
		$this->config =& $this->GetConfig();
		$this->call = str_replace('%ROOT_URL%', $this->config['root_url'], self::GLOBAL_SCRIPTS); 
	}
	
	public function call()
	{
		if (!$this->called)
		{
			$this->processScripts();
			return $this->call;
			$this->called = true;
		}
		else
		{
			return null;
		}
	}
	
	protected function processScripts()
	{
		$js = '';
		
		foreach ($this->scripts as $key => $script)
		{
			$js .= $script;
		}
		
		if ($js != '')
		{
			$this->call .= '<script language="JavaScript" type="text/javascript">' . $js . '</script>';
		}
	}
	
	// Scripts templates
	
	public function loadContentFromHttpFunctionName($content_id)
	{
		return 'loadContentFromHttpTo' . $content_id;
	}
	
	public function loadContentFromHttp($content_id, $url)
	{
		$function_name = $this->loadContentFromHttpFunctionName($content_id);
		
		$script = '
		function ' . $function_name . '()
		{
		  var httprequest = getHttpRequest();
		  var element = document.getElementById(\'' . $content_id . '\');		  
		  
		  httprequest.onreadystatechange  = function()
      { 
         if(httprequest.readyState  == 4)
         {
              if(httprequest.status  == 200) 
                  element.innerHTML = httprequest.responseText; 
         }
    }; 

   httprequest.open("GET", "' . $url .'",  true); 
   httprequest.send(null); 
  }';
		
		$this->scripts[] = $script;
		
		return $function_name;
	}
		
	public function getJSCall($function_name)
	{
		return '<script language="JavaScript" type="text/javascript">' . $function_name .  '();</script>';
	}

	 public function getJSCallFromiFrame($function_name)
  {
    return '<script language="JavaScript" type="text/javascript">window.top.window.' . $function_name .  '();</script>';
  }
  
	
}