<?php
/*

 XT Documents 

Copyrights: Jean-Christophe Cuvelier - Morris & Chapman Belgium 2009

*/

class XT_Documents extends CmsObject  {
    
	  var $module;
    var $deleteicon = '/modules/ModuleXtender/images/icons/delete.gif';
    var $editicon = '/modules/ModuleXtender/images/icons/edit.gif';
    var $config = array();

    function XT_Documents(&$module = null)
    {
        $this->module = $module; // DEPRECATED
        if ($this->module != null)
        {
        	$this->config = $this->module->GetConfig();
        }
      //  $this->config = $this->GetConfig();
        if (isset($this->config['root_url']))
        {
        	$root_url = $this->config['root_url'];
        }
        else
        {
        	$root_url = $_SERVER['HTTP_HOST'];
        }
        
        $this->deleteicon = $root_url.'/modules/ModuleXtender/images/icons/delete.gif';
        $this->editicon = $root_url.'/modules/ModuleXtender/images/icons/edit.gif';
    }
	
   
	// OLD MODULE
/*
    function GetDocumentsList($modulename, $moduleid, $frontend = false)
    {
        $documentlist = array();

        $db =& $this->module->GetDb();
        $ajax = $this->module->GetModuleInstance("AjaxMadeSimple");

        $this->module->GetConfig();

        // We make the request

        $query = "SELECT * FROM ".cms_db_prefix()."module_modulextender_documents WHERE modulename = ? AND module_id = ? AND type = 'document' ORDER BY position";

        $dbresult = $db->Execute($query, array($modulename, $moduleid));

        $rowclass = 'row1';
        $documentlist = array();

        // We populate the array

        while ($dbresult && $row = $dbresult->FetchRow())
        {
            $item = new stdClass();
            $item->title = $row['title'];
            $item->filename =  $row['file'];

            $item->url = $this->CheckDestinationDirInternal($modulename, $moduleid, 'documents', 'url').'/'.$row['file'];

            $item->file = $this->CheckDestinationDirInternal($modulename, $moduleid, 'documents').'/'.$row['file'];

            if (file_exists($item->file))
            {
              $item->size = $this->size_readable(filesize($item->file));
            }
            else
            {
            	$item->size = 0;
            }

            $item->extension = pathinfo($item->file, PATHINFO_EXTENSION);

            $item->icon = $this->document_icon($item->extension);

            $item->delete = '<a href="'.$ajax->GetRequestURL('ModuleXtender', 'UploadDocumentsBox', 'delete='.$row['id']).'" onClick="javascript:return confirm(\'Are you sure?\');" target="uploadbox">
				<img src="'.$this->deleteicon.'" alt="Delete" border="0"/>
				</a>';

            $item->edit = '<a href="'.$ajax->GetRequestURL('ModuleXtender', 'UploadDocumentsBox', 'edit='.$row['id']).'" target="uploadbox">
				<img src="'.$this->editicon.'" alt="Edit" border="0"/>
				</a>';

            $item->rowclass = $rowclass;

            ($rowclass=="row1"?$rowclass="row2":$rowclass="row1");

            $documentlist[] = $item;
        }

        if ($frontend)
        {
            return $documentlist;
        }
        else
        {

            $this->module->smarty->assign_by_ref('xtdocuments', $documentlist);
            $this->module->smarty->assign('xtdocumentscount', count($documentlist));

            return $this->module->ProcessTemplate('adminDocumentList.tpl');
        }
    }*/

    function GetFileInfos ($id, $selectrow = array())
    {
        $db =& $this->module->GetDb();

        $query = "SELECT * FROM ".cms_db_prefix()."module_modulextender_documents WHERE id = ?";

        $dbresult = $db->Execute($query, array($id));

        while ($dbresult && $row = $dbresult->FetchRow())
        {
            if (count($selectrow) > 0)
            {
                foreach ($selectrow as $col) {
                    $array[$col] = $row[$col];
                }
                return $array;

            }
            else
            {
                return $row;
            }

        }
    }

    function AddFile ($modulename, $moduleid, $filename, $title='', $type='document')
    {
        $db =& $this->module->GetDb();

        $query = "SELECT position FROM ".cms_db_prefix()."module_modulextender_documents WHERE modulename = ? AND module_id = ? ORDER BY position DESC LIMIT 1";
        $dbresult = $db->Execute($query, array($modulename, $moduleid));

        $lastposition = 0;

        while ($dbresult && $row = $dbresult->FetchRow())
        {
            $lastposition = $row['position'];
        }

        $lastposition++;

        $document_id = $db->GenID(cms_db_prefix()."module_modulextender_documents_seq");

        $query = "INSERT INTO ".cms_db_prefix()."module_modulextender_documents SET id = ?, modulename = ?, module_id = ?, title = ?, file = ?, position = ?, type = ?";

        $db->Execute($query, array($document_id, $modulename, $moduleid, $title, $this->CleanUpFileName($filename), $lastposition, $type));
    }

    function UpdateDocument ($id, $title, $position = 0)
    {
        // Position is not used for the moment

        $db =& $this->module->GetDb();


        $query = "UPDATE ".cms_db_prefix()."module_modulextender_documents SET title = ? WHERE id = ?";

        $db->Execute($query, array($title,$id));
    }

    function DeleteDocument ($id, $onlyfile=false, $newfile='')
    {
        $db = &$this->module->GetDb();

        $query = 'SELECT * FROM '.cms_db_prefix()."module_modulextender_documents WHERE id = ?";
        $dbresult = $db->Execute($query, array($id));

        while ($dbresult && $row = $dbresult->FetchRow())
        {
            if ($row['file'] != $newfile)
            {
                @unlink($this->module->config['uploads_path'].'/ModuleXtender/'.$row['modulename'].'/'.$row['module_id'].'/documents/'.$row['file']);
            }
        }

        if (!$onlyfile)
        {
            $query = "DELETE FROM ".cms_db_prefix()."module_modulextender_documents WHERE id = ?";
            $db->Execute($query, array($id));
        }

    }

    function CheckDestinationDir ($basearr = array(), $extra='default', $type='path')
    {
        if ($type == 'path')
        {
            $base = $this->config['uploads_path'];

            $extra = str_replace($this->config['uploads_path'], '', $extra);

            $extra = str_replace($this->config['uploads_url'], '', $extra);

        }
        elseif ($type == 'url')
        {
            $base = $this->config['uploads_url'];
        }
        else
        {
            $base = '';
        }

        $basearray = $basearr;

        if (strpos($extra, '/') === FALSE)
        {
            $basearray[] = $extra;
        }
        else
        {
            $subdirs = explode ('/', $extra);

            foreach ($subdirs as $dir)
            {
                $basearray[] = $dir;
            }
        }

        // Create inexistant dirs

        foreach ($basearray as $directory) {

            $base .= '/'.$directory;

            if (!is_dir($base) && strpos($base, 'http://') === FALSE)
            {
                mkdir($base, 0777);
            }


        }

        return $base;
    }

    function CheckDestinationDirInternal ($modulename, $moduleid, $extra='default', $type='path')
    {

        $basearray = array(	'ModuleXtender', $modulename , $moduleid);

        return $this->CheckDestinationDir($basearray, $extra, $type);
    }

    function CleanUpFileName($filename)
    {
        return $filename;
        //return strtolower(strtr($filename, " ���������������������������������������������������������������������", "_SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy"));
    }
    /*
    function UploadDocumentsBox ($modulename, $moduleid)
    {
        if (is_uploaded_file($_FILES['uploadfile']['tmp_name']))
        {

            //die($this->CleanUpFileName($_FILES['uploadfile']['name']));
            
            $destination =  ($this->CheckDestinationDirInternal($modulename, $moduleid, 'documents'));

            if (move_uploaded_file($_FILES['uploadfile']['tmp_name'], $destination.'/'.$this->CleanUpFileName($_FILES['uploadfile']['name'])))
            {
                $this->AddFile($modulename, $moduleid, $this->CleanUpFileName($_FILES['uploadfile']['name']), $_REQUEST['title']);
            }
            else
            {
                die ('Error uploading document to ['.$destination.']. Please try again');
            }
        }
        elseif (isset($_REQUEST['id']))
        {
            $this->UpdateDocument($_REQUEST['id'], $_REQUEST['title']);
        }

        if ($_REQUEST['delete'])
        {
            
        }

        if (isset($_REQUEST['edit']))
        {
            $docinfo = $this->GetFileInfos($_REQUEST['edit']);
            return $this->UploadDocumentsForm($modulename, $moduleid, $docinfo);
        }
        elseif (isset($_REQUEST['delete']))
        {
            $docinfo = $this->GetFileInfos($_REQUEST['delete'], array('modulename', 'module_id'));

            $this->DeleteDocument($_REQUEST['delete']);

            return $this->UploadDocumentsForm($modulename, $moduleid, $docinfo);
        }
        else
        {
            return $this->UploadDocumentsForm($modulename, $moduleid);
        }
    }
*//*
    function UploadDocumentsForm ($modulename, $moduleid, $docinfo=array())
    {
        if ($docinfo['modulename'] != '')
        {
            $action = $_SERVER['PHP_SELF'].'?module=ModuleXtender&method=UploadDocumentsBox&modulename='.$docinfo['modulename'].'&moduleid='.$docinfo['module_id'];
        }
        else
        {
            $action = $_SERVER['PHP_SELF'].'?module=ModuleXtender&method=UploadDocumentsBox&modulename='.$_REQUEST['modulename'].'&moduleid='.$_REQUEST['moduleid'];
        }

        $form =  '
			<form name="formbrowser" method="post" action="'.$action.'" enctype="multipart/form-data">
			<table cellpadding="0" cellspacing="2" border="0">
			<thead align="left" style="font-size: 8pt; font-weight: normal;">
				<tr>
					<th>'.$this->module->Lang('title').'</th>
					<th>'.$this->module->Lang('file').'</th>
					<th></th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td>';


        if ($docinfo['title'] != '')
        {
            $form .= '<input type="text" name="title" size="30" value="'.$docinfo['title'].'" />';

        }
        else
        {
            $form .= '<input type="text" name="title" size="30" />';
        }

        if ($docinfo['id'] != '')
        {
            $form .= '<input type="hidden" name="id" value="'.$docinfo['id'].'" />';
        }

        $form .= '</td><td>';


        if (isset($docinfo['file']))
        {
            $form .= '&nbsp;&nbsp;&nbsp;&nbsp;'.$docinfo['file'].'&nbsp;&nbsp;&nbsp;&nbsp;';
        }
        else
        {
            $form .= '<input type="file" name="uploadfile" size="30" />';
        }


        $form .= '</td>
					<td><input type="submit" name="Submit" value="Submit" /></td>
				</tr>
			</tbody>
			</table>
			</form>';

        return $form;
    }
*/
    function getStrippedFilename ($filename)
    {
        $fileinfo = pathinfo($filename);

        $file_extention = $fileinfo['extension'];

        $result = strtolower(str_replace('.'.$file_extention, '', $fileinfo['basename']));

        $result = strtr($result,  "�����������������������������������������������������",  "aaaaaaaaaaaaooooooooooooeeeeeeeecciiiiiiiiuuuuuuuuynn");

        // strip all non word chars
        $result = preg_replace('/\W/', ' ', $result);

        // replace all white space sections with a dash
        $result = preg_replace('/\ +/', '-', $result);

        // trim dashes
        $result = preg_replace('/\-$/', '', $result);
        $result = preg_replace('/^\-/', '', $result);

        return $result.'.'.$file_extention;
    }

    /* IMAGES PART */

    function DeleteImage ($id, $onlyfile=false, $newfile='')
    {
        $db = &$this->module->GetDb();

        $query = 'SELECT * FROM '.cms_db_prefix()."module_modulextender_documents WHERE id = ?";
        $dbresult = $db->Execute($query, array($id));

        while ($dbresult && $row = $dbresult->FetchRow())
        {
            if ($row['file'] != $newfile)
            {
                @unlink($this->module->config['uploads_path'].'/ModuleXtender/'.$row['modulename'].'/'.$row['module_id'].'/images/'.$row['file']);
                @unlink($this->module->config['uploads_path'].'/ModuleXtender/'.$row['modulename'].'/'.$row['module_id'].'/images/thubnails/'.$row['file']);
            }
        }

        if (!$onlyfile)
        {
            $query = "DELETE FROM ".cms_db_prefix()."module_modulextender_documents WHERE id = ?";
            $db->Execute($query, array($id));
        }

    }
/*
    function UploadImagesBox ($modulename, $moduleid)
    {

        if (is_uploaded_file($_FILES['uploadfile']['tmp_name']) && $this->isAllowedImage('uploadfile'))
        {
            $destination =  ($this->CheckDestinationDirInternal($modulename, $moduleid, 'images'));

            $thubdestination =  ($this->CheckDestinationDirInternal($modulename, $moduleid, 'images/thubnails'));

            // Move the original one

            if($_POST['img_size'])
            {
                
                $buildsizes = array();
                
                foreach($_POST['img_size'] as $size)
                {
                    foreach($this->module->settings['img_sizes'] as $properties)
                    {
                        if($size == $properties['id'])
                        {
                            $buildsizes[] = $properties;
                        }
                    }
                }
                
                if ($this->MultiSize($_FILES['uploadfile']['tmp_name'], $_FILES['uploadfile']['name'], $destination, $buildsizes))
                {
                    $this->AddFile($modulename, $moduleid, $_FILES['uploadfile']['name'], $_REQUEST['title'], 'image');
                }
                else
                {
                    die ('Error uploading document to ['.$destination.']. Please try again');
                }
                
            }
            else
            {
                if ($this->MoveImage($_FILES['uploadfile']['tmp_name'], $_FILES['uploadfile']['name'], $destination, 0, 100))
                {
                    $this->AddFile($modulename, $moduleid, $_FILES['uploadfile']['name'], $_REQUEST['title'], 'image');
                }
                else
                {
                    die ('Error uploading document to ['.$destination.']. Please try again');
                }
            }
           
        }


        if ($_REQUEST['delete'])
        {

        }

        if (isset($_REQUEST['edit']))
        {
            $docinfo = $this->GetFileInfos($_REQUEST['edit']);
            return $this->UploadDocumentsForm($modulename, $moduleid, $docinfo);
        }
        elseif (isset($_REQUEST['delete']))
        {
            $docinfo = $this->GetFileInfos($_REQUEST['delete'], array('modulename', 'module_id'));

            $this->DeleteDocument($_REQUEST['delete']);

            return $this->UploadImageForm($modulename, $moduleid, $docinfo);
        }
        else
        {
            return $this->UploadImageForm($modulename, $moduleid);
        }
    }*/

    function MoveImage ($tmpname, $name, $destination, $thumbwidht=0, $thumbheight=0)
    {
        if (!move_uploaded_file($tmpname, $destination.'/'.$name))
        {
            return false;
        }
        elseif (!$this->BuildThumb($name, $destination, $thumbwidht, $thumbheight))
        {
            return false;
        }
        else
        {
            return true ;
        }
    }

    function MultiSize($tmpname, $image, $sourcedir, $sizes = array())
    {
        if (!move_uploaded_file($tmpname, $sourcedir.'/'.$image))
        {
            return false;
        }

        foreach ($sizes as $size)
        {
            $destinationdir = $sourcedir . '/' . $size['id'] . '/';

            $this->CheckDestinationDir(array(), $destinationdir);

            if(!$this->ResizeImage($image, $sourcedir, $destinationdir, $size['width'] , $size['height']))
            {
                return false;
            }
        }

        return true;
    }

    function ResizeImage($image, $sourcedir, $destinationdir, $thumbwidth = 0 , $thumbheight = 0)
    {
        $properties =  $this->ImageSize($image, $sourcedir, $thumbwidth , $thumbheight);

        $srcimg = $this->CreateImage($sourcedir, $image);

        return $this->CreateImageFile($properties, $srcimg, $image, $destinationdir);
    }

    function BuildThumb ($image, $sourcedir, $thumbwidth = 0,  $thumbheight=0)
    {
        $destinationdir = $sourcedir.'/thumbnails/';

        $this->CheckDestinationDir(array(), $sourcedir.'/thumbnails');

        return $this->ResizeImage($image, $sourcedir, $destinationdir, $thumbwidth , $thumbheight);
    }

    function ImageSize($image, $sourcedir, $thumbwidth , $thumbheight)
    {
        $imgsize = getimagesize($sourcedir.'/'.$image);

        if (!$imgsize)
        {
            return false;
        }

        if ($thumbwidth == 0 && $thumbheight == 0)
        {
            $targetsize[0] = $imgsize[0];	// Target Height
            $targetsize[1] = $imgsize[1];	// Target Width
        }
        elseif ($thumbwidth == 0 && $thumbheight != 0)
        {
            $targetsize[0] = round($thumbheight*($imgsize[0]/$imgsize[1]));
            $targetsize[1] = $thumbheight;
        }
        elseif ($thumbwidth != 0 && $thumbheight == 0)
        {
            $targetsize[0] = $thumbwidth;
            $targetsize[1] = round($thumbwidth*($imgsize[0]/$imgsize[1]));
        }
        else
        {
            if (round($thumbwidth*($imgsize[0]/$imgsize[1])) > $thumbheight)
            {
                $targetsize[0] = $thumbheight;
                $targetsize[1] = round($thumbheight*($imgsize[1]/$imgsize[0]));
            }
            else
            {
                $targetsize[0] = round($thumbwidth*($imgsize[0]/$imgsize[1]));
                $targetsize[1] = $thumbwidth;
            }
        }
        
        $properties = array ($targetsize[0] ,$targetsize[1] ,$imgsize[0] ,$imgsize[1]);
        
        return $properties;
    }

    function CreateImage($sourcedir, $image)
    {
        switch(exif_imagetype($sourcedir.'/'.$image))
        {
            case 1:
                $srcimg = imagecreatefromgif($sourcedir.'/'.$image);
                break;
            case 2:
                $srcimg = imagecreatefromjpeg($sourcedir.'/'.$image);
                break;
            case 3:
                $srcimg = imagecreatefrompng($sourcedir.'/'.$image);
                break;
            default:
                return false;
        }

        return $srcimg;
    }

    function CreateImageFile($properties, $srcimg, $image, $destinationdir)
    {
        $destinationimg = imagecreatetruecolor($properties[0], $properties[1]);

        if (
        imagecopyresampled($destinationimg, $srcimg, 0, 0, 0, 0, $properties[0], $properties[1], $properties[2], $properties[3])
        &&
        imagejpeg($destinationimg, $destinationdir.$image, 100)
        )
        {
            return true;
        }

        else
        {
            return false;
        }
    }

    function isAllowedImage ($uploadedfile)
    {
        $allowed = array (
        'image/jpeg'
        ,'image/pjpeg'
        ,'image/png'
        ,'image/gif');

        if (in_array($_FILES[$uploadedfile]['type'], $allowed))
        {
            return true;
        }
        else
        {
            return false;
        }
    }
/*
    function GetImagesList($modulename, $moduleid, $frontend = false)
    {
        $documentlist = array();

        $db =& $this->module->GetDb();
        $ajax = $this->module->GetModuleInstance("AjaxMadeSimple");

        $this->module->GetConfig();

        // We make the request

        $query = "SELECT * FROM ".cms_db_prefix()."module_modulextender_documents WHERE modulename = ? AND module_id = ? AND type = 'image' ORDER BY position";

        $dbresult = $db->Execute($query, array($modulename, $moduleid));

        $rowclass = 'row1';
        $documentlist = array();

        // We populate the array

        while ($dbresult && $row = $dbresult->FetchRow())
        {
            $item = new stdClass();
            
            $item->title = $row['title'];
            
            $item->filename =  $row['file'];
            
            $item->url = $this->CheckDestinationDirInternal($modulename, $moduleid, 'images', 'url').'/'.$row['file'];
            
            $item->image = $this->CheckDestinationDirInternal($modulename, $moduleid, 'images', 'url').'/'.$row['file'];
            
            $item->thubnails = $this->CheckDestinationDirInternal($modulename, $moduleid, 'images/thumbnails', 'url').'/'.$row['file'];
            
            foreach ($this->module->settings['img_sizes'] as $img)
            {
                $item->$img['id'] = $this->CheckDestinationDirInternal($modulename, $moduleid, 'images/' . $img['id'] . '', 'url').'/'.$row['file'];
            }
            
            $item->delete = '<a href="'.$ajax->GetRequestURL('ModuleXtender', 'UploadImagesBox', 'delete='.$row['id']).'" onClick="javascript:return confirm(\'Are you sure?\');" target="uploadimgbox">
				<img src="'.$this->deleteicon.'" alt="Delete" border="0"/>
				</a>';

            $item->edit = '<a href="'.$ajax->GetRequestURL('ModuleXtender', 'UploadImagesBox', 'edit='.$row['id']).'" target="uploadimgbox">
				<img src="'.$this->editicon.'" alt="Edit" border="0"/>
				</a>';

            $item->rowclass = $rowclass;

            ($rowclass=="row1"?$rowclass="row2":$rowclass="row1");

            $documentlist[] = $item;
        }

        if ($frontend)
        {
            return $documentlist;
        }
        else
        {
            $this->module->smarty->assign_by_ref('xtdocuments', $documentlist);
            $this->module->smarty->assign('xtdocumentscount', count($documentlist));

            return $this->module->ProcessTemplate('adminImagesList.tpl');
        }
    }

    function AdditionalImageFormatForm()
    {
        $html = (count($this->module->settings['img_sizes']) > 0) ? '<b>Additional formats</b> ' : '';
        
        foreach($this->module->settings['img_sizes'] as $size)
        {
            //$disabled = ($size['id'] == 'thumbnails') ? 'disabled' : '';
           $checked = 'checked';
            
            $html .= ' <input '. $checked . ' ' . $disabled . ' type="checkbox" name="img_size[]" value="' . $size['id'] . '"> <b>'. $size['id']  .'</b> <em>(W:' . $size['width'] . ' H:' . $size['height'] . ')</em>' ;
        }
        
        return $html;
    }*/
    /*
    function UploadImageForm ($modulename, $moduleid, $docinfo=array())
    {
        if ($docinfo['modulename'] != '')
        {
            $action = $_SERVER['PHP_SELF'].'?module=ModuleXtender&method=UploadImagesBox&modulename='.$docinfo['modulename'].'&moduleid='.$docinfo['module_id'];
        }
        else
        {
            $action = $_SERVER['PHP_SELF'].'?module=ModuleXtender&method=UploadImagesBox&modulename='.$_REQUEST['modulename'].'&moduleid='.$_REQUEST['moduleid'];
        }

        $form =  '
			<form name="formbrowser" method="post" action="'.$action.'" enctype="multipart/form-data">
			<table cellpadding="0" cellspacing="2" border="0">
			<thead align="left" style="font-size: 8pt; font-weight: normal;">
				<tr>
					<th>'.$this->module->Lang('file').'</th>
					<th></th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td>';




        if ($docinfo['id'] != '')
        {
            $form .= '<input type="hidden" name="id" value="'.$docinfo['id'].'" />';
        }

        $form .= '<input type="file" name="uploadfile" size="30" /></td>
					<td style="font-family:Verdana;font-size:11px; color:#333333;"><input type="submit" name="Submit" value="Submit" />
					';
       $form .= $this->AdditionalImageFormatForm();
        
        $form .= '
					</td>
				</tr>
			</tbody>
			</table>
			</form>';

        return $form;
    }
*/
    function size_readable ($size, $retstring = null) {

        $sizes = array('B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');

        if ($retstring === null) { $retstring = '%01.2f %s'; }

        $lastsizestring = end($sizes);

        foreach ($sizes as $sizestring) {
            if ($size < 1024) { break; }
            if ($sizestring != $lastsizestring) { $size /= 1024; }
        }

        if ($sizestring == $sizes[0]) { $retstring = '%01d %s'; } // Bytes aren't normally fractional

        return sprintf($retstring, $size, $sizestring);
    }

    function document_icon ($extension, $icontype = 'small')
    {

        $icon = $this->config['root_url'].'/modules/ModuleXtender/images/icons/'.$icontype.'/';

        switch (strtolower($extension))
        {
            case 'pdf':
                $icon .= 'pdf.gif';
                break;
            case 'doc':
                $icon .= 'doc.gif';
                break;
            case 'gif':
                $icon .= 'gif.gif';
                break;
            case 'txt':
                $icon .= 'txt.gif';
                break;
            case 'xls':
                $icon .= 'xls.gif';
                break;
            case 'ppt':
                $icon .= 'ppt.gif';
                break;
            case 'jpg':
                $icon .= 'jpg.gif';
                break;
            case 'bmp':
                $icon .= 'bmp.gif';
                break;
            case 'html':
                $icon .= 'html.gif';
                break;
            case 'htm':
                $icon .= 'html.gif';
                break;
            case 'mov':
                $icon .= 'mov.gif';
                break;
            case 'zip':
                $icon .= 'zip.gif';
                break;
            default:
                $icon .= 'def.gif';
                break;
        }

        return $icon;
    }

    // Revised class (2009)
    
     public static function CheckDirectory ($directory, $create_if_not_exists = true, $prefix = null)
    {
   
            $directory = $prefix . DIRECTORY_SEPARATOR . $directory;
           // $directory = $instance->config['uploads_url'] . DIRECTORY_SEPARATOR . $directory;
    
        
        // Clean
        
        $directory = str_replace('\\', '/', $directory);
        $directory = str_replace('//', '/', $directory);
        $directory = str_replace(':/', '://', $directory);
        
        //die($directory);
        
        if (is_dir($directory))
        {
          return $directory;
        }
        elseif ($create_if_not_exists && strpos('http', $prefix)  === false)
        {
          $path = explode('/', $directory);
          
          $base = '';
          
          foreach ($path as $dir)
          {
          	if ($dir != null && $dir != '')
          	{
              $base .= DIRECTORY_SEPARATOR . $dir;
              if (!@is_dir($base))
              {
                mkdir($base, 0777);
              }
          	}
          }
          
          return $directory;
        }

        return false;
    }
  


}

	?>