<?php
if(!isset($gCms)) exit;

// Typical Database Initialization
$db = &$this->cms->db;
$dict = NewDataDictionary($db);
		
// mysql-specific, but ignored by other database
$taboptarray = array("mysql" => "TYPE=MyISAM");
		

// Creates the messages table
$flds = "
	msgid I KEY,
	fromid I,
	toid I,
	subject C(64),
	message X,
	`read` L,
	inbox_deleted L,
	outbox_deleted L,
	date_sent ".CMS_ADODB_DT."
	";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_femessages", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_femessages_seq");


// INSERTING DEFAULT STYLESHEET
$cssid = $db->GenID(cms_db_prefix()."css_seq");
$defcss = $this->getFileContent('default_css.css');
$date = str_replace("'","",$db->DBTimeStamp(time()));
$query = "INSERT INTO ".cms_db_prefix()."css SET css_id=?, css_name=?, css_text=?, media_type=?, create_date=?, modified_date=?";
$db->Execute($query, array($cssid, "Module: FEmessages", $defcss, "screen", $date, $date));


// INSERTING DEFAULT TEMPLATES
foreach(array('inbox','view','sendform','sent','email') as $onetpl){
	$template = $this->getFileContent($onetpl.'_default.tpl');
	$this->SetTemplate($onetpl.'_default',$template,$this->GetName());
	$this->SetPreference($onetpl.'_tpl',$onetpl.'_default');
}

$template = '<div id="femessages_summary">
<a href="{$inbox_url}"><span style="font-weight: bold;">{$modtitle}: </span>{$notice_new}</a>
</div>';
$this->SetTemplate("summary_default",$template,$this->GetName());
$this->SetPreference("summary_tpl","summary_default");

// permissions
$this->CreatePermission("femessages_admin", "FE Messages: admin");

// events
$this->CreateEvent("femessages_sent");
$this->CreateEvent("femessages_read");

foreach($this->getSettings() as $row)	$this->SetPreference($row[0],$row[2]);

// put mention into the admin log
$this->Audit( 0, $this->Lang("friendlyname"), $this->Lang("installed",$this->GetVersion()));

?>
