<?php
if(!isset($gCms))	exit;

$wysiwyg = $this->GetPreference("use_wysiwyg", false);
$usercombo = $this->GetPreference("usercombo", true);
$userlist = $this->get_userlist();

$message = "";
$subject = "";
$toid = false;

// retrieving message content
if(isset($params["submit"])){
	if($this->GetPreference("decode_entities",false)){
		$to_replace = array('&apos;','&#39;','&#039;');
		$message = str_replace($to_replace,"'",$params["message"]);
		$message = html_entity_decode($message);
		$subject = str_replace($to_replace,"'",$params["subject"]);
		$subject = html_entity_decode($subject);
	}else{
		$message = $params["message"];
		$subject = $params["subject"];
	}
	if(trim($subject) == "")	$subject = $this->Lang("nosubject");
}elseif(isset($params["msgid"])){
	$query = "SELECT * FROM ".cms_db_prefix()."module_femessages WHERE msgid=?";
	$dbresult = $db->Execute($query,array($params["msgid"]));
	if($dbresult && $row = $dbresult->FetchRow()){
		$toid = ($row["fromid"] == $userid)?$row["toid"]:$row["fromid"];
		if($wysiwyg){
			$message = '<br/><br/><br/><i>'.$this->Lang("quote",(isset($userlist[$row["fromid"]])?$userlist[$row["fromid"]]:"?")).'</i><br/><div class="femessages_quote">'.$row["message"].'</div>';
		}else{
			
			$message = '


> '.$this->Lang("quote",(isset($userlist[$row["fromid"]])?$userlist[$row["fromid"]]:"?")).'
'.$row["message"];

		}
		$subject = $this->Lang("re").$row["subject"];
	}
}


if(isset($params["submit"])){
	// the form is submitted
	if(!$usercombo){
		// we must first check if this is a valid user
		$tmplist = array_flip($userlist);
		if(isset($tmplist[$params["to"]]))	$toid = $tmplist[$params["to"]];
	}else{
		$toid = (int) $params["to"];
	}
	if(!$toid){
		// wrong user
		$this->smarty->assign("notification",$this->Lang("error_wronguser"));
	}elseif(trim($message) == ""){
		$this->smarty->assign("notification",$this->Lang("error_emptymsg"));
	}else{
		// sending message
		$msgid = $db->GenID(cms_db_prefix()."module_femessages_seq");
		$query = "INSERT INTO ".cms_db_prefix()."module_femessages SET msgid=?, toid=?, fromid=?, subject=?, message=?, date_sent=?, `read`=0, inbox_deleted=0, outbox_deleted=0";
		$date_sent = str_replace("'","",$db->DBTimeStamp(time()));
		if($db->Execute($query,array($msgid, $toid, $userid, $subject, $message, $date_sent))){
			// message is sent
			$this->SendEvent("femessages_sent", array("fromid"=>$userid, "toid"=>$toid, "msgid"=>$msgid));
			$this->smarty->assign("notification",$this->Lang("message_sent"));
			$this->do_notification($toid, $userid, $subject, $message, $date_sent);
			$this->user_clean($userid);
			$this->user_clean($toid);
		}else{
			$this->smarty->assign("notification",$this->Lang("error_notsent"));
		}
		$this->assign_basics($userid, $id, $returnid, $inline);
		echo $this->ProcessTemplateFromDatabase($this->GetPreference("sent_tpl"));
		return true;
	}
}else{
	$this->smarty->assign("notification",false);
}

$choices = array();
foreach($userlist as $key=>$value){
	if($key != $userid)	$choices[$value] = $key;
}
$this->smarty->assign("formstart", $this->CreateFormStart($id, "default", $returnid).$this->CreateInputHidden($id, "show", "send"));
$this->smarty->assign("formend", $this->CreateFormEnd());
$this->smarty->assign("to_label", $this->Lang("to"));
if($usercombo){
	$this->smarty->assign("to_input", $this->CreateInputDropdown($id,"to",$choices,-1,$toid));
}else{
	$this->smarty->assign("to_input", $this->CreateInputText($id,"to",$params["to"],30,32));	
}
$this->smarty->assign("subject_label", $this->Lang("subject"));
$this->smarty->assign("subject_input", $this->CreateInputText($id,"subject",$subject,50,64));
$this->smarty->assign("message_label", $this->Lang("message"));
$this->smarty->assign("message_input", $this->CreateTextArea($wysiwyg,$id,$message,"message"));
$this->smarty->assign("submit", $this->CreateInputSubmit($id, "submit", $this->Lang("submit")));

$this->assign_basics($userid, $id, $returnid, $inline);

echo $this->ProcessTemplateFromDatabase($this->GetPreference("sendform_tpl"));

?>

