<?php
require_once(dirname(__FILE__)."/../../include.php");
global $gCms;
$db =& $gCms->GetDb();
$file = new StdClass();
$hasperm = false;
$file_path  = '';
$file_name = '';
$file_id = '';

// make checking when downloading by alias
if( isset($_GET['alias']) )
{
	$query = 'SELECT * FROM '.cms_db_prefix().'module_downloadmanager_files WHERE alias = ? ';
	$dbresult = $db->Execute($query,array($_GET['alias']));
	if ($dbresult && $row = $dbresult->FetchRow())
	{
		foreach($row as $key=>$value)
			$file->$key = $value;
		$file_path =  $row['server_name'];
		$file_name =  $row['name'].($row['ext']!=''?'.'. $row['ext']:'');
		$file_id = $row['file_id'];
	}
	else
		die("No such alias");

	// lets see if we accesed by FEU
	if( $file->accesstype >= 1 )
	{
		// we did indeed
		$FEU = $gCms->modules['FrontEndUsers']['object'];
		if (!$FEU) {
				die("No FEU module.");
				exit;
		}
		// check if logged
		$userid = $FEU->LoggedInId();
		$usergroups = explode(',',$FEU->GetMemberGroups($userid));
		$groups = $FEU->GetGroupList();
		$filegroups = array();

		// get file groups
		$query = "SELECT * FROM ".cms_db_prefix()."module_downloadmanager_filegroups WHERE file_id=?";
		$dbresult = $db->Execute($query, array($file->file_id));
		while($dbresult && $row = $dbresult->FetchRow())
			$filegroups[]= $row['group_id'];

		// checking permisions
		$i = 0;
		while(!$hasperm && $i < count($usergroups))
		{
			if(in_array($groups[$usergroups[$i]],$filegroups))
			{
				$hasperm = true;
				break;
			}
			$i++;
		}
	}
	else if( $file->accesstype == 0 )
		// free downloads for all
		$hasperm = true;

}
// making checkig when downloading by email
else if( isset($_GET['hashkey']))
{
	$hasperm = true;
	$query = 'SELECT * FROM '.cms_db_prefix().'module_downloadmanager_files f
		RIGHT JOIN '.cms_db_prefix().'module_downloadmanager_downloads c USING (file_id)
		WHERE hashkey = ? ';
	$dbresult = $db->Execute($query, array($_GET['hashkey']));
	if ($dbresult && $row = $dbresult->FetchRow())
	{
		foreach($row as $key=>$value)
			$file->$key = $value;

		$file_path =  $row['server_name'];
		$file_name =  $row['name'].($row['ext']!=''?'.'. $row['ext']:'');
		$file_id =  $row['file_id'];

		$db->Execute('UPDATE '.cms_db_prefix().'module_downloadmanager_downloads
			SET downloaded = now() WHERE hashkey = ?', array($row['download_id']) );
	}
	else
		die("No such hash");

}
else
	die("Wrong parameters");

if(!$hasperm)
{
	header("HTTP/1.0 403 Forbidden");
	exit;
}

if( $file_path == '' || $file_name == '' )
	die(' DB error' );
if( !file_exists($file_path ))
	die('File '.$file_name.' not found.' );

$db->Execute('UPDATE '.cms_db_prefix().'module_downloadmanager_files
			SET counter = counter+1 WHERE file_id = ?', array($file_id) );
// all checked -> downloading
include_once("lib/vnc_httpdownload/class.httpdownload.php");
$object = new httpdownload;
$object->set_byfile($file_path);
//~ var_dump($file_path);
$object->filename = $file_name;
$object->download();


?>
