<?php
if (!isset($gCms)) exit;

if (! $this->CheckAccess("Use Category Manager"))
	{
	return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
	}

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for CategoryManager "addeditCategories" admin action
   
   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/

// If cancel, return home...

if (isset($params['cancel']))
{
	$params = array(
		//'tab_message'=> 'list_template_updated',
		'active_tab' => 'categories'
		);		
	
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

// First, if $param['category_name'] is define, we save it in database

if (isset($params['category_name']))
{
	$category_name = $params['category_name'];
}
else 
{
	$category_name = '';
}



if (isset($params['input_submitted']))
{
	
	if ($category_name != '')
	{
		
		if (!isset($params['catid']))
		{
			//echo 'INSERT';
			
			// We have to insert it
			
			// DB : module_modulextender_categories
			
			$catid = $db->GenID(cms_db_prefix()."module_modulextender_categories_seq");
			
			//$time = $db->DBTimeStamp(time());
			
			$query = 'INSERT INTO '.cms_db_prefix().'module_modulextender_categories (id, title) VALUES (?,?)';
			
			$db->Execute($query, array($catid, $category_name));
			
			//$this->UpdateHierarchyPositions();
			
			@$this->SendEvent('NewsCategoryAdded', array('category_id' => $catid, 'name' => $category_name));
				
			$params = array('tab_message'=> 'categoryadded', 'active_tab' => 'categories');
		}
		else 
		{
			//echo 'UPDATE '.$params['catid'];
			
			// We have to update it
			
			// DB : module_modulextender_categories
			
			$catid = $params['catid'];
			
			//$time = $db->DBTimeStamp(time());
			
			$query = 'UPDATE '.cms_db_prefix().'module_modulextender_categories SET title = ? WHERE id = ?';
			
			$db->Execute($query, array($category_name, $catid));
			//$this->UpdateHierarchyPositions();
			
			@$this->SendEvent('NewsCategoryAdded', array('category_id' => $catid, 'name' => $category_name));

			$params = array('tab_message'=> 'categorymodified', 'active_tab' => 'categories');
		}
	
				
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
	}
	elseif (!isset($params['catid']))
	{
		echo $this->ShowErrors($this->Lang('nonamegiven'));
	}
}


// If nothing is done, show the form.

$this->smarty->assign('title_section',$this->Lang('title_add_edit_category'));

// Form
$this->smarty->assign('form_start',$this->CreateFormStart($id, 'addeditCategories', $returnid));

$this->smarty->assign('title_category_name',$this->Lang('title_category_name'));

$this->smarty->assign('input_category_name',$this->CreateInputText($id, 'category_name', $category_name, 50));
$this->smarty->assign('input_submitted',$this->CreateInputHidden($id, 'input_submitted', ''));

if (isset($params['category_name']))
{
	$this->smarty->assign('submit_button',$this->CreateInputSubmit($id, 'submit', $this->Lang('edit_cat')));
}
else 
{
	$this->smarty->assign('submit_button',$this->CreateInputSubmit($id, 'submit', $this->Lang('add_cat')));
}

if (isset($params['catid']))
{
	$this->smarty->assign('catid',$this->CreateInputHidden($id, 'catid', $params['catid']));
}

$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));


			
$this->smarty->assign('form_end',$this->CreateFormEnd());


// MC ADDS  $this->Name


echo $this->ProcessTemplate('adminAddEditCategory.tpl');

?>