<?php
	/*****************************************************************************************************************************
		COUNTRIES FUNCTIONS
	********************************************************************************************************************************/
	
	class XT_Countries extends CmsObject {
			
  const COUNTRY_FLAGS_DIR = 'modules/ModuleXtender/images/countries/flags/';
    
	function XT_Countries (&$cms_module = null)
	{
		// Backward compatibility	, not used anymore.		$this->parentmodule = $parentmodule;
  }
		  
/**
 *  getCountries gives the list of the countries
 *
 * @param string $scope Scope of the countries
 * @param string $lang Language for the countries
 * @return array List of countries (with ISO as keys)
 */
  
  public static function getCountries($scope = 'iso_countries', $lang = 'en')
  {
  	// TODO: Implement the languages feature
  	  	
  	switch ($scope)
  	{
  		case 'iso_countries':
  			return unserialize(base64_decode(self::SR_COUNTRIES_EN));
  			break;
  		default:
  		  return array();
  		  break;
  	}
  }
  
 public static function getCountriesForDropdown($scope = 'iso_countries', $lang = 'en', $select_alternate = false)
  {
    $countries = self::getCountries($scope, $lang);
    
    $clean_countries = array();
    
    foreach ($countries as $iso => $country)
    {
    	if ($select_alternate && isset($country[1]))
      {
        $clean_countries[$iso] = $country[1];
      }
      else 
      {
        $clean_countries[$iso] = $country[0];
      }     
    }
    unset($clean_countries['ZZ']);
    
    natcasesort($clean_countries);
    
    return $clean_countries;
  }
  
	
	public static function getCountry ($country_iso, $lang = 'en', $select_alternate = false)
	{
		$countries = self::getCountries();
		if (isset($countries[$country_iso][0]))
		{
			if ($select_alternate && isset($countries[$country_iso][1]))
			{
				return $countries[$country_iso][1];
			}
			else 
			{
				return $countries[$country_iso][0];
			}			
		}
		else
		{
			return null;
		}
	}
	
	public function getCountryFlag ($country_iso, $version = 'small', $lang = 'en', $border = 0, $alt = '')
	{			
		return '<img src="'.$this->config['root_url'].self::COUNTRY_FLAGS_DIR.'/'.$version.'/name/'.$row['iso_flag'].'" alt='.$row['iso_name_'.$lng].'" />';
	}
	
	function getCountriesDropdown ($id, $name='countries', $lng='en', $selecteditem = '')
	{
		$countriesdropdown = '<select name="'.$id.$name.'"><option>'.$this->Lang('countries_select').'</option>';

		foreach (self::getCountries() as $iso => $country)
		{
			$countriesdropdown .= '<option value="'.$iso.'"';
			
			if ($iso == $selecteditem)
			{
				$countriesdropdown .= ' selected';
			}		
			
			$countriesdropdown .= ' >'.$country[0].'</option>';
		}
		
		$countriesdropdown .= '</select>';
		
		return $countriesdropdown;
	}
	
	function getCountriesDropdownWithFlags ($id, $name='countries', $lng='en', $selecteditem = '')
	{
		$countriesdropdown = '<select name="'.$id.$name.'"><option>'.$this->Lang('countries_select').'</option>';
		
				
		$imagepath = $this->config['root_url'].self::COUNTRY_FLAGS_DIR . '/small/name/';

    foreach (self::getCountries() as $iso => $country)
    {
			$countriesdropdown .= '<option value="'.$iso.'"';
			
			if ($iso == $selecteditem)
			{
				$countriesdropdown .= ' selected';
			}
			
			$countriesdropdown .= ' style="background-repeat: no-repeat; background-position: right; padding-right: 25px; margin-top: 5px; margin-bottom: 5px;';

			if ($iso != '')
			{
				$countriesdropdown .= ' background-image: url('.$imagepath.$iso.');';
			}
			
			$countriesdropdown .= '"';
			
			$countriesdropdown .= ' >'.$country[0].'</option>'."\r\n";
			//$countriesdropdown .= '<img src="'.$imagepath.$row['iso_flag'].'" />';
		}
		
		$countriesdropdown .= '</select>';
		
		return $countriesdropdown;
	}
	
	   // Extracted by Jean-Christophe Cuvelier from CLDR database from http://cldr.unicode.org/ - V.1.7 (2009-05-08)
	   
	   const SR_COUNTRIES_EN = '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';
     const SR_REGIONS_EN = 'YTozNDp7czozOiIwMDEiO2E6MTp7aTowO3M6NToiV29ybGQiO31zOjM6IjAwMiI7YToxOntpOjA7czo2OiJBZnJpY2EiO31zOjM6IjAwMyI7YToxOntpOjA7czoxMzoiTm9ydGggQW1lcmljYSI7fXM6MzoiMDA1IjthOjE6e2k6MDtzOjEzOiJTb3V0aCBBbWVyaWNhIjt9czozOiIwMDkiO2E6MTp7aTowO3M6NzoiT2NlYW5pYSI7fXM6MzoiMDExIjthOjE6e2k6MDtzOjE0OiJXZXN0ZXJuIEFmcmljYSI7fXM6MzoiMDEzIjthOjE6e2k6MDtzOjE1OiJDZW50cmFsIEFtZXJpY2EiO31zOjM6IjAxNCI7YToxOntpOjA7czoxNDoiRWFzdGVybiBBZnJpY2EiO31zOjM6IjAxNSI7YToxOntpOjA7czoxNToiTm9ydGhlcm4gQWZyaWNhIjt9czozOiIwMTciO2E6MTp7aTowO3M6MTM6Ik1pZGRsZSBBZnJpY2EiO31zOjM6IjAxOCI7YToxOntpOjA7czoxNToiU291dGhlcm4gQWZyaWNhIjt9czozOiIwMTkiO2E6MTp7aTowO3M6ODoiQW1lcmljYXMiO31zOjM6IjAyMSI7YToxOntpOjA7czoxNjoiTm9ydGhlcm4gQW1lcmljYSI7fXM6MzoiMDI5IjthOjE6e2k6MDtzOjk6IkNhcmliYmVhbiI7fXM6MzoiMDMwIjthOjE6e2k6MDtzOjEyOiJFYXN0ZXJuIEFzaWEiO31zOjM6IjAzNCI7YToxOntpOjA7czoxMzoiU291dGhlcm4gQXNpYSI7fXM6MzoiMDM1IjthOjE6e2k6MDtzOjE4OiJTb3V0aC1FYXN0ZXJuIEFzaWEiO31zOjM6IjAzOSI7YToxOntpOjA7czoxNToiU291dGhlcm4gRXVyb3BlIjt9czozOiIwNTMiO2E6MTp7aTowO3M6MjU6IkF1c3RyYWxpYSBhbmQgTmV3IFplYWxhbmQiO31zOjM6IjA1NCI7YToxOntpOjA7czo5OiJNZWxhbmVzaWEiO31zOjM6IjA1NyI7YToxOntpOjA7czoxODoiTWljcm9uZXNpYW4gUmVnaW9uIjt9czozOiIwNjEiO2E6MTp7aTowO3M6OToiUG9seW5lc2lhIjt9czozOiIwNjIiO2E6MTp7aTowO3M6MTg6IlNvdXRoLUNlbnRyYWwgQXNpYSI7fWk6MTQyO2E6MTp7aTowO3M6NDoiQXNpYSI7fWk6MTQzO2E6MTp7aTowO3M6MTI6IkNlbnRyYWwgQXNpYSI7fWk6MTQ1O2E6MTp7aTowO3M6MTI6Ildlc3Rlcm4gQXNpYSI7fWk6MTUwO2E6MTp7aTowO3M6NjoiRXVyb3BlIjt9aToxNTE7YToxOntpOjA7czoxNDoiRWFzdGVybiBFdXJvcGUiO31pOjE1NDthOjE6e2k6MDtzOjE1OiJOb3J0aGVybiBFdXJvcGUiO31pOjE1NTthOjE6e2k6MDtzOjE0OiJXZXN0ZXJuIEV1cm9wZSI7fWk6MTcyO2E6MTp7aTowO3M6MzQ6IkNvbW1vbndlYWx0aCBvZiBJbmRlcGVuZGVudCBTdGF0ZXMiO31pOjIwMDthOjE6e2k6MDtzOjE0OiJDemVjaG9zbG92YWtpYSI7fWk6NDE5O2E6MTp7aTowO3M6MzE6IkxhdGluIEFtZXJpY2EgYW5kIHRoZSBDYXJpYmJlYW4iO31pOjgzMDthOjE6e2k6MDtzOjE1OiJDaGFubmVsIElzbGFuZHMiO319';
	 }
	?>