<?php
$lang['friendlyname'] = 'Shop Made Simple';
$lang['admin_description'] = 'This module forms the base of preparing a shop. It handles the products and their grouping. Images and attributes are available per product';
$lang['message_postinstall'] = 'Be sure to set "Use Shop Made Simple" permissions to use this module.';
$lang['message_postuninstall'] = 'If images have been added, they are not removed during uninstall.';
$lang['message_confirmuninstall'] = 'Really? You\'re sure you want to uninstall this module?';

// Common translations
$lang['installed'] = 'has been installed.';
$lang['uninstalled'] = 'has been uninstalled.';
$lang['upgraded'] = 'has been upgraded.';

$lang['cancel'] = 'Cancel';
$lang['submit'] = 'Submit';
$lang['done'] = 'Done';
$lang['update'] = 'Update';
$lang['continue'] = 'Continue';
$lang['addimage'] = 'Add Image';
$lang['addattribute'] = 'Add Attribute';
$lang['addcategory'] = 'Add Category';
$lang['deletecategory'] = 'Delete Category';
$lang['module_example_stylesheet']='Module: Shop Made Simple';
$lang['root'] = 'Root';

// Specific translations, per tab
$lang['label_tab_preferences'] = 'Preferences';
$lang['label_admin_name'] = 'Administrator Name';
$lang['label_admin_email'] = 'Administrator Email';
$lang['label_shop_name'] = 'Shop Name';
$lang['label_shop_phone'] = 'Shop Emergency Phone';
$lang['label_shop_online'] = 'Shop Online';
$lang['label_default_language'] = 'Default Language';
$lang['label_prices_incl_vat'] = 'Prices are inclusive VAT';
$lang['label_weight_unit_measure'] = 'Product weight in';
$lang['label_item_capital_only'] = 'Itemnumber capitals only';
$lang['label_default_sku'] = 'Default Stock Keeping Unit';
$lang['label_default_currency'] = 'Default Currency';
$lang['label_default_symbol'] = 'Default Currency Symbol';
$lang['label_imagepath_category'] = 'Path to category images';
$lang['label_imagepath_product'] = 'Path to product images';
$lang['label_productpagelimit'] = 'Number of products per page';
$lang['label_tnheight_product'] = 'Product thumbnail height';
$lang['label_tnwidth_product'] = 'Width';
$lang['preferencesupdated'] = 'Preferences have been updated';
$lang['productsreindexed'] = 'Products have been reindexed for the Search module';
$lang['productthumbnailsrebuild'] = 'Thumbnails of products have been rebuild';
$lang['rebuildproductthumbnails'] = 'Rebuild';
$lang['searchreindex'] = 'Reindex for Search';

$lang['label_tab_templates'] = 'Templates';
$lang['label_categories_template'] = 'Categories';
$lang['label_catlist_template'] = 'Category & Products';
$lang['label_proddetail_template'] = 'Product detail';
$lang['label_prodfeat_template'] = 'Featured products';
$lang['templatesupdated'] = 'Templates have been updated';

$lang['label_tab_categories'] = 'Categories and Products';
$lang['label_current_category'] = 'Current Category';
$lang['label_categories'] = 'Categories';
$lang['label_category_id'] = 'Category';
$lang['label_category_parent'] = 'Parent Category';
$lang['label_category_name'] = 'Name';
$lang['label_category_description'] = 'Description';
$lang['label_category_image'] = 'Image';
$lang['label_category_active'] = 'Category is active ?';
$lang['label_category_position'] = 'List Order';
$lang['nocatfound'] = 'No categories found';


$lang['label_product_active'] = 'Product is active ?';
$lang['label_product_category'] = 'Products for';
$lang['label_product_category_id'] = 'Category';
$lang['label_product_description'] = 'Description';
$lang['label_product_featured'] = 'Feature this product';
$lang['label_product'] = 'Product';
$lang['label_product_id'] = 'ID';
$lang['label_product_image'] = 'Image';
$lang['label_product_itemnumber'] = 'Itemnumber';
$lang['label_product_name'] = 'Name';
$lang['label_product_netweight'] = 'Nett Weight';
$lang['label_product_position'] = 'List Order';
$lang['label_product_price'] = 'Price';
$lang['label_product_sku'] = 'Stock Keeping Unit (SKU)';
$lang['label_product_vatcode'] = 'VAT';
$lang['noprodfound'] = 'No products found';


$lang['message_areyousurecategory'] = 'Are you sure you want to delete category: %s?';
$lang['message_areyousureproduct'] = 'Are you sure you want to delete product: %s?';
$lang['message_areyousureprodcat'] = 'Are you sure you want to disconnect this product: %s from category %s?';
$lang['text_add'] = 'Add';
$lang['text_category'] = 'Category';
$lang['text_product'] = 'Product';
$lang['piece'] = 'Piece';
$lang['properties_updated'] = 'Properties have been updated';

// Product Attributes tab
$lang['column_attribute_description'] = 'Description';
$lang['column_attribute_name'] = 'Name';
$lang['label_attribute_description'] = 'Description';
$lang['label_attribute_name'] = 'Name';
$lang['label_attributes_product_name'] = 'Attributes for product';
$lang['message_areyousureattribute'] = 'Are you sure you want to delete attribute: %s?';
$lang['message_attributeadded'] = 'Attribute: %s has been added';
$lang['message_attributedeleted'] = 'Attribute: %s has been deleted';
$lang['message_noattributetosave'] = 'No attribute information to save. No attribute added';
$lang['no_attributes_available'] = 'No attributes available';

// Product Images tab
$lang['column_image_description'] = 'Description';
$lang['column_image_name'] = 'Image file';
$lang['label_image_description'] = 'Description';
$lang['label_image_name'] = 'Name';
$lang['label_image_product_name'] = 'Images for product';
$lang['message_areyousureimage'] = 'Are you sure you want to delete image: %s?';
$lang['no_images_available'] = 'No images available';

$lang['label_tab_product'] = 'Product Details';
$lang['label_tab_product_categories'] = 'Categories';
$lang['label_tab_attributes'] = 'Attributes';
$lang['label_tab_images'] = 'Images';

$lang['message_imageadded'] = 'Image: %s has been added';
$lang['message_imagedeleted'] = 'Image: %s has been deleted';
$lang['message_noimagetoupload'] = 'No image to upload. No image added';
$lang['text_active'] = 'Set Active';
$lang['text_delete'] = 'Delete';
$lang['text_edit'] = 'Edit';
$lang['text_inactive'] = 'Set Inactive';

// Stock Keeping Unit (SKU) tab
$lang['label_tab_skus'] = 'SKU\'s';
$lang['label_sku_name'] = 'Name';
$lang['label_sku_description'] = 'Description';
$lang['message_areyousuresku'] = 'Are you sure you want to delete SKU: %s?';
$lang['skudeleted'] = 'Stock keeping unit %s deleted';
$lang['skuinuse'] = 'Can\'t delete, stock keeping unit is, at least, in use in product: %s';
$lang['text_sku'] = 'Stock Keeping Unit';

// Templates tab
$lang['label_tab_template'] = 'Templates';

// Frontend translations
$lang['addtocart'] = 'Add to Cart';
$lang['firstpage'] = '<<';
$lang['lastpage'] = '>>';
$lang['nextpage'] = '>';
$lang['prevpage'] = '<';
$lang['print'] = 'Print this page';
$lang['print_page'] = 'Print';
$lang['productsoldout'] = 'Sold out';
$lang['prompt_of'] = 'of';
$lang['prompt_page'] = 'Page';
$lang['pricesincurinvat'] = 'All prices in %s, including TAX/VAT';
$lang['pricesincurexvat'] = 'All prices in %s, excluding TAX/VAT';
$lang['textproductcount'] = 'Total %s product(s) found:';
$lang['textmore'] = ' ...';
$lang['unknown_display'] = 'Parameter display not defined in action.default.';

// Admin
$lang['helpcatname'] = 'Name of category. Must exactly match. If left blank, the products from the root category will be shown. 
This parameter is only used if the parameter display contains productlist (see example).';
$lang['helpdisplay'] = 'Specifies the type of display you want to show. There are currently two available:<ul>
	<li>categorylist (default) - shows a list of the categories and the number of products within category;</li>
	<li>featured - shows a list of the products that are marked as featured;</li>
	<li>productlist - show products from a named category.</li>
</ul>';
$lang['helppagenumber'] = 'Enter the number of the page that the products should be shown. \'pagenumber=2\' will show all products as of page 2. 
The visitor will be able to use the previous page and the next (if any). If the pagenumber is not passed, page 1 will be shown.';
$lang['helpparentcategory'] = 'Internal number of category. This will show a list of all the categories using the provided number as parent. 
The internal number can be found on the left side of each category in the admin page of this module.';
$lang['helpprodpagelimit'] = 'The number of products that are to be shown on one page. This overrides the value as entered in the preferences.';
$lang['helpstart'] = 'The starting value for the page of products. If you want to show all products starting at the fourth, use \'start=4\'.';

$lang['changelog'] = '<ul>
<li>Version 0.2.5 10 August 2009<br><ul>
	<li>Missing code in front end product detail. (bug# 3850) solved by NaN.</li>
</ul>
<li>Version 0.2.4 26 July 2009<br><ul>
	<li>Automatic installation of stylesheet \'Module: Shop Made Simple\' was not working (stylesheet will be inserted during upgrade from version 0.2.3 to 0.2.4);</li>
	<li>Activating and deactivating was not working correctly for categories in list of categories, change also applied for products;</li>
	<li>No test data created anymore automatically during installation;</li>
	<li>On product detail new variables introduced: {imagethumb} and {fullpathimage} to support images better;</li>
	<li>No category and product id used anymore in installed template of catagory list;</li>
	<li>Default currency is set to Euro;</li>
	<li>Work done on pretty URL --> not fully functional;</li>
	<li>Bug solved (by Fatlizard) to handle correct product_id in fe product detail.</li>
</ul>
<li>Version 0.2.3 17 May 2009<br><ul>
	<li>Initialized variables correctly, so no warning appears for them when php.ini states to show warnings;</li>
	<li>New preferences for thumbnail generation. Use the rebuild button to generate thumbnails from earlier loaded images.</li>
	<li>The detail template has been changed to allow switching images. A simpler version is available to copy from in the
	templates directory. The name is fe_product_detail1.tpl.<br>
	If you have upgraded from an earlier version you may want to use the switching of images. Look in templates\fe_product_detail.tpl.</li>
	<li>Original template of products per category changed to show image with link on product line.</li>
	</ul>
<li>Version 0.2.2 8 Mar 2009<br><ul>
	<li>Show name without link to detail on product listing (feature request# 2986): use prodnamenolink in stead of prodname in the template.</li>
	<li>Build in link from image to detail on product listing (feature request# 3083): use prodimagelink in stead of prodimage in the template.</li>
	</ul>
<li>Version 0.2.1 15 Jan 2009<br><ul>
	<li>Typo caused display=productlist catname=... not to work correctly. Bug solved.</li>
	</ul>
<li>Version 0.2.0 11 Jan 2009<br><ul>
	<li>Currency symbol available for category list (use $entry->cursymbol};</li>
	<li>Templates can now be adjusted to decrease length of description (was hardcoded) using |truncate in template;</li>
	<li>Hardcoded signaling that there are no categories or products is removed, now part of translation;</li>
	<li>If the module Search has been installed, the name and description of products can be searched upon;</li>
	<li>Bug solved on updating category information. Editor was not working well;</li>
	<li>Description of category and product could span two lines. Now always only one line;</li>
	<li>New preference added to hold the number of products per page;</li>
	<li>Using parameter prodpagelimit, the number of products per page can be influenced (overriding the preference).<br>
	Paging is possible using the following in the Categories/Products template:<br>
	{if $pagecount > 1}<br>&nbsp;{$firstpage} {$prevpage} {$pagetext}:  {$pagenumber} {$oftext}: {$pagecount} {$nextpage} {$lastpage}<br>{/if}
	<br></li>
	<li>Internal clean up of front end category listing program.</li>
	</ul>
</li>
<li>Version 0.1.9 29 Dec 2008<br><ul>
	<li>Removed translation bug during installation.</li>
	</ul>
</li>
<li>Version 0.1.8 11 Dec 2008<br><ul>
	<li>Solved issue where switch status on product caused description to be cleared;</li>
	<li>Edit of Stock Keeping Unit was not working;</li>
	</ul>
</li>
<li>Version 0.1.7 9 Dec 2008<br><ul>
	<li>Add to cart available at list of products on front end;</li>
	<li>New fields: Stock Keeping Unit (SKU) and itemnumber available per product;</li>
	<li>Maintenance on SKU is possible;</li>
	<li>Additional preference to allow only capital characters in itemnumber;</li>
	<li>Additional preference to set default SKU during add of a product.</li>
	</ul>
</li>
<li>Version 0.1.6 12 Nov 2008<br><ul>
	<li>Image of category is now displayed in front of category name in category listing;</li>
	<li>Length of product and attribute description enlarged;</li>
	<li>Check build in during installation if the conflicting module Products has been installed;</li>
	<li>Bug on adding new products corrected (was always pointing to root after adding);</li>
	<li>Deletion of product returns to last used category;</li>
	<li>After Switch of status, last shown category/products list is shown;</li>
	<li>Description boxes for product, attributes and images improvements;</li>
	<li>Prepare correct connection of multiple categories to one product;</li>
	<li>Variable $image in detail template renamed to $prodimage, since it might be in use in other modules (like printing);</li>
	<li>When last category connection to product is deleted, the product will be connected to the root (otherwise it can\'t be selected anymore);</li>
	<li>Multiple levels of categories is allowed as of version 0.1.5 but is not supported on front end! (sorry).</li>
	</ul>
</li>
<li>Version 0.1.5 June 2008<br><ul>
	<li>Multiple levels of categories are allowed/possible;</li>
	<li>New parameter for frontend: parentcategory.</li>
	</ul>
</li>
<li>Version 0.1.4 May 2008<br><ul>
	<li>Upload of image for category has been changed;</li>
	<li>Changed install so directory path correct for categories and products.</li>
	</ul>
</li>
<li>Version 0.1.3 May 2008<br><ul>
	<li>All front end pages are handled by templates derived from admin part;</li>
	<li>Administrator now has tab containing templates as used on front end;</li>
	<li>Front end shows wether prices are incl. or excl. VAT dependent on preference;</li>
	<li>Products connected to category sorted by list order;</li>
	<li>Overview categories in back end and front end now sorted by list order.</li>
	</ul>
</li>
<li>Version 0.1.2 - May 1st 2008<br><ul>
	<li>When a category is deleted, its connected products will be connected to the root category.</li>
	<li>Some buttons lacked proper translations.</li>
	</ul>
</li>
<li>Version 0.1.1 - April 2008<br><ul>
	<li>Now option to show products of one category in single pages using parameters.</li>
	<li>Some fields turned into float to correctly handle decimals.</li>
	<li>Dropped admin preferences to hold shop policies (use content block or normal CMSMS page with the policies).</li>
	<li>Introduction of checkmark if prices are inclusive or exlcusive VAT in preferences.</li>
	<li>Also in preferences now unit of measure for weights of the products.</li>
	<li>Introduction of VAT code and nett weight per product. For calculation of (shipping) cost in Cart module</li>  
	</ul>
</li>
<li>Version 0.1.0 - April 18th 2008 Roll out version<br><ul>
	<li>Layout changes made</li>
	</ul>
</li>
<li>Version 0.0.4 - Import and Export Release<br><ul>
	<li>Categories</li>
	<li>Products</li>
	</ul>
</li>
<li>Version 0.0.3 - Client Interface Release<br><ul>
	<li>Client interface tags</li>
	</ul>
</li>
<li>Version 0.0.2 - Administration Extended Release<ul>
	<li>Templates, Events, Orders, Translations</li>
	</ul>
</li>
<li>Version 0.0.1 - Administration Release<br><ul>
	<li>Preferences - Completed on 24/12/2007</li>
	<li>Categories - Completed on 25/12/2007</li>
	<li>Products</li>
	</ul>
</li>
</ul>';
$lang['help'] = '
<h3>How Do I Use It</h3>
<p>
A visitor of the website will see a list of categories. You will be able to show a list of the categories by placing a smarty tag in a page or template using &#123;cms_module module=\'ShopMadeSimple\'}.<br> 
Using the parameter connected to a category, you are able to show products linked to that category.<br>
An example is: {cms_module module=\'ShopMadeSimple\' display=\'productlist\' catname=\'Gardentools\'}. This will show all products that are connected to the
category name \'Gardentools\'. Using the display=\'productlist\' without a category name will show the products in the root.<br> 
Another example is: {cms_module module=\'ShopMadeSimple\' display=\'categorylist\'}. This will show the various categories. If one is selected, all the connected products are shown.<br>
If you don\'t want to see an image for a category on the front end, place \'no_image.jpg\' in the field \'Image\'.<br><br>
When the Search module is installed, all the words as entered in the product name and product description will be part of the search index.<br>
If the Search module is installed after this module, one can use the button Reindex for Search from the options tab in the back end.
<h3>Note on compatibility</h3>
The modules Products/Cart/Orders are in NO way linked to the Shop, Cart and Payment Made Simple modules.<br>
They are not compatible and can\'t be used next to each other.<br>
Products and Shop Made Simple use the same classes internally and can\'t be installed next to each other.

<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report see the <a href="http://dev.cmsmadesimple.org/projects/sms">projects homepage</a>.</li>
<li>Commercial support is available via Duketown\'s module homepage at <a href="http://www.mantox.nl/dt">Duketown</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>
</ul>
<p>As per the GPL, this software is provided as-is. Please read the text
of the license for the full disclaimer.</p>

<h3>Copyright and License</h3>
<p>Copyright &copy; 2008.<br>
Authors:<ul>
	<li>Duketown: <a href="mailto:duketown@mantox.nl">&lt;duketown@mantox.nl&gt;</a></li>
	<li>Lahuindai: <a href="mailto:lahuindai@nobrain.co.za">&lt;lahuindai@nobrain.co.za&gt;</a></li>
</ul>
';
?>