<?php
if (isset($params['submit']) && $params['submit'] == $this->Lang('update')) {
	$this->products->Update($params);
	$params = array('active_tab'=>'categories', 'current_category_id'=>$params['current_category_id']);
	$this->Redirect( $id, 'defaultadmin', $returnid, $params );
}
if (isset($params['submit']) && $params['submit'] == $this->Lang('addimage')) {
	$this->Redirect( $id, 'product_images', $returnid, $params );
}
if (isset($params['submit']) && $params['submit'] == $this->Lang('addattribute')) {
	$this->Redirect( $id, 'product_attributes', $returnid, $params );
}
if (isset($params['submit']) && $params['submit'] == $this->Lang('addcategory')) {
	$this->products->CreateCategoryMap($params['category_id'], $params['product_id']);
	$params['active_tab'] = 'categories';
}
if (isset($params['submit']) && $params['submit'] == $this->Lang('deletecategory')) {
	$this->products->DeleteCategoryMap($params['category_id'], $params['product_id']);
	$params['active_tab'] = 'categories';
}
// All actions handled, now get all the information linked to the product
if (isset($params['product_id'])) {
	$product_data = $this->products->Get($params['product_id']);
}
$active_tab = 'product';
if( isset( $params['active_tab'] ) ) {
	$active_tab = $params['active_tab'];
}
if (isset($params['cancel']) && $params['cancel'] == $this->Lang('cancel')) {
	$params = array('active_tab'=>'categories', 'current_category_id'=>$params['current_category_id']);
	$this->Redirect( $id, 'defaultadmin', $returnid, $params );
}

/**
 * Prepare Product Tab
 */
$product = array();
$product['startform'] = $this->CreateFormStart( $id, 'product_edit', $returnid);
$product['submit'] = $this->CreateInputSubmit ($id, 'submit', $this->Lang('update'));
$product['cancel'] = $this->CreateInputSubmit ($id, 'cancel', $this->Lang('cancel'));
$product['endform'] = $this->CreateFormEnd();

$product['current_category_id'] = array(
	'label'=>'',
	'input'=>$this->CreateInputHidden( $id, 'current_category_id', $params['current_category_id'])
);
$product['product_id'] = array(
	'label'=>'',
	'input'=>$this->CreateInputHidden( $id, 'product_id', $params['product_id'])
);

$product['name'] = array(
	'label'=>$this->Lang('label_product_name'),
	'input'=>$this->CreateInputText( $id, 'name', $product_data['name'], 40, 40)
);
$product['description'] = array(
	'label'=>$this->Lang('label_product_description'),
	'input'=>$this->CreateTextArea(true, $id, $product_data['description'], 'pdescription','pagesmalltextarea','','','',40,40)
);
$product['price'] = array(
	'label'=>$this->Lang('label_product_price'),
	'input'=>$this->CreateInputText( $id, 'price', number_format($product_data['price'], 2, ".", ","), 40, 40)
);
$product['active'] = array(
	'label'=>$this->Lang('label_product_active'),
	'input'=>$this->CreateInputCheckbox( $id, 'active', 1, $product_data['active'])
);
$product['featured'] = array(
	'label'=>$this->Lang('label_product_featured'),
	'input'=>$this->CreateInputCheckbox( $id, 'featured', 1, $product_data['featured'])
);
$product['netweight'] = array(
	'label'=>$this->Lang('label_product_netweight'),
	'input'=>$this->CreateInputText( $id, 'netweight', number_format($product_data['netweight'], 3, ".", ","),10, 20),
	'unit'=>$this->GetPreference('weightunitmeasure', 'Kg')
);
// Prepare list of possible VAT codes as set up in Cart Made Simple
$cartms =& $this->GetModuleInstance('CartMadeSimple');
if( $cartms ) { 
	$vatcode = '';
	$listvatcode[$cartms->GetPreference('vat0name', '')] = '0';
	$listvatcode[$cartms->GetPreference('vat1name', '')] = '1';
	$listvatcode[$cartms->GetPreference('vat2name', '')] = '2';
	$listvatcode[$cartms->GetPreference('vat3name', '')] = '3';
	$listvatcode[$cartms->GetPreference('vat4name', '')] = '4';
	$product['vatcode'] = array(
		'label'=>$this->Lang('label_product_vatcode'),
		'input'=>$this->CreateInputDropdown( $id, 'vatcode', $listvatcode, $product_data['vatcode'], $vatcode)
	);
}
else {
	$product['vatcode'] = array(
		'label'=>$this->Lang('label_product_vatcode'),
		'input'=>$this->CreateInputText( $id, 'vatcode', '', 1, 1)
	);
}

$skudropdown = $this->products->BuildListSKU();
$product['sku'] = array(
	'label'=>$this->Lang('label_product_sku'),
	'input'=>$this->CreateInputDropdown( $id, 'sku', $skudropdown, -1, $product_data['sku'])
);

$product['itemnumber'] = array(
	'label'=>$this->Lang('label_product_itemnumber'),
	'input'=>$this->CreateInputText( $id, 'itemnumber', $product_data['itemnumber'], 30, 30)
);

$product['position'] = array(
	'label'=>$this->Lang('label_product_position'),
	'input'=>$this->CreateInputText( $id, 'position', $product_data['position'], 10, 10)
);
/**
 * Prepare Categories Tab
 */
$categories['startform'] = $this->CreateFormStart( $id, 'product_edit', $returnid, 'post', 'multipart/form-data');
$categories['submit'] = $this->CreateInputSubmit ($id, 'submit', $this->Lang('done'));
$categories['cancel'] = $this->CreateInputSubmit ($id, 'cancel', $this->Lang('cancel'));
$categories['endform'] = $this->CreateFormEnd();

$categories['current_category_id'] = array(
	'label'=>'',
	'input'=>$this->CreateInputHidden( $id, 'current_category_id', $params['current_category_id'])
);
$categories['product_id'] = array(
	'label'=>'',
	'input'=>$this->CreateInputHidden( $id, 'product_id', $params['product_id'])
);

$category_list = array();
foreach ($product_data['categories'] as $category) {
	if ($category['name'] == '') {
		$category['name'] = $this->Lang('root');
	} else {
		$category['name'] = $category['name'];
	}
	$category['link_delete'] = $this->CreateLink($id, 'product_edit', $returnid, 
		$gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('text_delete'), '', '', 'systemicon'), 
		array ('category_id' => $category['category_id'], 'product_id'=>$product_data['product_id'], 'current_category_id'=>$params['current_category_id'], 'submit'=>$this->Lang('deletecategory')), 
		$this->Lang ('message_areyousureprodcat', $product_data['name'], $category['name']));
	$category_list[] = $category;
}
$categories['list'] = $category_list;

$categories['categories'] = array(
	'label'=>$this->Lang('addcategory'),
	'submit'=>$this->CreateInputSubmit ($id, 'submit', $this->Lang('addcategory')),
	'list'=>$this->CreateInputDropdown( $id, 'category_id', $this->categories->BuildTotalList(), -1, '')
);
/**
 * Prepare Attributes Tab
 */
$attributes['startform'] = $this->CreateFormStart( $id, 'product_edit', $returnid, 'post', 'multipart/form-data');
$attributes['submit'] = $this->CreateInputSubmit ($id, 'submit', $this->Lang('addattribute'));
$attributes['cancel'] = $this->CreateInputSubmit ($id, 'cancel', $this->Lang('cancel'));
$attributes['endform'] = $this->CreateFormEnd();

// Messages come from deletion (or other places). So show it.
if (isset($params['message'])) {
	$attributes['message'] = $params['message'];
}
// Prepare name of product so that can be shown above images. Is easy for user to see for which product one is busy
$attributes['prodname'] = array(
	'label'=>$this->Lang('label_attributes_product_name'),
	'output'=>$product_data['name']
);
$attributes['name'] = array(
	'label'=>$this->Lang('column_attribute_name'),
	'input'=>$this->CreateInputText( $id, 'name', $product['attributes']['name'], 40, 40)
);
$attributes['description'] = array(
	'label'=>$this->Lang('label_attribute_description'),
	'input'=>$this->CreateTextArea(true, $id, '', 'adescription','pagesmalltextarea','','','',40,40)
);
$attributes['current_category_id'] = array(
	'label'=>'',
	'input'=>$this->CreateInputHidden( $id, 'current_category_id', $params['current_category_id'])
);
$attributes['product_id'] = array(
	'label'=>'',
	'input'=>$this->CreateInputHidden( $id, 'product_id', $params['product_id'])
);
// Build list of available attributes
$attributes['namecolumn'] = $this->Lang('column_attribute_name');
$attributes['descriptioncolumn'] = $this->Lang('column_attribute_description');
$attributes['no_attributes_available'] = $this->Lang('no_attributes_available');
$desclength = 80;
$product_attribute_list = array();
// Check if there are any attributes for the current product. If not checked, the foreach runs into an error
$attributes['itemcount'] = count($product_data['attributes']);
if ($attributes['itemcount'] > 0) {
foreach ($product_data['attributes'] as $attribute) {
	$attribute['name'] = $attribute['name'];
	if (strlen($attribute['description']) > $desclength) {
		$attribute['description'] = substr($attribute['description'], 0, $desclength).'...';
	}
	else {
		$attribute['description'] = $attribute['description'];
	}
	$attribute['link_edit'] = $this->CreateLink ($id, 'product_attribute_edit', $returnid, 
			$gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('text_edit'), '', '', 'systemicon'), 
			array ('current_attribute_id' => $params['current_attribute_id'],
				'current_category_id' => $params['current_category_id'],
				'prodname' => $product_data['name'],
				'attribute_id' => $attribute['attribute_id']));
	$attribute['link_delete'] = $this->CreateLink($id, 'product_attribute_delete', $returnid, 
			$gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('text_delete'), '', '', 'systemicon'), 
			array ('attribute_id' => $attribute['attribute_id'],
				'product_id' => $attribute['product_id'],
				'current_category_id' => $params['current_category_id'],
				'name' => $attribute['name']), 
				$this->Lang ('message_areyousureattribute',$attribute['name']));
	$product_attributes_list[] = $attribute;
}
$attributes['list'] = $product_attributes_list;
}
/**
 * Prepare Images Tab
 */
$images['startform'] = $this->CreateFormStart( $id, 'product_images', $returnid, 'post', 'multipart/form-data');
$images['submit'] = $this->CreateInputSubmit ($id, 'submit', $this->Lang('addimage'));
$images['cancel'] = $this->CreateInputSubmit ($id, 'cancel', $this->Lang('cancel'));
$images['endform'] = $this->CreateFormEnd();

// Messages come from deletion (or other places). So show it.
$images['message'] = $params['message'];
// Prepare name of product so that can be shown above images. Is easy for user to see for which product one is busy
$images['name'] = array(
	'label'=>$this->Lang('label_image_product_name'),
	'output'=>$product_data['name']
);
$images['image'] = array(
	'label'=>$this->Lang('column_image_name'),
	'input'=>$this->CreateInputFile( $id, 'image', '', 40)
);
$images['description'] = array(
	'label'=>$this->Lang('label_image_description'),
	'input'=>$this->CreateTextArea(true, $id, '', 'idescription','pagesmalltextarea','','','',40,40)
);
$images['current_category_id'] = array(
	'label'=>'',
	'input'=>$this->CreateInputHidden( $id, 'current_category_id', $params['current_category_id'])
);
$images['product_id'] = array(
	'label'=>'',
	'input'=>$this->CreateInputHidden( $id, 'product_id', $params['product_id'])
);
// Build list of available images
$images['namecolumn'] = $this->Lang('column_image_name');
$images['descriptioncolumn'] = $this->Lang('column_image_description');
$images['no_images_available'] = $this->Lang('no_images_available');

$product_image_list = array();
// Check if there are any images for the current product. If not checked, the foreach runs into an error
$images['itemcount'] = count($product_data['images']);
if ($images['itemcount'] > 0) {
foreach ($product_data['images'] as $image) {
	$image['productimage'] = $config['image_uploads_url'].'/'.$this->GetPreference('imagepath_product').$image['image'];
	$image['imageheight'] = '70'; // <-- Should be moved into a preference
	$image['image'] = $image['image'];
	$image['description'] = $image['description'];
	$image['link_edit'] = $this->CreateLink ($id, 'product_image_edit', $returnid, 
			$gCms->variables['admintheme']->DisplayImage ('icons/system/edit.gif', $this->Lang('text_edit'), '', '', 'systemicon'), 
			array ('current_product_images_id' => $params['current_product_images_id'],
				'current_category_id' => $params['current_category_id'],
				'product_images_id' => $image['product_images_id']));
	$image['link_delete'] = $this->CreateLink($id, 'product_image_delete', $returnid, 
			$gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('text_delete'), '', '', 'systemicon'), 
			array ('product_images_id' => $image['product_images_id'],
				'product_id' => $image['product_id'],
				'current_category_id' => $params['current_category_id'],
				'image' => $image['image']), 
				$this->Lang ('message_areyousureimage',$image['image']));
	$product_images_list[] = $image;
}
$images['list'] = $product_images_list;
}

/**
 * Show pages
 */
echo $this->StartTabHeaders();
echo $this->SetTabHeader('product', $this->Lang('label_tab_product'), ($active_tab == 'product'));
echo $this->SetTabHeader('categories', $this->Lang('label_tab_product_categories'), ($active_tab == 'categories'));
echo $this->SetTabHeader('attributes', $this->Lang('label_tab_attributes'), ($active_tab == 'attributes'));
echo $this->SetTabHeader('images', $this->Lang('label_tab_images'), ($active_tab == 'images'));
echo $this->EndTabHeaders();

echo $this->StartTabContent();
echo "\n<!-- From product -->\n";
echo $this->StartTab('product', $params);
$smarty->assign('product', $product);
echo $this->ProcessTemplate('product_edit.tpl');
echo $this->EndTab();

echo "\n<!-- From categories -->\n";
echo $this->StartTab('categories', $params);
$smarty->assign('categories', $categories);
echo $this->ProcessTemplate('product_categories.tpl');
echo $this->EndTab();

echo "\n<!-- From attributes -->\n";
echo $this->StartTab('attributes', $params);
$smarty->assign('attributes', $attributes);
echo $this->ProcessTemplate('product_attributes.tpl');
echo $this->EndTab();

echo "\n<!-- From images -->\n";
echo $this->StartTab('images', $params);
$smarty->assign('images', $images);
echo $this->ProcessTemplate('product_images.tpl');
echo $this->EndTab();

echo $this->EndTabContent();

?>