<?php

if (!isset($gCms)) exit;

$detailpage = '';
if (isset($params['detailpage']))
{
	$manager =& $gCms->GetHierarchyManager();
	$node =& $manager->sureGetNodeByAlias($params['detailpage']);
	if (isset($node))
	{
		$content =& $node->GetContent();
		if (isset($content))
		{
			$detailpage = $content->Id();
		}
	}
	else
	{
		$node =& $manager->sureGetNodeById($params['detailpage']);
		if (isset($node))
		{
			$detailpage = $params['detailpage'];
		}
	}
}

$pathproduct = $this->GetPreference('imagepath_product');
// Prepare settings for usage of cart
$cartMSInstalled = false;
$modulename = 'CartMadeSimple';

$cmsmodules = $gCms->modules;
if (isset($cmsmodules[$modulename]))
{
	if (isset($cmsmodules[$modulename]['object'])
		&& $cmsmodules[$modulename]['installed'] == true
		&& $cmsmodules[$modulename]['active'] == true ) {
		$cartMSInstalled = true;
	}
}

// Display information of the product
$sql = 'SELECT * FROM '.cms_db_prefix().'module_sms_products WHERE featured = 1 ORDER BY position';
$dbresult = $db->Execute( $sql );

$row = array();
$rowclass = 'row1';
$entryarray = array();

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();
	$onerow->prodid = $row['product_id'];
	$onerow->prodname = $this->CreateLink($id, 'fe_product_detail', $returnid, $row['name'], array('product_id'=>$row['product_id']));
	$onerow->proddesc = $row['description'];

	// Prepare price, if no price state 'Sold out'
	if ($row['price'] != 0) {
		$onerow->price = $row['price'];
	}
	else {
		$onerow->price = $this->Lang('productsoldout');
	}
	// Build link to cart
	if ($cartMSInstalled) {
		$onerow->addproduct = $cmsmodules[$modulename]['object']->CreateLink( $id, 'cart', $returnid, $this->Lang('addtocart'), 
			array ('name'=>$row['name'],
				'perfaction' => 'add_product',
				'product_id' => $row['product_id'],
				'qty' => 1,
				'returnmod' => 'ShopMadeSimple'
			));
	}

	// Get the first picture available for the product found
	$query = "SELECT * FROM ".cms_db_prefix()."module_sms_product_images WHERE product_id = ?";
	$picture = $db->GetRow($query, array($row['product_id']));
	if ($picture)
	{
		if (isset($picture['image']) && $picture['image'] != 'no_image.jpg') {
			$onerow->prodimage = $pathproduct.$picture['image'];
			#$onerow->prodimage = $pathproduct.$picture['image'].'" alt="'.$picture['description'].'"';
		}
		else {
			$this->smarty->assign('prodimage', '*none');
		}

	}

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}

$this->smarty->assign_by_ref('products', $entryarray);
$this->smarty->assign('lable_product_count', $this->Lang('textproductcount', count($entryarray)));

// State the currency symbol and that prices are in/ex VAT/TAX
$inexvat = $this->GetPreference('pricesinclvat');
if ( $inexvat != '' ) {
	$this->smarty->assign('currency', $this->Lang('pricesincurinvat',$this->GetPreference('default_currency')));
}
else {
	$this->smarty->assign('currency', $this->Lang('pricesincurexvat',$this->GetPreference('default_currency')));
}
$this->smarty->assign('cur_symbol', $this->GetPreference('default_symbol'));

// Display template
$template = 'prodfeat_template';
// Currently only one template available, so next lines will not perform anything
if (isset($params['prodfeattemplate'])) {
	$template = $params['prodfeattemplate'];
}
echo $this->ProcessTemplateFromDatabase($template);
?>