<?php

if (!isset($gCms)) exit;

$detailpage = '';
if (isset($params['detailpage']))
{
	$manager =& $gCms->GetHierarchyManager();
	$node =& $manager->sureGetNodeByAlias($params['detailpage']);
	if (isset($node))
	{
		$content =& $node->GetContent();
		if (isset($content))
		{
			$detailpage = $content->Id();
		}
	}
	else
	{
		$node =& $manager->sureGetNodeById($params['detailpage']);
		if (isset($node))
		{
			$detailpage = $params['detailpage'];
		}
	}
}

$config = $gCms->GetConfig();
$pathcat = $this->GetPreference('imagepath_category');
$pathproduct = $this->GetPreference('imagepath_product');
// Prepare settings for usage of cart
$cartMSInstalled = false;
$modulename = 'CartMadeSimple';

$cmsmodules = $gCms->modules;
if (isset($cmsmodules[$modulename]))
{
	if (isset($cmsmodules[$modulename]['object'])
		&& $cmsmodules[$modulename]['installed'] == true
		&& $cmsmodules[$modulename]['active'] == true ) {
		$cartMSInstalled = true;
	}
}

// Save the product id for correct usage throughout all queries
$product_id = '';
if (isset($params['product_id'])) {
	$product_id = $params['product_id'];
}

// Display information of the product
$query = "SELECT * FROM ".cms_db_prefix()."module_sms_products WHERE product_id = ?";
$row = $db->GetRow($query, array($product_id));

if ($row)
{
	$this->smarty->assign('id', $product_id);
	$this->smarty->assign('productname', $row['name']);
	$this->smarty->assign('description', $row['description']);
	$this->smarty->assign('price', $row['price']);
	$this->smarty->assign('sku', $row['sku']);
	$this->smarty->assign('itemnumber', $row['itemnumber']);
	// Get the first picture available for the product found
	$query = "SELECT * FROM ".cms_db_prefix()."module_sms_product_images WHERE product_id = ?";
	$picture = $db->GetRow($query, array($product_id));
	if ($picture)
	{
		if (isset($picture['image']) && $picture['image'] != 'no_image.jpg') {
			$this->smarty->assign('prodimage', $pathproduct.$picture['image']);
			$this->smarty->assign('imagedesc', $row['description']);
		}
		else {
			$this->smarty->assign('prodimage', '*none');
		}
	}
	// When the {image} tag of smarty is not in use, the complete path must be passed
	$this->smarty->assign('pimage', $config['root_url'].'/uploads/images'.$pathproduct.$picture['image']);
	// Build array that holds the images connected to the product
	$dbresult = $db->Execute($query, array($product_id));
	$entryarray = array();
	while ($dbresult && $row = $dbresult->FetchRow())
	{
		$onerow = new stdClass();
		if (isset($picture['image']) && $picture['image'] != 'no_image.jpg') {
			$onerow->image = $pathproduct.$row['image'];
			$onerow->imagethumb = $pathproduct.'tn_'.$row['image'];
			$onerow->imagedesc = $row['description'];
			$onerow->fullpathimage = $config['root_url'].'/uploads/images'.$pathproduct.$row['image'];
		}

		$entryarray[] = $onerow;
	}
	$this->smarty->assign_by_ref('items', $entryarray);
	$this->smarty->assign('itemcount', count($entryarray));
	// Build link to cart
	if ($cartMSInstalled) {
		$this->smarty->assign('addproduct', $cmsmodules[$modulename]['object']->CreateLink( $id, 'cart', $returnid, $this->Lang('addtocart'), 
			array ('name'=>$row['name'],
				'perfaction' => 'add_product',
				'product_id' => $product_id,
				'qty' => 1,
				'returnmod' => 'ShopMadeSimple'
			)));
	}
	
	$product_data = $this->products->Get($product_id);
	$attribute = array();
	$attributes = array();
	// Check if there are any attributes for the current product. If not checked, the foreach runs into an error
	$attributes['itemcount'] = count($product_data['attributes']);
	if ($attributes['itemcount'] > 0) {
		foreach ($product_data['attributes'] as $attribute) {
			$attribute['name'] = $attribute['name'];
			$attribute['description'] = $attribute['description'];
			$product_attributes_list[] = $attribute;
		}
		$attributes['list'] = $product_attributes_list;
		// Now all the attributes are found, connect them for the front end
		$this->smarty->assign_by_ref('attributes', $attributes);

	}
}

$cur_symbol = $this->GetPreference('default_symbol');
$this->smarty->assign('cur_symbol', $this->GetPreference('default_symbol'));

// Display template
$template = 'proddetail_template';
// Currently only one template available, so next lines will not perform anything
if (isset($params['proddetailtemplate'])) {
	$template = $params['proddetailtemplate'];
}
echo $this->ProcessTemplateFromDatabase($template);
?>