<?php

include_once(dirname(__FILE__).'/library/categories.api.php');
include_once(dirname(__FILE__).'/library/products.api.php');
#include_once(dirname(__FILE__).'/library/translations.api.php');

class ShopMadeSimple extends CMSModule {
	
	var $categories;
	var $products;
#	var $translations;
	
	function ShopMadeSimple() {
    	parent::CMSModule();
    	$this->categories = new Categories($this);
    	$this->products = new Products($this);
#   	$this->translations = new Translations($this);
	}
	function GetName() {
		return 'ShopMadeSimple';
	}
	function GetFriendlyName() {
		return $this->Lang('friendlyname');
	}
	function GetVersion() {
		return '0.2.5';
	}
	function GetAuthor() {
		return 'Duketown and Gary Greyling<br>';
	}
	function GetAuthorEmail() {
		return 'duketown@mantox.nl and gary.greyling@gmail.com';
	}
	function GetHelp() {
		return $this->Lang('help');
	}
	function GetChangeLog()	{
		return $this->Lang('changelog');
	}
	function IsPluginModule() {
		return true;
	}
	function HasAdmin()	{
		return true;
	}
	function GetAdminSection() {
		return 'extensions';
	}
	function GetAdminDescription() {
		return $this->Lang('admin_description');
	}
	function GetDependencies() {
	}	
	function MinimumCMSVersion() {
		return "1.0.0";
	}
	
	function SetParameters() {
		#$this->RegisterRoute('/[sS]hop[mM]ade[sS]imple\/(?P<returnid>[0-9]+)$/', array('action'=>'fe_category_list'));
		$this->RegisterRoute('/[sS]hop[mM]ade[sS]imple\/(?P<product_id>[0-9]+)\/(?P<returnid>[0-9]+)$/', array('action'=>'fe_product_detail'));
		$this->RegisterRoute('/[sS]hop[mM]ade[sS]imple\/(?P<category_id>[0-9]+)\/(?P<returnid>[0-9]+)$/', array('action'=>'fe_product_list'));
		# The top most parameter will be shown in the bottom and vice versa
		$this->CreateParameter('start', '', $this->Lang('helpstart'));
		$this->CreateParameter('pagenumber', '', $this->Lang('helppagenumber'));
		$this->CreateParameter('prodpagelimit', '', $this->Lang('helpprodpagelimit'));
		$this->CreateParameter('parentcategory', '', $this->Lang('helpparentcategory'));
		$this->CreateParameter('display', '', $this->Lang('helpdisplay'));
		$this->CreateParameter('catname', '', $this->Lang('helpcatname'));
	}

	function GetEventDescription ( $eventname ) {
		return $this->Lang('event_info_'.$eventname );
	}

	function GetEventHelp ( $eventname ) {
		return $this->Lang('event_help_'.$eventname );
	}

	function InstallPostMessage() {
		return $this->Lang('message_postinstall');
	}
	function UninstallPostMessage() {
		return $this->Lang('message_postuninstall');
	}
	function UninstallPreMessage() {
		return $this->Lang('message_confirmuninstall');
	}
	// Function that is used by the search module
	function SearchResultWithParams( $returnid, $product_id, $attr='', $parms)   {
		$result = array();
		if ($attr == 'product') {
			$db =& $this->GetDb();
			$q = "SELECT name FROM ".cms_db_prefix()."module_sms_products WHERE product_id = ?";
			$dbresult = $db->Execute( $q, array( $product_id ) );
			if ($dbresult) {
				$row = $dbresult->FetchRow(); 
				// 0 position is the prefix displayed in the list results.
				$result[0] = $this->GetFriendlyName();

				// 1 position is the title
				$result[1] = $row['name'];


				// Page to use for the news-article-details:
				if (isset($parms['detailpage'])) {    
					$pagealias = $parms['detailpage'];
				}  
				else $pagealias = 'home';  
				$pageinfo = PageInfoOperations::LoadPageInfoByContentAlias($pagealias);
				$content_id = $pageinfo->content_id;
				$prettyurl = 'ShopMadeSimple/'.$product_id."/".$content_id;

				// 2 position is the URL to the title. 
				$result[2] = $this->CreateLink('cntnt01', 'fe_product_detail', $returnid, '', 
				array('product_id' => $product_id), '', true, false, '', true, $prettyurl);
			}
		}
		return $result;
	}

	function SearchReindex() {
		$searchmodule =& $this->GetModuleInstance('Search');
		if ($searchmodule != FALSE)
		{
			$db =& $this->GetDb();

			$query = 'SELECT * FROM '.cms_db_prefix().'module_sms_products';
			$dbresult = &$db->Execute($query);

			while ($dbresult && $row = $dbresult->FetchRow() )
			{
				if ($row['active'] == 1)
				{
					$searchmodule->AddWords($this->GetName(), $row['product_id'], 'product', $row['name'] . ' ' . $row['description']);
				}
			}
		}
	}


	function BuildThumb ($image, $sourcedir, $thumbwidth = 0,  $thumbheight=0) {

		ini_set("memory_limit","30M");
		$imgsize = getimagesize($sourcedir.'/'.$image);
		if (!$imgsize) {
			return false;
		}

		if ($thumbwidth == 0 && $thumbheight == 0) {
			$targetsize[0] = $imgsize[0];	// Target Height
			$targetsize[1] = $imgsize[1];	// Target Width
		} elseif ($thumbwidth == 0 && $thumbheight != 0) 	{
			$targetsize[0] = round($thumbheight*($imgsize[0]/$imgsize[1])); 
			$targetsize[1] = $thumbheight; 
		} elseif ($thumbwidth != 0 && $thumbheight == 0) 	{
			$targetsize[0] = $thumbwidth; 
			$targetsize[1] = round($thumbwidth*($imgsize[0]/$imgsize[1])); 
		}
		else {
			if (round($thumbwidth*($imgsize[0]/$imgsize[1])) > $thumbheight)
				{
					$targetsize[0] = $thumbheight;
					$targetsize[1] = round($thumbheight*($imgsize[1]/$imgsize[0])); 
				} else {
					$targetsize[0] = round($thumbwidth*($imgsize[0]/$imgsize[1])); 
					$targetsize[1] = $thumbwidth;
				}
		}

		$properties = array ($targetsize[0], $targetsize[1], $imgsize[0], $imgsize[1]);

		switch(exif_imagetype($sourcedir.'/'.$image)) {
				case 1:
					$srcimg = imagecreatefromgif($sourcedir.'/'.$image);
					break;
				case 2:
					$srcimg = imagecreatefromjpeg($sourcedir.'/'.$image);
					break;
				case 3:
					$srcimg = imagecreatefrompng($sourcedir.'/'.$image);
					break;
				default:
					return false;
		}

		$destinationimg = imagecreatetruecolor($properties[0], $properties[1]);			

		if (
			imagecopyresampled($destinationimg, $srcimg, 0, 0, 0, 0, $properties[0], $properties[1], $properties[2], $properties[3])
			&&
			imagejpeg($destinationimg, $sourcedir.'/tn_'.$image)
		)
		{
			return true;
		} else {
			return false;
		}
	}
	
	function RebuildThumbnails($sourcedir, $type='products') {
		$images = array();
		// Set pattern 
		$pattern = "tn_*"; 
		// Change to named directory 
		chdir($sourcedir); 
		// Find files matching pattern 
		$images = glob($pattern); 
		// Iterate over files array and delete existing thumbnails
		foreach ($images as $f) { 
			unlink($f);
		} 
		
		// Prepare an array with the available images
		$pattern = "*"; 
		$images = glob($pattern); 
		$thumbwidth = $this->GetPreference('tnwidth_product', '100');
		$thumbheight = $this->GetPreference('tnheight_product', '100');
		// Use next image found in list of available images and prepare thumbnail
		foreach ($images as $f) { 
			$this->BuildThumb ($f, $sourcedir, $thumbwidth, $thumbheight);
		}

		return;
	}
}

?>