<?php
if (!isset($gCms)) exit;

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for DocumentsLibrary "manageTemplate" admin action
   
   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/
if (isset($params['modulename']) && $params['modulename'] != '')
{
	$module = MX_XtendedModule::retrieveByPk($params['modulename']);
	
	if (!$module)
	{
		$module = new MX_XtendedModule();
	}
	
	if (isset($params['submitbutton']))
	{		
		if (isset($params['option_documents']))
		{
			$module->setOption('documents');
		}
		else 
		{
			$module->unsetOption('documents');
		}
		
		if (isset($params['option_images']))
		{
      $module->setOption('images');			
		}
		else 
		{			
      $module->unsetOption('images');
		}
		
		if (isset($params['option_links']))
		{
      $module->setOption('links');			
		}
		else 
		{			
      $module->unsetOption('links');
		}
		
		if (isset($params['option_relations']))
		{
			$module->setOption('relations');			
		}
		else
		{
      $module->unsetOption('relations');			
		}		
		
		$module->save();
		
		$this->Redirect($id, 'defaultadmin', $returnid, array('active_tab' => 'xtendedmodules'));
		// Submit and redirect
	}
	
	if (isset($params['cancelbutton']))
	{
		$this->Redirect($id, 'defaultadmin', $returnid, array('active_tab' => 'xtendedmodules'));
	}
	
	
	
	// Form part
	
	$this->smarty->assign('form_start', $this->CreateFormStart($id, 'manageXtended', $returnid));
	$this->smarty->assign('form_end',$this->CreateFormEnd());
	
	$this->smarty->assign('modulename_title', $module->getModuleFriendlyName());
	$this->smarty->assign('modulename',$this->CreateInputHidden($id, 'modulename', $params['modulename']));
	
	// Options
	
	$options = array('documents', 'images', 'links', 'relations');
	
	$this->smarty->assign('option_documents_title', $this->Lang('option_documents_title'));
	$this->smarty->assign('option_documents',$this->CreateInputCheckbox($id, 'option_documents', 'documents' , $module->optionExists('documents')?'documents':''));
	
	
	$this->smarty->assign('option_images_title', $this->Lang('option_images_title'));
	$this->smarty->assign('option_images',$this->CreateInputCheckbox($id, 'option_images', 'images', $module->optionExists('images')?'images':''));

	
	$this->smarty->assign('option_links_title', $this->Lang('option_links_title'));
	$this->smarty->assign('option_links',$this->CreateInputCheckbox($id, 'option_links', 'links', $module->optionExists('links')?'links':''));

	
	$this->smarty->assign('option_relations_title', $this->Lang('option_relations_title'));
	$this->smarty->assign('option_relations',$this->CreateInputCheckbox($id, 'option_relations', 'relations', $module->optionExists('relations')?'relations':''));

	
	$this->smarty->assign('form_submit', $this->CreateInputSubmit($id, 'submitbutton', $this->Lang('submit')));	
	$this->smarty->assign('form_cancel', $this->CreateInputSubmit($id, 'cancelbutton', $this->Lang('cancel')));	
		
	echo $this->ProcessTemplate('admin.manageXtended.tpl');

}

?>