<?php
if (!isset($gCms)) exit;

if (! $this->CheckAccess())
{
  return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
}

  /*
   * 
   * Edit Relation Title
   * 
   * This is to allow titles to be tweaked
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2009
   * 
   */

$relation = MX_Relation::retrieveByPk($params['relation_id']); 

if (isset($params['cancel']))
{
  $this->Redirect($id, 'manageRelations', $returnid, array('modulename' => $relation->getModuleName()));
}

  
if (isset($params['submit']))
{
  $relation->setTitle($params['title']);
  $relation->save(); 
  $this->Redirect($id, 'manageRelations', $returnid, array( 'modulename' => $relation->getModuleName()));
}

  if (isset($params['mx_action']))
  {
    switch ($params['mx_action'])
    {
      case 'delete':
        $relation->delete();
        echo 'Relation deleted';
        break;
      case 'move_up':
        $relation->moveUp();
        echo 'Relation moved up';
        break;
      case 'move_down':
        echo 'Relation moved down';
        $relation->moveDown();
        break;
      case 'show':
        echo 'Relation show';
        $relation->setIsVisible(true);
        $relation->save();
        break;      
      case 'hide':
        echo 'Relation hide';
        $relation->setIsVisible(false);
        $relation->save();
        break;
      case 'is_filter':
        echo 'Change "is filter" status';
        $relation->setIsFilter(($relation->getIsFilter())?false:true);
        $relation->save();
        break;
      case 'have_column':
        echo 'Change "have_column" status';
        $relation->setHaveColumn(!$relation->getHaveColumn());
        $relation->save();
        break;
     case 'rotateSubtype':
        echo 'Relation rotate subtype';
        $relation->rotateRelationSubtype();
        $relation->save();
        break;
    }
    
      $this->Redirect($id, 'manageRelations', $returnid, array( 'modulename' => $relation->getModuleName()));
  }  

$this->smarty->assign('relation_id', $this->CreateInputHidden($id, 'relation_id', $relation->getId()));
$this->smarty->assign('title', $this->lang('edit_relation_title_for') . $relation->getTitle(true) );
$this->smarty->assign('edit_title', $this->lang('relation_title'));
$this->smarty->assign('edit_title_input', $this->CreateInputText($id, 'title', $relation->getTitle(), 50));

$this->smarty->assign('form_start',$this->CreateFormStart($id, 'manageRelation', $returnid));
$this->smarty->assign('form_submit',$this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));         
  $this->smarty->assign('form_cancel', $this->CreateInputSubmit($id, 'cancel', $this->lang('cancel')));
$this->smarty->assign('form_end',$this->CreateFormEnd());

echo $this->ProcessTemplate('adminEditRelationTitle.tpl');
