<?php

/*

Relation Module class

This class is made to provide a "pages" relation system to the module.

Copyrights: Jean-Christophe Cuvelier - Morris & Chapman Belgium

DOC: See end of this file

VERSION: 0.0.1

REQUIRE: CategoryManager

*/

class XT_Categories extends CmsObject {


    var $module;
    var $deleteicon = '/modules/ModuleXtender/images/icons/delete.gif';
    var $editicon = '/modules/ModuleXtender/images/icons/edit.gif';
    var $config = array();

    function XT_Categories (&$module)
    {
        $this->module = $module;
        $this->config = $this->module->GetConfig();
        $this->deleteicon = $this->config['root_url'].'/modules/ModuleXtender/images/icons/delete.gif';
        $this->editicon = $this->config['root_url'].'/modules/ModuleXtender/images/icons/edit.gif';
    }

    /******************************************************************************************************************************

    CATEGORY MANAGER FUNCTION

    ******************************************************************************************************************************/

    /* MC SPECIFICS */

    /**
	 * This function return the list of the categories
	 *
	 * @return array Array of categories (id => title) 
	 */

    function getCategories()
    {
        $db =& $this->module->GetDb();

        // We define an empty array

        $returnarray = array();

        // We make the request

        $query = "SELECT * FROM ".cms_db_prefix()."module_modulextender_categories";

        $dbresult = $db->Execute($query);

        // We populate the array

        while ($dbresult && $row = $dbresult->FetchRow())
        {
            $returnarray[$row['id']] = $row['title'];
        }

        return $returnarray;
    }

    /**
	 * This function return the same list that getCategories but reverse the key model
	 *
	 * @return array Array of categories (title => id)
	 */

    function getReverseCategories()
    {
        $tmp = $this->getCategories();

        $result = array();

        foreach ($tmp as $id => $value)
        {
            $result[$value] = $id;
        }

        return $result;
    }

    /**
	 * This function retunr the list of options related to the category ID. Sorted by option position.
	 *
	 * @param int $category_id The id of related category.
	 * @return array Array of options related to the $category_id
	 */

    function getOptions($category_id)
    {
        $db =& $this->module->GetDb();

        // We define an empty array

        $returnarray = array();

        // We make the request

        $query = "SELECT * FROM ".cms_db_prefix()."module_modulextender_options WHERE category_id = ? ORDER BY position ASC";

        $dbresult = $db->Execute($query, array($category_id));

        // We populate the array

        while ($dbresult && $row = $dbresult->FetchRow())
        {
            $returnarray[$row['id']] = $row['title'];
        }

        return $returnarray;
    }

    /**
	 * This function return the same list that getOptions but reverse the key model
	 *
	 * @param int $category_id The id of related category.
	 * @return array Array of options related to the $category_id (title => id)
	 */

    function getReverseOptions($category_id)
    {
        $tmp = $this->getOptions($category_id);

        $result = array();

        foreach ($tmp as $id => $value)
        {
            $result[$value] = $id;
        }

        return $result;
    }

    /**
	 * This function shows category name
	 *
	 * @param int $category_id
	 * @return Category title
	 */

    function getCategoryName ($category_id)
    {
        $db =& $this->module->GetDb();

        $return_title = '';

        // We make the request

        $query = "SELECT * FROM ".cms_db_prefix()."module_modulextender_categories WHERE id = ?";

        $dbresult = $db->Execute($query, array($category_id));

        // We populate the array

        while ($dbresult && $row = $dbresult->FetchRow())
        {
            $return_title = $row['title'];
        }

        return $return_title;
    }


    /**
	 * This function shows option name
	 *
	 * @param int $option_id
	 * @return Option name
	 */

    function getOptionName ($option_id)
    {
        $db =& $this->module->GetDb();

        $return_title = '';

        // We make the request

        $query = "SELECT * FROM ".cms_db_prefix()."module_modulextender_options WHERE id = ?";

        $dbresult = $db->Execute($query, array($option_id));

        // We populate the array

        while ($dbresult && $row = $dbresult->FetchRow())
        {
            $return_title = $row['title'];
        }

        return $return_title;
    }

    /**
	 * Return a multiple array with all the options
	 *
	 * @param array $categories_id
	 * @return array
	 */


    function getMultiOptions ($categories_id)
    {
        $return_array = array();

        if (is_array($categories_id))
        {
            foreach ($categories_id as $category_id)
            {
                $return_array[$category_id] = $this->getOptions($category_id);
            }
        }

        return $return_array;
    }

    function GetPagesList($modulename, $moduleid)
	{
		$pages = new XT_Pages($this->module);
		
		return $pages->GetPagesList($modulename, $moduleid);
	}
	
	function GetCategoriesList($modulename, $moduleid)
	{
		$list = array();
		
		$db =& $this->GetDb();
		
		// We make the request	

		$query = "

	    SELECT
	       
	         ".cms_db_prefix()."module_modulextender_relations_link .*
	       
	       , ".cms_db_prefix()."module_modulextender_categories.title AS category_name
	       
	       ,".cms_db_prefix()."module_modulextender_options.title AS option_name
	       

	    FROM 
	    
	       ".cms_db_prefix()."module_modulextender_relations_link 
	       
	    LEFT JOIN
	       
	       ".cms_db_prefix()."module_modulextender_options
	    ON
	       ".cms_db_prefix()."module_modulextender_options.id = ".cms_db_prefix()."module_modulextender_relations_link.rel_id
	    
	    LEFT JOIN
	    
	       ".cms_db_prefix()."module_modulextender_categories
	       
	    ON
	    
	       ".cms_db_prefix()."module_modulextender_categories.id = ".cms_db_prefix()."module_modulextender_options.category_id
	       
	    WHERE 
	       
               ".cms_db_prefix()."module_modulextender_relations_link .modulename = ? 
           
           AND ".cms_db_prefix()."module_modulextender_relations_link .rel_code = 'options'
           
           AND ".cms_db_prefix()."module_modulextender_relations_link .module_id = ?
        ";

		$dbresult = $db->Execute($query, array($modulename, $moduleid));

		$rowclass = 'row1';
		
		$list = array();
		
		// We populate the array
	
		while ($dbresult && $row = $dbresult->FetchRow())
		{				
			$item = new stdClass();
			
			$item->title = $row['option_name'];
			
			if (isset($row['url']))
			{
				$item->page_url = $row['url'];
			}
			else 
			{
				$item->page_url = null;
			}
			
			$item->rowclass = $rowclass;
			
			($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
	
			$list[$row['category_name']][] = $item;			
		}

		return $list;
	}

	/* Deprecated *\*/
	
	function FECategories( $modulename, $type )
    {
        
        $categories = array();

        $db =& $this->module->GetDb();

        $query = "

	    SELECT
	       
	         ".cms_db_prefix()."module_modulextender_relations_link .*
	       
	       , ".cms_db_prefix()."module_modulextender_categories.title AS category_name
	       
	       ,".cms_db_prefix()."module_modulextender_options.title AS option_name
	       

	    FROM 
	    
	       ".cms_db_prefix()."module_modulextender_relations_link 
	       
	    LEFT JOIN
	       
	       ".cms_db_prefix()."module_modulextender_options
	    ON
	       ".cms_db_prefix()."module_modulextender_options.id = ".cms_db_prefix()."module_modulextender_relations_link.rel_id
	    
	    LEFT JOIN
	    
	       ".cms_db_prefix()."module_modulextender_categories
	       
	    ON
	    
	       ".cms_db_prefix()."module_modulextender_categories.id = ".cms_db_prefix()."module_modulextender_options.category_id
	       
	    WHERE 
	       
               ".cms_db_prefix()."module_modulextender_relations_link .modulename = ? 
           
           AND ".cms_db_prefix()."module_modulextender_relations_link .rel_code = ?
        ";

        $dbresult = $db->Execute($query, array($modulename, 'categories'));

        while ($dbresult && $row = $dbresult->FetchRow())
        {
            $categories['cat'][$row['module_id']][$row['category_name']][] = $row['option_name'];
        }

        return $categories;
        
    }
    
    function FELoadCategories($categories, $id)
    {
        if (is_array($categories))
        {
          return $categories['cat'][$id];
        }
        else
        {
          return null;
        }
    }
    
    function FEPages($modulename, $type)
    {
        
        $pages = array();

        $db =& $this->module->GetDb();

        $query = "

	    SELECT
	       
	         ".cms_db_prefix()."module_modulextender_relations_link .*
	       
	       ,".cms_db_prefix()."content.content_name AS page_title
	       

	    FROM 
	    
	       ".cms_db_prefix()."module_modulextender_relations_link 
	       
	    LEFT JOIN
	       
	       ".cms_db_prefix()."content
	       
	    ON
	       ".cms_db_prefix()."content.content_id = ".cms_db_prefix()."module_modulextender_relations_link.rel_id
	       
	    WHERE 
	       
               ".cms_db_prefix()."module_modulextender_relations_link .modulename = ? 
           
           AND ".cms_db_prefix()."module_modulextender_relations_link .rel_code = ?
        ";
       
        $dbresult = $db->Execute($query, array($modulename, 'pages') );

        while ($dbresult && $row = $dbresult->FetchRow())
        {
           
            $pages[$row['module_id']][] = array('title'=>$row['page_title'], 'id'=>$row['rel_id']);

        }
        
        return $pages;
        
    }

}

?>