<?php
  
  /*
   * Relation class
   * 
   * This class allow management of a relation object
   * 
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2009
   * 
   */

class MX_Option extends CmsObject 
{
  // Vars

	var $id;
  var $title;
  var $position;
  var $category_id;
   
  var $category;
  var $loaded;
	
	const DB_NAME  = 'module_modulextender_options';
	const ITEMS_NAME = 'options';
	const ITEM_NAME = 'option';
	
	public function __construct($id = null)
	{
		if ($id)
		{
			$this->id = $id;
			$this->load();
		}
	}
		
  public function __toString()
  {
    return $this->getTitle(false, true);
  } 
	
  public function getItemsName()
  {
    return self::ITEMS_NAME;
  }
  
  public function getItemName()
  {
    return self::ITEM_NAME;
  }
  
	public function setId($value)
	{
		$this->id = $value;
	}
	
	public function getId()
	{
		return $this->id;
	}
	
	public function getTitle()
	{
		return $this->title;
	}
	
	public function setTitle($title)
	{
		$this->title = $title; 
	}
	
	public function setCategoryId($value)
  {
    $this->category_id = $value;
  }
  
	
 public function getCategoryId()
  {
    return $this->category_id;
  }
  
  public function getCategory()
  {
    if (!$this->category)
    {
      $this->category = MX_Category::retrieveByPk($this->getCategoryId()); 
    }
    return $this->category;
  }
	
 public function getPosition()
  {
    if ($this->position != '')
    {
      return $this->position;
    }
    else
    {
      return self::retrieveNextPosition($this->getCategoryId());
    }
  }

  public static function retrieveNextPosition($category_id)
  {
    $last_document = self::doSelectOne(array('where' => array('category_id' => $category_id), 'order_by' => array('position desc')));
    
    if ($last_document)
    {
      return $last_document->getPosition()+1;
    }
    else
    {
      return 1;
    }
  }
  
  public function getNextItem()
  {
    $document =  self::doSelectOne(array('where' => array('category_id' => $this->getCategoryId(),  'position' => $this->position+1)));
    
    if ($document)
    {
      return $document;
    }
    else 
    {
      return false;
    }
   }
   
  public function getPreviousItem()
  {
    $document =  self::doSelectOne(array('where' => array('category_id' => $this->getCategoryId(),  'position' => $this->position-1)));
    
    if ($document)
    {
      return $document;
    }
    else 
    {
      return false;
    }
   }
  
   public function moveUp()
   {
    $this->switchPosition($this->getPreviousItem());
   }
   
   public function moveDown()
   {
    $this->switchPosition($this->getNextItem());
   }
   
   protected function switchPosition($item)
   {
      if($item)
      {
        $current_position = $this->getPosition();
        $this->setPosition($item->getPosition());
        $item->setPosition($current_position);
        $this->save();
        $item->save();
      }
   }
   
  public function setPosition($position)
  {
    $this->position = $position;
  }

  public static function resetPositions($category_id)
  {
    $documents = self::doSelect(array('where' => array('category_id' => $category_id), 'order_by' => array('position asc')));
    
    $position = 1;
    
    foreach ($documents as $document)
    {
      $document->setPosition($position);
      $position = $document->getPosition() + 1;
      $document->save();
    }
    
  }
  	
	public function load()
	{
		
    $db =& $this->GetDb();
    
		$query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME . ' WHERE id = ? LIMIT 1';
		
		$dbresult = $db->Execute($query, array($this->id));
		
	   if ($dbresult && $dbresult->RecordCount() > 0)
      {
      	$this->loaded = true;
        while ($dbresult && $row = $dbresult->FetchRow())
        {
          $this->PopulateFromDb($row);
        }
      }
	}
	
	public function PopulateFromDb($row)
	{
		  $this->id = $row['id'];
		  $this->title = $row['title'];
		  $this->position = $row['position'];
		  $this->category_id = $row['category_id'];
	}
	
  public function save()
  {
    // Upgrade or Insert ?
    if ($this->id != null)
    {
      $this->update();
    }
    else 
    {     
        $this->insert();
    }   
    
  }
  
  protected function update()
  {
    
    $db =& $this->GetDb();
    

      $query = 'UPDATE  ' . cms_db_prefix() .  self::DB_NAME . ' 
      
      SET ';
            
      $query .= ' title = ?,  category_id = ?,  position = ?';
      
      $query .= '
      
      WHERE
      
      id = ?  ';
      
      
      $result = $db->Execute($query,
          array(
             $this->title,
             $this->category_id,
             $this->getPosition(),

             $this->getId()
          )
        );        
        
        /*FIXME: Test the $db status; */
        
        return true;
  }
  
  protected function insert()
  {
    $db =& $this->GetDb();
    
    $this->setId($db->GenID(cms_db_prefix() .  self::DB_NAME .'_seq' ));
      
    $query = 'INSERT INTO ' . cms_db_prefix() .  self::DB_NAME .  ' 
      
      SET  id = ?,  ';

      $query .= ' title = ?,  category_id = ?,  position = ?';
      
      
       $db->Execute($query,
          array(
            $this->getId(), 
             $this->title,
             $this->category_id,
             $this->getPosition(),

          )
        );
        
        return true;    
  }  
  
  public function isLoaded()
  {
    return $this->loaded;
  }
  
  public static function retrieveByPk($id)
  {
    return self::doSelectOne(array('where' => array('id' => $id)));    
  }
  
  public static function doSelectOne($params = array())
  {
    $items = self::doSelect($params);
    if ($items)
    {
      return $items[0];
    }
    else 
    {
      return null;
    }   
  }
  
  public static function doSelect($params = array())
  {
    $instance = new self();    
    
    $db =& $instance->GetDb();
    
    $query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME;;
    
    $values = array();
    
    if (isset($params['where']))
    {

      $fields = array();
      foreach ($params['where'] as $field => $value) 
      {
        $fields[] = $field . ' =  ?';
        $values[] = $value;
      }
      
      $query .= ' WHERE ' . implode(' AND ', $fields);
    } 
    
    if(isset($params['order_by']))
    {
     $query .= ' ORDER BY ' . implode(', ' , $params['order_by']);
    }
    else
    {
      $query .= ' ORDER BY position';
    }
    
    $dbresult = $db->Execute($query, $values);
  
    $items = array();
   if ($dbresult && $dbresult->RecordCount() > 0)
    {
      while ($dbresult && $row = $dbresult->FetchRow())
      {
        $item = new self();
        $item->PopulateFromDb($row);        
        $items[] = $item;
      }
    }
    
    return  $items;   
  }
  
    public function delete()
    {   
    
    $db =& $this->GetDb();
    $query = 'DELETE FROM '. cms_db_prefix() . self::DB_NAME;
    $query .= ' WHERE id = ?';
    $db->Execute($query, array($this->id));   

    self::resetPositions($this->getCategoryId());
  }
  
  public static function resetAllPositions()
  {
  	$categories = MX_Category::doSelect();
  	
  	foreach ($categories as $category)
  	{
  		MX_Option::resetPositions($category->getId());
  	}
  }
  
}

?>