<?php
if (!isset($gCms)) exit;

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for DocumentsLibrary "manageTemplate" admin action
   
   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/

// ROCK AND LOAD


$maintemplates = array ('fe.general', 'fe.documents', 'fe.images','fe.pages', 'fe.categories');

if (isset($params['template']) && $params['template'] != '')
{
	$title = $params['template'];
	
	if (isset($params['submitbutton']) || isset($params['applybutton']))
	{
		$this->SetTemplate($params['template'], $params['templatedetails']);
		
		if (isset($params['assignto']) && in_array ($params['assignto'], $maintemplates))
		{
			$this->SetPreference($params['assignto'], $title);
		}
		
		if (isset($params['defaulttemplate']) && in_array ($params['defaulttemplate'], $maintemplates))
		{
			$this->SetTemplate($params['template'],$this->GetTemplateFromFile($params['defaulttemplate']));
		}
		
		if (isset($params['submitbutton']))
		{
			$this->Redirect($id, 'defaultadmin', $returnid, array('active_tab' => 'templates'));
		}
	}
}
else 
{
	$title = '';
}

// DETAILS
		
	
		
	
	

	$this->smarty->assign('form_start', $this->CreateFormStart($id, 'manageTemplate', $returnid));
	
	
	$this->smarty->assign('title_template', $this->Lang('titleTemplate'));
	$this->smarty->assign('input_template',$this->CreateInputText($id, 'template', $title, 50));
	
	if (isset($params['template']) && $params['template'] != '')
	{
		$templatecode = $this->GetTemplate($params['template']);
	}
	elseif (isset($params['templatedetails']))
	{
		$templatecode = $params['templatedetails'];
	}
	else 
	{
		$templatecode = '';
	}
	
	$templates_dropdown = array ($this->Lang('fe.select') => '');
	
	$selecttemplate = '';
	
	foreach ($maintemplates as $templatename)
	{
		$templates_dropdown[$this->Lang($templatename)] = $templatename;
		
		if ($this->GetPreference($templatename) == $title)
		{
			$selecttemplate = $templatename;
		}
	}
	
	/**/
	
	$this->smarty->assign('assign_to_title', $this->Lang('assigned_to'));
	$this->smarty->assign('assign_to_dropdown', $this->CreateInputDropdown($id, 'assignto', $templates_dropdown, -1,  $selecttemplate) );
		
	$this->smarty->assign('get_default_template', $this->Lang('get_default_template'));
	$this->smarty->assign('default_dropdown', $this->CreateInputDropdown($id, 'defaulttemplate', $templates_dropdown, -1) );
	
	$this->smarty->assign('code_template', $this->Lang('codeTemplate'));
	$this->smarty->assign('textarea_template', $this->CreateTextArea(true, $id, $templatecode, 'templatedetails', 'pagebigtextarea', '','', '', 90, 15, 'EditArea'));
	
	$this->smarty->assign('form_details_submit', $this->CreateInputSubmit($id, 'submitbutton', $this->Lang('submit')));
	$this->smarty->assign('form_details_apply', $this->CreateInputSubmit($id, 'applybutton', $this->Lang('apply')));

	/*
	$this->smarty->assign('form_details_restorelist', $this->CreateInputSubmit($id, 'restorelist', $this->Lang('restorelist')));
	$this->smarty->assign('form_details_restoredetails', $this->CreateInputSubmit($id, 'restoredetails', $this->Lang('restoredetails')));
	*/
	
	
	$this->smarty->assign('form_end',$this->CreateFormEnd());

	echo $this->ProcessTemplate('managetemplate.tpl');
	
?>