<?php
  
  /*
   * Relation class
   * 
   * This class allow management of a relation link object
   * 
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2009
   * 
   */

class MX_RelationLink extends CmsObject 
{
  // Vars

	var $id;
  var $left_module;
  var $left_module_id;
  var $right_module;
  var $right_module_id;
  
  var $loaded = false;
	
	const DB_NAME  = 'module_modulextender_relations_link';

	public function __construct($id = null)
	{
		if ($id)
		{
			$this->id = $id;
			$this->load();
		}
	}
		
	public function getId()
	{
		return $this->id;
	}
	
  public function setId($value)
  {
    $this->id = $value;
  }
  
	public function getLeftModule()
	{
		return $this->left_module;
	}
	
  public function setLeftModule($value)
  {
    $this->left_module = $value;
  }
  
	public function getLeftModuleId()
	{
		return $this->left_module_id;
	}
	
  public function setLeftModuleId($value)
  {
    $this->left_module_id = $value;
  }
  
	public function getRightModule()
	{
		return $this->right_module;
	}
	
  public function setRightModule($value)
  {
    $this->right_module = $value;
  }
  
	public function getRightModuleId()
	{
		return $this->right_module_id;
	}
	
  public function setRightModuleId($value)
  {
    $this->right_module_id = $value;
  }
  
  
  public function getRelation()
  {    
      switch($this->left_module)
      {
        case 'options':
          return MX_Option::retrieveByPk($this->left_module_id);
          break;
        case 'pages':
         return MX_Page::retrieveByPk($this->left_module_id);
        default: 
        	return null;
          break;
      }
  }
  // Specific
	
  public static function getRelatedLinks($module_name, $module_id)
  {
  	$relations = self::doSelect(array('where' => array('modulename' => $module_name, 'module_id' => $module_id)));
  	$related = array();
  	
  	foreach ($relations as $relation)
  	{
  		$related[$relation->getLeftModule()][$relation->getLeftModuleId()] = $relation;
  	}
  	
  	return $related;
  }
  
	public function load()
	{
		
    $db =& $this->GetDb();
    
		$query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME . ' WHERE id = ? LIMIT 1';
		
		$dbresult = $db->Execute($query, array($this->id));
		
	   if ($dbresult && $dbresult->RecordCount() > 0)
      {
      	$this->loaded = true;
        while ($dbresult && $row = $dbresult->FetchRow())
        {
          $this->PopulateFromDb($row);
          $this->PerformPostLoadingActions();
        }
      }
	}
	
	public function PopulateFromDb($row)
	{
		  $this->id = $row['id'];
		  $this->left_module = $row['rel_code'];
		  $this->left_module_id = $row['rel_id'];
		  $this->right_module = $row['modulename'];
		  $this->right_module_id = $row['module_id'];
	}
	
  public function save()
  {
    // Upgrade or Insert ?
    if ($this->id != null)
    {
      $this->update();
    }
    else 
    {     
        $this->insert();
    }   
    
  }
  
  protected function update()
  {
    
    $db =& $this->GetDb();
    

      $query = 'UPDATE  ' . cms_db_prefix() .  self::DB_NAME . ' 
      
      SET ';
            
      $query .= ' rel_code = ?, rel_id = ?, modulename = ?,  module_id = ?';
      
      $query .= '
      
      WHERE
      
      id = ?  ';
      
      
      $result = $db->Execute($query,
          array(             
             $this->getLeftModule(),
             $this->getLeftModuleId(),
             $this->getRightModule(),
             $this->getRightModuleId(),
             $this->getId()
          )
        );        
        
        /*FIXME: Test the $db status; */
        
        return true;
  }
  
  protected function insert()
  {
  	if (!self::doExists(             
  	         $this->getLeftModule(),
             $this->getLeftModuleId(),
             $this->getRightModule(),
             $this->getRightModuleId()))
    {
    $db =& $this->GetDb();
    
    $this->setId($db->GenID(cms_db_prefix() .  self::DB_NAME .'_seq' ));
      
    $query = 'INSERT INTO ' . cms_db_prefix() .  self::DB_NAME .  ' 
      
      SET  id = ?,  ';
            
      $query .= ' rel_code = ?, rel_id = ?, modulename = ?,  module_id = ?';
      
       $db->Execute($query,
          array(
             $this->getId(), 
             $this->getLeftModule(),
             $this->getLeftModuleId(),
             $this->getRightModule(),
             $this->getRightModuleId(),
          )
        );
        
        return true;    
    }
    else
    {
    	return false;
    }
  }
  
  public static function doExists($left_module, $left_module_id, $right_module, $right_module_id)
  {
  	if ($relation_link = self::doSelectOne(array('where' => array(
	  	'rel_code' => $left_module,
	  	'rel_id' => $left_module_id,
	  	'modulename' => $right_module,
	  	'module_id' => $right_module_id,
  	))))
  	{
  		return true;  		
  	}
  	else
  	{
  		return false;
  	}
  }
  
  public function isLoaded()
  {
  	return $this->loaded;
  }
   
  public static function retrieveByPk($id)
  {
    return self::doSelectOne(array('where' => array('id' => $id)));    
  }
  
  public static function doSelectOne($params = array())
  {
    $items = self::doSelect($params);
    if ($items)
    {
      return $items[0];
    }
    else 
    {
      return null;
    }   
  }
  
  public static function doSelect($params = array())
  {
    $instance = new self();
    
    
    $db =& $instance->GetDb();
    
    $query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME;;
    
    $values = array();
    
    if (isset($params['where']))
    {

      $fields = array();
      foreach ($params['where'] as $field => $value) 
      {
        $fields[] = $field . ' =  ?';
        $values[] = $value;
      }
      
      $query .= ' WHERE ' . implode(' AND ', $fields);
    } 
    
    if(isset($params['order_by']))
    {
     $query .= ' ORDER BY ' . implode(', ' , $params['order_by']);
    }
    else
    {
    	$query .= ' ORDER BY module_id';
    }
    
    $dbresult = $db->Execute($query, $values);
  
    $items = array();
   if ($dbresult && $dbresult->RecordCount() > 0)
    {
      while ($dbresult && $row = $dbresult->FetchRow())
      {
        $item = new self();
        $item->PopulateFromDb($row);        
        $items[] = $item;
      }
    }
    
    return  $items;   
  }
  
   public function delete()
   {       
    $db =& $this->GetDb();
    $query = 'DELETE FROM '. cms_db_prefix() . self::DB_NAME;
    $query .= ' WHERE id = ?';
    $db->Execute($query, array($this->id));   
   }
  
}

?>