<?php
#CMS - CMS Made Simple
#(c)2004 by Ted Kulp (wishy@users.sf.net)
#This project's homepage is: http://cmsmadesimple.sf.net
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#$Id$
/**
* SeminarplanModule Desception
*
*What does it do?<br/>
*The seminarplanmodul is a contentmodul and a CMSMS Tagmodul.<br/>
*It would be selected to give visitors the ability<br/>
*to show events by diverent days.<br/>
*
*@package seminarplan
*@author Krisztian Kishazi<support@expectmore.at>
*@version 0.3 16/01/2006 10:18
*/
//SeminarplanModulclass Beginn
class seminarplan extends CMSModule
{
		/**
		*Must return the exact class name of the module.<br/><br/>
		*
		*If these do not match, bad things happen<br/>
		*This is the name that's shown in the main Modules<br/>
		*page in the Admin.<br/>
		*If you want to be safe, you can just replace the body<br/>
		*of this function with:<br/>
		*return get_class($this); <br/>
		*/
	function GetName()
	{
		return 'seminarplan';
	}
		/**
		*This can return any string, preferably a localized name of the module.
		*
		*This is the name that's shown in the<br/>
		*Admin Menus and section pages (if the module has an admin<br/>
		*component).<br/>
		*See for more details skeleton module.<br/>
		*/
		
	function GetFriendlyName()
	{
	return $this->Lang('seminarplan');
	}
	
		/**
		*Alow users to add it in a Page using 'smarty' tag
		*
		*This function returns true or false, depending upon<br/>
		*whether users can include the module in a page or<br/>
		*template using a smarty tag <br/>
		*If your module does not get included in pages or<br/>
		*templates, return "false" here.<br/>
		*/
		
	function IsPluginModule()
	{
		return true;
	}
	
		/**
		*Alow users to add as an Contenttype
		*
		*This function returns true or false, depending upon<br/>
		*If you don't want to include it as an Contentmodule<br/>
		*return "false" here.<br/>
		*/
	
	function IsContentModule()
	{
		return true;
	}
	
		/**
		*Give CMSMS back if this Module has an Adminarea
		*
		*This function returns a boolean value, depending on<br/>
		*whether your module adds anything to the Admin area of<br/>
		*the site. For the rest of these comments, I'll be calling<br/>
		*the admin part of your module the "Admin Panel" for<br/>
		*want of a better term.<br/>
		*/
		
	function HasAdmin()
	{
		return true;
	}
	
		/**
		*Show or not Show for User with no access to the Module
		*
		*If your module does have an Admin Panel, you<br/>
		*can control whether or not it's displayed by the boolean<br/>
		*that is returned by this method. This is primarily used<br/>
		*to hide modules from admins who lack permission to use<br/>
		*them.<br/>
		*In this case, the module will only be visible to admins<br/>
		*who have "Use Skeleton" permissions.<br/>
		*/
		
	function VisibleToAdminUser()
	{
		$access = $this->CheckPermission('Modify seminarplan');
		$access1 = $this->CheckPermission('Add Roomreservation');
		$accessforall = $this->CheckPermission('Add for all Reservation');
		if ($access || $access1 || $accessforall)
		{
			return true;
		}
		else
		{
        		return false;
        	}
	}
	
		/**
		*This can return any string, preferably a number or<br/>
		*something that makes sense for designating a version.
		*
		*The CMS will use this to identify whether or not<br/>
		*the installed version of the module is current, and<br/>
		*the module will use it to figure out how to upgrade<br/>
		*itself if requested.<br/>
		*/
		
	function GetVersion()
	{
		return '0.4';
	}
	
		/**
		*Specify which Admin Section (or top-level Admin Menu) it shows<br/>
		*
		*If your module has an Admin Panel, you can specify<br/>
		*which Admin Section (or top-level Admin Menu) it shows<br/>
		*up in. This method returns a string to specify that<br/>
		*section. Valid return values are:<br/><br/>	
		*	
		*main        - the Main menu tab.<br/>
		*content     - the Content menu<br/>
		*layout      - the Layout menu<br/>
		*usersgroups - the Users and Groups menu<br/>
		*extensions  - the Extensions menu (this is the default)<br/>
		*siteadmin   - the Site Admin menu<br/>
		*viewsite    - the View Site menu tab<br/>
		*logout      - the Logout menu tab<br/><br/>
		*
		*Note that if you place your module in the main,<br/>
		*viewsite, or logout sections, it will show up in the<br/>
		*menus, but will not be visible in any top-level<br/>
		*section pages.<br/>
		*/
		
	function GetAdminSection()
	{
		return 'content';
	}
	
		/**
		*GetAdminDescription()
		*
		*If your module does have an Admin Panel, you<br/>
		*can have it return a description string that gets shown<br/>
		*in the Admin Section page that contains the module.<br/><br/>
		*
		*See the note on localization at the top of this file.<br/>
		*/
	
	function GetAdminDescription()
	{
		return $this->Lang('moddescription');
	}
	
		/**
		*When your module is installed, you may need to do some<br/>
		*setup. Typical things that happen here are the creation<br/>
		*and prepopulation of database tables, database sequences,<br/>
		*permissions, preferences, etc.<br/><br/>
		*
		*For information on the creation of database tables,<br/>
		*check out the ADODB Data Dictionary page at<br/>
		*http://phplens.com/lens/adodb/docs-datadict.htm<br/><br/>
		*
		*This function can return a "false" in case of any error,<br/>
		*and CMS will not consider the module installed.<br/><br/><br/>
		*<b>$flds</b> 
		*<br/><br/>Set's the fields for cms_db_prefix().module_seminarplan.<br/>
		*fields are:<br/><br/>
		*semID<br/>
		*energie: costs<br/>
		*train<br/>
		*name<br/>
		*info<br/>
		*intern<br/><br/>
		*
		*<b>$flds1</b><br/><br/> 
		*Set's the fields for cms_db_prefix().module_seminarplandates. <br/>
		*fields are:<br/><br/>
		*datID<br/>
		*semID<br/>
		*objectID<br/>
		*starttime<br/>
		*endtime<br/>
		*intern<br/>
		*<br/><br/>
		*<b>$flds2</b><br/><br/> 
		*Set's the fields for cms_db_prefix().module_seminarplantrain. <br/>
		*fields are:<br/><br/>
		*trainID<br/>
		*name<br/>
		*<br/><br/>
		*<b>Sequences</b><br/><br/>
		*Sequences wich will be created is:<br/><br/>
		*cms_db_prefix()."module_seminarplan_seq<br/>
		*<br/><br/>
		*<b>Permissions</b><br/><br/> 
		*It Creates some permissions. <br/>
		*The Permissions are:<br/><br/>
		*Modify seminarplan: Grand rights for Seminarplan<br/>
		*Add Roomreservation: Alow to add Internal Roomreservations wich are allowed for this user<br/>
		*Add for all Reservation: Grand rights for Internal Kalender to add sombodies reservation<br/><br/>
		*
		*/
		
	function Install()
	{
	
	$db = $this->cms->db;
	$dict = NewDataDictionary($db);
	
	$flds = "
	semID I KEY AUTO,
	energie C(255),
	train I,
	name X,
	info X,
	intern I
	";
	
	$flds1 = "
	datID I KEY AUTO,
	semID I,
	objectID I,
	starttime T,
	endtime T,
	intern I
	";
	
	$flds2 = "
	trainID I KEY AUTO,
	name X,
	traininfo X
	";
	
	$taboptarray = array('mysql' =>
	'TYPE=MyISAM');
	
	$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_seminarplan",
	$flds, $taboptarray);
	
	$sqlarray1 = $dict->CreateTableSQL(cms_db_prefix()."module_seminarplandates",
	$flds1, $taboptarray);
	
	$sqlarray2 = $dict->CreateTableSQL(cms_db_prefix()."module_seminarplantrain",
	$flds2, $taboptarray);
	
	$dict->ExecuteSQLArray($sqlarray);
	$dict->ExecuteSQLArray($sqlarray1);
	$dict->ExecuteSQLArray($sqlarray2);
	$db->CreateSequence(cms_db_prefix()."module_seminarplan_seq");
	$this->CreatePermission('Modify seminarplan', 'Modify seminarplan');
	$this->CreatePermission('Add Roomreservation', 'Add Roomreservation');
	$this->CreatePermission('Add for all Reservation', 'Add for all Reservation');
	
	}
	
		/**
		*Message after Module was Installed 
		*
		*After installation, there may be things you want to<br/>
		*communicate to your admin. This function returns a<br/>
		*string which will be displayed.<br/><br/>
		*
		*For best you put a Variable like $lang['inposmes']<br/>
		*into your Languagefile already includet is de_DE<br/>
		*/
		
	function InstallPostMessage()
	{
		return $this->Lang('inposmes');;
	}
		
		/**
		*The Upgrade function
		*
		*If your module version number does not match the version<br/>
		*number of the installed module, the CMS Admin will give<br/>
		*you a chance to upgrade the module. This is the function<br/>
		*that actually handles the upgrade.<br/>
		*Ideally, this function should handle upgrades incrementally,<br/>
		*so you could upgrade from version 0.0.1 to 10.5.7 with<br/>
		*a single call. For a great example of this, see the News<br/>
		*module in the standard CMS install.<br/>
		*/
		
	function Upgrade($oldversion, $newversion)
	{
	$db = $this->cms->db;
			$dict = NewDataDictionary($db);
			$config = $this->cms->config;
			$taboptarray=array('mysql'=>'TYPE=MyISAM');
	$current_version = $oldversion;
	switch($current_version)
	{
		case "0.2":
		{
		$flds = "
			objectID I,
			intern I
			";
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix()."module_seminarplandates",$flds, $taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		$flds1 = "
			intern I
			";
		$sqlarray1 = $dict->AddColumnSQL(cms_db_prefix()."module_seminarplan",$flds1, $taboptarray);
		$dict->ExecuteSQLArray($sqlarray1);
		}
		case "0.3":
		{
			$this->CreatePermission('Add Roomreservation', 'Add Roomreservation');
			$this->CreatePermission('Add for all Reservation', 'Add for all Reservation');	
		}
		case "0.4":
		{
			$flds1 = "
			traininfo X
			";
		$sqlarray1 = $dict->AddColumnSQL(cms_db_prefix()."module_seminarplantrain",$flds1, $taboptarray);
		$dict->ExecuteSQLArray($sqlarray1);
		}
	}
	}
	
		/**
		*The Uninstallfunction
		*
		*Sometimes, an exceptionally unenlightened or ignorant<br/>
		*admin will wish to uninstall your module. While it<br/>
		*would be best to lay into these idiots with a cluestick,<br/>
		*we will do the magnanimous thing and remove the module<br/>
		*and clean up the database, permissions, and preferences<br/>
		*that are specific to it.<br/>
		*This is the method where we do this.<br/>
		*/
		
	function Uninstall()
	{
		$db = $this->cms->db;
		$dict = NewDataDictionary( $db );
		
		$sqlarray = $dict->DropTableSQL( cms_db_prefix()."module_seminarplan" );
		$dict->ExecuteSQLArray($sqlarray);
		
		$sqlarray1 = $dict->DropTableSQL( cms_db_prefix()."module_seminarplandates" );
		$dict->ExecuteSQLArray($sqlarray1);
		
		$sqlarray2 = $dict->DropTableSQL( cms_db_prefix()."module_seminarplantrain" );
		$dict->ExecuteSQLArray($sqlarray2);
		
		$db->DropSequence( cms_db_prefix()."module_seminarplan_seq" );
		
		$this->RemovePermission('Modify seminarplan');
		$this->RemovePermission('Add Roomreservation');
		$this->RemovePermission('Add for all Reservation');
	}
	
		/**
		*ShowError to display error 
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the Errors,<br/>
		*so it's avalable to change the error stile on oneplace.<br/>
		*
		*@param string $error The Error to display
		*/
	function ShowError($error)
	{
	
		echo '<p class="pageerror">'.$error;
		echo '</p>';
	}
	
		/**
		*TrainForm to generate or edit Trainers
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*
		*@param string $id The ID of the module
		*@param string $moduleaction  
		*@param string $error Gets the errormessages if something went wrong
		*@param string $name used for edit trainers comes soon
		*@param int $trainID ID of the trainer wich will be edited
		*/
		
	function TrainForm($id, $moduleaction, $error='', $name='', $trainID, $traininfo='')
	{
		if ( $error != "" )
		{
			$this->ShowError($error);
		}
		
		$this->smarty->assign('theFormStart', $this->CreateFormStart($id, $moduleaction));
		$this->smarty->assign('utrainer', $this->lang('trainname'));
		$this->smarty->assign('uinfo', $this->lang('uinfo'));
		$this->smarty->assign('name', $this->CreateInputText($id, 'name', $name, '40', '', ''));
		$this->smarty->assign('traininfo', $this->CreateTextarea(true, $id, $traininfo, 'traininfo', 'syntaxHighlight', 'traininfo'));
		$this->smarty->assign('trainID', $this->CreateInputHidden($id, 'trainID', $trainID, ''));
		$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', Lang('submit')));
		$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancelsubmit', Lang('cancel')));
		$this->smarty->assign('formend', $this->CreateFormEnd());
		echo $this->ProcessTemplate('trainform.tpl');
	
	}
	
	/**
		*DateForm to generate or edit Trainers
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*
		*@param string $id The ID of the module
		*@param string $moduleaction  
		*@param string $error Gets the errormessages if something went wrong
		*@param string $time definate the Startday and time of Dropdownfields
		*@param string $endtime definate the endday and time of Dropdownfields
		*@param string $entryarray Put a list of already added Dates to the Form
		*@param string $semID used to store the ID of the Seminar for whom a date will be created
		*@param string $semname used to store the Name of the Seminar
		*@param string $objektedropdown used to store the Name of the Rooms wich are available with the objektmodul
		*/
		
	function DateForm($id, $moduleaction, $error='', $time='', $endtime='', $entryarray='', $semID='', $semname='', $objektedropdown='')
	{
	if ( $error != "" )
	{
		$this->ShowError($error);
	}
	
	if (isset($time))
			{
				$startdate = time();
			}
			$enddate = strtotime('+6 months', time());
			if (isset($endtime))
			{
				$enddate = mktime($endtime);
			}
			$this->smarty->assign('semname', $semname);
			$this->smarty->assign('theFormStart', $this->CreateFormStart($id, $moduleaction));
			$this->smarty->assign('ukurs', $this->lang('kurs'));
			$this->smarty->assign('ubestdate', $this->lang('ubestdate'));
			$useobjektevalue=$this->GetPreference('useobjekte', 'no');
			$useobjekte=($useobjektevalue=='no'?false:true);
			if($useobjekte)
			{
			$this->smarty->assign('uobjekte', $this->lang('uobjekte'));
			$this->smarty->assign('objekte', $objektedropdown);
			}
			else
			{
				$this->smarty->assign('dontuseobjekte', $this->CreateInputHidden($id, 'dontuseobjekte', '1', ''));
			}
			$this->smarty->assign('usdate', $this->lang('usdate'));
			$this->smarty->assign('ustime', $this->lang('ustime'));
			$this->smarty->assign('uetime', $this->lang('uetime'));
			$this->smarty->assign('semname', $semname);
			$this->smarty->assign('items', $entryarray);
			$this->smarty->assign('itemcount', count($entryarray));
			$this->smarty->assign('uakttermine', $this->lang('uakttermine'));
			$this->smarty->assign('startdateprefix', $id.'startdate_');
			$this->smarty->assign('enddateprefix', $id.'enddate_');
			$this->smarty->assign('startdate', $startdate);
			$this->smarty->assign('enddate', $enddate);
			$this->smarty->assign('uintern', $this->lang('uintern'));
			$this->smarty->assign('intern', $this->CreateInputCheckbox($id, 'intern', '2', ''));
			$this->smarty->assign('semID', $this->CreateInputHidden($id, semID, $semID, ''));
			$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', Lang('submit')));
			$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancelsubmit', Lang('cancel')));
			$this->smarty->assign('formend', $this->CreateFormEnd());
			echo $this->ProcessTemplate('adddateform.tpl');
	
	
	
	
	}
		
		/**
		*DateFormReservation to generate or edit Trainers
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*
		*@param string $id like m1_
		*@param string $moduleaction  
		*@param string $error Gets the errormessages if something went wrong
		*@param string $dayvalue definate the Startday and time of Dropdownfields
		*@param string $objektedropdown used to store the Name of the Rooms wich are available with the objektmodul
		*@param string $entryarray stores a list of Seminarsdates for the current Date
		*@param string $semID used to store the ID of the Seminar for whom a date will be created
		*@param string $semname used to store the Name of the Seminar
		*/
		
	function DateFormReservation($id, $moduleaction, $error='', $dayvalue='', $objektedropdown='', $entryarray='', $semID='', $semname='')
	{
	$access = $this->CheckPermission('Modify seminarplan');
		if ( $error != "" )
		{
			echo "<ul class=\"error\">$error</ul>";
		}
		if(!$access)
		{
			$wert=1;
		}
		else
		{
			$wert=2;
		}
		
		$time=mktime('00','00','00','01','01','2000');
			$this->smarty->assign('semname', $semname);
			$this->smarty->assign('theFormStart', $this->CreateFormStart($id, $moduleaction));
			$useobjektevalue=$this->GetPreference('useobjekte', 'no');
			$useobjekte=($useobjektevalue=='no'?false:true);
			if($useobjekte)
			{
				$this->smarty->assign('uobjekte', $this->lang('uobjekte'));
				$this->smarty->assign('objekte', $objektedropdown);
			}
			else
			{
				$this->smarty->assign('dontuseobjekte', $this->CreateInputHidden($id, 'dontuseobjekte', '1', ''));
			}
			$this->smarty->assign('utrainer', $this->lang('trainname'));
			$this->smarty->assign('ukurs', $this->lang('kurs'));
			$this->smarty->assign('ubestdate', $this->lang('ubestdate'));
			$this->smarty->assign('usdate', $this->lang('usdate'));
			$this->smarty->assign('ustime', $this->lang('ustime'));
			$this->smarty->assign('uetime', $this->lang('uetime'));
			$this->smarty->assign('semname', $semID);
			$this->smarty->assign('items', $entryarray);
			$this->smarty->assign('itemcount', count($entryarray));
			$this->smarty->assign('uakttermine', $this->lang('uakttermine'));
			$this->smarty->assign('startdateprefix', $id.'startdate_');
			$this->smarty->assign('enddateprefix', $id.'enddate_');
			$this->smarty->assign('trainer', $trainer);
			$this->smarty->assign('startdate', $time);
			$this->smarty->assign('enddate', $time);
			$this->smarty->assign('access', $wert);
			
			$this->smarty->assign('datum', $this->CreateInputHidden($id, 'datum', $dayvalue, ''));
			$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', Lang('submit')));
			$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancelsubmit', Lang('cancel')));
			$this->smarty->assign('formend', $this->CreateFormEnd());
			echo $this->ProcessTemplate('addroomreservationform.tpl');
	
	
	
	
	}
		/**
		*Gets all Seminarsdates and return them as an array
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*
		*/
	function GetAllSemDates()
	{
	global $gCms;
	$config = $this->cms->config;
	$db = $this->cms->db;
		$query6 = "SELECT datID, semID, objectID,";
		$query6.= " DATE_FORMAT(starttime,'%H:%i') AS starttime1,";// Format HH:mm
		$query6.= " DATE_FORMAT(starttime,'%w') AS wochentag,";//gets the weekday
		$query6.= " DATE_FORMAT(starttime,'%d-%m-%Y') AS starttime2,";//Date as dd-mm-jjjj
		$query6.= " DATE_FORMAT(endtime,'%H:%i') AS endtime1 FROM ";//endtime as hh:mm
		$query6 .= cms_db_prefix()."module_seminarplandates";
		$query6 .= " ORDER BY starttime1 ";
		$dbresult6 = $db->Execute($query6);
		if ($dbresult6 && $dbresult6->RowCount() > 0)
		{
			return $dbresult6->GetArray();
		}
	}

		/**
		*gets all Seminarsdates from one day and return them as an array
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*
		@param string $day_of_month definate the Day wich is needed
		*/
		
	function GetAllDaySemDates($day_of_month)
	{
	
	global $gCms;
	$config = $this->cms->config;
	$db = $this->cms->db;
	// 	$query6 =  "SELECT datID, semID,objectID,starttime, DATE_FORMAT(starttime,'%H:%i') AS starttime1, DATE_FORMAT(starttime,'%H') AS hour, DATE_FORMAT(starttime,'%w') AS wochentag, DATE_FORMAT(starttime,'%d-%m-%Y') AS starttime2, DATE_FORMAT(endtime,'%H:%i') AS endtime1, DATE_FORMAT(endtime,'%H') AS endhour, DATE_FORMAT(endtime,'%i') AS endmin FROM ";
	//         $query6 .= cms_db_prefix()."module_seminarplandates";
	//         $query6 .= " WHERE starttime >= ".$day_of_month;
	//         $query6 .= " ORDER BY starttime1 ";
	//         $dbresult6 = $db->Execute($query6);
	//         if ($dbresult6 && $dbresult6->RowCount() > 0)
	//         {
	//  		return $dbresult6->GetArray();
	// 	}
		$useobjektevalue=$this->GetPreference('useobjekte', 'no');
			$useobjekte=($useobjektevalue=='no'?false:true);
		if($useobjekte)
		{
		$query6 =  "SELECT sd.datID, sd.semID, sd.objectID, sp.intern, DATE_FORMAT(sd.starttime,'%H:%i') AS starttime1,DATE_FORMAT(sd.starttime,'%H') AS hour,  DATE_FORMAT(sd.starttime,'%w') AS wochentag, DATE_FORMAT(sd.starttime,'%d-%m-%Y') AS starttime2, DATE_FORMAT(sd.endtime,'%H:%i') AS endtime1, DATE_FORMAT(sd.endtime,'%H') AS endhour, DATE_FORMAT(sd.endtime,'%i') AS endmin,sp.name AS semname, o.objID, o.name FROM ";
		$query6 .= cms_db_prefix()."module_seminarplandates AS sd INNER JOIN
		".cms_db_prefix()."module_seminarplan AS sp ON sd.semID=sp.semID INNER JOIN 
		".cms_db_prefix()."module_objekte AS o ON sd.objectID=o.objID";
		$query6 .= " WHERE starttime >= ".$day_of_month;
		$query6 .= " ORDER BY starttime1 ";
		$dbresult6 = $db->Execute($query6);
			if ($dbresult6 && $dbresult6->RowCount() > 0)
			{
				return $dbresult6->GetArray();
			}
		}
		else
		{
// 			$query6 =  "SELECT sd.datID, sd.semID, sd.objectID, sp.intern,";
// 			$query6 .= "DATE_FORMAT(sd.starttime,'%H:%i') AS starttime1, ";
// 			$query6 .= "DATE_FORMAT(sd.starttime,'%H') AS hour, ";
// 			$query6 .= "DATE_FORMAT(sd.starttime,'%w') AS wochentag, ";
// 			$query6 .= "DATE_FORMAT(sd.starttime,'%d-%m-%Y') AS starttime2, ";
// 			$query6 .= "DATE_FORMAT(sd.endtime,'%H:%i') AS endtime1, ";
// 			$query6 .= "DATE_FORMAT(sd.endtime,'%H') AS endhour, ";
// 			$query6 .= "DATE_FORMAT(sd.endtime,'%i') AS endmin, sp.name AS semname FROM ";
// 			$query6 .= cms_db_prefix()."module_seminarplandates AS sd INNER JOIN";
// 			$query6 .= cms_db_prefix()."module_seminarplan AS sp ON sd.semID=sp.semID";
$query6 =  "SELECT sd.datID, sd.semID, sd.objectID, sp.intern, DATE_FORMAT(sd.starttime,'%H:%i') AS starttime1,DATE_FORMAT(sd.starttime,'%H') AS hour,  DATE_FORMAT(sd.starttime,'%w') AS wochentag, DATE_FORMAT(sd.starttime,'%d-%m-%Y') AS starttime2, DATE_FORMAT(sd.endtime,'%H:%i') AS endtime1, DATE_FORMAT(sd.endtime,'%H') AS endhour, DATE_FORMAT(sd.endtime,'%i') AS endmin,sp.name AS semname FROM ";
		$query6 .= cms_db_prefix()."module_seminarplandates AS sd INNER JOIN
		".cms_db_prefix()."module_seminarplan AS sp ON sd.semID=sp.semID ";
			$query6 .= " WHERE starttime >= ".$day_of_month;
			$query6 .= " ORDER BY starttime1 ";
			$dbresult6 = $db->Execute($query6);
			if ($dbresult6 && $dbresult6->RowCount() > 0)
			{
				return $dbresult6->GetArray();
			}
		}
	}
	
		/**
		*gets all Seminars and return them as an Assoc
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*/
	
	function GetAllSeminar()
	{
	global $gCms;
	$config = $this->cms->config;
	$db = $this->cms->db;
	$query1 =  "SELECT ".cms_db_prefix()."module_seminarplan.semID, ".cms_db_prefix()."module_seminarplan.name, ".cms_db_prefix()."module_seminarplan.energie, ".cms_db_prefix()."module_seminarplan.train, ".cms_db_prefix()."module_seminarplantrain.trainID, ".cms_db_prefix()."module_seminarplantrain.name AS trainname FROM ";
	$query1 .= cms_db_prefix()."module_seminarplan INNER JOIN ".cms_db_prefix()."module_seminarplantrain ON ".cms_db_prefix()."module_seminarplan.train=".cms_db_prefix()."module_seminarplantrain.trainID";
	$dbresult = $db->Execute($query1);
	if ($dbresult && $dbresult->RowCount() > 0)
		{
			return $dbresult->GetAssoc();
		}
	}
	
	/**
		*gets all Seminars and return the result orderd by name
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*/
	
	function GetSeminars()
	{
	global $gCms;
	$config = $this->cms->config;
	$db = $this->cms->db;
	$query = "SELECT * FROM ".cms_db_prefix()."module_seminarplan ORDER BY name desc";
	return $db->Execute($query);
	}

		/**
		*gets all internal Seminars and return them as an Assoc
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*
		*@param string $id like m1_
		*/
		
	function GetAllInternSeminarAsDorpdown($id)
	{
	global $gCms;
	$config = $this->cms->config;
	$db = $this->cms->db;
		$query1 =  "SELECT name,semID FROM ";
		$query1 .= cms_db_prefix()."module_seminarplan WHERE intern=2";
		$dbresult = $db->Execute($query1);
		if ($dbresult && $dbresult->RowCount() > 0)
			{
				return $dbresult->GetMenu($id.'semID');
			}
	}
	
		/**
		*gets all Trainers and return the result
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*
		*/
		
	function GetTrainer()
	{
	$db = $this->cms->db;
		$query9 = "SELECT name,trainID FROM ";
			$query9 .= cms_db_prefix()."module_seminarplantrain ORDER BY name desc";
			return $db->Execute($query9);
	
	}
	
	/**
		*gets all informations Trainers and return the result
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*
		*/
	function GetTrainerbyID($trainID)
	{
	$db = $this->cms->db;
		$query9 = "SELECT name,trainID,traininfo FROM ";
			$query9 .= cms_db_prefix()."module_seminarplantrain WHERE trainID = ?";
			return $db->Execute($query9,array($trainID));
	
	}
	
		/**
		*Generates the Daycallender
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*
		*@param string $id like m1_
		*@param string $returnid
		*@param string $year Stores the selected year
		*@param string $month Stores the selected month
		*@param string $day Stores the selected day
		*@param string $day_of_month Stores the day of the month
		*@param string $entryarray stores the dates as an array
		*@param string $semarray stores the seminars as an assocarray
		*/
		
	function generate_day_calendar2($id,$returnid,$year, $month, $day,$day_of_month, $entryarray=array(), $semarray=array())
	{
		$day_names = array();
		$n=0;
		$useobjektevalue=$this->GetPreference('useobjekte', 'no');
			$useobjekte=($useobjektevalue=='no'?false:true);
		if($useobjekte)
		{
			$objektemodule=$this->GetModuleInstance('objekte');
			$objektearray=$objektemodule->GetAllObject();
		}
		while ($n<=6)
		{
			$day_names[$n] = $this->Lang('ds'.$n);
			$n++;
		}
		
		list($month, $year, $month_name, $weekday) = explode(',',gmstrftime('%m,%Y,%B,%w',$day_of_month));
		
		$weekday = ($weekday + 7 - $first_day) % 7;
		$title   = $month_name.'&nbsp;'.$year;
		
		$p = '<span class="kal-prev">'.$this->CreateLink($id, 'showcall', $returnid, '<<<', array('gomonth'=>'back','curmonth'=>$month,'curyear'=>$year,), '', false, false, 'class="pageoptions"').'</span>&nbsp;';
		
		$n = '&nbsp;<span class="kal-next">'.$this->CreateLink($id, 'showcall', $returnid, '>>>', array('gomonth'=>'next','curmonth'=>$month,'curyear'=>$year,), '', false, false, 'class="pageoptions"').'</span>';
		
		$calendar2='<div class="kal-monat">'.$p.$this->CreateLink($id, 'showcall', $returnid, $title, array('gomonth'=>'stay','curmonth'=>$month,'curyear'=>$year,), '', false, false, 'class="pageoptions"').$n."</div>\n";
		
		$calendar = '<table class="pagetable"';
		if($table_id != '')
		{
		
			$calendar .= ' id="'.$table_id.'">';
		}
		else
		{
				$calendar .='>';
		}
		$calendar .= "<tr>\n";
		
		
		$calendar .= "<th>Uhrzeit</th><th>".$day."-".$month."-".$year."</th>\n";
	
			$calendar .= "</tr>\n";
			
			for($f=0;$f<24;$f++)
			{
			
			$calendar .= '<tr><td valign="top">'.$f.'Uhr</td><td>';
			
			$dasdatum=$day.'-'.$month.'-'.$year;
			for($i=0;$i<sizeof($entryarray);$i++)
				{
				
				
				if($entryarray[$i]['starttime2']==$dasdatum && $entryarray[$i]['hour']<=$f && $entryarray[$i]['endhour']>$f)
				{
				
				$calendar .= "\n";
				$calendar .= '<br/><span class="object'.$entryarray[$i]['objectID'].'">';
				$calendar .= "\n<br/>".$semarray[$entryarray[$i]['semID']]['name'];
				if($useobjekte)
				{
				$calendar .= '<br/>in Raum '.$objektearray[$entryarray[$i]['objectID']]['name'];
				}
				$calendar .= '</span>';
				}
				elseif($entryarray[$i]['starttime2']==$dasdatum && $entryarray[$i]['endhour']==$f && $entryarray[$i]['endmin']!='00')
				{
				$calendar .= "\n";
				$calendar .= '<br/><span class="object'.$entryarray[$i]['objectID'].'">';
				$calendar .= "\n<br/>".$semarray[$entryarray[$i]['semID']]['name'];
				if($useobjekte)
				{
				$calendar .= '<br/>in Raum '.$objektearray[$entryarray[$i]['objectID']]['name'];
				}
				$calendar .= '</span>';
				}
				}
				
			$calendar .="</td>\n";
		$calendar.="</tr>\n";
		}
		
		$calendar.="</table>\n";
		
		return $calendar2.str_replace('&','&amp;',$calendar);
		}

		/**
		*Generates the Monthkallender
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*
		*@param string $id like m1_
		*@param string $returnid
		*@param string $year Stores the selected year
		*@param string $month Stores the selected month
		*@param string $day Stores the selected day
		*@param string $month_href will be deleted
		*@param string $firstday specificate the day wich the week start
		*@param string $pn will be deleted
		*/


	function generate_calendar2($id,$returnid,$year, $month, $days, $month_href = NULL, $first_day = '1', $pn = array())
	{
		global $gCms;
		$themeObjekt=$gCms->variables['admintheme'];
		$newobjekt=$themeObjekt->DisplayImage('icons/system/newobject.gif', $this->Lang('addsemint'),'','','systemicon');
		$first_of_month = mktime(0,0,0,$month,1,$year);
		$day_names = array();
		$n=0;
		$entryarray=$this->GetAllSemDates();
		$semarray=$this->GetAllSeminar();
		$useobjektevalue=$this->GetPreference('useobjekte', 'no');
			$useobjekte=($useobjektevalue=='no'?false:true);
		if($useobjekte)
		{
			$objektemodule=$this->GetModuleInstance('objekte');
			$objektearray=$objektemodule->GetAllObject();
		}
		while ($n<=6)
		{
			$day_names[$n] = $this->Lang('ds'.$n);
			$n++;
		}
		list($month, $year, $month_name, $weekday) = explode(',',strftime('%m,%Y,%B,%w',$first_of_month));
		
		$weekday = ($weekday + 7 - $first_day) % 7;
		$title   = $month_name.'&nbsp;'.$year;
		
		$p = '<span class="kal-prev">'.$this->CreateLink($id, 'showcall', $returnid, '<<<', array('gomonth'=>'back','curmonth'=>$month,'curyear'=>$year,), '', false, false, 'class="pageoptions"').'</span>&nbsp;';
		
		$n = '&nbsp;<span class="kal-next">'.$this->CreateLink($id, 'showcall', $returnid, '>>>', array('gomonth'=>'next','curmonth'=>$month,'curyear'=>$year,), '', false, false, 'class="pageoptions"').'</span>';
		
		$calendar2='<div class="kal-monat">'.$p.$this->CreateLink($id, 'showcall', $returnid, $title, array('gomonth'=>'stay','curmonth'=>$month,'curyear'=>$year,), '', false, false, 'class="pageoptions"').$n."</div>\n";
		
		$calendar = '<table class="pagetable" ';
		if($table_id != '')
		{
		
			$calendar .= ' id="'.$table_id.'">';
		}
		else
		{
			$calendar .='>';
		}
		$calendar .= "<tr>\n";
		if($first_day==0)
		{
			$i=0;
			foreach($day_names as $d)
			{
				if ($i<>0 && $i<>6) 
				{
					$calendar .= '<td class="kal_kl_td_tage">' .$d;
					
					$calender.='</td>';
				}
				else
				{
					$calendar .= '<td class="kal_kl_td_wochenende">' .$d.'</td>';
				}
				$i++;
			}
		}
		else
		{
		
			for($i=0;$i<7;$i++)
			{
				if($i<$first_day)
				{
					$thebeginday=$first_day+$i;
				}
				elseif(($first_day+$i)>6)
				{
					$thebeginday=($first_day+$i)-7;
				}
				else
				{
					$thebeginday=$first_day+$i;
				}
				if ($thebeginday<>0 && $thebeginday<>6) 
				{
					$calendar .= "<th class=\"pagepos\">" .$day_names[$thebeginday];
					$calendar.= "</th>\n";
				}
				else
				{
					$calendar .= "<th class=\"pagepos\">";
					$calendar .= $day_names[$thebeginday]."</th>\n";
				}
			}
		}
		$calendar .= "</tr>\n<tr>";
		if($weekday > 0) 
		{
			$calendar .= "<td class=\"kal_kl_tabelle_blank\" colspan=\"".$weekday."\"></td>\n";
		}
		for($day=1,$days_in_month=date('t',$first_of_month); $day<=$days_in_month; $day++,$weekday++)
		{
			if($weekday == 7)
			{
				$weekday   = 0; #start a new week
				$calendar .= "</tr>\n<tr>\n";
			}
			$reservarray=array('gomonth'=>'next','curmonth'=>$month,'curyear'=>$year,'curday'=>$day,);
			$calendar .= '<td valign="top">'.$day.'<br/>';
			$calendar .= $this->CreateLink($id, 'reservieren', $returnid, $newobjekt, $reservarray, '', false, false, 'class="pageoptions"');
			if($day<10)
			{
				$day='0'.$day;
			}
			else
			{
				$day;
			}
			$dasdatum=$day.'-'.$month.'-'.$year;
			for($i=0;$i<sizeof($entryarray);$i++)
			{
				
				$calendar .=$entryarray[$i]['datum'];
				if($entryarray[$i]['starttime2']==$dasdatum)
				{
					$calendar .= "\n";
					$calendar .= '<br/><span class="object'.$entryarray[$i]['objectID'].'">';
					$calendar .= "\n<br/>".$semarray[$entryarray[$i]['semID']]['name'];
					$calendar .= ' '.$entryarray[$i]['starttime1'].' bis ';
					$calendar .= $entryarray[$i]['endtime1'];
					if($useobjekte)
					{
						$calendar .= '<br/>in Raum ';
						$calendar .= $objektearray[$entryarray[$i]['objectID']]['name'];
					}
					$calendar .= '</span>';
				}
			}
			$calendar .="</td>\n";
			
		}
		if($weekday != 7)
		{
			$calendar .= '<td class="kal_kl_tabelle_blank" colspan="';
			$calendar .= (7-$weekday).'"></td>';
			$calendar .= "</tr>\n</table>\n";
		}
	
		return $calendar2.$calendar;
	}
	
		/**
		*AdminForm to generate or edit Seminars
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*
		*@param string $id The ID of the module
		*@param string $moduleaction  
		*@param string $error Gets the errormessages if something don't insert the Adminform
		*@param string $name Stores the Seminarname
		*@param string $info Stores the information about the Seminar
		*@param string $train
		*@param string $energie Costs of the seminar
		*@param string $semID Stores the seminarID on edit
		*@param string $trainers
		*@param string $intern mark Seminar as Internal or normal
		*
		*/
		
	function AdminForm($id, $moduleaction, $error='', $name='', $info='', $train='', $energie='' , $semID = '', $trainers= '',$intern='')
	{
	if ( $error != "" )
	{
		echo "<ul class=\"error\">$error</ul>";
	}
			$this->smarty->assign('theFormStart', $this->CreateFormStart($id, $moduleaction));
			$this->smarty->assign('utrainer', $this->lang('trainname'));
			$this->smarty->assign('trainers', $trainers);
			$this->smarty->assign('utitel', $this->lang('utitel'));
			$this->smarty->assign('uintern', $this->lang('uintern'));
			$this->smarty->assign('titel', $this->CreateInputText($id, 'name', $name, '', '', ''));
			$this->smarty->assign('uinfo', $this->lang('uinfo'));
			$this->smarty->assign('info', $this->CreateTextarea(true, $id, $info, 'info', 'syntaxHighlight', 'info'));
			$this->smarty->assign('uenergie', $this->lang('uenergie'));
			$this->smarty->assign('energie', $this->CreateInputText($id, 'energie', $energie, '40', '', ''));
			$this->smarty->assign('interncheck', $this->CreateInputCheckbox($id, 'intern',2, $intern));
			$this->smarty->assign('semID', $this->CreateInputHidden($id, semID, $semID, ''));
			$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', Lang('submit')));
			$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancelsubmit', Lang('cancel')));
			$this->smarty->assign('formend', $this->CreateFormEnd());
			echo $this->ProcessTemplate('addseminar.tpl');
	}
	
		/**
		*ShowStandard to few the Seminars to vistors
		*
		*This is NOT overriding a CMSModule function.<br/>
		*It's just used internallly for displaying the form,<br/>
		* since it's used in so many places.<br/>
		*/
		
	function ShowStandard()
	{
	
	global $gCms;
	$config = $this->cms->config;
	$db = $this->cms->db;
	$thispage = $gCms->variables['page'];
		$onecontent = ContentManager::LoadContentFromId($thispage, false);
      
		if($_GET['semID'])
		{
		$query =  "SELECT semID, name, info FROM ";
		$query .= cms_db_prefix()."module_seminarplan WHERE semID=";
		$query .= $_GET[semID];
		$dbresult = $db->Execute($query);
		if ($dbresult && $dbresult->RowCount() > 0)
		{
			$entryarray=array();
		while (($row = $dbresult->FetchRow()))
		{
		
			$link="<a href=\"";
			$link.=$this->GetURL();
			if($config["assume_mod_rewrite"] AND $_GET['wochentag'] OR $_GET['wochentag']=='0' AND $config["assume_mod_rewrite"])
			{
				$link.="?wochentag=";
				$link.=$_GET[wochentag];
			}
			elseif(!$config["assume_mod_rewrite"] AND $_GET['wochentag'] OR $_GET['wochentag']=='0' AND !$config["assume_mod_rewrite"])
			{
				$link.="&wochentag=";
				$link.=$_GET[wochentag];
			}
			$link.="\">zur&uuml;ck</a>";
			if($config["assume_mod_rewrite"])
			{
			$anmeldlink="<a href=\"";
			$anmeldlink.="kontakt".$config['page_extension'];
			$anmeldlink.="\">Anmeldung</a>";
			}
			else
			{
			$anmeldlink="<a href=\"index.php?";
			$anmeldlink.=$config['query_var'];
			$anmeldlink.="=kontakt";
			$anmeldlink.="\">Anmeldung</a>";
			}
			$this->smarty->assign('name',$row['name']);
			$this->smarty->assign('info',$row['info']);
			$this->smarty->assign('backlink',$link);
			$this->smarty->assign('anmeldlink',$anmeldlink);
		
		}
		
		echo $this->ProcessTemplate('detailshow.tpl');
		}
		}
		elseif($_GET['trainID'])
		{
		$query =  "SELECT trainID, name, traininfo FROM ";
		$query .= cms_db_prefix()."module_seminarplantrain WHERE trainID = ?";
		$dbresult = $db->Execute($query,array($_GET['trainID']));
		if ($dbresult && $dbresult->RowCount() > 0)
		{
			$entryarray=array();
		while (($row = $dbresult->FetchRow()))
		{
		
			$link="<a href=\"";
			$link.=$this->GetURL();
			if($config["assume_mod_rewrite"] AND $_GET['wochentag'] OR $_GET['wochentag']=='0' AND $config["assume_mod_rewrite"])
			{
				$link.="?wochentag=";
				$link.=$_GET['wochentag'];
			}
			elseif(!$config["assume_mod_rewrite"] AND $_GET['wochentag'] OR $_GET['wochentag']=='0' AND !$config["assume_mod_rewrite"])
			{
				$link.="&wochentag=";
				$link.=$_GET['wochentag'];
			}
			$link.="\">zur&uuml;ck</a>";
			if($config["assume_mod_rewrite"])
			{
			$anmeldlink="<a href=\"";
			$anmeldlink.="kontakt".$config['page_extension'];
			$anmeldlink.="\">Anmeldung</a>";
			}
			else
			{
			$anmeldlink="<a href=\"index.php?";
			$anmeldlink.=$config['query_var'];
			$anmeldlink.="=kontakt";
			$anmeldlink.="\">Anmeldung</a>";
			}
			$this->smarty->assign('name',$row['name']);
			$this->smarty->assign('info',$row['traininfo']);
			$this->smarty->assign('backlink',$link);
			$this->smarty->assign('anmeldlink',$anmeldlink);
		
		}
		
		echo $this->ProcessTemplate('detailshow.tpl');
		}
		}
		else
		{
		$weekday = array (
		"Alle"=>7,
		"Montag" =>1,
		"Dienstag" =>2,
		"Mittwoch" =>3,
		"Donnerstag" =>4,
		"Freitag" =>5,
		"Samstag" =>6,
		"Sonntag" =>0
		);
		$this->smarty->assign('formstarthtml',"<form name=\"filter\" method=\"get\">");
		$this->smarty->assign('getwochentag',$_GET['wochentag']);
		
		if(!$config["assume_mod_rewrite"])
		{
		$this->smarty->assign('quervar',$this->CreateInputHidden('', $config["query_var"], $_GET[$config["query_var"]]));
		}
		$this->smarty->assign('dropdown',$this->CreateInputDropdown('', 'wochentag', $weekday, '', (isset($_GET['wochentag'])?$_GET['wochentag']:7), ''));
		$this->smarty->assign('submit', $this->CreateInputSubmit('', 'submit', 'filtern'));
		$this->smarty->assign('formend', $this->CreateFormEnd());
		$query = "SELECT sd.semID, sd.starttime, DATE_FORMAT(sd.starttime,'%H:%i') AS starttime1,DATE_FORMAT(sd.starttime,'%w') AS wochentag1, DATE_FORMAT(sd.starttime,'%d-%m-%Y') AS starttime2, DATE_FORMAT(sd.endtime,'%H:%i') AS endtime1 FROM ";
		$query .= cms_db_prefix().'module_seminarplandates AS sd WHERE sd.starttime > CURDATE()-1 ';
		if($_GET['wochentag'] && $_GET['wochentag']<=6)
		{
			$query .="AND DATE_FORMAT(sd.starttime,'%w')= ? ";
			$query .="ORDER BY sd.starttime";
			$dbresult = $db->Execute($query,array($_GET['wochentag']));
		}
		elseif($_GET['wochentag']=='0')
		{
			$query .="AND DATE_FORMAT(sd.starttime,'%w')= ? ";
			$query .="ORDER BY sd.starttime";
			$dbresult = $db->Execute($query,array($_GET['wochentag']));
		}
		else
		{
			$query .="ORDER BY sd.starttime";
			$dbresult = $db->Execute($query);
		}
		$rowclass="row1";
		$entryarray1=array();
		if ($dbresult && $dbresult->RowCount() > 0)
		{
		while (($row1 = $dbresult->FetchRow()))
		{
		$wochentag1 = $prestring.$row1["wochentag1"].$poststring;
		if($_GET['wochentag'] && $_GET['wochentag']<=6)
		{
		$getwoche=$_GET[wochentag];
		}
		elseif($_GET['wochentag']=='0')
		{
		$getwoche=$_GET[wochentag];
		}
		else
		{
			$_GET[wochentag]='7';
		}
		$this->smarty->assign('getitwoche',$_GET[wochentag]);
		$query1 =  "SELECT sp.semID,sp.intern, sp.name, sp.energie, sp.train, sp.intern, st.trainID, st.name AS trainname,st.traininfo AS traininfo FROM ";
		$query1 .= cms_db_prefix()."module_seminarplan AS sp INNER JOIN ".cms_db_prefix()."module_seminarplantrain AS st ON sp.train=st.trainID WHERE semID=?";
		$dbresult1 = $db->Execute($query1,array($row1["semID"]));
		$timestamp = $prestring.$row1["starttime1"].$poststring;
		$timestamp1 = $prestring.$row1["starttime2"].$poststring;
		$timestamp2 = $prestring.$row1["endtime1"].$poststring;
		if ($dbresult1 && $dbresult1->RowCount() > 0)
		{
			while (($row = $dbresult1->FetchRow()))
			{
			if($row['intern']==1)
			{
			$onerow= new stdClass();
			if($wochentag1==0)
			{
				$namwoche= "Sonntag";
			}
			elseif($wochentag1==1)
			{
				$namwoche= "Montag";
			}
			elseif($wochentag1==2)
			{
				$namwoche= "Dienstag";
			}
			elseif($wochentag1==3)
			{
				$namwoche= "Mittwoch";
			}
			elseif($wochentag1==4)
			{
				$namwoche= "Donnerstag";
			}
			elseif($wochentag1==5)
			{
				$namwoche= "Freitag";
			}
			elseif($wochentag1==6)
			{
				$namwoche= "Samstag";
			}
			$onerow->wochentagnummer = $wochentag1;
			$onerow->wochentag = $namwoche;
			$onerow->datum = $timestamp1;
			$onerow->beginn = $timestamp;
			$onerow->ende = $timestamp2;
			$link="<a href=\"";
			$link.=$this->GetURL();
			if($config["assume_mod_rewrite"])
			{
			$link.="?semID=";
			$link.=$row["semID"];
			}
			else
			{
			$link.="&semID=";
			$link.=$row["semID"];
			}
			if($_GET['wochentag'] OR $_GET['wochentag']=='0')
			{
				$link.="&wochentag=";
				$link.=$_GET[wochentag];
			}
			$link.="\" ><b>";
			$link.=$row["name"];
			$link.="<b></a>";
			$onerow->link = $link;
			$linktrain="<a href=\"";
			$linktrain.=$this->GetURL();
			if($config["assume_mod_rewrite"])
			{
			$linktrain.="?trainID=";
			$linktrain.=$row["trainID"];
			}
			else
			{
			$linktrain.="&trainID=";
			$linktrain.=$row["trainID"];
			}
			if($_GET['wochentag'] OR $_GET['wochentag']=='0')
			{
				$linktrain.="&wochentag=";
				$linktrain.=$_GET[wochentag];
			}
			$linktrain.="\" ><b>";
			$linktrain.=$row["trainname"];
			$linktrain.="<b></a>";
			$onerow->trainer = (isset($row["traininfo"]) && $row["traininfo"]!=NULL?$linktrain: $row["trainname"]);
			
						$onerow->energie = $row["energie"];;
						$onerow->rowclass = $rowclass;
			array_push($entryarray1, $onerow);
			($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
			}
			}
			$this->smarty->assign('items1', $entryarray1);
			$this->smarty->assign('itemcount1', count($entryarray1));
		}
		}
		}
		echo $this->ProcessTemplate('showlist1.tpl');
		}
	
	}

		/**
		*This is the main function that gets called if your module
		*is a plug-in type module.
		*
		*In general, you'll want to call various different<br/>
		*methods, depending upon the requested "action."<br/><br/>
		*There are two built-in actions: "default" which gets<br/>
		*called if the module is accessed from a page or template,<br/>
		*and "defaultadmin" which gets called from the Admin<br/>
		*panel.<br/><br/>
		*
		*The Action can be overridden by passing a different<br/>
		*action either in your tag, e.g.,<br/>
		*{cms_module module='Skeleton' action='something'}<br/>
		*or by passing it in a link create by the CreateLink<br/>
		*method. More on that can be seen below in the<br/>
		*DisplayAdminNav method.<br/>
		*@param string $action <br/>
		*switch <br/>
		*case "default": Shows the Seminarplan to Visitors<br/>
		*case "defaultadmin": Adminarea to administrate the Seminarplan<br/>
		*case "edit": Call the function AdminForm to edit an entrie<br/>
		*case "add": Adds an entrie from the Adminarea of gastbuch<br/>
		*case "delete": Deletes an entrie from the gastbuch<br/>
		*case "pruef1": Activate an entrie to show it to the Visitors<br/>
		*case "pruef": Deactivate an entrie to show it to the Visitors<br/>
		*case "completeadd": This case saves the entrie you make from the Adminarea with the AdminForm function<br/>
		*case "completeedit": This case saves the entrie you modify from the Adminarea with the AdminForm function<br/><br/>
		* @param string The ID of the module
		* @param string The parameters targeted for this module
		*<br/><br/>
		*<b>default</b><br/><br/>
		*To Show the Visitorsinterface<br/>
		*<b>defaultadmin</b><br/><br/>
		*To Show the Administratorinterface<br/>
		*<b>showcall</b><br/><br/>
		*To Show the Calender for Internal Roomreservations<br/>
		*<b>reservieren</b><br/><br/>
		*To Show the Day wich is choosen by user<br/>
		*<b>completereservation</b><br/><br/>
		*To Save the roomreservation<br/>
		*<b>edit</b><br/><br/>
		*To edit a Seminar<br/>
		*<b>completeedit</b><br/><br/>
		*Save a edited Seminar<br/>
		*<b>add</b><br/><br/>
		*To Show the AdminForm for Inserting Seminars<br/>
		*<b>completeadd</b><br/><br/>
		*Save a inserted Seminar<br/>
		*<b>addtrain</b><br/><br/>
		*To Show the TrainForm for Inserting Trainers<br/>
		*<b>completeaddtrain</b><br/><br/>
		*Saves the Inserted Data from the Trainform<br/>
		*<b>adddate</b><br/><br/>
		*First it checks for already inserted days andthen it generate the DateForm for Inserting new Dates<br/>
		*<b>completeadddate</b><br/><br/>
		*Saves the Inserted data from the DateForm<br/>
		*<b>deldate</b><br/><br/>
		*Deletes a Date from the DateForm<br/>
		*<b>delete</b><br/><br/>
		*Deletes a Seminar<br/>
		*<b>updateoptions</b><br/><br/>
		*Saves the setten options<br/>
		*/
		
	function DoAction($action, $id, $params, $returnid = -1)
	{
	GLOBAL $PHP_SELF;
	global $gCms;
	$config = $this->cms->config;
	$db = $this->cms->db;
	$themeObjekt=$gCms->variables['admintheme'];
	switch ($action)
	{
		case "default":
		{
			$this->ShowStandard();
		}
		break;
		case "defaultadmin":
		{
		check_login();
			$newobjektintern=$themeObjekt->DisplayImage('icons/system/newobject.gif', $this->Lang('showcall'),'','','systemicon');
			$newobjektinternlink=$this->CreateLink($id, 'showcall', $returnid, $newobjektintern, array(), '', false, false, '') .' '. $this->CreateLink($id, 'showcall', $returnid, $this->Lang('showcall'), array(), '', false, false, 'class="pageoptions"');
			
			
			$access = $this->CheckPermission('Modify seminarplan');
			$access1 = $this->CheckPermission('Add Roomreservation');
			$accessforall = $this->CheckPermission('Add for all Reservation');
			if (!$access1 && !$accessforall)
			{
				echo $this->ShowError($this->Lang('E_Need_AR_perm'));
			}
			
			if ($access1 || $accessforall)
			{
				echo $newobjektinternlink;
			}
			
			if ($access && !$access1 && !$accessforall)
			{
				echo $newobjektinternlink;
			}
			
			if (!$access)
			{
				echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
			}
			$image_false = $themeObjekt->DisplayImage('icons/system/true.gif', $this->Lang('deakti'),'','','systemicon');
			$image_true = $themeObjekt->DisplayImage('icons/system/false.gif',$this->Lang('ativi') ,'','','systemicon');
			$image_edit = $themeObjekt->DisplayImage('icons/system/edit.gif', lang('edit'),'','','systemicon');
			$image_delete = $themeObjekt->DisplayImage('icons/system/delete.gif', lang('delete'),'','','systemicon');
		//$searchbutton=$themeObjekt->DisplayImage('icons/system/view.gif', $this->Lang('tabsearch'),'','','systemicon');
			$rowsperpage=20;
			
			
			$sort = (isset($params['sort'])?$params['sort']:"");
			$current_page = (isset($params['page'])?$params['page']:"1");
			
			if (!isset($current_page))
			{
				$current_page = 1;
			}
			
			
			
				//l�chen der alten eintr�e, zusatz fr archivierung
				//$query12 = "DELETE FROM ".cms_db_prefix()."module_seminarplandates WHERE endtimetime
				//< CURDATE()-1";
				//$dbresult12 = $db->
				//Execute($query12);
				
				
				
				
			echo $this->StartTabHeaders();
				
				
			
			echo $this->SetTabHeader('kurse',$this->Lang('tabseminar'));
			echo $this->SetTabHeader('trainer',$this->Lang('tabtrainer'));
			echo $this->SetTabHeader('prefer',$this->Lang('tabpreferences'));
			
			echo $this->EndTabHeaders();
			
			echo $this->StartTabContent();//ausgeben der daten
				
			
			echo $this->StartTab("kurse");
			$this->smarty->assign('hloesch',lang('delete'));
			$this->smarty->assign('hedit',lang('edit'));
	
			$this->smarty->assign('hintern',$this->Lang('uintern'));
			$udathinzu=$this->Lang('datumhinzu');
			$this->smarty->assign('hdathinzu',$udathinzu);
			$this->smarty->assign('hsemnam',$this->Lang('semname'));
			$this->smarty->assign('hallsem',$this->Lang('allsem'));
			
				$dbresult = $this->GetSeminars();
				if ($dbresult && $dbresult->RowCount() > 0)
				{
					$entryarray1=array();
					$this->smarty->assign('pagany', $this->CreatePagination($id, 'defaultadmin', $returnid, $current_page, $dbresult->RowCount(), $rowsperpage));
					$this->smarty->assign('semname', $semname);
					$rowclass="row1";
					$r=0;
					$startn = ($current_page - 1) * $rowsperpage;
					$endn   = ($current_page * $rowsperpage) - 1;
					while ($row = $dbresult->FetchRow())
					{
						if( $r < $startn || $r > $endn )
						{
							$r++;
							continue;
						}
						$r++;
						$onerow= new stdClass();
						$onerow->semname = $this->CreateLink($id, 'edit', $returnid, $row["name"], array("semID"=>$row["semID"]));
						$onerow->rowclass = $rowclass;
									
						$onerow->adddatelink = $this->CreateLink($id, 'adddate', $returnid, $udathinzu, array("semID"=>$row["semID"],"semname"=>$row["name"]));
						$onerow->intern =$row["intern"];
						$onerow->internlinktrue = $this->CreateLink($id, 'interntrue', $returnid, $image_false, array("semID"=>$row["semID"]));
						$onerow->internlinkfalse = $this->CreateLink($id, 'internfalse', $returnid, $image_true, array("semID"=>$row["semID"]));
							
						$onerow->editsemlink = $this->CreateLink($id, 'edit', $returnid, $image_edit, array("semID"=>$row["semID"]));
						$onerow->delsemlink = $this->CreateLink($id, 'delete', $returnid, $image_delete, array("semID"=>$row["semID"]), $this->Lang('sure_delete'));
						array_push($entryarray1, $onerow);
						($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
					}
				}
				$newobjektsem=$themeObjekt->DisplayImage('icons/system/newobject.gif', $this->Lang('addseminar'),'','','systemicon');
				$newobjektsem=$this->CreateLink($id, 'add', $returnid, $newobjektsem, array(), '', false, false, '') .' '. $this->CreateLink($id, 'add', $returnid, $this->Lang('addseminar'), array(), '', false, false, 'class="pageoptions"');
				$this->smarty->assign('newobjektsem', $newobjektsem);
				$this->smarty->assign('items1', $entryarray1);
				$this->smarty->assign('itemcount1', count($entryarray1));
				echo $this->ProcessTemplate('adminsemtable.tpl');
			
			
		
			echo $this->EndTab();
			echo $this->StartTab("trainer");
			
				$rowclass="row1";
				$dbresult9 = $this->GetTrainer();
				if ($dbresult9 && $dbresult9->RowCount() > 0)
				{
					$entryarray=array();
					while ($row9 = $dbresult9->FetchRow())
					{
						$onerow= new stdClass();
						$onerow->name = $row9['name'];
						$onerow->rowclass = $rowclass;
						$onerow->deltrain = $this->CreateLink($id, 'deltrain', $returnid, $image_delete,array('trainID'=>$row9['trainID']));
						$onerow->edittrain = $this->CreateLink($id, 'edittrain', $returnid, $image_edit,array('trainID'=>$row9['trainID']));
										
						array_push($entryarray, $onerow);
						($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
					}
				}
				$newobjekt=$themeObjekt->DisplayImage('icons/system/newobject.gif', $this->Lang('addtrainer'),'','','systemicon');
				$newobjektsmart=$this->CreateLink($id, 'addtrain', $returnid, $newobjekt, array(), '', false, false, '') .' '. $this->CreateLink($id, 'addtrain', $returnid, $this->Lang('addtrainer'), array(), '', false, false, 'class="pageoptions"');
				$this->smarty->assign('newobjektsmart', $newobjektsmart);
				$this->smarty->assign('items', $entryarray);
				$this->smarty->assign('itemcount', count($entryarray));
				echo $this->ProcessTemplate('traintable.tpl');
		
		
			echo $this->EndTab();
			echo $this->StartTab("prefer");
			echo $this->CreateFormStart($id, 'updateoptions');
				$objektepref=$this->GetPreference('useobjekte', 'no');
				echo '<p>' . $this->Lang('useobjekt') . ':' . $this->CreateInputCheckbox($id, 'useobjekte', 'yes', $this->GetPreference('useobjekte', 'no')) . '</p>';

				echo $this->CreateInputSubmit($id, 'optionssubmitbutton', lang('submit'));

				echo $this->CreateFormEnd();
			echo $this->EndTab();
			echo $this->EndTabContent();
		}
		break;
		case "showcall":
		{
			check_login();
			$access = $this->CheckPermission('Modify seminarplan');
			$access1 = $this->CheckPermission('Add Roomreservation');
			$accessforall = $this->CheckPermission('Add for all Reservation');
			if (!$access && !$access1 && !$accessforall)
			{
				echo $this->ShowError($this->Lang('E_Need_AR_perm'));
			return;
			}
			if($params['gomonth']=='next' || $params['gomonth']=='back' || $params['gomonth']=='stay')
			{
				if($params['gomonth']=='next')
				{
					if($params['curmonth']<12)
					{
						$monthvalue=$params['curmonth']+1;
						$yearvalue=$params['curyear'];
					}
					else
					{
						$monthvalue='01';
						$yearvalue=$params['curyear']+1;
					}
				}
				
				if($params['gomonth']=='back')
				{
					if($params['curmonth']>1)
					{
						$monthvalue=$params['curmonth']-1;
						$yearvalue=$params['curyear'];
					}
					else
					{
						$monthvalue='12';
						$yearvalue=$params['curyear']-1;
					}
				}
				
				if($params['gomonth']=='stay')
				{
					
						$monthvalue=$params['curmonth'];
						$yearvalue=$params['curyear'];
				}
			}
			else
			{
				list($monthvalue, $yearvalue, $month_name, $days) = explode(',',strftime('%m,%Y,%B,%d',time()));
			}
			echo $this->generate_calendar2($id,$returnid,$yearvalue, $monthvalue,'');
		}
		break;
		case "reservieren":
		{
			check_login();
			$access = $this->CheckPermission('Modify seminarplan');
			$access1 = $this->CheckPermission('Add Roomreservation');
			$accessforall = $this->CheckPermission('Add for all Reservation');
			if (!$access && !$access1 && !$accessforall)
			{
				echo $this->ShowError($this->Lang('E_Need_AR_perm'));
			return;
			}
			$image_delete = $themeObjekt->DisplayImage('icons/system/delete.gif', lang('delete'),'','','systemicon');
		
			echo '<p class="error">';
			echo $params['error'];
			echo '</p>';
			$monthvalue=$params['curmonth'];
			$yearvalue=$params['curyear'];
			$dayvalue=$params['curday'];
			if(!$params['saveday'])
			{
				if($dayvalue<10)
				{
					$dayvalue='0'.$dayvalue;
				}
			}
			$day_of_month = mktime('00','00','00',$monthvalue,$dayvalue,$yearvalue);
			$day_of_month1=$dayvalue.'-'.$monthvalue.'-'.$yearvalue;
			$entryarray=$this->GetAllDaySemDates($day_of_month);
			$entryarray1=array();
// 			print_r($entryarray);
			foreach($entryarray as $row6)
			{
				if($row6['starttime2']==$day_of_month1)
				{
					$wochentag=$row6["wochentag"];
					if($wochentag==0)
					{
					$wtag= $this->lang('sonntag');
					}
					elseif($wochentag==1)
					{
					$wtag= $this->lang('montag');
					}
					elseif($wochentag==2)
					{
					$wtag= $this->lang('dienstag');
					}
					elseif($wochentag==3)
					{
					$wtag= $this->lang('mittwoch');
					}
					elseif($wochentag==4)
					{
					$wtag= $this->lang('donnerstag');
					}
					elseif($wochentag==5)
					{
					$wtag= $this->lang('freitag');
					}
					elseif($wochentag==6)
					{
					$wtag= $this->lang('samstag');
					}
					$onerow= new stdClass();
					$onerow->id = $row['usrID'];
					$onerow->wochentag = $wtag;
					$onerow->rowclass = $rowclass;
					$onerow->semname= $row6["semname"];
					$onerow->datum= $row6["starttime2"];
					$onerow->beginn = $row6["starttime1"];
					$onerow->ende = $row6["endtime1"];
					$onerow->objekt = $row6["name"];
					if($row6["intern"]== 2)
					{
						$onerow->intern = $this->Lang('intern');
					}
					else
					{
						$onerow->intern = $this->Lang('notintern');
					}
					$onerow->deldate1 = $this->CreateLink($id, 'deldate', $returnid, $image_delete,array("datID"=>$row6['datID'],"semID"=>$row6["semID"],"semname"=>$row6["semname"]));
						
					array_push($entryarray1, $onerow);
					($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
				}
			}
			$semarray=$this->GetAllSeminar();
			$semdrop=$this->GetAllInternSeminarAsDorpdown($id);
			echo '<table class="pagetable"><tr><th class="pagew50">';
			echo $this->Lang('dayoverview');
			echo '</th><th class="pagew50">';
			echo $this->Lang('reservationform');
			echo '</th></tr>';
			echo '<tr><td>';
			echo $this->generate_day_calendar2($id,$returnid,$yearvalue, $monthvalue, $dayvalue,$day_of_month,$entryarray,$semarray);
			echo '</td>';
			echo '<td valign="top">';
			$useobjektevalue=$this->GetPreference('useobjekte', 'no');
			$useobjekte=($useobjektevalue=='no'?false:true);
			if($useobjekte)
			{
			$objektemodule=$this->GetModuleInstance('objekte');
			$objektearray=$objektemodule->GetAllObjectResult();
			$objektedropdown=$objektearray->GetMenu($id.'objekt');
			}
			else
			{
				$objektedropdown=$this->CreateInputHidden($id, 'objekt', '1', '');
			}
			echo $this->DateFormReservation($id, 'completereservation', '', $day_of_month1, $objektedropdown, $entryarray1,$semdrop);
			echo '</td></tr></table>';
		
		}
		break;
		case "completereservation":
		{
			check_login();
			$access = $this->CheckPermission('Modify seminarplan');
			$access1 = $this->CheckPermission('Add Roomreservation');
			$accessforall = $this->CheckPermission('Add for all Reservation');
			if (!$access && !$access1 && !$accessforall)
			{
				echo $this->ShowError($this->Lang('E_Need_AR_perm'));
			return;
			}
			$objektID = (isset($params['objekt'])?$params['objekt']:"");
			$semID = (isset($params['semID'])?$params['semID']:"");
			if (isset($params['cancelsubmit']))
			{
				$this->Redirect($id, 'defaultadmin');
			}
			$validinfo = true;
			$error="";
			list($days,$monthvalue, $yearvalue) = explode('-',$params['datum']);
			if (isset($params['startdate_Hour']))
			{
				$startdate = date("Y-m-d H:i:s", mktime($params['startdate_Hour'], $params['startdate_Minute'], $params['startdate_Second'], $monthvalue, $days, $yearvalue));
				$enddate = date("Y-m-d H:i:s", mktime($params['enddate_Hour'], $params['enddate_Minute'], $params['enddate_Second'], $monthvalue, $days, $yearvalue));
			}
			else
			{
				$validinfo = false;
				$error.=$this->Lang('ferrnotstarttime');
			}
			if($semID == '')
			{
				$validinfo = false;
				$error.=$this->Lang('ferrnosem');
			}
			if($validinfo)
			{
			$querystart= "INSERT INTO ".cms_db_prefix()."module_seminarplandates (semID, starttime, endtime, objectID";
			$queryend .= ") VALUES (?,?,?,?";
			$params = array($semID, $startdate, $enddate, $objektID);
			$query = $querystart . $queryend . ")";
			$dbresult8 = $db->Execute($query, $params);
			$this->Audit($semID, 'seminarplan', 'Neuen Termin hinzugefgt');
			$params="";
			$params['curmonth']=$monthvalue;
						$params['curyear']=$yearvalue;
						$params['curday']=$days;
						$params['saveday']=true;
						
			$this->Redirect( $id,'reservieren',$returnid,$params);
			}
			else
			{
			$params="";
			$params['error']=$error;
			$params['curmonth']=$monthvalue;
						$params['curyear']=$yearvalue;
						$params['curday']=$days;
			$this->Redirect( $id,'reservieren',$returnid,$params);
			}
		}
		break;
		case "edit":
		{
			check_login();
			$access = $this->CheckPermission('Modify seminarplan');
			if (!$access)
			{
			//Showing error
				echo $this->ShowError($this->Lang('E_Need_MS_perm'));
			return;
			}
			$semID = (isset($params['semID'])?$params['semID']:'');
			$query = "SELECT ".cms_db_prefix()."module_seminarplan.name,".cms_db_prefix()."module_seminarplan.info, ".cms_db_prefix()."module_seminarplan.train, ".cms_db_prefix()."module_seminarplan.energie, ".cms_db_prefix()."module_seminarplan.intern, ".cms_db_prefix()."module_seminarplan.semID,"
			.cms_db_prefix()."module_seminarplantrain.trainID,"
			.cms_db_prefix()."module_seminarplantrain.name AS trainname FROM ".cms_db_prefix()."module_seminarplan INNER JOIN "
			.cms_db_prefix()."module_seminarplantrain ON ".cms_db_prefix()."module_seminarplan.train = "
			.cms_db_prefix()."module_seminarplantrain.trainID WHERE semID = ?";
			$dbresult = $db->Execute($query, array($semID));
			if ($dbresult && $dbresult->RowCount() >0)
			{
			$row = $dbresult->FetchRow();
			$name = $row["name"];
			$info = $row["info"];
			$train = $row["train"];
			$trainname = $row["trainname"];
			$energie = $row["energie"];
			$intern = $row['intern'];
			$query2 = "SELECT name,trainID FROM "
			.cms_db_prefix()."module_seminarplantrain ORDER BY name";
			$dbresult2 = $db->Execute($query2);
			$onerow=$dbresult2->GetMenu($id.'train',$trainname , false);
			$this->AdminForm($id, 'completeedit', '', $name, $info, $train, $energie, $semID,$onerow,$intern);
			}
		}
		break;
		case "completeedit":
		{
		check_login();
			$access = $this->CheckPermission('Modify seminarplan');
			if (!$access)
			{
			//Showing error
				echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
			}
			if (isset($params['cancelsubmit']))
			{
			$this->Redirect($id, 'defaultadmin');
			return;
			}
			$validinfo = true;
			$error = '';
			$semID = (isset($params['semID'])?$params['semID']:"");
			$name = (isset($params['name'])?$params['name']:"");
			$info = (isset($params['info'])?$params['info']:"");
			$train = (isset($params['train'])?$params['train']:"");
			$energie = (isset($params['energie'])?$params['energie']:"");
			$intern = (isset($params['intern'])?$params['intern']:'1');
			if ($name == "")
			{
				$error .= "<li>Keinen namen vergeben</li>";
				$validinfo = false;
			}
		
			if ($validinfo)
			{
				$query = "UPDATE ".cms_db_prefix()."module_seminarplan SET ";
				$query.= "name = ?, info = ?, train = ?, energie = ?, intern = ?";
				$params = array($name, $info, $train, $energie, $intern);
				$query .= " WHERE semID = ?";
				array_push($params, $semID);
				$dbresult = $db->Execute($query, $params);
				$this->Audit($semID, 'seminarplan', 'Bearbeite Veranstalltungs eintrag');
				$this->Redirect($id, 'defaultadmin');
				return;
			}
			else
			{
				$this->AdminForm($id, 'completeadd', $error, $name, $info, $train, $energie, $semID);
			}
		}
		break;
		case "add":
		{
		check_login();
			$access = $this->CheckPermission('Modify seminarplan');
				if (!$access)
				{
				//Showing error
					echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
				}
		$dbresult = $this->GetTrainer();
		$onerow=$dbresult->GetMenu($id.'train','',false);
		$this->AdminForm($id, 'completeadd', '', '', '', '', '', '', $onerow,'');
		}
		break;
		case "completeadd":
		{
		check_login();
			$access = $this->CheckPermission('Modify seminarplan');
			if (!$access)
			{
			//Showing error
				echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
			}
			$error = '';
			if (isset($params['cancelsubmit']))
			{
				$this->Redirect($id, 'defaultadmin');
			}
			$validinfo = true;
			$name = (isset($params['name'])?$params['name']:"");
			$info = (isset($params['info'])?$params['info']:"");
			$train = (isset($params['train'])?$params['train']:"");
			$energie = (isset($params['energie'])?$params['energie']:"");
			$intern = (isset($params['intern'])?$params['intern']:'1');
		
			if ($name == "")
			{
				$error .= "<li>Kein Name eingegeben</li>";
				$validinfo = false;
			}
			if ($train == "")
			{
				$error .= "<li>Kein train eingegeben</li>";
				$validinfo = false;
			}
			if ($info == "")
			{
				$error .= "<li>Kein info eingegeben</li>";
				$validinfo = false;
			}
			if ($energie == "")
			{
				$error .= "<li>Kein energie eingegeben</li>";
				$validinfo = false;
			}
			if ($validinfo)
			{
				$new_id = $db->GenID(cms_db_prefix()."module_seminarplan_seq");
				$querystart= "INSERT INTO ".cms_db_prefix()."module_seminarplan ";
				$querystart.="(name, energie, train, info, intern";
				$queryend .= ") VALUES (?,?,?,?,?";
				$params = array($name, $energie, $train, $info, $intern);
				$query = $querystart . $queryend . ")";
				$dbresult = $db->Execute($query, $params);
				$this->Audit($semID, 'seminarplan', 'Neuen Termin hinzugefgt');
				$this->Redirect($id, 'defaultadmin');
				return;
			}
			else
			{
				$this->AdminForm($id, 'completeadd', $error, $name, $info, $train, $energie,  $semID);
			}
		}
		break;
		case "addtrain":
		{
		check_login();
			$access = $this->CheckPermission('Modify seminarplan');
				if (!$access)
				{
				//Showing error
					echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
				}
		$this->TrainForm($id, 'completeaddtrain', '', '', '');
		}
		break;
		
		case "completeaddtrain":
		{
		check_login();
			$access = $this->CheckPermission('Modify seminarplan');
				if (!$access)
				{
				//Showing error
					echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
				}
		if (isset($params['cancelsubmit']))
		{
		$this->Redirect($id, 'defaultadmin');
		}
		$name = (isset($params['name'])?$params['name']:"");
		$new_id = $db->
		GenID(cms_db_prefix()."module_seminarplan_seq");
		$querystart= "INSERT INTO ".cms_db_prefix()."module_seminarplantrain (trainID, name";
		$queryend .= ") VALUES (?,?";
		$params = array($trainID, $name);
		$query = $querystart . $queryend . ")";
		$dbresult8 = $db->
		Execute($query, $params);
		$this->
		Audit($semID, 'seminarplan', 'Neuen Termin hinzugefgt');
		$this->
		Redirect($id, 'defaultadmin');
		return;
		}
		break;
		case "edittrain":
		{
		check_login();
			$access = $this->CheckPermission('Modify seminarplan');
				if (!$access)
				{
				//Showing error
					echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
				}
				$trainID = (isset($params['trainID'])?$params['trainID']:'');
				$trainresult=$this->GetTrainerbyID($trainID);
				if ($trainresult && $trainresult->RowCount() > 0)
				{
					while (($trainrow = $trainresult->FetchRow()))
					{
						$name=$trainrow['name'];
						$traininfo=$trainrow['traininfo'];
					}
					$this->TrainForm($id, 'completeedittrain', '', $name, $trainID, $traininfo);
				}
		
		}
		break;
		case "completeedittrain":
		{
		check_login();
			$access = $this->CheckPermission('Modify seminarplan');
			if (!$access)
			{
			//Showing error
				echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
			}
			if (isset($params['cancelsubmit']))
			{
			$this->Redirect($id, 'defaultadmin');
			return;
			}
			$validinfo = true;
			$error = '';
			$trainID = (isset($params['trainID'])?$params['trainID']:'');
			$name = (isset($params['name'])?$params['name']:"");
			$traininfo = (isset($params['traininfo'])?$params['traininfo']:'');
			if ($name == "")
			{
				$error .= "<li>Keinen namen vergeben</li>";
				$validinfo = false;
			}
		
			if ($validinfo)
			{
				$query = "UPDATE ".cms_db_prefix()."module_seminarplantrain SET ";
				$query.= "name = ?, traininfo = ?";
				$params = array($name, $traininfo);
				$query .= " WHERE trainID = ?";
				array_push($params, $trainID);
				$dbresult = $db->Execute($query, $params);
				$this->Audit($semID, 'seminarplan', 'Bearbeitete Trainer eintrag');
				$this->Redirect($id, 'defaultadmin');
				return;
			}
			else
			{
				$this->TrainForm($id, 'completeedittrain', $error, $name, $trainID, $traininfo);
			}
		}
		break;
		case "adddate":
		{
		check_login();
			$access = $this->CheckPermission('Modify seminarplan');
				if (!$access)
				{
				//Showing error
					echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
				}
				$useobjektevalue=$this->GetPreference('useobjekte', 'no');
			$useobjekte=($useobjektevalue=='no'?false:true);
			if($useobjekte)
			{
			$objektemodule=$this->GetModuleInstance('objekte');
			$objektearray=$objektemodule->GetAllObjectResult();
			$objektarray=$objektearray;
			
			$objektedropdown=$objektearray->GetMenu($id.'objekt');
			}
			else
			{
				$objektedropdown=$this->CreateInputHidden($id, 'objekt', '1', '');
			}
			$image_delete = $themeObjekt->DisplayImage('icons/system/delete.gif', lang('delete'),'','','systemicon');
			$semID = (isset($params['semID'])?$params['semID']:"");
			$semname = (isset($params['semname'])?$params['semname']:"");
			$query6 = "SELECT sd.datID, sd.semID, sd.objectID, sd.intern,";
			$query6 .= " DATE_FORMAT(sd.starttime,'%H:%i') AS starttime1,";
			$query6 .= " DATE_FORMAT(sd.starttime,'%w') AS wochentag,";
			$query6 .= " DATE_FORMAT(sd.starttime,'%d-%m-%Y') AS starttime2,";
			$query6 .= " DATE_FORMAT(sd.endtime,'%H:%i') AS endtime1, o.objID, o.name FROM ";
			$query6 .= cms_db_prefix()."module_seminarplandates AS sd INNER JOIN ";
			$query6 .= cms_db_prefix()."module_objekte AS o ON sd.objectID=o.objID WHERE semID=?";
			$query6 .= " ORDER BY starttime1";
			$dbresult6 = $db->Execute($query6,array($semID));
			if ($dbresult6 && $dbresult6->RowCount() > 0)
			{
			$entryarray= array();
			while (($row6 = $dbresult6->FetchRow()))
			{
			$wochentag=$row6["wochentag"];
			if($wochentag==0)
			{
			$wtag= $this->lang('sonntag');
			}
			elseif($wochentag==1)
			{
			$wtag= $this->lang('montag');
			}
			elseif($wochentag==2)
			{
			$wtag= $this->lang('dienstag');
			}
			elseif($wochentag==3)
			{
			$wtag= $this->lang('mittwoch');
			}
			elseif($wochentag==4)
			{
			$wtag= $this->lang('donnerstag');
			}
			elseif($wochentag==5)
			{
			$wtag= $this->lang('freitag');
			}
			elseif($wochentag==6)
			{
			$wtag= $this->lang('samstag');
			}
			$onerow= new stdClass();
						$onerow->id = $row['usrID'];
						$onerow->wochentag = $wtag;
						$onerow->rowclass = $rowclass;
						$onerow->datum= $row6["starttime2"];
						$onerow->beginn = $row6["starttime1"];
						$onerow->ende = $row6["endtime1"];
						$onerow->objekt = $row6["name"];
						if($row6["intern"]== 2)
						{
							$onerow->intern = $this->Lang('notintern');
						}
						else
						{
							$onerow->intern = $this->Lang('intern');
						}
						$onerow->deldate = $this->CreateLink($id, 'deldate', $returnid, $image_delete,array("datID"=>$row6['datID'],"semID"=>$semID,"semname"=>$semname));
							
						array_push($entryarray, $onerow);
						($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
						
					}
					}
					
		$this->DateForm($id, 'completeadddate', '', '', '', $entryarray, $semID, $semname, $objektedropdown);
		}
		break;
		case "completeadddate":
		{
		check_login();
			$access = $this->CheckPermission('Modify seminarplan');
			if (!$access)
			{
				//Showing error
				echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
			}
			$objektID = (isset($params['objekt'])?$params['objekt']:"");
			$semID = (isset($params['semID'])?$params['semID']:"");
			if (isset($params['cancelsubmit']))
			{
				$this->Redirect($id, 'defaultadmin');
			}
			$validinfo = true;
			$error="";
			if (isset($params['startdate_Month']))
			{
				$startdate = date("Y-m-d H:i:s", mktime($params['startdate_Hour'], $params['startdate_Minute'], $params['startdate_Second'], $params['startdate_Month'], $params['startdate_Day'], $params['startdate_Year']));
				$enddate = date("Y-m-d H:i:s", mktime($params['enddate_Hour'], $params['enddate_Minute'], $params['enddate_Second'], $params['startdate_Month'], $params['startdate_Day'], $params['startdate_Year']));
			}
			else
			{
				$validinfo = false;
				$error.=$this->Lang('ferrnotstarttime');
			}
			$querystart= "INSERT INTO ".cms_db_prefix()."module_seminarplandates ";
			$querystart.="(semID, starttime, endtime, objectID";
			$queryend .= ") VALUES (?,?,?,?";
			$params = array($semID, $startdate, $enddate, $objektID);
			$query = $querystart . $queryend . ")";
			$dbresult8 = $db->Execute($query, $params);
			$this->Audit($semID, 'seminarplan', 'Neuen Termin hinzugefgt');
			$this->Redirect($id, 'defaultadmin');
		return;
		}
		break;
		case "deldate":
		{
		check_login();
			$access = $this->CheckPermission('Modify seminarplan');
				if (!$access)
				{
				//Showing error
					echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
				}
			$query = "DELETE FROM ".cms_db_prefix()."module_seminarplandates WHERE datID = ?";
			$dbresult = $db->Execute($query, array($params['datID']));
			$this->Audit($params['semID'], 'seminarplan', 'Deleted Seminarplandate');
			$this->DoAction('adddate', $id, $params, '');
		}
		break;
		case "deltrain":
		{
		check_login();
			$access = $this->CheckPermission('Modify seminarplan');
				if (!$access)
				{
				//Showing error
					echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
				}
				$trainID = (isset($params['trainID'])?$params['trainID']:"");
				if ($trainID == "")
			{
				$error .= "<li>Keinen Trainer ausgesucht</li>";
				$validinfo = false;
			}
		
			if ($validinfo)
			{
			$query = "DELETE FROM ".cms_db_prefix()."module_seminarplantrain WHERE trainID = ?";
			$dbresult = $db->Execute($query, array($trainID));
			$this->Audit($params['trainID'], 'seminarplan', 'Deleted Trainer');
			}
			$this->Redirect($id, 'defaultadmin');
		}
		break;
		case "delete":
		{
		check_login();
			$access = $this->CheckPermission('Modify seminarplan');
				if (!$access)
				{
				//Showing error
					echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
				}
		$query = "DELETE FROM ".cms_db_prefix()."module_seminarplan WHERE semID = ?";
		$dbresult = $db->Execute($query, array($params['semID']));
		$this->Audit($params['semID'], 'seminarplan', 'Deleted Seminarplan Item');
		$this->Redirect($id, 'defaultadmin', $returnid);
		}
		break;
		case "updateoptions":
		{
		check_login();
			$access = $this->CheckPermission('Modify seminarplan');
				if (!$access)
				{
				//Showing error
					echo $this->ShowError($this->Lang('E_Need_MS_perm'));
				return;
				}
			if(isset($params['useobjekte']) && $params['useobjekte']=='yes')
			{
				$this->SetPreference('useobjekte', 'yes');
			}
			else
			{
				$this->SetPreference('useobjekte', 'no');
			}
			$this->Redirect($id, 'defaultadmin');
		}
		break;

	}
	}
	
		/**
		*This returns HTML information on the module.
		*
		*Typically, you'll want to include information on how to
		*use the module.
		*See the Languagefile at /lang/
		*/
		
	function GetHelp($lang='en_US')
	{
		return $this->Lang('help');
	}
	
		/**
		*This returns a string that is presented in the Module<br/>
		*Admin if you click on the "About" link.
		*/
		
	function GetAuthor()
	{
		return 'Krisztian Kishazi';
	}
	
		/**
		*This returns a string that is presented in the Module<br/>
		* Admin if you click on the "About" link.
		*
		*It helps users of your module get in touch with you to send </br>
		*bug reports,questions, cases of beer, and/or large sums of money.
		*/
	
	function GetAuthorEmail()
	{
		return 'krisztian.kishazi@expectmore.at';
	}
	
		/**
		*This returns a string that is presented in the module<br/>
		* Admin if you click on the About link.
		* 
		*It helps users figure out what's changed between releases.<br/>
		*See the note on localization at the top of this file.
		*/
	
	function GetChangeLog()
	{
		return $this->Lang('changelog');
	}
	
// 	function GetURL()
// 	{
// 	global $config;
// 		$url = "";
// 
// 		if ($config["assume_mod_rewrite"])
// 		{
// 			if ($this->mAlias != '')
// 			{
// 				$url = $config["root_url"]."/".$this->mAlias.$config["page_extension"];
// 			}
// 			else
// 			{
// 				$url = $config["root_url"]."/".$this->mId.$config["page_extension"];
// 			}
// 		}
// 		else
// 		{
// 			if ($this->mAlias != '')
// 			{
// 				$url = $config["root_url"]."/index.php?".$config["query_var"]."=".$this->mAlias;
// 			}
// 			else
// 			{
// 				$url = $config["root_url"]."/index.php?".$config["query_var"]."=".$this->mId;
// 			}
// 		}
// 
// 		return $url;
// 	}
	function GetURL()
	{
	global $gCms;
	$config = $gCms->config;
	$url = "";
	if ($config['assume_mod_rewrite'])
	{
	$url = $config['root_url'].'/'.$gCms->variables['page'];
	$url .= $config['page_extension'];
	}
	else
	{
		$url = $config['root_url'].'/index.php?'.$config['query_var'].'='.$gCms->variables['page'];
	}
	return $url;
	}
	
}//SeminarplanModulclass Ends

/**
* SeminarplanModule Contenttype Descreption
*
*What does it do?<br/>
*The seminarplanModule Class extends the Contenttypes.<br/>
*It would be created to allow users quickr acces to this modul<br/>
*
*@package Seminarplancontentypes
*@subpackage CMSModuleContentType
*@author Krisztian Kishyzi<support@expectmore.at>
*@version 0.3 16/01/2005 09:53
*/
class seminarplanModule extends CMSModuleContentType
{
	function SetProperties()
	{
		#Turn on preview
		$this->mPreview = true;

	}
	
	function GetTabDefinitions()
	{
		return array('Basic', 'Advanced');
		#return array();
	}
	
	function TabNames()
	{
		return array(lang('main'), lang('options'));
	}

  	function EditAsArray($adding = false, $tab = 0, $showadmin = false)
	{
		global $gCms;
		$config = $gCms->config;

		$ret = array();
		$userid = get_userid();
		$access = check_ownership($userid, $content_id) || check_permission($userid, 'Modify Any Page');
		$adminaccess = $access;
		if (!$access)
		{
			$access = check_authorship($userid, $content_id);
		}
		
		if ($access)
		{
		if($tab==0)
		{
			array_push($ret,array(lang('title').':','<input type="text" name="title" value="'.$this->mName.'">'));
			array_push($ret,array(lang('menutext').':','<input type="text" name="menutext" value="'.$this->mMenuText.'">'));
			#if (!($config['auto_alias_content'] == true && $this->mAlias == ''))
			if (!($config['auto_alias_content'] == true && $adding))
			{
				array_push($ret,array(lang('pagealias').':','<input type="text" name="alias" value="'.$this->mAlias.'">'));
			}
			array_push($ret,array(lang('template').':',TemplateOperations::TemplateDropdown('template_id', $this->mTemplateId)));
			array_push($ret,array(lang('parent').':',ContentManager::CreateHierarchyDropdown($this->mId, $this->mParentId)));
		}
		if($tab==1)
		{
			
			array_push($ret,array(lang('active').':','<input type="checkbox" name="active"'.($this->mActive?' checked="1"':'').'>'));
			array_push($ret,array(lang('showinmenu').':','<input type="checkbox" name="showinmenu"'.($this->mShowInMenu?' checked="true"':'').'>'));
			array_push($ret, array(lang('cachable').':','<input class="pagecheckbox" type="checkbox" name="cachable"'.($this->mCachable?' checked="checked"':'').' />'));
			if (!$adding && $showadmin)
			{
				array_push($ret, array('Owner:',@UserOperations::GenerateDropdown($this->Owner())));
			}
			if ($adding || $showadmin)
			{
				array_push($ret,$this->ShowAdditionalEditors());
			}
		}
		}
		else
		{
			array_push($ret,array('ERROR:','you have no permission to'));
		}
		return $ret;
	}
	
	function ModuleName()
	{
		return 'seminarplan';
	}
	
  	function Edit($adding = false)
	{
		global $gCms;
		$config = $gCms->config;

		$text = '';

		$text .= '<tr><td>'.lang('title').':</td><td><input type="text" name="title" value="'.$this->mName.'"></td></tr>';
		$text .= '<tr><td>'.lang('menutext').':</td><td><input type="text" name="menutext" value="'.$this->mMenuText.'"></td></tr>';
		#if (!($config['auto_alias_content'] == true && $this->mAlias == ''))
		if (!($config['auto_alias_content'] == true && $adding))
		{
			$text .= '<tr><td>'.lang('pagealias').':</td><td><input type="text" name="alias" value="'.$this->mAlias.'"></td></tr>';
		}
		$text .= '<tr><td>'.lang('template').':</td><td>'.TemplateOperations::TemplateDropdown('template_id', $this->mTemplateId).'</td></tr>';
		$text .= '<tr><td>'.lang('active').':</td><td><input type="checkbox" name="active"'.($this->mActive?' checked="true"':'').'></td></tr>';
		$text .= '<tr><td>'.lang('showinmenu').':</td><td><input type="checkbox" name="showinmenu"'.($this->mShowInMenu?' checked="true"':'').'></td></tr>';
		$text .= '<tr><td>'.lang('parent').':</td><td>'.ContentManager::CreateHierarchyDropdown($this->mId, $this->mParentId).'</td></tr>';
		$text .= '<tr><td>'.lang('parent').':</td><td>'.ContentManager::GetAdditionalEditors().'</td></tr>';

		return $text;
	}
	
	function Show()
	{
		global $gCms;

		$params = array();
			
			

		$seminarplan = new seminarplan();

		//Buffer all this crap spit out by the News module and return it
		@ob_start();
		$seminarplan->DoAction('default', 'seminarplanmodule', $params);
		$text .= @ob_get_contents();
		@ob_end_clean();
		return $text;
	}
	
	function IsDefaultPossible()
	{
		return TRUE;
	}
	
	function GetURL()
	{
	global $gCms;
	$config = $gCms->config;
		$url = "";

		if ($config["assume_mod_rewrite"])
		{
			if ($this->mAlias != '')
			{
				$url = $config["root_url"]."/".$this->mAlias.$config["page_extension"];
			}
			else
			{
				$url = $config["root_url"]."/".$this->mId.$config["page_extension"];
			}
		}
		else
		{
			if ($this->mAlias != '')
			{
				$url = $config["root_url"]."/index.php?".$config["query_var"]."=".$this->mAlias;
			}
			else
			{
				$url = $config["root_url"]."/index.php?".$config["query_var"]."=".$this->mId;
			}
		}

		return $url;
	}
  
	function FillParams(&$params)
	{
	global $gCms;
	$config = $gCms->config;
		if (isset($params['title']))
		{
			$this->mName = $params['title'];
		}
		if (isset($params['menutext']))
		{
			$this->mMenuText = $params['menutext'];
		}
		if (isset($params['template_id']))
		{
			$this->mTemplateId = $params['template_id'];
		}
		if (isset($params['alias']))
		{
			$this->SetAlias($params['alias']);
		}
		else
		{
			$this->SetAlias('');
		}
		if (isset($params['parent_id']))
		{
			if ($this->mParentId != $params['parent_id'])
			{
				$this->mHierarchy = '';
				$this->mItemOrder = -1;
			}
			$this->mParentId = $params['parent_id'];
		}
		if (isset($params['active']))
		{
			$this->mActive = true;
		}
		else
		{
			$this->mActive = false;
		}
		if (isset($params['showinmenu']))
		{
			$this->mShowInMenu = true;
		}
		else
		{
			$this->mShowInMenu = false;
		}
		$addtarray = array();
		$sizeofaddeditor=sizeof($params["additional_editors"]);
		if($sizeofaddeditor >0)
		{
			foreach ($params["additional_editors"] as $addt_user_id)
			{
				array_push($addtarray, $addt_user_id);
			}
			$this->SetAdditionalEditors($addtarray);
		}
		if (isset($params['cachable']))
			{
				$this->mCachable = true;
			}
			else
			{
				$this->mCachable = false;
			}	
	}
	
	function FriendlyName()
	{
		return 'Seminarplan';
	}
}
    # vim:ts=4 sw=4 noet
?>