<?php

require_once 'class.Playlist.php';

class PlaylistManager
{
	var $db;
	
	function PlaylistManager(&$db)
	{
		$this->db =& $db;
	}
	
	function addPlaylist(&$playlist)
	{
		$errors = array();
		$ret = array();
		
		if (trim($playlist->Name) == '')
		{
			$errors[] = 'no_name';
		}
		
		if (empty($errors))
		{
			$new_id = $this->db->GenID(cms_db_prefix() . 'module_exspf_playlist_seq');
			$query = "
				INSERT INTO " . cms_db_prefix(). "module_exspf_playlist
				(id, name, description)
					VALUES
				(?, ?, ?)
			";
			$result = $this->db->Execute(
				$query, 
				array($new_id, $playlist->Name, $playlist->Description)
			);
			if ($result)
			{
				$ret['new_id'] = $new_id;
			}
		}
		$ret['errors'] = $errors;
		return $ret;
	}
	
	function editPlaylist($playlist_id, &$playlist)
	{
		$errors = array();
		if (trim($playlist->Name) == '')
		{
			$errors[] = 'no_name';
		}
		
		if (!empty($errors))
		{
			return $errors;
		}
		else
		{
			$query = "
				UPDATE " . cms_db_prefix(). "module_exspf_playlist
				SET name = ?, description = ?
				WHERE id = '$playlist_id'
			";
			$result = $this->db->Execute(
				$query, 
				array($playlist->Name, $playlist->Description)
			);
			if (!$result)
			{
				$errors[] = 'db_error';
			}
		}
		return $errors;
	}
	
	function & getPlaylistById($playlist_id, $load_songs=true)
	{
		require_once 'class.Playlist.php';
		$query = "
			SELECT name, description FROM " . cms_db_prefix(). "module_exspf_playlist
			WHERE
			id = ?
		";
		$result = $this->db->Execute($query, array($playlist_id));
		$row = $result->FetchRow();
		if ($result && $result->RecordCount() == 1)
		{
			$playlist =& new Playlist($row['name'], $row['description']);
			if ($load_songs)
			{
				$playlist->setSongs($this->getPlaylistSongs($playlist_id));
			}
			return $playlist;
		}
	}
	
	function getPlaylistSongs($playlist_id)
	{
		require_once 'class.Song.php';
		$songs = array();
		$query = "
			SELECT upload_id 
			FROM " . cms_db_prefix(). "module_exspf_playlist_song
			WHERE
			playlist_id = ?
			ORDER BY position
		";
		$result = $this->db->Execute($query, array($playlist_id));
		if ($result && $result->RecordCount() > 0)
		{
			foreach  ($result->GetRows() as $row)
			{
				$details = $this->getFileDetails($row['upload_id']);
				if ($details)
				{
					$song =& new Song($row['upload_id']);
					$this->setSongDetails($song, $details);
					$songs[$row['upload_id']] =& $song;
				}
			}
		}
		return $songs;
	}
	
	function getFileDetails($file_id)
	{
		$db =& $this->db;
		$query = "
			SELECT * FROM " . cms_db_prefix() . "module_uploads u
			LEFT JOIN " . cms_db_prefix(). "module_uploads_categories c
				ON c.upload_category_id = u.upload_category_id
			WHERE u.upload_id = ?
		";
		$result = $db->Execute($query, array($file_id));
		if ($result)
		{
			$row = $result->FetchRow();
			return $row;
		}
		return;
	}
	
	function setSongDetails(&$song, $details)
	{
		$song->setUploadCategoryPath($details['upload_category_path']);
		$song->setFilename($details['upload_name']);
		$song->setSummary($details['upload_summary']);
		$song->setDescription($details['upload_description']);
		$song->setAuthor($details['upload_author']);
		$song->setThumb($details['upload_thumbnail']);
	}
	
	function getThumb($config, $song)
	{
		$thumb_path = cms_join_path($config['root_path'], 'uploads', $song->UploadCategoryPath, $song->Thumb);
		$thumb_url = $config['root_url'] . '/uploads/' . $song->UploadCategoryPath . '/' . $song->Thumb;
		if(file_exists($thumb_path))
		{
			return $thumb_url;
		}
	}
}

?>
