<?php

if (!isset($gCms)) 
{
	exit(); 
}

check_login();

if (! $this->CheckPermission('Use Enhanced XSPF'))
{
	echo $this->ShowErrors($this->Lang('err_access_denied'));
	return;
}

require_once cms_join_path('lib', 'classes', 'class.PlaylistManager.php');

$playlist_manager =& new PlaylistManager($this->cms->db);
$themeObject  = (isset($this->cms->variables['admintheme']) ? $this->cms->variables['admintheme'] : '');
$image_edit   = $themeObject->DisplayImage('icons/system/edit.gif'  , lang('edit')         , '', '', 'systemicon');
$image_delete = $themeObject->DisplayImage('icons/system/delete.gif', lang('delete')       , '', '', 'systemicon');

$query = 'SELECT id, name, description FROM ' . cms_db_prefix() . 'module_exspf_playlist ORDER BY id';
$result = $db->Execute($query);
$playlist_rows = array();
if ($result && $result->RecordCount() > 0)
{
	while ($row = $result->FetchRow())
	{
		$onerow =& new StdClass();
		
		require_once cms_join_path('lib', 'classes', 'class.Playlist.php');
		$playlist =& $playlist_manager->getPlaylistById($row['id']);
		$onerow->Playlist = $playlist;
		$onerow->Id = $row['id'];
		$onerow->EditLink   = $this->CreateLink($id, 'admin_edit_playlist'  , $returnid, $image_edit  , array('playlist_id' => $row['id']));
		$onerow->DeleteLink = $this->CreateLink($id, 'admin_delete_playlist', $returnid, $image_delete, array('playlist_id' => $row['id']), $this->Lang('alert_delete_playlist', $row['id'] . ' - ' . $playlist->Name));
		
		$playlist_rows[] = $onerow;
	}
}
$this->smarty->assign('playlist_rows', $playlist_rows);
$this->smarty->assign('header_admin_playlists', $this->Lang('header_admin_playlists'));

$this->smarty->assign(
	'add_playlist_icon',
	$this->CreateLink(
		$id,
		'admin_add_playlist',
		$returnid,
		$this->cms->variables['admintheme']->DisplayImage(
			'icons/system/newobject.gif', $this->Lang('title_link_add_playlist'), '', '', 'systemicon'
		),
		array(),
		'',
		false,
		false,
		''
	)
);
$this->smarty->assign(
	'add_playlist_link',
 	$this->CreateLink(
		$id, 
		'admin_add_playlist', 
		$returnid, 
		$this->Lang('title_link_add_playlist'), 
		array(), 
		'', 
		false, 
		false, 
		'class="pageoptions"'
	)
);

$this->smarty->assign(
	'tableheaders',
	array(
		'id' => $this->Lang('id'),
		'name' => $this->Lang('name'),
		'description' => $this->Lang('description'),
		'songs' => $this->Lang('songs'),
		'edit' => lang('edit'),
		'delete' => lang('delete')
	)
);

?>