<?php

if (!isset($gCms)) 
{
	exit(); 
}

check_login();

if (! $this->CheckPermission('Use Enhanced XSPF'))
{
	echo $this->ShowErrors($this->Lang('err_access_denied'));
	return;
}

$messages = isset($params['messages']) ? $params['messages'] : array();
$errors   = isset($params['errors'])   ? $params['errors']   : array();

require_once cms_join_path('lib', 'classes', 'class.EnhancedXSPFAdmin.php');
require_once cms_join_path('lib', 'classes', 'class.PlaylistManager.php');

$playlist_manager =& new PlaylistManager($this->cms->db);
$playlist = $playlist_manager->getPlaylistById($params['playlist_id'], false);

if (isset($params['cancel']))
{
	return $this->doAction('defaultadmin', $id, $params, $returnid);
}
elseif (isset($_GET['submitted']))
{
	$submitted_playlist =& new Playlist($_GET['m1_playlist_name'], $_GET['m1_playlist_description']);
	
	$errors = $playlist_manager->editPlaylist($params['playlist_id'], $submitted_playlist);
	if (!empty($errors))
	{
		foreach ($errors as $index => $error)
		{
			$errors[$index] = $this->ShowErrors($this->Lang('err_admin_add_playlist_'. $error));
		}
	}
	else
	{
		if ($submitted_playlist != $playlist)
		{
			$messages[] = $this->Lang('msg_playlist_updated');
			$this->Audit($params['playlist_id'], $this->GetFriendlyName(), $this->Lang('audit_admin_playlist_changed'));
		}
		
		$query = "DELETE FROM " . cms_db_prefix() . "module_exspf_playlist_song WHERE playlist_id = ?";
		$db->Execute($query, array($params['playlist_id']));
		$songs = isset($_GET['selected_songs']) ? $_GET['selected_songs'] : array();
		foreach ($songs as $index => $upload_id)
		{
			$query = "
				INSERT INTO " .  cms_db_prefix() . "module_exspf_playlist_song 
				(playlist_id, upload_id, position) 
				VALUES
				(?, ?, ?)
			";
			$db->Execute($query, array($params['playlist_id'], $upload_id, $index + 1));
		}
		
		$this->Audit($params['playlist_id'], $this->GetFriendlyName(), $this->Lang('audit_admin_playlist_songs_saved'));
		$messages[] = $this->Lang('msg_playlist_songs_updated');
		$params['messages'] = $messages;
		return $this->doAction('defaultadmin', $id, $params, $returnid);
	}
}

// create an Admin object
$admin =& new EnhancedXSPFAdmin($this->cms->smarty, $this->cms->db, $params);

// create the tabheaders
$tabheaders = array();
foreach ($admin->getTabs() as $tabname)
{
	$tabheaders[] = $this->SetTabHeader($tabname, $this->Lang('title_admintab_' . $tabname), ($admin->getActiveTab() == $tabname));
}

// create the tabs content
$tabcontent = array();
foreach ($admin->getTabs() as $tabname)
{
	$tab = array();
	$tab['start'] = $this->StartTab($tabname);
	if ($tabname == 'playlists')
	{
		$playlist =& $playlist_manager->getPlaylistById($params['playlist_id']);
		$playlist->Id = $params['playlist_id'];
		
		$uploads = $this->GetModuleInstance('Uploads');
		
		$this->smarty->assign('playlist', $playlist);
		
		$category_list = $uploads->getCategoryList();
		$filelist = array();
		if (!empty($category_list))
		{
			foreach($category_list as $category)
			{
				$filelist = array_merge($filelist, $uploads->getFileList($category));
			}
		}
		
		$files = array();
		foreach ($filelist as $filename => $file_id)
		{
			$file_name = trim ($filename);
		    $extension = strtolower(strrchr($file_name, '.'));
			if ($extension != '.mp3')
			{
				unset($filelist[$filename]);
			}
			else
			{
				$files[] = $uploads->GetUploadDetails($file_id, $returnid);
			}
		}
		$rows = array();
		if (empty($files))
		{
			$errors[] = $this->ShowErrors($this->Lang('err_no_mp3s_found'));
		}
		else
		{
			foreach ($files as $mp3)
			{
				if (!isset($playlist->Songs[$mp3['upload_id']]))
				{
					require_once cms_join_path('lib', 'classes', 'class.Song.php');

					$song =& new Song($mp3['upload_id']);
					$song->setFilename($mp3['upload_name']);
					$song->setSummary($mp3['upload_summary']);
					$song->setDescription($mp3['upload_description']);
					$song->setAuthor($mp3['upload_author']);
					$onerow =& new StdClass();
					$onerow->Id = $song->UploadId;
					$onerow->Song = $song;
					$rows[] = $onerow;
				}
			}
		}
		$this->smarty->assign('playlist_song_rows', $rows);
		
		$this->smarty->assign('header_edit_playlist', $this->Lang('header_edit_playlist'));
		$this->smarty->assign('header_edit_playlist_songs', $this->Lang('header_edit_playlist_songs'));
		
		$this->smarty->assign('module_id', $id);
		
		$this->smarty->assign('formstart', $this->CreateFormStart($id, 'admin_edit_playlist', $returnid, 'post', '', false, '', array('playlist_id' => $playlist->Id)));
		$this->smarty->assign('submit', lang('submit'));
		$this->smarty->assign('cancel', lang('cancel'));
		$this->smarty->assign('formend', $this->CreateFormEnd());
		
		$this->smarty->assign('cancel_link', htmlspecialchars_decode($this->CreateLink($id, 'defaultadmin', $returnid, '', array(), '', true)));

		$this->smarty->assign('title_playlist', $this->Lang('playlist'));
		
		$this->smarty->assign('labels',
			array(
				'playlist_name' => $this->Lang('name'), 
				'playlist_description' => $this->Lang('description')
			)
		);
		$this->smarty->assign('inputs',
			array(
				'playlist_name' => $this->CreateInputText($id, 'playlist_name', isset($params['playlist_name']) ? $params['playlist_name'] : $playlist->Name, '20'), 
				'playlist_description' => $this->CreateTextArea(false, $id, isset($params['playlist_description']) ? $params['playlist_description'] : $playlist->Description, 'playlist_description', 'pageheadtags')
			)
		);
		$this->smarty->assign('titles',
			array(
				'songs_in_playlist'=> $this->Lang('title_songs_in_playlist'),
				'available_songs'  => $this->Lang('title_available_songs')
			)
		);
		$this->smarty->assign('help_drag_drop', $this->Lang('help_drag_drop'));
		
		$tab['content'] = $this->ProcessTemplate('admin_edit_playlist.tpl');
	}
	else
	{
		$this->doAction('admin_'.$tabname, $id, $params, $returnid);
		$tab['content'] = $this->ProcessTemplate('admin_'.$tabname.'.tpl');
	}
	$tab['end'] = $this->EndTab();
	$tabcontent[] = $tab;
}

// format any messages
foreach($messages as $index => $message)
{
	$messages[$index] = $this->ShowMessage($message);
}

// assign Smarty variables
$this->smarty->assign('errors'          , $errors);
$this->smarty->assign('messages'        , $messages);
$this->smarty->assign('tabheaders_start', $this->StartTabHeaders());
$this->smarty->assign('tabheaders'      , $tabheaders);
$this->smarty->assign('tabheaders_end'  , $this->EndTabHeaders());
$this->smarty->assign('tabcontent_start', $this->StartTabContent());
$this->smarty->assign('tabcontent'      , $tabcontent);
$this->smarty->assign('tabcontent_end'  , $this->EndTabContent());

// process the template
echo $this->ProcessTemplate('defaultadmin.tpl');

?>