<?php

if (!isset($gCms)) 
{
	exit(); 
}

check_login();

if (! $this->CheckPermission('Use Enhanced XSPF'))
{
	echo $this->ShowErrors($this->Lang('err_access_denied'));
	return;
}


$messages = isset($params['messages']) ? $params['messages'] : array();
$errors   = isset($params['errors'])   ? $params['errors']   : array();

require_once cms_join_path('lib', 'classes', 'class.EnhancedXSPFAdmin.php');
require_once cms_join_path('lib', 'classes', 'class.PlaylistManager.php');

$playlist_manager =& new PlaylistManager($this->cms->db);
$playlist = $playlist_manager->getPlaylistById($params['playlist_id'], false);

if (isset($params['cancel']))
{
	return $this->doAction('defaultadmin', $id, $params, $returnid);
}
elseif (isset($_GET['submitted']))
{
	$query = "DELETE FROM " . cms_db_prefix() . "module_exspf_playlist_song WHERE playlist_id = ?";
	$db->Execute($query, array($params['playlist_id']));
	$songs = isset($_GET['selected_songs']) ? $_GET['selected_songs'] : array();
	foreach ($songs as $index => $upload_id)
	{
		$query = "
			INSERT INTO " .  cms_db_prefix() . "module_exspf_playlist_song 
			(playlist_id, upload_id, position) 
			VALUES
			(?, ?, ?)
		";
		$db->Execute($query, array($params['playlist_id'], $upload_id, $index + 1));
	}
	
	$this->Audit($params['playlist_id'], $this->GetFriendlyName(), $this->Lang('audit_admin_playlist_songs_saved'));
	$messages[] = $this->Lang('msg_playlist_songs_updated');
	$params['messages'] = $messages;
	return $this->doAction('defaultadmin', $id, $params, $returnid);
}

// create an Admin object
$admin =& new EnhancedXSPFAdmin($this->cms->smarty, $this->cms->db, $params);

// create the tabheaders
$tabheaders = array();
foreach ($admin->getTabs() as $tabname)
{
	$tabheaders[] = $this->SetTabHeader($tabname, $this->Lang('title_admintab_' . $tabname), ($admin->getActiveTab() == $tabname));
}

// create the tabs content
$tabcontent = array();
foreach ($admin->getTabs() as $tabname)
{
	$tab = array();
	$tab['start'] = $this->StartTab($tabname);
	if ($tabname == 'playlists')
	{
		$playlist =& $playlist_manager->getPlaylistById($params['playlist_id']);
		$playlist->Id = $params['playlist_id'];
		
		$uploads = $this->GetModuleInstance('Uploads');
		
		$this->smarty->assign('playlist', $playlist);
		
		$category_list = $uploads->getCategoryList();
		$filelist = array();
		if (!empty($category_list))
		{
			foreach($category_list as $category)
			{
				$filelist = array_merge($filelist, $uploads->getFileList($category));
			}
		}
		
		$files = array();
		foreach ($filelist as $filename => $file_id)
		{
			$file_name = trim ($filename);
		    $extension = strtolower(strrchr($file_name, '.'));
			if ($extension != '.mp3')
			{
				unset($filelist[$filename]);
			}
			else
			{
				$files[] = $uploads->GetUploadDetails($file_id, $returnid);
			}
		}
		$rows = array();
		if (empty($files))
		{
			$errors[] = $this->ShowErrors($this->Lang('err_no_mp3s_found'));
		}
		else
		{
			foreach ($files as $mp3)
			{
				if (!isset($playlist->Songs[$mp3['upload_id']]))
				{
					require_once cms_join_path('lib', 'classes', 'class.Song.php');

					$song =& new Song($mp3['upload_id']);
					$song->setFilename($mp3['upload_name']);
					$song->setSummary($mp3['upload_summary']);
					$song->setDescription($mp3['upload_description']);
					$song->setAuthor($mp3['upload_author']);
					$onerow =& new StdClass();
					$onerow->Id = $song->UploadId;
					$onerow->Song = $song;
					$rows[] = $onerow;
				}
			}
		}
		$this->smarty->assign('playlist_song_rows', $rows);
		
		$this->smarty->assign('header_add_playlist_songs', $this->Lang('header_add_playlist_songs'));
		
		$this->smarty->assign('module_id', $id);
		
		$this->smarty->assign('formstart', $this->CreateFormStart($id, 'admin_add_playlist_songs', $returnid, 'post', '', false, '', array('playlist_id' => $playlist->Id)));
		$this->smarty->assign('submit', lang('submit'));
		$this->smarty->assign('formend', $this->CreateFormEnd());

		$this->smarty->assign('title_playlist', $this->Lang('playlist'));
		
		$this->smarty->assign('titles',
			array(
				'playlist' => $this->Lang('playlist'),
				'songs_in_playlist'=> $this->Lang('title_songs_in_playlist'),
				'available_songs'  => $this->Lang('title_available_songs')
			)
		);
		$this->smarty->assign('help_drag_drop', $this->Lang('help_drag_drop'));
		
		$tab['content'] = $this->ProcessTemplate('admin_add_playlist_songs.tpl');
	}
	else
	{
		$this->doAction('admin_'.$tabname, $id, $params, $returnid);
		$tab['content'] = $this->ProcessTemplate('admin_'.$tabname.'.tpl');
	}
	$tab['end'] = $this->EndTab();
	$tabcontent[] = $tab;
}

// format any messages
foreach($messages as $index => $message)
{
	$messages[$index] = $this->ShowMessage($message);
}

// assign Smarty variables
$this->smarty->assign('errors'          , $errors);
$this->smarty->assign('messages'        , $messages);
$this->smarty->assign('tabheaders_start', $this->StartTabHeaders());
$this->smarty->assign('tabheaders'      , $tabheaders);
$this->smarty->assign('tabheaders_end'  , $this->EndTabHeaders());
$this->smarty->assign('tabcontent_start', $this->StartTabContent());
$this->smarty->assign('tabcontent'      , $tabcontent);
$this->smarty->assign('tabcontent_end'  , $this->EndTabContent());

// process the template
echo $this->ProcessTemplate('defaultadmin.tpl');

?>
