<?php

if (!isset($gCms)) exit;

// check for permissions
if (!$this->CheckPermission('Use DownloadManager'))
{
	echo $this->ShowErrors($this->Lang('needpermission', array('Use DownloadManager')));
	return;
}


$this->smarty->assign('startform', $this->CreateFormStart($id, 'save_admin_prefs', $returnid));
$this->smarty->assign('endform', $this->CreateFormEnd());
$this->smarty->assign('submit',$this->CreateInputSubmit($id, 'submit', 'Submit'));


$pref_errors = array();
$download_dir = $this->GetPreference('dir');
if( !file_exists($config['root_path'].DIRECTORY_SEPARATOR.$download_dir ) )
	$pref_errors[] = $this->lang('dir_dont_exists',$download_dir);
if( !is_writable($config['root_path'].DIRECTORY_SEPARATOR.$download_dir ) )
	$pref_errors[] = $this->lang('download_dir_not_writable',$download_dir);

$this->smarty->assign('label_download_dir', $this->Lang('download_dir'));

$this->smarty->assign('stop_image',$gCms->variables['admintheme']->DisplayImage('icons/system/stop.gif', 'error','','','systemicon'));
if(count($pref_errors) > 0 )
	$this->smarty->assign_by_ref('pref_errors', $pref_errors);
$this->smarty->assign('input_download_dir', $this->CreateInputText($id, 'download_dir', $this->GetPreference('dir', lang('needupgrade')), 50, 250));
$this->smarty->assign('label_download_template', $this->Lang('download_template'));
$this->smarty->assign('label_download_template_info', $this->Lang('download_template_info'));
$this->smarty->assign('input_download_template', $this->CreateTextArea( false, $id, $this->GetTemplate('default_download_template'), 'download_template','pagesmalltextarea'));

// Display the populated template
echo $this->ProcessTemplate('adminprefs.tpl');

?>