<?php
	/*---------------------------------------------------------
	   DisplayAdminPrefs($id, $params, $returnid)
	   NOT PART OF THE MODULE API

	   This is an example of a simple method to present an Admin
	   form that contains preference information.
	   
	   It sets smarty tag values, and then calls the
	   code necessary to render the template.
	   
	   You will see that the method calls an API method to
	   create a checkbox. This is just one of many available
	   methods for form creation.
	   
	   Take a look at CMSROOT/lib/classes/class.module.inc.php for a
	   large collection of methods to create HTML and form widgets:
		   
		   - CreateInputPassword       - CreateInputText
		   - CreateLink                       - CreateFileUploadInput
		   - CreateTextArea                - CreateInputSubmit
		   - CreateInputRadioGroup    - CreateInputCheckbox
		   - CreateInputSelectList       - CreateInputHidden
		   
		   There are also methods for making tabbed interfaces:
		   - StartTabHeaders              - SetTabHeader
		   - EndTabHeaders                - StartTabContent
		   - EndTabContent                - StartTab
		   - EndTab
	  ---------------------------------------------------------*/

/*
    For separated methods, you'll always want to start with the following
    line which check to make sure that method was called from the module
    API, and that everything's safe to continue:
*/ 
if (!isset($gCms)) exit;

/*
    For separated methods, you won't be able to do permission checks in
    the DoAction method, so you'll need to do them as needed in your
    method:
*/ 
if (! $this->CheckPermission('Use Skeleton')) exit;

/* After this, the code is identical to the code that would otherwise be
    wrapped in the DisplayAdminPrefs() method in the module body.
*/

    	// simple way to have common nav available to all admin pages
    	$this->DisplayAdminNav($id, $params, $returnid);

    	// CreateFormStart sets up a proper form tag that will cause the submit to
    	// return control to this module for processing.
		$this->smarty->assign('startform',
			$this->CreateFormStart($id, 'save_admin_prefs', $returnid));
		$this->smarty->assign('endform', $this->CreateFormEnd());
		$this->smarty->assign('submit',
			$this->CreateInputSubmit($id, 'submit', 'Submit'));


		// it's good practice to set even static titles using smarty, so localization is
		// easier.
		$this->smarty->assign('title_sing_loudly', $this->Lang('title_sing_loudly'));
		$this->smarty->assign('title_section', $this->Lang('title_mod_prefs'));
		
		// you'll often want to do things like this to provide feedback:
		$this->smarty->assign('message', (isset($params['message'])?$params['message']:''));

		// present a control of the preference; in this case, it's a
		// checkbox for our "Sing Loudly" option.
		   
        $this->smarty->assign('input_sing_loudly',
        	$this->CreateInputCheckbox($id, 'sing_loudly', 1,
        		$this->GetPreference('sing_loudly', '1')).' '.
        		$this->Lang('title_sing_loudly'));

        // Display the populated template
        echo $this->ProcessTemplate('adminprefs.tpl');

?>