<?php
#CMS - CMS Made Simple
#(c)2006 by Thomas Gubisch (http://www.newmusica.de)
#This project's homepage is: http://dev.cmsmadesimple.org
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY.

function smarty_cms_function_file($params, &$smarty)
{
	global $gCms;  
	
	$sizeunits = array(' B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB');
	$sizebase = 1024;
	$sizeprec = 1;
	$filesize = false;
	$size = 0;

	$output = '';
	$target = '';
	$aclasses = array();

	$file = $params['name'];
	$text = $params['text'];
	
	if($file == '') {
		return '<!-- file plugin: no file name given -->';
	}
	
	if($file{0} == '/') {
		$file = substr($file, 1);
	}
	
	if(isset($params['target'])) {
		$target = ' target="'.$params['target'].'"';
        }
	
	if(isset($params['class'])) {
		$moreclasses = explode(' ',str_replace(array(',',';'),array(' ',' '),$params['class']));
		foreach($moreclasses as $class) {
		$aclasses[] = $class;
		}
	}
	
	$filepath = realpath($gCms->config['uploads_path'].'/'.$file);

	if(!file_exists($filepath) or !is_readable($filepath)) {
		/* A common mistake */
		$pos = strlen($gCms->config['uploads_path']) - strlen($gCms->config['root_path']);
		$newfile = substr($file, $pos);
		$newfilepath = realpath($gCms->config['uploads_path'].'/'.$newfile);
		
		if(is_file($newfilepath) and file_exists($newfilepath) and is_readable($newfilepath)) {
			$aclasses[] = 'checkpath';
			$file = $newfile;
			$filepath = $newfilepath;
		} else {
			$aclasses[] = 'deadlink';
		}
	}
	
	if($text == '') {
		$text = basename($filepath);
		if($text == '') {
			$text = $file;
		}
	}
	
	$fileurl = $gCms->config['uploads_url'].'/'.$file;
	
	if(is_dir($filepath)) {
		$aclasses[] ='directory';
	} else {
		$aclasses[] = 'file';
		
		$info = pathinfo($filepath);
		
		if($info['extension'] == '') {
			$pos = strrpos($file, '/');
			if($pos === false) {
				$filename = $file;
			} else {
				$filename = substr($file, ($pos+1));
			}
			$pos = strrpos($filename, '.');
			if($pos === false) {
				$info['extension'] = 'unknown';
			} else {
				$info['extension'] = substr($filename, ($pos+1)); 
			}
		}
		
		$aclasses[] = 'filetype_'.$info['extension'];
		$mimetype = ' type="'._file_get_mime_type($filepath).'"';
		
		$filesize = filesize($filepath);
	}
	
	if($filesize != false and $filesize > 0) {
		$sizerank = floor(log($filesize,$sizebase));
		$size = $filesize/pow($sizebase,$sizerank);
		if($size >= 100) $sizeprec = 0;
		$sizetext = round($size,$sizeprec).' '.$sizeunits[$sizerank];
	}
	
	$output .= '<a href="'.$fileurl.'" class="'.implode(' ',$aclasses).'"'.$mimetype.$target.'>';
	$output .= '<span class="filename">'.$text.'</span>';
	if($size > 0) {
		$output .= '<span class="filesize"> ('.$sizetext.')</span>';
	}
	$output .= '</a>';
	
	return $output;
}

function smarty_cms_help_function_file()
{
	global $gCms;  	
	?>
	<h3>What does this do?</h3>
	<p>Adds a hyperlink on any kind of file in your upload directory. By automatically adding a common and a file type specific css class you are free to configure your css to display the hyperlink as you like. The file size will be also added to the link text.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your page like: <code>{file name='download.pdf' text="a PDF file"}</code></p>
	<h3>What parameters does it take?</h3>
	<p>
			<ul>
				<li><em>(required)</em> name - file name and path as seen from your upload directory</li>
				<li><em>(optional)</em> text - The text to be shown within the link. If omitted, the file name will be displayed</li>
				<li><em>(optional)</em> class - Add more css classes to the link tag</li>
				<li><em>(optional)</em> target - target of the window which has to be opened (default: same window)</li>
			</ul>
		</p>
	<h3>Formatting with CSS</h3>
	<p>A css class named <code>file</code> is added to every link. Additionally a file type specific class named <code>filetype_<i><type></i></code> (e.g. <code>filetype_pdf</code>) is added also.</p>
	<p>CSS Code Example:</p>
	<pre style="border:1px solid #333;padding:0.25em;background:#fff;">

.file {
	padding-left: 20px;
	background: transparent url('<?php echo $gCms->config['root_url'] ?>/plugins/icons/file.png') no-repeat left;
}

.directory, .directory:link, .directory:visited {
        /* You should not link to a directory via {file} */
	color: red;
}

.filesize {
	/* display: none; */
	font-size: 90%;
}

.deadlink, .deadlink:link, .deadlink:visited {
	/* added if the specified file does not exist */
	color: red;
	font-weight: bold;
}

.checkpath {
	/* added if the file path is wrong */
	color: red;
}

.filetype_pdf {
	padding-left: 20px;
	background: transparent url('<?php echo $gCms->config['root_url'] ?>/plugins/icons/pdf.png') no-repeat left;
}

.filetype_zip {
	padding-left: 20px;
	background: transparent url('<?php echo $gCms->config['root_url'] ?>/plugins/icons/zip.png') no-repeat left;
}

.filetype_doc {
	padding-left: 20px;
	background: transparent url('<?php echo $gCms->config['root_url'] ?>/plugins/icons/doc.png') no-repeat left;
}

.filetype_ppt {
	padding-left: 20px;
	background: transparent url('<?php echo $gCms->config['root_url'] ?>/plugins/icons/ppt.png') no-repeat left;
}

.filetype_xls {
	padding-left: 20px;
	background: transparent url('<?php echo $gCms->config['root_url'] ?>/plugins/icons/xls.png') no-repeat left;
}

</pre>
	<?php
}

function smarty_cms_about_function_file()
{
	?>
	<p>Author: Georg Wallisch (mail@phpco.de);</p>
	<p>Version: 1.1</p>
	<p>Change History:</p>
	<ul>
	<li>1.1 - Improved error handling</li>
	<li>1.0 - Initial release</li>
	<?php
}

function _file_get_mime_type($filename)
{
	if($filename == '') {
		return 'application/octet-stream';
	}
	
	$mimetype = '';
	
	if(function_exists('finfo_open')) {
		$finfo = finfo_open(FILEINFO_MIME);
		$mimetype = finfo_file($finfo, $filename);
		finfo_close($finfo);
	} elseif(function_exists('mime_content_type')) {
		$mimetype = mime_content_type($filename);
	}
	
	if($mimetype == '') {
		$mimetype = _file_mime_content_type($filename);
	}
	
	return $mimetype;
}

function _file_mime_content_type($filename)
{
	$mime_types = array(
		'txt' => 'text/plain',
		'htm' => 'text/html',
		'html' => 'text/html',
		'php' => 'text/html',
		'css' => 'text/css',
		'js' => 'application/javascript',
		'json' => 'application/json',
		'xml' => 'application/xml',
		'swf' => 'application/x-shockwave-flash',
		'flv' => 'video/x-flv',
		'png' => 'image/png',
		'jpe' => 'image/jpeg',
		'jpeg' => 'image/jpeg',
		'jpg' => 'image/jpeg',
		'gif' => 'image/gif',
		'bmp' => 'image/bmp',
		'ico' => 'image/vnd.microsoft.icon',
		'tiff' => 'image/tiff',
		'tif' => 'image/tiff',
		'svg' => 'image/svg+xml',
		'svgz' => 'image/svg+xml',
		'zip' => 'application/zip',
		'rar' => 'application/x-rar-compressed',
		'exe' => 'application/x-msdownload',
		'msi' => 'application/x-msdownload',
		'cab' => 'application/vnd.ms-cab-compressed',
		'mp3' => 'audio/mpeg',
		'qt' => 'video/quicktime',
		'mov' => 'video/quicktime',
		'pdf' => 'application/pdf',
		'psd' => 'image/vnd.adobe.photoshop',
		'ai' => 'application/postscript',
		'eps' => 'application/postscript',
		'ps' => 'application/postscript',
		'doc' => 'application/msword',
		'rtf' => 'application/rtf',
		'xls' => 'application/vnd.ms-excel',
		'ppt' => 'application/vnd.ms-powerpoint',
		'odt' => 'application/vnd.oasis.opendocument.text',
		'ods' => 'application/vnd.oasis.opendocument.spreadsheet'
	);
	
        $ext = strtolower(array_pop(explode('.',$filename)));
	
	if(array_key_exists($ext, $mime_types))	{
		return $mime_types[$ext];
	}
	
	return 'application/octet-stream';
}

?>