<?php
#-------------------------------------------------------------------------
# Module: Glossary / Dictionary / FAQ module
# Version: 0.6.6, SjG
# http://dev.cmsmadesimple.org/projects/glossary
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2009 by Ted Kulp (ted@cmsmadesimple.org)
# http://www.cmsmadesimple.org
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$db =& $this->GetDb();
$taboptarray = array('mysql' => 'TYPE=MyISAM');
$dict = NewDataDictionary($db);
// table schema description
$flds = "
			term_id I KEY,
			term X,
			definition X
			";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_glossary_term",
				  $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_glossary_term_seq");
$flds = "
			category_id I KEY,
			name C(80)
			";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_glossary_cat",
				  $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_glossary_cat_seq");
$flds = "
			category_id I,
			term_id I
			";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix().
				  "module_glossary_term_cat",
				  $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$flds = "
			template_id I KEY,
			name C(80),
			template X
			";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix().
				  "module_glossary_template",
				  $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_glossary_template_seq");

// insert sample terms
$query = 'INSERT INTO '. cms_db_prefix().
  'module_glossary_term (term_id, term, definition) VALUES (?,?,?)';
$term_id1 = $db->GenID(cms_db_prefix().'module_glossary_term_seq');
$dbresult = $db->Execute($query,array($term_id1,'abecedarian','<ol><li>One who teaches or studies the alphabet.</li><li>One who is just learning; a beginner.</li></ol>'));
$term_id2 = $db->GenID(cms_db_prefix().'module_glossary_term_seq');
$dbresult = $db->Execute($query,array($term_id2,'syzygy','Astronomy.<ol><li>Either of two points in the orbit of a celestial body where the body is in opposition to or in conjunction with the sun.</li><li>Either of two points in the orbit of the moon when the moon lies in a straight line with the sun and Earth.</li><li>The configuration of the sun, the moon, and Earth lying in a straight line.</li></ol>'));
$term_id3 = $db->GenID(cms_db_prefix().'module_glossary_term_seq');
$dbresult = $db->Execute($query,array($term_id3,'ontology','The branch of metaphysics that deals with the nature of being.'));
$term_id4 = $db->GenID(cms_db_prefix().'module_glossary_term_seq');
$dbresult = $db->Execute($query,array($term_id4,'ineffable','<ol><li>Incapable of being expressed; indescribable or unutterable.</li><li>Not to be uttered; taboo: <strong>the ineffable name of God</strong>.</li></ol>'));
$term_id5 = $db->GenID(cms_db_prefix().'module_glossary_term_seq');
$dbresult = $db->Execute($query,array($term_id5,'aciniform','<ol><li>Having the form of a cluster of grapes; clustered like grapes.</li><li>Full of small kernels like a grape.</li></ol>'));
$term_id6 = $db->GenID(cms_db_prefix().'module_glossary_term_seq');
$dbresult = $db->Execute($query,array($term_id6,'sybarite','<ol><li>A person devoted to pleasure and luxury; a voluptuary.</li><li>A native or inhabitant of Sybaris.</li></ol>'));

// insert sample categories
$query = 'INSERT INTO '. cms_db_prefix().
  'module_glossary_cat (category_id, name) VALUES (?,?)';
$cat_id1 = $db->GenID(cms_db_prefix().'module_glossary_cat_seq');
$dbresult = $db->Execute($query,array($cat_id1,'Science'));
$cat_id2 = $db->GenID(cms_db_prefix().'module_glossary_cat_seq');
$dbresult = $db->Execute($query,array($cat_id2,'Obscure'));
$cat_id3 = $db->GenID(cms_db_prefix().'module_glossary_cat_seq');
$dbresult = $db->Execute($query,array($cat_id3,'General'));

// and put sample terms into categories
$query = 'INSERT INTO '. cms_db_prefix().
  'module_glossary_term_cat (term_id, category_id) VALUES (?,?)';
$dbresult = $db->Execute($query,array($term_id1, $cat_id3));
$dbresult = $db->Execute($query,array($term_id2, $cat_id3));
$dbresult = $db->Execute($query,array($term_id3, $cat_id3));
$dbresult = $db->Execute($query,array($term_id4, $cat_id3));
$dbresult = $db->Execute($query,array($term_id5, $cat_id3));
$dbresult = $db->Execute($query,array($term_id2, $cat_id1));
$dbresult = $db->Execute($query,array($term_id1, $cat_id2));
$dbresult = $db->Execute($query,array($term_id5, $cat_id2));
$dbresult = $db->Execute($query,array($term_id6, $cat_id3));


// set some defaults
$this->SetPreference('number_show', '5');
$this->SetPreference('filter_site', '0');
$this->SetPreference('filter_news', '0');
// update these numbers if we add more sample templates
$this->SetPreference('default_template', '1');
$this->SetPreference('default_single_term_template', '2');
$this->SetPreference('glossary_inline', '1');

// create a permission
$this->CreatePermission('Modify Glossary', 'Modify Glossary');

// import all the templates
$query = 'INSERT INTO '. cms_db_prefix().
  'module_glossary_template (template_id, name, template) VALUES (?,?,?)';
$dir=opendir(dirname(__FILE__).'/includes');
$temps = array();
while($filespec=readdir($dir))
  {
    if(! preg_match('/\.tpl$/i',$filespec))
      {
	continue;
      }
    array_push($temps, $filespec);
  }        
sort($temps);
foreach ($temps as $filespec)
{
  $template = file_get_contents(dirname(__FILE__).'/includes/'.$filespec);
  $temp_name = preg_replace('/\.tpl$/i','',$filespec);
  $temp_id = $db->GenID(cms_db_prefix().'module_glossary_template_seq');
  $dbresult = $db->Execute($query,array($temp_id,$temp_name,$template));
  $this->SetTemplate('glossary_'.$temp_id,$template);
}
// put mention into the admin log
$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('installed',$this->GetVersion()));

# EOF
?>