<?php
#-------------------------------------------------------------------------
# Module: Glossary / Dictionary / FAQ module
# Version: 0.6.6, SjG
# http://dev.cmsmadesimple.org/projects/glossary
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2009 by Ted Kulp (ted@cmsmadesimple.org)
# http://www.cmsmadesimple.org
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------


function markupGlossaryContent($content,&$module)
{
  global $gCms;
  $db =& $gCms->GetDb();

  if( empty($content) ) return $content;

  $targ = $module->GetPreference('glossary_page','');
  $inline = ($module->GetPreference('glossary_inline','0') == '1');
  $show_single = ($module->GetPreference('show_single','0') == '1');
  $query = "SELECT term_id, term, definition FROM ".cms_db_prefix().
    "module_glossary_term";
  $dbresult = $db->Execute($query);
  
  while ($dbresult !== false && $row = $dbresult->FetchRow())
    {
      $link = $module->CreateTermLink('\2', $row['term'], $row['term_id'], $row['definition'],
				    $inline, $targ, $show_single);
      $term = preg_replace('/([\/#@$!.?*{}()|\[\]])/','\\\1',$row['term']);
      $newcontent = preg_replace('/(\s+)('.$term.')(\W)/i',
				 '\1'.$link.'\3',$content);
      if( empty($newcontent) )
	{
	  $content = '<!-- glossary filtering failed -->'.$content;
	}
      else
	{
	  $content = $newcontent;
	}
    }

  return $content;
}

$this->in_filter = true;
global $gCms;
$db =& $gCms->GetDb();
$contentops =& $gCms->GetContentOperations();
    
//
// Filter All Content Objects
//
if ($this->GetPreference('filter_site','0') == '1' ||
    isset($params['filter_site']))
  {
    $query = 'SELECT content_id,type FROM '.cms_db_prefix().'content
           ORDER BY hierarchy';
    $dbresult =& $db->Execute($query);
    while($dbresult && !$dbresult->EOF)
      {
	if( $dbresult->fields['type'] != 'content' )
	  {
	    $dbresult->MoveNext();
	    continue;
	  }
	
	// get the content object
	$content =& $contentops->LoadContentFromId($dbresult->fields['content_id']);
	$gCms->variables['content_id'] = $dbresult->fields['content_id'];
	
	// process the default content block
	$text = markupGlossaryContent($content->GetPropertyValue('content_en'),$this);
	$content->SetPropertyValue('content_en',$text);
	
	$content->GetAdditionalContentBlocks();
	foreach( $content->additionalContentBlocks as $blockName => $blockNameId )
	  {
	    $text = markupGlossaryContent($content->GetPropertyValue($blockNameId['id']),$this);
	    $content->SetPropertyValue($blockNameId['id'],$text);
	  }
    
	$content->Save();
	$dbresult->MoveNext();
      }
  }


//
// Filter all news articles
//
if ($this->GetPreference('filter_news','0') == '1' ||
    isset($params['filter_news']) )
  {
    $news =& $this->GetModuleInstance('News');
    if( !$news || version_compare($news->GetVersion(),'2.6.1') < 0 )
      {
	$this->in_filter = false;
      }

    $query = 'SELECT news_id,news_data,summary FROM '.cms_db_prefix().'module_news';
    $dbresult = $db->Execute( $query );
    while($dbresult && !$dbresult->EOF)
      {
	$summary = $dbresult->fields['summary'];
	$news_id = $dbresult->fields['news_id'];
	$news_data = $dbresult->fields['news_data'];
	if( !empty($summary) )
	  {
	    $summary = markupGlossaryContent($summary,$this);
	  }

	$news_data = markupGlossaryContent($news_data,$this);

	$query2 = 'UPDATE '.cms_db_prefix().'module_news 
                      SET news_data = ?, summary = ?
                    WHERE news_id = ?';
	$db->Execute( $query2, array( $news_data, $summary, $news_id ));

	$dbresult->MoveNext();
      }
    
  }

$this->in_filter = false;
# EOF
?>
