<?php
if(!isset($gCms)) exit;

// Typical Database Initialization
$db = &$this->cms->db;
$dict = NewDataDictionary($db);
		
// mysql-specific, but ignored by other database
$taboptarray = array("mysql" => "TYPE=MyISAM");
		

// Creates the attachment table
$flds = "
	attachid I KEY,
	name C(64),
	sourcetype I,
	sourceid I,
	desttype I,
	destid C(128)
	";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_attach_attachments", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_attach_attachments_seq");

// Creates the ressource type table
$flds = "
	typeid I KEY,
	typename C(32),
	destonly L,
	active L,
	iscore L,
	type_retrievecombo X,
	type_retrieveitem X,
	type_activecheck X
	";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_attach_restypes", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_attach_restypes_seq");



// CREATING STOCK RESSOURCE TYPES :
$query = "INSERT INTO ".cms_db_prefix()."module_attach_restypes SET typeid=?, typename=?, iscore=?, destonly=?, active=?, type_retrievecombo=?, type_retrieveitem=?, type_activecheck=?";

// Content Page
$typeid = $db->GenID(cms_db_prefix()."module_attach_restypes_seq");
$name = "Content Page";
$iscore = 1;
$destonly = 0;
$active = 1;
$retrievecombo = '';
$retrieveitem = '$manager =& $gCms->GetHierarchyManager();
$node =& $manager->sureGetNodeById($item->destid);
if(!isset($node))	return false;
$content =& $node->GetContent();
$item->ressource_name = $content->Name();
$item->ressource_url = $content->getURL();';
$activecheck = '$result=true;';
$db->Execute($query, array($typeid, $name, $iscore, $destonly, $active, $retrievecombo, $retrieveitem, $activecheck));

// URL
$typeid = $db->GenID(cms_db_prefix()."module_attach_restypes_seq");
$name = "URL";
$iscore = 1;
$destonly = 1;
$active = 1;
$retrievecombo = '';
$retrieveitem = '$item->ressource_name = $item->name;
$item->ressource_url = $item->destid;';
$activecheck = '$result=true;';
$db->Execute($query, array($typeid, $name, $iscore, $destonly, $active, $retrievecombo, $retrieveitem, $activecheck));

// FILE
$typeid = $db->GenID(cms_db_prefix()."module_attach_restypes_seq");
$name = "File";
$iscore = 1;
$destonly = 1;
$active = 1;
$retrievecombo = '';
$retrieveitem = '$item->ressource_name = $item->name;
$item->ressource_url = $gCms->config["uploads_url"].str_replace("//","/","/attachments/".$item->destid);
$info = $this->plGetFileInfo($gCms->config["uploads_path"]."/attachments/".$item->destid);
if($info){
	foreach($info as $key=>$value)	$item->$key = $value;
}';
$activecheck = '$result=true;';
$db->Execute($query, array($typeid, $name, $iscore, $destonly, $active, $retrievecombo, $retrieveitem, $activecheck));

// NEWS
$typeid = $db->GenID(cms_db_prefix()."module_attach_restypes_seq");
$name = "News-article";
$iscore = 0;
$destonly = 0;
$active = (isset($gCms->modules["News"]) && $gCms->modules["News"]["active"])?1:0;
$retrievecombo = '$query = "SELECT news_id, news_title FROM ".cms_db_prefix()."module_news";
$dbresult =& $db->Execute($query);
while ($dbresult && $row = $dbresult->FetchRow()){
	$options[$row["news_id"]] = $row["news_title"];
}';
$retrieveitem = '$newsmodule = $this->GetModuleInstance("News");
if(!$newsmodule) return false;

$query = "SELECT news_title FROM ".cms_db_prefix()."module_news WHERE news_id=?";
$dbresult = $db->Execute($query,array($item->destid));
if($dbresult && $row = $dbresult->FetchRow()){
	$item->ressource_name = $row["news_title"];
}else{
	return false;
}

$prettyurl = "news/" . $item->destid."/".$returnid."/".munge_string_to_url($item->ressource_name);
$item->ressource_url = $newsmodule->CreateLink($id,"detail",$returnid,"",array("articleid"=>$item->destid),"",true, false, "", true, $prettyurl);';
$activecheck = 'if(!isset($gCms->modules["News"]) || !$gCms->modules["News"]["active"]){
	$result = false;
}else{
	$result = true;
}';
$db->Execute($query, array($typeid, $name, $iscore, $destonly, $active, $retrievecombo, $retrieveitem, $activecheck));




// INSERTING DEFAULT TEMPLATE
	$template = '<fieldset><legend><b>{$restitle}</b></legend>
<ul id="ressources_list">
{foreach from=$itemlist item="item"}
	<li><a href="{$item->ressource_url}">{$item->ressource_name}</a>{if $item->ressource_type->typename == "File"} ({$item->ext}, {$item->size_wformat}){/if}</li>
{/foreach}
</ul>

</fieldset>';
$this->SetTemplate("default",$template,$this->GetName());
$this->SetPreference("deftemplate","default",$this->GetName());

// permissions
	$this->CreatePermission("attach_use", "Attach: use module");
	$this->CreatePermission("attach_admin", "Attach: admin");

// try to create upload folder
	if(@mkdir($gCms->config['uploads_path'].DIRECTORY_SEPARATOR.'attachments')){
		@chmod($gCms->config['uploads_path'].DIRECTORY_SEPARATOR.'attachments', 0777);
	}

// put mention into the admin log
	$this->Audit( 0, $this->Lang("friendlyname"), $this->Lang("installed",$this->GetVersion()));

?>
