<?php
/**
 * class.CSK_Output.php
 *
 * @author David Broz <db-cmsms@elunia.ch>
 * @copyright (c) 2009 by David Broz - {@link http://www.elunia.ch elunia visual media} Zurich, Switzerland
 * @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License Version 2
 * @since 30/04/2009 7:30:29 PM
 * @package CSSKit
 */

if($_SERVER['SCRIPT_FILENAME'] == __FILE__ )
{
	exit();
}

/**
 * CSK_Output
 *
 * Direct output wrapper for CSSKit
 *
 * @author David Broz <db-cmsms@elunia.ch>
 * @copyright (c) 2009 by David Broz - {@link http://www.elunia.ch elunia visual media} Zurich, Switzerland
 * @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License Version 2
 * @package CSSKit
 */
class CSK_Output
{

	/**
	 * $_cskInstance
	 *
	 * @var CSSKit
	 */
	protected $_cskInstance;

	/**
	 * CSK_Output (constructor)
	 *
	 * @return CSK_Output
	 */
	function CSK_Output($i_cskInstance=null)
	{
		if (!is_null($i_cskInstance))
		{
			$this->setModuleInstance($i_cskInstance);
		}
	}

	/**
	 * setModuleInstance
	 *
	 */
	private function setModuleInstance(&$i_module=null)
	{
		if ($i_module instanceof CSSKit)
		{
			$this->_cskInstance = &$i_module;
		}
	}


	/**
	 * Render
	 *
	 * @return string
	 */
	public function Render()
	{
		if (isset($_REQUEST['css']) && !empty($_REQUEST['css']))
		{
			if($this->validEtag())
			{
				$this->sendNotModified($_REQUEST['css']);
				$this->_cskInstance->CSK_TouchCSS($_REQUEST['css']);
				return ;
			}
			return $this->getCSS($_REQUEST['css']);
		}

	}

	/**
	 * sendNotModified
	 *
	 * @param string $i_hash
	 */
	private function sendNotModified($i_hash)
	{
		$this->_setHeader('Etag: "'.md5($i_hash).'"');
		$this->_setHeader('HTTP/1.1 304 Not Modified');
		$this->_setHeader("Expires: ".gmdate("D, d M Y H:i:s", $this->_cskInstance->CSK_GetExpiryTime($i_hash)));
		$this->_setHeader("Cache-Control: max-age=".$this->_cskInstance->CSK_GetCacheAge());
	}

	/**
	 * validEtag
	 *
	 * @return boolean
	 */
	private function validEtag()
	{
		$etag = '';
		if( function_exists('getallheaders') )
		{
			$headers = getallheaders();
			if (isset($headers['If-None-Match'])  )
			{
				$etag = trim($headers['If-None-Match'],'"');
			}
		}
		else if( isset($_SERVER['HTTP_IF_NONE_MATCH']) )
		{
			$etag = trim($_SERVER['HTTP_IF_NONE_MATCH']);
			$etag = trim($etag,'"');
		}
		return (strcmp(md5($_REQUEST['css']),$etag) == 0);
	}

	/**
	 * getCSS
	 *
	 * @param string $i_hash
	 * @return strin
	 */
	private function getCSS($i_hash)
	{
		$css = $this->_cskInstance->CSK_GetCSS($i_hash);
		if (!empty($css))
		{
			ob_start();
			$this->_setHeader("Etag: ".md5($i_hash));
			$this->_setHeader("Pragma: public");
			$this->_setHeader("Expires: ".gmdate("D, d M Y H:i:s", $this->_cskInstance->CSK_GetExpiryTime($i_hash)));
			$this->_setHeader("Cache-Control: max-age=".$this->_cskInstance->CSK_GetCacheAge());
			$this->_setHeader("Content-Type: text/css");
			echo $css;
			$cssout = ob_get_contents();
			ob_end_clean();
			return $cssout;
		}
		return '';
	}

	/**
	 * _setHeader
	 *
	 * @param string $i_header
	 */
	private function _setHeader($i_header)
	{
		header($i_header);
	}
}
?>