<?php
#-------------------------------------------------------------------------
# CSSKit Module
# Copyright (C) 2009 David Broz <db-cmsms@elunia.ch>
# http://www.elunia.ch Zürich, Switzerland
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

/**
 * Language Variables (ENGLISH)
 *
 * @author David Broz <db-cmsms@elunia.ch>
 * @copyright (c) 2009 by David Broz - {@link http://www.elunia.ch elunia visual media} Zurich, Switzerland
 * @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License Version 2 (GPLv2)
 * @since 30/04/2009 4:38:13 PM
 * @package CSSKit
 */

$lang['friendlyname'] = 'CSSKit';
$lang['postinstall'] = 'Module successfully added.';
$lang['postuninstall'] = 'Module successfully removed.';
$lang['really_uninstall'] = 'Really? Are you sure you want to uninstall this fine module?';
$lang['uninstalled'] = 'Module Uninstalled.';
$lang['installed'] = 'Module version %s installed.';
$lang['upgraded'] = 'Module upgraded to version %s.';
$lang['moddescription'] = 'A more efficient stylesheets module';




$lang['made_by_elunia'] = "<p>Module made by <a href=\"http://www.elunia.ch\" target=\"_blank\">elunia visual media</a></p>";
$lang['changelog'] = '<ul>
<li>Version 0.1 - 30 April 2009. Initial Release.</li>
</ul>';
$lang['help'] = '<h3>What Does This Do?</h3>
<p>This is a stylesheet/css kit. It is an alternative method of embedding stylesheets into your templates.<br/>
The advantage of it is that it combines stylesheets of the same media type into a single stylesheet, reducing the number of HTTP requests per page.<br/>
It also minifies the css to make the stylesheet smaller so that it delivers to the browser faster.
</p>
<h3>How Do I Use It</h3>
<p>
In the head of your html template insert this <b>instead</b> of your regular {stylesheet} tag.
<br />
<pre style="padding:10px;background-color:#E4ECED;">
<code style="font-size:1em;">
{CSK_Stylesheets}
</code>
</pre>
</p>
<h3>What Parameters Does It Take</h3>
<p>
You can use "name" to retieve a single css stylesheet link with that name.<br/>
You can use "media" to override the media type of the stylesheet.<br/>
You can use "assign" to assign the output to a smarty variable of your choice.<br/>
</p>
<h3>Documentation</h3>
<p>There is some excellent <a href="../../../modules/CSSKit/docs/">documentation</a> in phpdoc format for those who would like to play under the hood.</p>
<h3>Support</h3>
<p>As per the GPL, this software is provided as-is. Please read the text of the license for the full disclaimer.</p>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2009, David Broz <a href="mailto:db-cmsms@elunia.ch">&lt;db-cmsms@elunia.ch&gt;</a>. All Rights Are Reserved.</p>
<p>This module has been released under the <a href="http://opensource.org/licenses/gpl-2.0.php">GNU General Public License Version 2</a>. You must agree to this license before using the module.</p>
<h3>Credits</h3>
<p>Module lovingly handcrafted at <a href=\"http://www.elunia.ch\" target=\"_blank\">elunia visual media</a></p>
';

$lang["phelp_assign"] = "Assigns the output to a smarty variable of your choice.";
$lang["phelp_name"] = "A stylesheet name to retrieve.";
$lang["phelp_media"] = "Overrides the media type of the stylesheet.";
?>