<?php
#-------------------------------------------------------------------------
# CSSKit Module
# Copyright (C) 2009 David Broz <db-cmsms@elunia.ch>
# http://www.elunia.ch Zürich, Switzerland
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

/**
 * CSSKit.module.php
 *
 * @author David Broz <db-cmsms@elunia.ch>
 * @copyright (c) 2009 by David Broz - {@link http://www.elunia.ch elunia visual media} Zurich, Switzerland
 * @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License Version 2
 * @since 30/04/2009 4:38:13 PM
 * @package CSSKit
 */

if($_SERVER['SCRIPT_FILENAME'] == __FILE__ )
{
	exit();
}

if(version_compare(PHP_VERSION, '5.2.1', '>='))
{
	define("CSK_DIR",dirname(__FILE__)."/");
	define("CMS_MODULES_DIR",realpath(CSK_DIR."../")."/");
	define("CSK_LIB",CSK_DIR."lib/");
	define("CSK_CLASS_LIB",CSK_LIB."classes/");
	define("CSK_3RDPARTY_LIB",CSK_LIB."3rd_Party/");
	require_once(CSK_CLASS_LIB."class.CSK_CSSKit.php");
}

/**
 * CSSKit
 *
 * A stylesheets module. It is an alternative to using the standard {stylesheets} function.
 * It provides combining and minification of page specific stylesheets.
 *
 * @author David Broz <db-cmsms@elunia.ch>
 * @copyright (c) 2009 by David Broz - {@link http://www.elunia.ch elunia visual media} Zurich, Switzerland
 * @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License Version 2
 * @package CSSKit
 */
class CSSKit  extends CMSModule
{

	/**
	 * $MDK
	 *
	 * @var ModuleDevKit
	 */
	var $MDK;


	/**
	 * $CSK
	 *
	 * @var CSK_CSSKit
	 */
	var $CSK;

	/**
	 * CSSKit (constructor)
	 *
	 * @return CSSKit
	 */
	function CSSKit()
	{
		parent::CMSModule();
		$this->SetModuleDevKit();
		$this->registerSmartyFunctions();
	}


	/**
	 * GetName
	 *
	 * @return string
	 */
	function GetName()
	{
		return "CSSKit";
	}

	/**
	 * GetFriendlyName
	 *
	 * @return string
	 */
	function GetFriendlyName()
	{
		return $this->Lang("friendlyname");
	}

	/**
	 * GetVersion
	 *
	 * @return string
	 */
	function GetVersion()
	{
		return "0.1";
	}

	/**
	 * GetChangeLog
	 *
	 * @return string
	 */
	function GetChangeLog()
	{
		return $this->Lang('changelog');
	}

	/**
	 * IsPluginModule
	 *
	 * @return boolean
	 */
	function IsPluginModule()
	{
		return true;
	}

	/**
	 * HasAdmin
	 *
	 * @return boolean
	 */
	function HasAdmin()
	{
		return false;
	}



	/**
	 * GetAdminDescription
	 *
	 * @return string
	 */
	function GetAdminDescription()
	{
		return $this->Lang('admindescription');
	}


	/**
	 * VisibleToAdminUser
	 *
	 * @return boolean
	 */
	function VisibleToAdminUser()
	{
		return false;
	}


	/**
	 * GetDependencies
	 *
	 * @return array
	 */
	function GetDependencies()
	{
		$dependents = array("ModuleDevKit"=>"0.1");
		if(version_compare(PHP_VERSION, '5.2.1', '<'))
		{
			$dependents["PHP_VERSION"] = "5.2.1";
		}
		return $dependents;
	}


	/**
	 * MinimumCMSVersion
	 *
	 * @return string
	 */
	function MinimumCMSVersion()
	{
		return "1.5.2";
	}

	/**
	 * GetHelp
	 *
	 * @return string
	 */
	function GetHelp()
	{
		return $this->Lang("help");
	}


	/**
	 * GetAuthor
	 *
	 * @return string
	 */
	function GetAuthor()
	{
		return "David Broz";
	}

	/**
	 * GetAuthorEmail
	 *
	 * @return string
	 */
	function GetAuthorEmail()
	{
		return "db-cmsms@elunia.net";
	}


	/**
	 * InstallPostMessage
	 *
	 * @return string
	 */
	function InstallPostMessage()
	{
		return $this->Lang("postinstall");
	}


	/**
	 * UninstallPostMessage
	 *
	 * @return string
	 */
	function UninstallPostMessage()
	{
		return $this->Lang("postuninstall");
	}

	/**
	 * UninstallPreMessage
	 *
	 * @return string
	 */
	function UninstallPreMessage()
	{
		return $this->Lang("really_uninstall");
	}


	/**
	 * Install
	 *
	 */
	function Install()
	{
		$this->SetModuleDevKit();
		$this->MDK->MDK_InstallModule($this,$this->GetModuleModel());
	}

	/**
	 * Uninstall
	 *
	 */
	function Uninstall()
	{
		$this->SetModuleDevKit();
		$this->MDK->MDK_UninstallModule($this,$this->GetModuleModel());
	}

	/**
	 * SetModuleDevKit
	 *
	 */
	function SetModuleDevKit()
	{
		if (!($this->MDK instanceof ModuleDevKit))
		{
			$this->MDK = $this->GetModuleInstance("ModuleDevKit");
		}
	}

	/**
	 * GetModuleModel
	 *
	 * @return MDK_ModuleModel
	 */
	function GetModuleModel()
	{
		$model = $this->MDK->MDK_CreateModuleModel();
		$model->preferences = array("CSK_version"=>$this->GetVersion());
		$model->sqlTableOptions =  array("mysql" => "TYPE=MyISAM");
		$model->sqlTables = CSK_CSSKit::getSQLTableStruct();
		return $model;
	}

	/**
	 * SetParameters
	 *
	 */
	function SetParameters()
	{
		$this->CreateParameter("assign","", $this->Lang("phelp_assign"),true);
		$this->SetParameterType("assign",CLEAN_STRING);

		$this->CreateParameter("name","", $this->Lang("phelp_name"),true);
		$this->SetParameterType("name",CLEAN_STRING);

		$this->CreateParameter("media","", $this->Lang("phelp_media"),true);
		$this->SetParameterType("media",CLEAN_STRING);
	}

	/**
	 * DoAction
	 *
	 * @param string $action
	 * @param integer $id
	 * @param array $params
	 * @param integer $returnid
	 */
	function DoAction($action, $id, $params, $returnid=-1)
	{
		if ($action == "default")
		{
			//$translation = $this->TLK_Translate($params);

		}
	}

	/**
	 * CSK_Stylesheets
	 *
	 * @param array $params
	 * @param Smarty $smarty
	 * @return string
	 */
	public function CSK_Stylesheets($params,&$smarty = null)
	{
		$stylesheet = '';
		$this->SetCSSKitClass();
		$name = isset($params['name']) ? $params['name'] : '';
		$media = isset($params['media']) ? $params['media'] : '';
		$stylesheet = $this->CSK->getStyleSheetLinks($name,$media);
		if( isset($params['assign']) )
		{
			if (!($smarty instanceof Smarty_CMS ))
			{
				global $gCms;
				$smarty =& $gCms->GetSmarty();
			}
			$smarty->assign(trim($params['assign']),$stylesheet);
			return;
		}
		return $stylesheet;
	}

	/**
	 * CSK_GetCSS
	 *
	 * @param string $i_hash
	 * @return string
	 */
	public function CSK_GetCSS($i_hash='')
	{
		$this->SetCSSKitClass();
		return $this->CSK->getCSS($i_hash);
	}

	/**
	 * CSK_TouchCSS
	 *
	 * @param string $i_hash
	 */
	public function CSK_TouchCSS($i_hash='')
	{
		$this->SetCSSKitClass();
		$this->CSK->touchCSS($i_hash);
	}
	
	/**
	 * CSK_GetExpiryTime
	 *
	 * @param string $i_hash
	 * @return int (seconds)
	 */
	public function CSK_GetExpiryTime($i_hash='')
	{
		$this->SetCSSKitClass();
		return $this->CSK->getExpiryTime($i_hash);
	}
	
	/**
	 * CSK_GetCacheAge
	 *
	 * @return int
	 */
	public function CSK_GetCacheAge()
	{
		$this->SetCSSKitClass();
		return $this->CSK->getCacheAge();
	}

	/**
	 * SetCSSKitClass
	 *
	 */
	private function SetCSSKitClass()
	{
		$this->SetModuleDevKit();

		if (!($this->CSK instanceof CSK_CSSKit))
		{
			$this->CSK = new CSK_CSSKit($this->GetModuleInstance('CSSKit'));
		}
	}

	/**
	 * registerSmartyFunctions
	 *
	 */
	private function registerSmartyFunctions()
	{
		global $gCms;
		$smarty =& $gCms->GetSmarty();
		$smarty->register_function('CSK_Stylesheets', array(&$this, 'CSK_Stylesheets'));
	}
}
?>